/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.CandleChart;
import eu.hansolo.fx.charts.data.CandleChartItem;
import eu.hansolo.fx.charts.data.ChartItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class CandleChartBuilder<B extends CandleChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected CandleChartBuilder() {
    }

    public static final CandleChartBuilder create() {
        return new CandleChartBuilder();
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B backgroundColor(Color BACKGROUND_COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)BACKGROUND_COLOR));
        return (B)this;
    }

    public final B bullishColor(Color BULLISH_COLOR) {
        this.properties.put("bullishColor", (Property)new SimpleObjectProperty((Object)BULLISH_COLOR));
        return (B)this;
    }

    public final B bearishColor(Color BEARISH_COLOR) {
        this.properties.put("bearishColor", (Property)new SimpleObjectProperty((Object)BEARISH_COLOR));
        return (B)this;
    }

    public final B strokeColor(Color STROKE_COLOR) {
        this.properties.put("strokeColor", (Property)new SimpleObjectProperty((Object)STROKE_COLOR));
        return (B)this;
    }

    public final B endLinesVisible(boolean END_LINES_VISIBLE) {
        this.properties.put("endLinesVisible", (Property)new SimpleBooleanProperty(END_LINES_VISIBLE));
        return (B)this;
    }

    public final B useItemColorForStroke(boolean USE_ITEM_COLOR_FOR_STROKE) {
        this.properties.put("useItemColorForStroke", (Property)new SimpleBooleanProperty(USE_ITEM_COLOR_FOR_STROKE));
        return (B)this;
    }

    public final B minNumberOfItems(int MIN_NUMBER_OF_ITEMS) {
        this.properties.put("minNumberOfItems", (Property)new SimpleIntegerProperty(MIN_NUMBER_OF_ITEMS));
        return (B)this;
    }

    public final B useMinNumberOfItems(boolean USE_MIN_NUMBER_OF_ITEMS) {
        this.properties.put("useMinNumberOfItems", (Property)new SimpleBooleanProperty(USE_MIN_NUMBER_OF_ITEMS));
        return (B)this;
    }

    public final B popupTimeout(long POPUP_TIMEOUT) {
        this.properties.put("popupTimeout", (Property)new SimpleLongProperty(POPUP_TIMEOUT));
        return (B)this;
    }

    public final B yAxis(Axis Y_AXIS) {
        this.properties.put("yAxis", (Property)new SimpleObjectProperty((Object)Y_AXIS));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final CandleChart build() {
        CandleChart candleChart = new CandleChart();
        if (this.properties.keySet().contains("itemsArray")) {
            candleChart.setItems((CandleChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        } else if (this.properties.keySet().contains("itemsList")) {
            candleChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    candleChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    candleChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    candleChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    candleChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    candleChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    candleChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    candleChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    candleChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    candleChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    candleChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    candleChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    candleChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    candleChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    candleChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    candleChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    candleChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    candleChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "locale": {
                    candleChart.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "backgroundColor": {
                    candleChart.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "bullishColor": {
                    candleChart.setBullishColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "bearishColor": {
                    candleChart.setBearishColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "strokeColor": {
                    candleChart.setStrokeColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "endLinesVisible": {
                    candleChart.setEndLinesVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "useItemColorForStroke": {
                    candleChart.setUseItemColorForStroke(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "minNumberOfItems": {
                    candleChart.setMinNumberOfItems(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "useMinNumberOfItems": {
                    candleChart.setUseMinNumberOfItems(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "popupTimeout": {
                    candleChart.setPopupTimeout(((LongProperty)this.properties.get(key)).get());
                }
            }
        }
        if (this.properties.containsKey("yAxis")) {
            candleChart.setYAxis((Axis)((Object)((ObjectProperty)this.properties.get("yAxis")).get()));
        }
        return candleChart;
    }
}

