/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.PlotItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class Cluster
implements Comparable<Cluster> {
    private Set<PlotItem> items = new CopyOnWriteArraySet<PlotItem>();
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;

    public Cluster() {
        this("", Color.TRANSPARENT, Color.TRANSPARENT, new PlotItem[0]);
    }

    public Cluster(String NAME) {
        this(NAME, Color.TRANSPARENT, Color.TRANSPARENT, new PlotItem[0]);
    }

    public Cluster(String NAME, List<PlotItem> ITEMS) {
        this(NAME, Color.TRANSPARENT, Color.TRANSPARENT, ITEMS.toArray(new PlotItem[0]));
    }

    public Cluster(List<PlotItem> ITEMS) {
        this("", Color.TRANSPARENT, Color.TRANSPARENT, ITEMS.toArray(new PlotItem[0]));
    }

    public Cluster(PlotItem ... ITEMS) {
        this("", Color.TRANSPARENT, Color.TRANSPARENT, ITEMS);
    }

    public Cluster(String NAME, PlotItem ... ITEMS) {
        this(NAME, Color.TRANSPARENT, Color.TRANSPARENT, ITEMS);
    }

    public Cluster(String NAME, Color FILL, PlotItem ... ITEMS) {
        this(NAME, FILL, Color.TRANSPARENT, ITEMS);
    }

    public Cluster(String NAME, Color FILL, Color STROKE, PlotItem ... ITEMS) {
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this.items.addAll(Arrays.asList((PlotItem[])ITEMS.clone()));
        Arrays.stream(ITEMS).forEach(item -> item.setCluster(this));
    }

    public Collection<PlotItem> getItems() {
        return this.items;
    }

    public Collection<PlotItem> getSortedItems() {
        LinkedList<PlotItem> sortedItems = new LinkedList<PlotItem>(this.items);
        Collections.sort(sortedItems, Comparator.comparingDouble(PlotItem::getSumOfOutgoing).reversed());
        return sortedItems;
    }

    public void addItem(PlotItem ITEM) {
        this.items.add(ITEM);
        ITEM.setCluster(this);
    }

    public void removeItem(PlotItem ITEM) {
        if (this.items.contains(ITEM)) {
            ITEM.setCluster(null);
            this.items.remove(ITEM);
        }
    }

    public void addItems(List<PlotItem> ITEMS) {
        this.items.addAll(ITEMS);
        ITEMS.forEach(item -> item.setCluster(this));
    }

    public void addItems(PlotItem ... ITEMS) {
        this.items.addAll(Arrays.asList((PlotItem[])ITEMS.clone()));
        Arrays.stream(ITEMS).forEach(item -> item.setCluster(this));
    }

    public PlotItem getItemWithMaxValue() {
        return this.items.stream().max(Comparator.comparingDouble(PlotItem::getSumOfOutgoing)).get();
    }

    public double getMaxValue() {
        return this.items.stream().max(Comparator.comparingDouble(PlotItem::getSumOfOutgoing)).get().getValue();
    }

    public void clear() {
        this.items.forEach(item -> item.setCluster(null));
        this.items.clear();
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                public Object getBean() {
                    return Cluster.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                public Object getBean() {
                    return Cluster.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                public Object getBean() {
                    return Cluster.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public int compareTo(Cluster other) {
        if (this.getMaxValue() < other.getMaxValue()) {
            return 1;
        }
        if (this.getMaxValue() > other.getMaxValue()) {
            return -1;
        }
        return 0;
    }
}

