/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.event.SelectionEvt;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.series.Series;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class ComparisonBarChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ChartItemSeries<ChartItem> series1;
    private ChartItemSeries<ChartItem> series2;
    private Paint _backgroundFill;
    private ObjectProperty<Paint> backgroundFill;
    private Paint _categoryBackgroundFill;
    private ObjectProperty<Paint> categoryBackgroundFill;
    private Color _barBackgroundFill;
    private ObjectProperty<Color> barBackgroundFill;
    private Color _textFill;
    private ObjectProperty<Color> textFill;
    private Color _categoryTextFill;
    private ObjectProperty<Color> categoryTextFill;
    private Color _betterDarkerColor;
    private ObjectProperty<Color> betterDarkerColor;
    private Color _betterBrighterColor;
    private ObjectProperty<Color> betterBrighterColor;
    private Color _poorerDarkerColor;
    private ObjectProperty<Color> poorerDarkerColor;
    private Color _poorerBrighterColor;
    private ObjectProperty<Color> poorerBrighterColor;
    private boolean _barBackgroundVisible;
    private BooleanProperty barBackgroundVisible;
    private boolean _shadowsVisible;
    private BooleanProperty shadowsVisible;
    private boolean _categorySumVisible;
    private BooleanProperty categorySumVisible;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private boolean _doCompare;
    private BooleanProperty doCompare;
    private boolean _useItemTextFill;
    private BooleanProperty useItemTextFill;
    private boolean _useCategoryTextFill;
    private BooleanProperty useCategoryTextFill;
    private boolean _shortenNumbers;
    private BooleanProperty shortenNumbers;
    private boolean _sorted;
    private BooleanProperty sorted;
    private Order _order;
    private ObjectProperty<Order> order;
    private Map<Category, Double> categoryValueMap;
    private Map<Rectangle, ChartItem> rectangleItemMap;
    private ListChangeListener<ChartItem> chartItemListener;
    private EvtObserver<ChartEvt> observer;
    private EventHandler<MouseEvent> mouseHandler;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;
    private InfoPopup popup;

    public ComparisonBarChart(ChartItemSeries series1, ChartItemSeries series2) {
        if (null == series1 || series1.getItems().isEmpty()) {
            throw new IllegalArgumentException("Series 1 cannot be null or empty");
        }
        if (null == series2 || series2.getItems().isEmpty()) {
            throw new IllegalArgumentException("Series 2 cannot be null or empty");
        }
        this.series1 = series1;
        this.series2 = series2;
        if (!this.validate()) {
            throw new IllegalArgumentException("Please make sure the categories of the items in series 1 and 2 are the same and not null or empty");
        }
        this._backgroundFill = Color.TRANSPARENT;
        this._barBackgroundFill = Color.rgb((int)230, (int)230, (int)230);
        this._categoryBackgroundFill = Color.TRANSPARENT;
        this._textFill = Color.WHITE;
        this._categoryTextFill = Color.BLACK;
        this._betterDarkerColor = Color.rgb((int)51, (int)178, (int)75);
        this._betterBrighterColor = Color.rgb((int)163, (int)206, (int)53);
        this._poorerDarkerColor = Color.rgb((int)252, (int)79, (int)55);
        this._poorerBrighterColor = Color.rgb((int)252, (int)132, (int)36);
        this._barBackgroundVisible = false;
        this._shadowsVisible = false;
        this._categorySumVisible = false;
        this._numberFormat = NumberFormat.NUMBER;
        this._doCompare = false;
        this._useItemTextFill = false;
        this._useCategoryTextFill = false;
        this._shortenNumbers = false;
        this._sorted = false;
        this._order = Order.DESCENDING;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
        this.popup = new InfoPopup();
        this.categoryValueMap = new HashMap<Category, Double>();
        this.rectangleItemMap = new HashMap<Rectangle, ChartItem>();
        this.observer = evt -> {
            EvtType type = evt.getEvtType();
            if (type.equals(ChartEvt.ITEM_UPDATE) || type.equals(ChartEvt.FINISHED)) {
                this.drawChart();
            }
        };
        this.chartItemListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ANY, this.observer));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ANY, this.observer));
            }
            this.drawChart();
        };
        this.mouseHandler = e -> this.handleMouseEvents((MouseEvent)e);
        this.prepareSeries(this.series1);
        this.prepareSeries(this.series2);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"comparison-ring-chart");
        this.canvas = new Canvas(this.size * 0.9, 0.9);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.series1.getItems().forEach(item -> item.addChartEvtObserver(ChartEvt.ANY, this.observer));
        this.series2.getItems().forEach(item -> item.addChartEvtObserver(ChartEvt.ANY, this.observer));
        this.series1.getItems().addListener(this.chartItemListener);
        this.series2.getItems().addListener(this.chartItemListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.addChartEvtObserver(SelectionEvt.ANY, (EvtObserver<ChartEvt>)((EvtObserver)e -> {
            this.popup.update((SelectionEvt)e);
            this.popup.animatedShow(this.getScene().getWindow());
        }));
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 4096.0;
    }

    protected double computeMaxHeight(double width) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Paint getBackgroundFill() {
        return null == this.backgroundFill ? this._backgroundFill : (Paint)this.backgroundFill.get();
    }

    public void setBackgroundFill(Paint backgroundFill) {
        if (null == this.backgroundFill) {
            this._backgroundFill = backgroundFill;
            this.redraw();
        } else {
            this.backgroundFill.set((Object)backgroundFill);
        }
    }

    public ObjectProperty<Paint> backgroundFillProperty() {
        if (null == this.backgroundFill) {
            this.backgroundFill = new ObjectPropertyBase<Paint>(this._backgroundFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "backgroundFill";
                }
            };
            this._backgroundFill = null;
        }
        return this.backgroundFill;
    }

    public Paint getCategoryBackgroundFill() {
        return null == this.categoryBackgroundFill ? this._categoryBackgroundFill : (Paint)this.categoryBackgroundFill.get();
    }

    public void setCategoryBackgroundFill(Paint categoryBackgroundFill) {
        if (null == this.categoryBackgroundFill) {
            this._categoryBackgroundFill = categoryBackgroundFill;
            this.redraw();
        } else {
            this.categoryBackgroundFill.set((Object)categoryBackgroundFill);
        }
    }

    public ObjectProperty<Paint> categoryBackgroundFillProperty() {
        if (null == this.categoryBackgroundFill) {
            this.categoryBackgroundFill = new ObjectPropertyBase<Paint>(this._categoryBackgroundFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "categoryBackgroundFill";
                }
            };
            this._categoryBackgroundFill = null;
        }
        return this.categoryBackgroundFill;
    }

    public Color getBarBackgroundFill() {
        return null == this.barBackgroundFill ? this._barBackgroundFill : (Color)this.barBackgroundFill.get();
    }

    public void setBarBackgroundFill(Color barBackgroundFill) {
        if (null == this.barBackgroundFill) {
            this._barBackgroundFill = barBackgroundFill;
            this.redraw();
        } else {
            this.barBackgroundFill.set((Object)barBackgroundFill);
        }
    }

    public ObjectProperty<Color> barBackgroundFillProperty() {
        if (null == this.barBackgroundFill) {
            this.barBackgroundFill = new ObjectPropertyBase<Color>(this._barBackgroundFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "barBackgroundFill";
                }
            };
            this._barBackgroundFill = null;
        }
        return this.barBackgroundFill;
    }

    public Color getTextFill() {
        return null == this.textFill ? this._textFill : (Color)this.textFill.get();
    }

    public void setTextFill(Color textFill) {
        if (null == this.textFill) {
            this._textFill = textFill;
            this.redraw();
        } else {
            this.textFill.set((Object)textFill);
        }
    }

    public ObjectProperty<Color> textFillProperty() {
        if (null == this.textFill) {
            this.textFill = new ObjectPropertyBase<Color>(this._textFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "textFill";
                }
            };
            this._textFill = null;
        }
        return this.textFill;
    }

    public Color getCategoryTextFill() {
        return null == this.categoryTextFill ? this._categoryTextFill : (Color)this.categoryTextFill.get();
    }

    public void setCategoryTextFill(Color categoryTextFill) {
        if (null == this.categoryTextFill) {
            this._categoryTextFill = categoryTextFill;
            this.redraw();
        } else {
            this.categoryTextFill.set((Object)categoryTextFill);
        }
    }

    public ObjectProperty<Color> categoryTextFillProperty() {
        if (null == this.categoryTextFill) {
            this.categoryTextFill = new ObjectPropertyBase<Color>(this._categoryTextFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "categoryTextFill";
                }
            };
            this._categoryTextFill = null;
        }
        return this.categoryTextFill;
    }

    public void setBetterColor(Color betterColor) {
        this.setBetterDarkerColor(betterColor.darker().darker());
        this.setBetterBrighterColor(betterColor.brighter().brighter());
    }

    public void setPoorerColor(Color poorerColor) {
        this.setPoorerDarkerColor(poorerColor.darker().darker());
        this.setPoorerBrighterColor(poorerColor.brighter().brighter());
    }

    public Color getBetterDarkerColor() {
        return null == this.betterDarkerColor ? this._betterDarkerColor : (Color)this.betterDarkerColor.get();
    }

    public void setBetterDarkerColor(Color betterDarkerColor) {
        if (null == this.betterDarkerColor) {
            this._betterDarkerColor = betterDarkerColor;
            this.redraw();
        } else {
            this.betterDarkerColor.set((Object)betterDarkerColor);
        }
    }

    public ObjectProperty<Color> betterDarkerColorProperty() {
        if (null == this.betterDarkerColor) {
            this.betterDarkerColor = new ObjectPropertyBase<Color>(this._betterDarkerColor){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "betterDarkerColor";
                }
            };
            this._betterDarkerColor = null;
        }
        return this.betterDarkerColor;
    }

    public Color getBetterBrighterColor() {
        return null == this.betterBrighterColor ? this._betterBrighterColor : (Color)this.betterBrighterColor.get();
    }

    public void setBetterBrighterColor(Color betterBrighterColor) {
        if (null == this.betterBrighterColor) {
            this._betterBrighterColor = betterBrighterColor;
            this.redraw();
        } else {
            this.betterBrighterColor.set((Object)betterBrighterColor);
        }
    }

    public ObjectProperty<Color> betterBrighterColorProperty() {
        if (null == this.betterBrighterColor) {
            this.betterBrighterColor = new ObjectPropertyBase<Color>(this._betterBrighterColor){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "betterBrighterColor";
                }
            };
            this._betterBrighterColor = null;
        }
        return this.betterBrighterColor;
    }

    public Color getPoorerDarkerColor() {
        return null == this.poorerDarkerColor ? this._poorerDarkerColor : (Color)this.poorerDarkerColor.get();
    }

    public void setPoorerDarkerColor(Color poorerDarkerColor) {
        if (null == this.poorerDarkerColor) {
            this._poorerDarkerColor = poorerDarkerColor;
            this.redraw();
        } else {
            this.poorerDarkerColor.set((Object)poorerDarkerColor);
        }
    }

    public ObjectProperty<Color> poorerDarkerColorProperty() {
        if (null == this.poorerDarkerColor) {
            this.poorerDarkerColor = new ObjectPropertyBase<Color>(this._poorerDarkerColor){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "poorerDarkerColor";
                }
            };
            this._poorerDarkerColor = null;
        }
        return this.poorerDarkerColor;
    }

    public Color getPoorerBrighterColor() {
        return null == this.poorerBrighterColor ? this._poorerBrighterColor : (Color)this.poorerBrighterColor.get();
    }

    public void setPoorerBrighterColor(Color poorerBrighterColor) {
        if (null == this.poorerBrighterColor) {
            this._poorerBrighterColor = poorerBrighterColor;
            this.redraw();
        } else {
            this.poorerBrighterColor.set((Object)poorerBrighterColor);
        }
    }

    public ObjectProperty<Color> poorerBrighterColorProperty() {
        if (null == this.poorerBrighterColor) {
            this.poorerBrighterColor = new ObjectPropertyBase<Color>(this._poorerBrighterColor){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "poorerBrighterColor";
                }
            };
            this._poorerBrighterColor = null;
        }
        return this.poorerBrighterColor;
    }

    public boolean getBarBackgroundVisible() {
        return null == this.barBackgroundVisible ? this._barBackgroundVisible : this.barBackgroundVisible.get();
    }

    public void setBarBackgroundVisible(boolean barBackgroundVisible) {
        if (null == this.barBackgroundVisible) {
            this._barBackgroundVisible = barBackgroundVisible;
            this.redraw();
        } else {
            this.barBackgroundVisible.set(barBackgroundVisible);
        }
    }

    public BooleanProperty barBackgroundVisibleProperty() {
        if (null == this.barBackgroundVisible) {
            this.barBackgroundVisible = new BooleanPropertyBase(this._barBackgroundVisible){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "barBackgroundVisible";
                }
            };
        }
        return this.barBackgroundVisible;
    }

    public boolean getShadowsVisible() {
        return null == this.shadowsVisible ? this._shadowsVisible : this.shadowsVisible.get();
    }

    public void setShadowsVisible(boolean shadowsVisible) {
        if (null == this.shadowsVisible) {
            this._shadowsVisible = shadowsVisible;
            this.redraw();
        } else {
            this.shadowsVisible.set(shadowsVisible);
        }
    }

    public BooleanProperty shadowsVisibleProperty() {
        if (null == this.shadowsVisible) {
            this.shadowsVisible = new BooleanPropertyBase(this._shadowsVisible){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "shadowsVisible";
                }
            };
        }
        return this.shadowsVisible;
    }

    public boolean getCategorySumVisible() {
        return null == this.categorySumVisible ? this._categorySumVisible : this.categorySumVisible.get();
    }

    public void setCategorySumVisible(boolean categorySumVisible) {
        if (null == this.categorySumVisible) {
            this._categorySumVisible = categorySumVisible;
            this.redraw();
        } else {
            this.categorySumVisible.set(categorySumVisible);
        }
    }

    public BooleanProperty categorySumVisibleProperty() {
        if (null == this.categorySumVisible) {
            this.categorySumVisible = new BooleanPropertyBase(this._categorySumVisible){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "categorySumVisible";
                }
            };
        }
        return this.categorySumVisible;
    }

    public NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public void setNumberFormat(NumberFormat FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = FORMAT;
            this.updatePopup();
            this.redraw();
        } else {
            this.numberFormat.set((Object)FORMAT);
        }
    }

    public ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new ObjectPropertyBase<NumberFormat>(this._numberFormat){

                protected void invalidated() {
                    ComparisonBarChart.this.updatePopup();
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "numberFormat";
                }
            };
            this._numberFormat = null;
        }
        return this.numberFormat;
    }

    public boolean getDoCompare() {
        return null == this.doCompare ? this._doCompare : this.doCompare.get();
    }

    public void setDoCompare(boolean doCompare) {
        if (null == this.doCompare) {
            this._doCompare = doCompare;
            this.redraw();
        } else {
            this.doCompare.set(doCompare);
        }
    }

    public BooleanProperty doCompareProperty() {
        if (null == this.doCompare) {
            this.doCompare = new BooleanPropertyBase(this._doCompare){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "doCompare";
                }
            };
        }
        return this.doCompare;
    }

    public boolean getUseItemTextFill() {
        return null == this.useItemTextFill ? this._useItemTextFill : this.useItemTextFill.get();
    }

    public void setUseItemTextFill(boolean useItemTextFill) {
        if (null == this.useItemTextFill) {
            this._useItemTextFill = useItemTextFill;
            this.redraw();
        } else {
            this.useItemTextFill.set(useItemTextFill);
        }
    }

    public BooleanProperty useItemTextFillProperty() {
        if (null == this.useItemTextFill) {
            this.useItemTextFill = new BooleanPropertyBase(this._useItemTextFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "useItemTextFill";
                }
            };
        }
        return this.useItemTextFill;
    }

    public boolean getUseCategoryTextFill() {
        return null == this.useCategoryTextFill ? this._useCategoryTextFill : this.useCategoryTextFill.get();
    }

    public void setUseCategoryTextFill(boolean useCategoryTextFill) {
        if (null == this.useCategoryTextFill) {
            this._useCategoryTextFill = useCategoryTextFill;
            this.redraw();
        } else {
            this.useCategoryTextFill.set(useCategoryTextFill);
        }
    }

    public BooleanProperty useCategoryTextFillProperty() {
        if (null == this.useCategoryTextFill) {
            this.useCategoryTextFill = new BooleanPropertyBase(this._useCategoryTextFill){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "useCategoryTextFill";
                }
            };
        }
        return this.useCategoryTextFill;
    }

    public boolean getShortenNumbers() {
        return null == this.shortenNumbers ? this._shortenNumbers : this.shortenNumbers.get();
    }

    public void setShortenNumbers(boolean SHORTEN) {
        if (null == this.shortenNumbers) {
            this._shortenNumbers = SHORTEN;
            this.redraw();
        } else {
            this.shortenNumbers.set(SHORTEN);
        }
    }

    public BooleanProperty shortenNumbersProperty() {
        if (null == this.shortenNumbers) {
            this.shortenNumbers = new BooleanPropertyBase(this._shortenNumbers){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "shortenNumbers";
                }
            };
        }
        return this.shortenNumbers;
    }

    public boolean getSorted() {
        return null == this.sorted ? this._sorted : this.sorted.get();
    }

    public void setSorted(boolean sorted) {
        if (null == this.sorted) {
            this._sorted = sorted;
            this.redraw();
        } else {
            this.sorted.set(sorted);
        }
    }

    public BooleanProperty sortedProperty() {
        if (null == this.sorted) {
            this.sorted = new BooleanPropertyBase(){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "sorted";
                }
            };
        }
        return this.sorted;
    }

    public Order getOrder() {
        return null == this.order ? this._order : (Order)((Object)this.order.get());
    }

    public void setOrder(Order order) {
        if (null == this.order) {
            this._order = order;
            this.redraw();
        } else {
            this.order.set((Object)order);
        }
    }

    public ObjectProperty<Order> orderProperty() {
        if (null == this.order) {
            this.order = new ObjectPropertyBase<Order>(this._order){

                protected void invalidated() {
                    ComparisonBarChart.this.redraw();
                }

                public Object getBean() {
                    return ComparisonBarChart.this;
                }

                public String getName() {
                    return "order";
                }
            };
            this._order = null;
        }
        return this.order;
    }

    private boolean validate() {
        if (this.series1.getItems().size() != this.series2.getItems().size()) {
            return false;
        }
        if (this.series1.getItems().stream().filter(item -> item.getCategory() == null).count() > 0L) {
            return false;
        }
        if (this.series2.getItems().stream().filter(item -> item.getCategory() == null).count() > 0L) {
            return false;
        }
        if (this.series1.getItems().stream().filter(item -> item.getCategory().getName() == null).count() > 0L) {
            return false;
        }
        if (this.series2.getItems().stream().filter(item -> item.getCategory().getName() == null).count() > 0L) {
            return false;
        }
        if (this.series1.getItems().stream().filter(item -> item.getCategory().getName().isEmpty()).count() > 0L) {
            return false;
        }
        if (this.series2.getItems().stream().filter(item -> item.getCategory().getName().isEmpty()).count() > 0L) {
            return false;
        }
        List categories1 = this.series1.getItems().stream().map(item -> item.getCategory()).collect(Collectors.toList());
        List categories2 = this.series2.getItems().stream().map(item -> item.getCategory()).collect(Collectors.toList());
        if (categories1.isEmpty()) {
            return false;
        }
        if (categories2.isEmpty()) {
            return false;
        }
        if (categories1.size() != categories2.size()) {
            return false;
        }
        return categories1.stream().map(category -> category.getName()).anyMatch(categories2.stream().map(category -> category.getName()).collect(Collectors.toSet())::contains);
    }

    private void handleMouseEvents(MouseEvent evt) {
        double x = evt.getX();
        double y = evt.getY();
        Optional<Map.Entry> opt = this.rectangleItemMap.entrySet().stream().filter(entry -> ((Rectangle)entry.getKey()).contains(x, y)).findFirst();
        if (opt.isPresent()) {
            this.popup.setX(evt.getScreenX());
            this.popup.setY(evt.getScreenY() - this.popup.getHeight());
            ChartItem selectedItem = (ChartItem)opt.get().getValue();
            if (this.series1.getItems().contains((Object)selectedItem)) {
                this.fireChartEvt(new SelectionEvt<ChartItem>(this.series1, (ChartItem)opt.get().getValue()));
            } else {
                this.fireChartEvt(new SelectionEvt<ChartItem>(this.series2, (ChartItem)opt.get().getValue()));
            }
        }
    }

    private void updatePopup() {
        switch (this.getNumberFormat()) {
            case NUMBER: {
                this.popup.setDecimals(0);
                break;
            }
            case FLOAT_1_DECIMAL: {
                this.popup.setDecimals(1);
                break;
            }
            case FLOAT_2_DECIMALS: {
                this.popup.setDecimals(2);
                break;
            }
            case FLOAT: {
                this.popup.setDecimals(8);
                break;
            }
            case PERCENTAGE: {
                this.popup.setDecimals(0);
                break;
            }
            case PERCENTAGE_1_DECIMAL: {
                this.popup.setDecimals(1);
            }
        }
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    private void prepareSeries(Series<ChartItem> SERIES) {
        boolean animated = SERIES.isAnimated();
        long animationDuration = SERIES.getAnimationDuration();
        SERIES.getItems().forEach(item -> {
            if (animated) {
                item.setAnimated(animated);
            }
            item.setAnimationDuration(animationDuration);
        });
    }

    private void drawChart() {
        Category category2;
        this.categoryValueMap.clear();
        this.rectangleItemMap.clear();
        double inset = 5.0;
        double chartWidth = this.width - 2.0 * inset;
        double chartHeight = this.height - 2.0 * inset;
        List<Category> categories = this.series1.getItems().stream().map(item -> item.getCategory()).sorted().collect(Collectors.toList());
        ObservableList<ChartItem> items1 = this.series1.getItems();
        ObservableList<ChartItem> items2 = this.series2.getItems();
        double noOfCategories = categories.size();
        double maxBarWidth = chartWidth * 0.4;
        double categoryWidth = chartWidth * 0.2;
        double barHeight = chartHeight / (noOfCategories + noOfCategories * 0.4);
        double cornerRadius = barHeight * 0.75;
        double barSpacer = (chartHeight - noOfCategories * barHeight) / (noOfCategories - 1.0);
        double maxValue = Math.max(this.series1.getMaxValue(), this.series2.getMaxValue());
        NumberFormat numberFormat = this.getNumberFormat();
        Color valueTextFill = this.getTextFill();
        Color categoryTextFill = this.getCategoryTextFill();
        boolean useItemTextFill = this.getUseItemTextFill();
        boolean useCategoryTextFill = this.getUseCategoryTextFill();
        String formatString = numberFormat.formatString();
        Paint leftFill = this.series1.getFill();
        Paint rightFill = this.series2.getFill();
        boolean shortenNumbers = this.getShortenNumbers();
        boolean barBackgroundVisible = this.getBarBackgroundVisible();
        Color barBackgroundFill = this.getBarBackgroundFill();
        Paint categoryBackgroundFill = this.getCategoryBackgroundFill().equals(Color.TRANSPARENT) ? this.getBackgroundFill() : this.getCategoryBackgroundFill();
        boolean shadowsVisible = this.getShadowsVisible();
        boolean categorySumVisible = this.getCategorySumVisible();
        Font valueFont = Fonts.latoRegular((double)(barHeight * 0.5));
        Font categoryFont = categorySumVisible ? Fonts.latoRegular((double)(barHeight * 0.4)) : Fonts.latoRegular((double)(barHeight * 0.5));
        Font categorySumFont = Fonts.latoRegular((double)(barHeight * 0.3));
        DropShadow leftShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.15), barHeight * 0.1, 0.0, -1.0, barHeight * 0.1);
        DropShadow rightShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.15), barHeight * 0.1, 0.0, 1.0, barHeight * 0.1);
        if (this.getSorted()) {
            categories.forEach(category -> {
                double value1 = this.series1.getItems().stream().filter(item -> item.getCategory().getName().equals(category.getName())).findFirst().get().getValue();
                double value2 = this.series2.getItems().stream().filter(item -> item.getCategory().getName().equals(category.getName())).findFirst().get().getValue();
                this.categoryValueMap.put((Category)category, value1 + value2);
            });
            categories = this.categoryValueMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(entry -> (Category)entry.getKey()).collect(Collectors.toList());
            if (Order.DESCENDING == this.getOrder()) {
                Collections.reverse(categories);
            }
        }
        LinearGradient leftBetterFill = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.getBetterBrighterColor()), new Stop(1.0, this.getBetterDarkerColor())});
        LinearGradient rightBetterFill = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.getBetterDarkerColor()), new Stop(1.0, this.getBetterBrighterColor())});
        LinearGradient leftPoorerFill = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.getPoorerBrighterColor()), new Stop(1.0, this.getPoorerDarkerColor())});
        LinearGradient rightPoorerFill = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.getPoorerDarkerColor()), new Stop(1.0, this.getPoorerBrighterColor())});
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getBackgroundFill());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.RIGHT);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(valueFont);
        int i = 0;
        while ((double)i < noOfCategories) {
            category2 = (Category)categories.get(i);
            ChartItem leftItem = items1.stream().filter(it -> it.getCategory().getName().equals(category2.getName())).findFirst().get();
            double leftValue = Helper.clamp(0.0, Double.MAX_VALUE, leftItem.getValue());
            double leftBarWidth = leftValue / maxValue * maxBarWidth;
            double leftBarX = inset + maxBarWidth - leftBarWidth;
            double leftBarY = inset + (double)i * barHeight + (double)i * barSpacer;
            ChartItem rightItem = items2.stream().filter(it -> it.getCategory().getName().equals(category2.getName())).findFirst().get();
            double rightValue = Helper.clamp(0.0, Double.MAX_VALUE, rightItem.getValue());
            double rightBarWidth = rightValue / maxValue * maxBarWidth;
            double rightBarX = inset + maxBarWidth + categoryWidth;
            double rightBarY = inset + (double)i * barHeight + (double)i * barSpacer;
            double categoryX = inset + maxBarWidth + categoryWidth * 0.5;
            double categoryY = inset + (double)i * barHeight + (double)i * barSpacer;
            category2.setValue(leftItem.getValue() + rightItem.getValue());
            if (barBackgroundVisible) {
                this.ctx.setFill((Paint)barBackgroundFill);
                this.ctx.beginPath();
                this.ctx.moveTo(inset + maxBarWidth, leftBarY);
                this.ctx.lineTo(inset + maxBarWidth, leftBarY + barHeight);
                this.ctx.lineTo(inset + cornerRadius, leftBarY + barHeight);
                this.ctx.bezierCurveTo(inset, leftBarY + barHeight, inset, leftBarY, inset + cornerRadius, leftBarY);
                this.ctx.lineTo(inset + maxBarWidth, leftBarY);
                this.ctx.closePath();
                this.ctx.fill();
            }
            if (this.getDoCompare()) {
                leftFill = leftValue > rightValue ? leftBetterFill : (leftValue < rightValue ? leftPoorerFill : this.series1.getFill());
            }
            this.ctx.save();
            if (shadowsVisible) {
                this.ctx.setEffect((Effect)leftShadow);
            }
            this.ctx.setFill(leftFill);
            this.ctx.beginPath();
            this.ctx.moveTo(leftBarX + leftBarWidth, leftBarY);
            this.ctx.lineTo(leftBarX + leftBarWidth, leftBarY + barHeight);
            if (leftBarWidth < cornerRadius) {
                this.ctx.lineTo(leftBarX + leftBarWidth, leftBarY + barHeight);
                this.ctx.bezierCurveTo(leftBarX, leftBarY + barHeight, leftBarX, leftBarY, leftBarX + leftBarWidth, leftBarY);
            } else {
                this.ctx.lineTo(leftBarX + cornerRadius, leftBarY + barHeight);
                this.ctx.bezierCurveTo(leftBarX, leftBarY + barHeight, leftBarX, leftBarY, leftBarX + cornerRadius, leftBarY);
            }
            this.ctx.lineTo(leftBarX + leftBarWidth, leftBarY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.restore();
            this.rectangleItemMap.put(new Rectangle(leftBarX, leftBarY, leftBarWidth, barHeight), leftItem);
            this.ctx.setTextAlign(TextAlignment.RIGHT);
            this.ctx.setFill((Paint)(useItemTextFill ? leftItem.getTextFill() : valueTextFill));
            if (shortenNumbers) {
                this.ctx.fillText(Helper.shortenNumber((long)leftValue), inset + maxBarWidth - 5.0, leftBarY + barHeight * 0.5);
            } else if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                this.ctx.fillText(String.format(Locale.US, numberFormat.formatString(), leftValue / maxValue * 100.0), inset + maxBarWidth - 5.0, leftBarY + barHeight * 0.5);
            } else {
                this.ctx.fillText(String.format(Locale.US, numberFormat.formatString(), leftValue), inset + maxBarWidth - 5.0, leftBarY + barHeight * 0.5);
            }
            if (barBackgroundVisible) {
                this.ctx.setFill((Paint)barBackgroundFill);
                this.ctx.beginPath();
                this.ctx.moveTo(rightBarX, rightBarY);
                this.ctx.lineTo(rightBarX + maxBarWidth - cornerRadius, rightBarY);
                this.ctx.bezierCurveTo(rightBarX + maxBarWidth, rightBarY, rightBarX + maxBarWidth, rightBarY + barHeight, rightBarX + maxBarWidth - cornerRadius, rightBarY + barHeight);
                this.ctx.lineTo(rightBarX, rightBarY + barHeight);
                this.ctx.lineTo(rightBarX, rightBarY);
                this.ctx.closePath();
                this.ctx.fill();
            }
            if (this.getDoCompare()) {
                rightFill = rightValue > leftValue ? rightBetterFill : (rightValue < leftValue ? rightPoorerFill : this.series2.getFill());
            }
            this.ctx.save();
            if (shadowsVisible) {
                this.ctx.setEffect((Effect)rightShadow);
            }
            this.ctx.setFill(rightFill);
            this.ctx.beginPath();
            this.ctx.moveTo(rightBarX, rightBarY);
            if (rightBarWidth < cornerRadius) {
                this.ctx.bezierCurveTo(rightBarX + rightBarWidth, rightBarY, rightBarX + rightBarWidth, rightBarY + barHeight, rightBarX, rightBarY + barHeight);
            } else {
                this.ctx.lineTo(rightBarX + rightBarWidth - cornerRadius, rightBarY);
                this.ctx.bezierCurveTo(rightBarX + rightBarWidth, rightBarY, rightBarX + rightBarWidth, rightBarY + barHeight, rightBarX + rightBarWidth - cornerRadius, rightBarY + barHeight);
            }
            this.ctx.lineTo(rightBarX, rightBarY + barHeight);
            this.ctx.lineTo(rightBarX, rightBarY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.restore();
            this.rectangleItemMap.put(new Rectangle(rightBarX, rightBarY, rightBarWidth, barHeight), rightItem);
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.setFill((Paint)(useItemTextFill ? rightItem.getTextFill() : valueTextFill));
            if (shortenNumbers) {
                this.ctx.fillText(Helper.shortenNumber((long)rightValue), rightBarX + 5.0, rightBarY + barHeight * 0.5);
            } else if (NumberFormat.PERCENTAGE == numberFormat || NumberFormat.PERCENTAGE_1_DECIMAL == numberFormat) {
                this.ctx.fillText(String.format(Locale.US, formatString, rightValue / maxValue * 100.0), rightBarX + 5.0, rightBarY + barHeight * 0.5);
            } else {
                this.ctx.fillText(String.format(Locale.US, formatString, rightValue), rightBarX + 5.0, rightBarY + barHeight * 0.5);
            }
            ++i;
        }
        this.ctx.setFill(categoryBackgroundFill);
        this.ctx.fillRect(inset + maxBarWidth, inset, categoryWidth, chartHeight);
        i = 0;
        while ((double)i < noOfCategories) {
            category2 = (Category)categories.get(i);
            double categoryX = inset + maxBarWidth + categoryWidth * 0.5;
            double categoryY = inset + (double)i * barHeight + (double)i * barSpacer;
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setFill((Paint)(useCategoryTextFill ? category2.getTextFill() : categoryTextFill));
            if (categorySumVisible) {
                this.ctx.setFont(categoryFont);
                this.ctx.fillText(category2.getName(), categoryX, categoryY + barHeight * 0.3, categoryWidth);
                this.ctx.setFont(categorySumFont);
                if (shortenNumbers) {
                    this.ctx.fillText(Helper.shortenNumber((long)category2.getValue()), categoryX, categoryY + barHeight * 0.7, categoryWidth);
                } else {
                    this.ctx.fillText(String.format(Locale.US, "%.0f", category2.getValue()), categoryX, categoryY + barHeight * 0.7, categoryWidth);
                }
            } else {
                this.ctx.setFont(categoryFont);
                this.ctx.fillText(category2.getName(), categoryX, categoryY + barHeight * 0.5, categoryWidth);
            }
            ++i;
        }
        if (shadowsVisible) {
            this.ctx.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.ctx.fillRect(inset + maxBarWidth - 6.0, inset, 6.0, chartHeight);
            this.ctx.setFill((Paint)new LinearGradient(1.0, 0.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.25))}));
            this.ctx.fillRect(inset + maxBarWidth + categoryWidth, inset, 6.0, chartHeight);
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

