/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ChartArea;
import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.PixelMatrix;
import eu.hansolo.fx.charts.PixelMatrixBuilder;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.MatrixItem;
import eu.hansolo.fx.charts.series.MatrixItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.Mapping;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;

public class MatrixPane<T extends MatrixItem>
extends Region
implements ChartArea {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 0.0;
    private static final double MINIMUM_HEIGHT = 0.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static double aspectRatio;
    private boolean keepAspect;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private MatrixItemSeries<T> series;
    private PixelMatrix matrix;
    private LinearGradient matrixGradient;
    private double minZ;
    private double maxZ;
    private double rangeZ;
    private double scaleX;
    private double scaleY;
    private double scaleZ;
    private double _lowerBoundX;
    private DoubleProperty lowerBoundX;
    private double _upperBoundX;
    private DoubleProperty upperBoundX;
    private double _lowerBoundY;
    private DoubleProperty lowerBoundY;
    private double _upperBoundY;
    private DoubleProperty upperBoundY;
    private double _lowerBoundZ;
    private DoubleProperty lowerBoundZ;
    private double _upperBoundZ;
    private DoubleProperty upperBoundZ;
    private ListChangeListener<T> itemListener;

    public MatrixPane(MatrixItemSeries<T> SERIES) {
        this((Paint)Color.WHITE, SERIES);
    }

    public MatrixPane(Paint BACKGROUND, MatrixItemSeries<T> SERIES) {
        this.getStylesheets().add((Object)XYPane.class.getResource("chart.css").toExternalForm());
        aspectRatio = 1.0;
        this.keepAspect = false;
        this._chartBackground = BACKGROUND;
        this.series = SERIES;
        this.matrixGradient = ColorMapping.BLUE_CYAN_GREEN_YELLOW_RED.getGradient();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.scaleZ = 1.0;
        this._lowerBoundX = 0.0;
        this._upperBoundX = 100.0;
        this._lowerBoundY = 0.0;
        this._upperBoundY = 100.0;
        this._lowerBoundZ = 0.0;
        this._upperBoundZ = 100.0;
        this.itemListener = c -> this.redraw();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().setAll((Object[])new String[]{"chart", "matrix-chart"});
        this.matrix = ((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)PixelMatrixBuilder.create().prefSize(250.0, 250.0)).pixelShape(PixelMatrix.PixelShape.SQUARE)).useSpacer(true)).squarePixels(false)).pixelOnColor(Color.BLACK)).pixelOffColor(Color.TRANSPARENT)).build();
        this.pane = new Pane(new Node[]{this.matrix});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.series.setOnSeriesEvent(seriesEvent -> this.redraw());
        this.series.getItems().addListener(this.itemListener);
    }

    protected double computeMinWidth(double HEIGHT) {
        return 0.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 0.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        if (null != this.series) {
            this.series.getItems().removeListener(this.itemListener);
        }
    }

    @Override
    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    @Override
    public void setChartBackground(Paint PAINT) {
        if (null == this.chartBackground) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public double getLowerBoundX() {
        return null == this.lowerBoundX ? this._lowerBoundX : this.lowerBoundX.get();
    }

    public void setLowerBoundX(double VALUE) {
        if (null == this.lowerBoundX) {
            this._lowerBoundX = VALUE;
            this.redraw();
        } else {
            this.lowerBoundX.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundXProperty() {
        if (null == this.lowerBoundX) {
            this.lowerBoundX = new DoublePropertyBase(this._lowerBoundX){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "lowerBoundX";
                }
            };
        }
        return this.lowerBoundX;
    }

    public double getUpperBoundX() {
        return null == this.upperBoundX ? this._upperBoundX : this.upperBoundX.get();
    }

    public void setUpperBoundX(double VALUE) {
        if (null == this.upperBoundX) {
            this._upperBoundX = VALUE;
            this.redraw();
        } else {
            this.upperBoundX.set(VALUE);
        }
    }

    public DoubleProperty upperBoundXProperty() {
        if (null == this.upperBoundX) {
            this.upperBoundX = new DoublePropertyBase(this._upperBoundX){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "upperBoundX";
                }
            };
        }
        return this.upperBoundX;
    }

    public double getLowerBoundY() {
        return null == this.lowerBoundY ? this._lowerBoundY : this.lowerBoundY.get();
    }

    public void setLowerBoundY(double VALUE) {
        if (null == this.lowerBoundY) {
            this._lowerBoundY = VALUE;
            this.redraw();
        } else {
            this.lowerBoundY.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundYProperty() {
        if (null == this.lowerBoundY) {
            this.lowerBoundY = new DoublePropertyBase(this._lowerBoundY){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "lowerBoundY";
                }
            };
        }
        return this.lowerBoundY;
    }

    public double getUpperBoundY() {
        return null == this.upperBoundY ? this._upperBoundY : this.upperBoundY.get();
    }

    public void setUpperBoundY(double VALUE) {
        if (null == this.upperBoundY) {
            this._upperBoundY = VALUE;
            this.redraw();
        } else {
            this.upperBoundY.set(VALUE);
        }
    }

    public DoubleProperty upperBoundYProperty() {
        if (null == this.upperBoundY) {
            this.upperBoundY = new DoublePropertyBase(this._upperBoundY){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "upperBoundY";
                }
            };
        }
        return this.upperBoundY;
    }

    public double getLowerBoundZ() {
        return null == this.lowerBoundZ ? this._lowerBoundZ : this.lowerBoundZ.get();
    }

    public void setLowerBoundZ(double VALUE) {
        if (null == this.lowerBoundZ) {
            this._lowerBoundZ = VALUE;
            this.redraw();
        } else {
            this.lowerBoundZ.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundZProperty() {
        if (null == this.lowerBoundZ) {
            this.lowerBoundZ = new DoublePropertyBase(this._lowerBoundZ){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "lowerBoundZ";
                }
            };
        }
        return this.lowerBoundZ;
    }

    public double getUpperBoundZ() {
        return null == this.upperBoundZ ? this._upperBoundZ : this.upperBoundZ.get();
    }

    public void setUpperBoundZ(double VALUE) {
        if (null == this.upperBoundZ) {
            this._upperBoundZ = VALUE;
            this.redraw();
        } else {
            this.upperBoundZ.set(VALUE);
        }
    }

    public DoubleProperty upperBoundZProperty() {
        if (null == this.upperBoundZ) {
            this.upperBoundZ = new DoublePropertyBase(this._upperBoundZ){

                protected void invalidated() {
                    MatrixPane.this.redraw();
                }

                public Object getBean() {
                    return MatrixPane.this;
                }

                public String getName() {
                    return "upperBoundZ";
                }
            };
        }
        return this.upperBoundZ;
    }

    public double getRangeX() {
        return this.getUpperBoundX() - this.getLowerBoundX();
    }

    public double getRangeY() {
        return this.getUpperBoundY() - this.getLowerBoundY();
    }

    public double getRangeZ() {
        return this.getUpperBoundZ() - this.getLowerBoundZ();
    }

    public double getValueAt(int X, int Y) throws Exception {
        if (null == this.getSeries()) {
            throw new Exception("Series is null");
        }
        if (this.getSeries().getItems().isEmpty()) {
            throw new Exception("Series is empty");
        }
        return this.getSeries().getAt(X, Y);
    }

    public void setValueAt(int X, int Y, double Z) {
        if (null != this.getSeries()) {
            this.minZ = Math.min(this.minZ, Z);
            this.maxZ = Math.max(this.maxZ, Z);
            this.rangeZ = this.maxZ - this.minZ;
            Color color = Helper.getColorAt(this.matrixGradient, Z / this.rangeZ);
            this.matrix.setPixel(X, Y, color);
        }
    }

    public MatrixItemSeries<T> getSeries() {
        return this.series;
    }

    public PixelMatrix getMatrix() {
        return this.matrix;
    }

    public void setColorMapping(Mapping MAPPING) {
        this.setMatrixGradient(MAPPING.getGradient());
    }

    public LinearGradient getMatrixGradient() {
        return this.matrixGradient;
    }

    public void setMatrixGradient(LinearGradient GRADIENT) {
        this.matrixGradient = GRADIENT;
        this.drawChart();
    }

    private void drawChart() {
        if (null == this.series || this.series.getItems().isEmpty()) {
            return;
        }
        ChartType TYPE = this.series.getChartType();
        switch (TYPE) {
            case MATRIX_HEATMAP: {
                this.drawMatrixHeatMap(this.series);
            }
        }
    }

    private void drawMatrixHeatMap(MatrixItemSeries<T> SERIES) {
        this.minZ = SERIES.getItems().stream().mapToDouble(MatrixItem::getZ).min().getAsDouble();
        this.maxZ = SERIES.getItems().stream().mapToDouble(MatrixItem::getZ).max().getAsDouble();
        this.rangeZ = this.maxZ - this.minZ;
        SERIES.getItems().forEach(data -> {
            Color color = Helper.getColorAt(this.matrixGradient, data.getZ() / this.rangeZ);
            this.matrix.setPixel(data.getX(), data.getY(), color);
        });
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.keepAspect) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.matrix.setPrefSize(this.width, this.height);
            this.scaleX = this.width / this.getRangeX();
            this.scaleY = this.height / this.getRangeY();
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }
}

