/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.NestedBarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class NestedBarChartBuilder<B extends NestedBarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected NestedBarChartBuilder() {
    }

    public static final NestedBarChartBuilder create() {
        return new NestedBarChartBuilder();
    }

    public final B series(ChartItemSeries<ChartItem> ... SERIES) {
        this.properties.put("seriesArray", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B series(List<ChartItemSeries<ChartItem>> SERIES) {
        this.properties.put("seriesList", (Property)new SimpleObjectProperty(SERIES));
        return (B)this;
    }

    public final B order(Order ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B chartBackground(Paint BACKGROUND) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)BACKGROUND));
        return (B)this;
    }

    public final B spacer(double SPACER) {
        this.properties.put("spacer", (Property)new SimpleDoubleProperty(SPACER));
        return (B)this;
    }

    public final B seriesTitleVisible(boolean VISIBLE) {
        this.properties.put("seriesTitleVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B seriesTitleColor(Color COLOR) {
        this.properties.put("seriesTitleColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final NestedBarChart build() {
        NestedBarChart nestedBarChart = new NestedBarChart();
        if (this.properties.keySet().contains("seriesArray")) {
            nestedBarChart.setSeries((ChartItemSeries[])((ObjectProperty)this.properties.get("seriesArray")).get());
        }
        if (this.properties.keySet().contains("seriesList")) {
            nestedBarChart.setSeries((List)((ObjectProperty)this.properties.get("seriesList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    nestedBarChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    nestedBarChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    nestedBarChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    nestedBarChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    nestedBarChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    nestedBarChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    nestedBarChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    nestedBarChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    nestedBarChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    nestedBarChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    nestedBarChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    nestedBarChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    nestedBarChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    nestedBarChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    nestedBarChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    nestedBarChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "order": {
                    nestedBarChart.setOrder((Order)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "chartBackground": {
                    nestedBarChart.setChartBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "spacer": {
                    nestedBarChart.setSpacer(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesTitleColor": {
                    nestedBarChart.setSeriesTitleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "seriesTitleVisible": {
                    nestedBarChart.setSeriesTitleVisible(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return nestedBarChart;
    }
}

