/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.DayOfWeekCategory;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.data.MonthCategory;
import eu.hansolo.fx.charts.event.SeriesEventListener;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.series.Series;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.geometry.Rectangle;
import eu.hansolo.toolboxfx.font.Fonts;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class PanelBarChart
extends Region {
    private static final double PREFERRED_WIDTH = 600.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ObservableList<ChartItemSeries<ChartItem>> listOfSeries;
    private ObservableList<ChartItemSeries<ChartItem>> comparisonListOfSeries;
    private SeriesEventListener seriesEvtListener;
    private ObservableList<? extends Category> categories;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private Color _categoryNameColor;
    private ObjectProperty<Color> categoryNameColor;
    private String _name;
    private StringProperty name;
    private Color _nameColor;
    private ObjectProperty<Color> nameColor;
    private Color _seriesNameColor;
    private ObjectProperty<Color> seriesNameColor;
    private Color _categorySumColor;
    private ObjectProperty<Color> categorySumColor;
    private Color _seriesSumColor;
    private ObjectProperty<Color> seriesSumColor;
    private boolean _comparisonEnabled;
    private BooleanProperty comparisonEnabled;
    private String _comparisonName;
    private StringProperty comparisonName;
    private Color _comparisonNameColor;
    private ObjectProperty<Color> comparisonNameColor;
    private Color _comparisonSeriesNameColor;
    private ObjectProperty<Color> comparisonSeriesNameColor;
    private Color _comparisonCategorySumColor;
    private ObjectProperty<Color> comparisonCategorySumColor;
    private Color _comparisonSeriesSumColor;
    private ObjectProperty<Color> comparisonSeriesSumColor;
    private Color _gridColor;
    private ObjectProperty<Color> gridColor;
    private boolean _colorByCategory;
    private BooleanProperty colorByCategory;
    private Map<Category, Double> sumsPerCategory;
    private Map<Category, Double> comparisonSumsPerCategory;
    private Map<Rectangle, ChartItem> itemMap;
    private Map<Rectangle, ChartItem> comparisonItemMap;
    private EventHandler<MouseEvent> mouseHandler;
    private ListChangeListener<Category> categoryListener;
    private ListChangeListener<ChartItemSeries<ChartItem>> seriesListener;
    private InfoPopup popup;

    public PanelBarChart(List<? extends Category> categories) {
        this(categories, new ArrayList<ChartItemSeries<ChartItem>>());
    }

    public PanelBarChart(List<? extends Category> categories, ChartItemSeries<ChartItem> ... series) {
        this(categories, Arrays.asList(series));
    }

    public PanelBarChart(List<? extends Category> categories, List<ChartItemSeries<ChartItem>> series) {
        this.listOfSeries = FXCollections.observableArrayList(series);
        this.comparisonListOfSeries = FXCollections.observableArrayList();
        this.seriesEvtListener = evt -> this.redraw();
        this.categories = FXCollections.observableArrayList(categories);
        this._locale = Locale.getDefault();
        this._chartBackground = Color.TRANSPARENT;
        this._categoryNameColor = Color.BLACK;
        this._seriesNameColor = Color.BLACK;
        this._categorySumColor = Color.BLACK;
        this._seriesSumColor = Color.BLACK;
        this._comparisonSeriesNameColor = Color.BLACK;
        this._comparisonCategorySumColor = Color.BLACK;
        this._comparisonSeriesSumColor = Color.BLACK;
        this._gridColor = Color.LIGHTGRAY;
        this._colorByCategory = false;
        this._comparisonEnabled = false;
        this._name = "";
        this._nameColor = Color.BLACK;
        this._comparisonName = "";
        this._comparisonNameColor = Color.BLACK;
        this.sumsPerCategory = new ConcurrentHashMap<Category, Double>();
        this.comparisonSumsPerCategory = new ConcurrentHashMap<Category, Double>();
        this.itemMap = new ConcurrentHashMap<Rectangle, ChartItem>();
        this.comparisonItemMap = new ConcurrentHashMap<Rectangle, ChartItem>();
        this.mouseHandler = e -> this.handleMouseEvent((MouseEvent)e);
        this.categoryListener = c -> this.redraw();
        this.seriesListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(series1 -> series1.addSeriesEventListener(this.seriesEvtListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(series1 -> series1.removeSeriesEventListener(this.seriesEvtListener));
            }
            this.recalc();
            this.redraw();
        };
        this.popup = new InfoPopup();
        this.recalc();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(600.0, 400.0);
            }
        }
        this.canvas = new Canvas(600.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.categories.addListener(this.categoryListener);
        this.listOfSeries.addListener(this.seriesListener);
        this.comparisonListOfSeries.addListener(this.seriesListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 2048.0;
    }

    protected double computeMaxHeight(double width) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public ObservableList<? extends Category> getCategories() {
        return this.categories;
    }

    public ObservableList<ChartItemSeries<ChartItem>> getListOfSeries() {
        return this.listOfSeries;
    }

    public void setListOfSeries(ChartItemSeries<ChartItem> ... arrayOfSeries) {
        this.setListOfSeries(Arrays.asList(arrayOfSeries));
    }

    public void setListOfSeries(List<ChartItemSeries<ChartItem>> listOfSeries) {
        this.listOfSeries.setAll(listOfSeries);
    }

    public void addSeries(ChartItemSeries<ChartItem> series) {
        if (this.listOfSeries.contains(series)) {
            return;
        }
        this.listOfSeries.add(series);
    }

    public void removeSeries(Series<ChartItem> series) {
        if (!this.listOfSeries.contains(series)) {
            return;
        }
        this.listOfSeries.remove(series);
    }

    public ObservableList<ChartItemSeries<ChartItem>> getComparisonListOfSeries() {
        return this.comparisonListOfSeries;
    }

    public void setComparisonListOfSeries(ChartItemSeries<ChartItem> ... arrayOfSeries) {
        this.setComparisonListOfSeries(Arrays.asList(arrayOfSeries));
    }

    public void setComparisonListOfSeries(List<ChartItemSeries<ChartItem>> listOfOfSeries) {
        this.comparisonListOfSeries.setAll(listOfOfSeries);
    }

    public void addComparisonSeries(ChartItemSeries<ChartItem> series) {
        if (this.comparisonListOfSeries.contains(series)) {
            return;
        }
        this.comparisonListOfSeries.add(series);
    }

    public void removeComparisonSeries(ChartItemSeries<ChartItem> series) {
        if (this.comparisonListOfSeries.contains(series)) {
            this.comparisonListOfSeries.remove(series);
        }
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale locale) {
        if (null == this.locale) {
            this._locale = locale;
            this.redraw();
        } else {
            this.locale.set((Object)locale);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "locale";
                }
            };
            this._locale = null;
        }
        return this.locale;
    }

    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    public void setChartBackground(Paint chartBackground) {
        if (null == this.chartBackground) {
            this._chartBackground = chartBackground;
            this.redraw();
        } else {
            this.chartBackground.set((Object)chartBackground);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String name) {
        if (null == this.name) {
            this._name = name;
            this.redraw();
        } else {
            this.name.set((Object)name);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public Color getNameColor() {
        return null == this.nameColor ? this._nameColor : (Color)this.nameColor.get();
    }

    public void setNameColor(Color color) {
        if (null == this.nameColor) {
            this._nameColor = color;
            this.redraw();
        } else {
            this.nameColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> nameColorProperty() {
        if (null == this.nameColor) {
            this.nameColor = new ObjectPropertyBase<Color>(this._nameColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "nameColor";
                }
            };
            this._nameColor = null;
        }
        return this.nameColor;
    }

    public Color getCategoryNameColor() {
        return null == this.categoryNameColor ? this._categoryNameColor : (Color)this.categoryNameColor.get();
    }

    public void setCategoryNameColor(Color color) {
        if (null == this.categoryNameColor) {
            this._categoryNameColor = color;
            this.redraw();
        } else {
            this.categoryNameColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> categoryNameColorProperty() {
        if (null == this.categoryNameColor) {
            this.categoryNameColor = new ObjectPropertyBase<Color>(this._categoryNameColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "categoryNameColor";
                }
            };
            this._categoryNameColor = null;
        }
        return this.categoryNameColor;
    }

    public Color getSeriesNameColor() {
        return null == this.seriesNameColor ? this._seriesNameColor : (Color)this.seriesNameColor.get();
    }

    public void setSeriesNameColor(Color color) {
        if (null == this.seriesNameColor) {
            this._seriesNameColor = color;
            this.redraw();
        } else {
            this.seriesNameColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> seriesNameColorProperty() {
        if (null == this.seriesNameColor) {
            this.seriesNameColor = new ObjectPropertyBase<Color>(this._seriesNameColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "seriesNameColor";
                }
            };
            this._seriesNameColor = null;
        }
        return this.seriesNameColor;
    }

    public Color getCategorySumColor() {
        return null == this.categorySumColor ? this._categorySumColor : (Color)this.categorySumColor.get();
    }

    public void setCategorySumColor(Color color) {
        if (null == this.categorySumColor) {
            this._categorySumColor = color;
            this.redraw();
        } else {
            this.categorySumColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> categorySumColorProperty() {
        if (null == this.categorySumColor) {
            this.categorySumColor = new ObjectPropertyBase<Color>(this._categorySumColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "categorySumColor";
                }
            };
            this._categorySumColor = null;
        }
        return this.categorySumColor;
    }

    public Color getSeriesSumColor() {
        return null == this.seriesSumColor ? this._seriesSumColor : (Color)this.seriesSumColor.get();
    }

    public void setSeriesSumColor(Color color) {
        if (null == this.seriesSumColor) {
            this._seriesSumColor = color;
            this.redraw();
        } else {
            this.seriesSumColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> seriesSumColorProperty() {
        if (null == this.seriesSumColor) {
            this.seriesSumColor = new ObjectPropertyBase<Color>(this._seriesSumColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "seriesSumColor";
                }
            };
            this._seriesSumColor = null;
        }
        return this.seriesSumColor;
    }

    public Color getGridColor() {
        return null == this.gridColor ? this._gridColor : (Color)this.gridColor.get();
    }

    public void setGridColor(Color color) {
        if (null == this.gridColor) {
            this._gridColor = color;
            this.redraw();
        } else {
            this.gridColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> gridColorProperty() {
        if (null == this.gridColor) {
            this.gridColor = new ObjectPropertyBase<Color>(){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "gridColor";
                }
            };
            this._gridColor = null;
        }
        return this.gridColor;
    }

    public boolean getColorByCategory() {
        return null == this.colorByCategory ? this._colorByCategory : this.colorByCategory.get();
    }

    public void setColorByCategory(boolean colorByCategory) {
        if (null == this.colorByCategory) {
            this._colorByCategory = colorByCategory;
            this.redraw();
        } else {
            this.colorByCategory.set(colorByCategory);
        }
    }

    public BooleanProperty colorByCategoryProperty() {
        if (null == this.colorByCategory) {
            this.colorByCategory = new BooleanPropertyBase(this._colorByCategory){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "colorByCategory";
                }
            };
        }
        return this.colorByCategory;
    }

    public boolean getComparisonEnabled() {
        return null == this.comparisonEnabled ? this._comparisonEnabled : this.comparisonEnabled.get();
    }

    public void setComparisonEnabled(boolean comparisonEnabled) {
        if (null == this.comparisonEnabled) {
            this._comparisonEnabled = comparisonEnabled;
            this.redraw();
        } else {
            this.comparisonEnabled.set(comparisonEnabled);
        }
    }

    public BooleanProperty comparisonEnabledProperty() {
        if (null == this.comparisonEnabled) {
            this.comparisonEnabled = new BooleanPropertyBase(this._comparisonEnabled){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonEnabled";
                }
            };
        }
        return this.comparisonEnabled;
    }

    public String getComparisonName() {
        return null == this.comparisonName ? this._comparisonName : (String)this.comparisonName.get();
    }

    public void setComparisonName(String name) {
        if (null == this.comparisonName) {
            this._comparisonName = name;
            this.redraw();
        } else {
            this.comparisonName.set((Object)name);
        }
    }

    public StringProperty comparisonNameProperty() {
        if (null == this.comparisonName) {
            this.comparisonName = new StringPropertyBase(this._comparisonName){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonName";
                }
            };
            this._comparisonName = null;
        }
        return this.comparisonName;
    }

    public Color getComparisonNameColor() {
        return null == this.comparisonNameColor ? this._comparisonNameColor : (Color)this.comparisonNameColor.get();
    }

    public void setComparisonNameColor(Color color) {
        if (null == this.comparisonNameColor) {
            this._comparisonNameColor = color;
            this.redraw();
        } else {
            this.comparisonNameColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> comparisonNameColorProperty() {
        if (null == this.comparisonNameColor) {
            this.comparisonNameColor = new ObjectPropertyBase<Color>(this._comparisonNameColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonNameColor";
                }
            };
            this._comparisonNameColor = null;
        }
        return this.comparisonNameColor;
    }

    public Color getComparisonCategorySumColor() {
        return null == this.comparisonCategorySumColor ? this._comparisonCategorySumColor : (Color)this.comparisonCategorySumColor.get();
    }

    public void setComparisonCategorySumColor(Color color) {
        if (null == this.comparisonCategorySumColor) {
            this._comparisonCategorySumColor = color;
            this.redraw();
        } else {
            this.comparisonCategorySumColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> comparisonCategorySumColorProperty() {
        if (null == this.comparisonCategorySumColor) {
            this.comparisonCategorySumColor = new ObjectPropertyBase<Color>(this._comparisonCategorySumColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonCategorySumColor";
                }
            };
            this._comparisonCategorySumColor = null;
        }
        return this.comparisonCategorySumColor;
    }

    public Color getComparisonSeriesNameColor() {
        return null == this.comparisonSeriesNameColor ? this._comparisonSeriesNameColor : (Color)this.comparisonSeriesNameColor.get();
    }

    public void setComparisonSeriesNameColor(Color color) {
        if (null == this.comparisonSeriesNameColor) {
            this._comparisonSeriesNameColor = color;
            this.redraw();
        } else {
            this.comparisonSeriesNameColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> comparisonSeriesNameColorProperty() {
        if (null == this.comparisonSeriesNameColor) {
            this.comparisonSeriesNameColor = new ObjectPropertyBase<Color>(this._comparisonSeriesNameColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonSeriesNameColor";
                }
            };
            this._comparisonSeriesNameColor = null;
        }
        return this.comparisonSeriesNameColor;
    }

    public Color getComparisonSeriesSumColor() {
        return null == this.comparisonSeriesSumColor ? this._comparisonSeriesSumColor : (Color)this.comparisonSeriesSumColor.get();
    }

    public void setComparisonSeriesSumColor(Color color) {
        if (null == this.comparisonSeriesSumColor) {
            this._comparisonSeriesSumColor = color;
            this.redraw();
        } else {
            this.comparisonSeriesSumColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> comparisonSeriesSumColorProperty() {
        if (null == this.comparisonSeriesSumColor) {
            this.comparisonSeriesSumColor = new ObjectPropertyBase<Color>(this._comparisonSeriesSumColor){

                protected void invalidated() {
                    PanelBarChart.this.redraw();
                }

                public Object getBean() {
                    return PanelBarChart.this;
                }

                public String getName() {
                    return "comparisonSeriesSumColor";
                }
            };
            this._comparisonSeriesSumColor = null;
        }
        return this.comparisonSeriesSumColor;
    }

    public void removeAllData() {
        this.listOfSeries.clear();
        this.comparisonListOfSeries.clear();
        this.redraw();
    }

    public void dispose() {
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.categories.removeListener(this.categoryListener);
        this.listOfSeries.forEach(series -> series.removeSeriesEventListener(this.seriesEvtListener));
        this.listOfSeries.removeListener(this.seriesListener);
        this.comparisonListOfSeries.forEach(series -> series.removeSeriesEventListener(this.seriesEvtListener));
        this.comparisonListOfSeries.removeListener(this.seriesListener);
    }

    private void recalc() {
        this.sumsPerCategory.clear();
        this.comparisonSumsPerCategory.clear();
        for (Category category : this.categories) {
            this.listOfSeries.stream().mapToDouble(series -> series.getItems().parallelStream().filter(item -> item.getCategory().getName().equals(category.getName())).map(ChartItem::getValue).reduce(0.0, Double::sum)).forEach(seriesSum -> {
                double sum = this.sumsPerCategory.getOrDefault(category, 0.0);
                this.sumsPerCategory.put(category, sum + seriesSum);
            });
            this.comparisonListOfSeries.stream().mapToDouble(comparisonSeries -> comparisonSeries.getItems().parallelStream().filter(item -> item.getCategory().getName().equals(category.getName())).map(ChartItem::getValue).reduce(0.0, Double::sum)).forEach(comparisonSeriesSum -> {
                double comparisonSum = this.comparisonSumsPerCategory.getOrDefault(category, 0.0);
                this.comparisonSumsPerCategory.put(category, comparisonSum + comparisonSeriesSum);
            });
        }
    }

    private void handleMouseEvent(MouseEvent evt) {
        EventType type = evt.getEventType();
        double x = evt.getX();
        double y = evt.getY();
        if (type.equals(MouseEvent.MOUSE_PRESSED)) {
            Optional<Map.Entry> optionalItem = this.itemMap.entrySet().parallelStream().filter(entry -> ((Rectangle)entry.getKey()).contains(x, y)).findFirst();
            if (optionalItem.isPresent()) {
                this.popup.setX(evt.getScreenX());
                this.popup.setY(evt.getScreenY() - this.popup.getHeight());
                if (((ChartItem)optionalItem.get().getValue()).getDescription().isEmpty()) {
                    this.popup.update((Item)optionalItem.get().getValue());
                } else {
                    this.popup.update((Item)optionalItem.get().getValue(), true);
                }
                this.popup.animatedShow(this.getScene().getWindow());
            } else {
                Optional<Map.Entry> optionalComparisonItem = this.comparisonItemMap.entrySet().parallelStream().filter(entry -> ((Rectangle)entry.getKey()).contains(x, y)).findFirst();
                if (optionalComparisonItem.isPresent()) {
                    this.popup.setX(evt.getScreenX());
                    this.popup.setY(evt.getScreenY() - this.popup.getHeight());
                    if (((ChartItem)optionalComparisonItem.get().getValue()).getDescription().isEmpty()) {
                        this.popup.update((Item)optionalComparisonItem.get().getValue());
                    } else {
                        this.popup.update((Item)optionalComparisonItem.get().getValue(), true);
                    }
                    this.popup.animatedShow(this.getScene().getWindow());
                }
            }
        }
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.redraw();
        }
    }

    private void redraw() {
        block19: {
            this.ctx.clearRect(0.0, 0.0, this.width, this.height);
            this.ctx.setFill(this.getChartBackground());
            this.ctx.fillRect(0.0, 0.0, this.width, this.height);
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.setTextBaseline(VPos.CENTER);
            if (this.listOfSeries.isEmpty()) break block19;
            if (this.getComparisonEnabled() && !this.comparisonListOfSeries.isEmpty() && this.listOfSeries.size() == this.comparisonListOfSeries.size()) {
                int noOfSeries = this.listOfSeries.size();
                int noOfCategories = this.categories.size();
                double nameColumnWidth = this.width * 0.125;
                double sumColumnWidth = this.width * 0.06125;
                double spaceBetweenCategories = this.width * 0.00625;
                double spaceBetweenSeries = this.height * 0.0075;
                double cellWidth = (this.width - (double)(noOfCategories - 1) * spaceBetweenCategories - nameColumnWidth - sumColumnWidth) / (double)noOfCategories;
                double cellHeight = (this.height - (double)(noOfSeries + 1) * spaceBetweenSeries) / (double)(noOfSeries + 2);
                double maxCellValue = Math.max(this.listOfSeries.parallelStream().max(Comparator.comparingDouble(ChartItemSeries::getMaxValue)).get().getMaxValue(), this.comparisonListOfSeries.parallelStream().max(Comparator.comparingDouble(ChartItemSeries::getMaxValue)).get().getMaxValue());
                double scaleFactorX = cellWidth / maxCellValue;
                double itemHeight = cellHeight * 0.4;
                double itemOffsetY = cellHeight * 0.1;
                double spaceBetweenItems = cellHeight * 0.05;
                boolean useCategoryColor = this.getColorByCategory();
                double completeSum = this.sumsPerCategory.values().stream().reduce(0.0, (a, b) -> a + b);
                double comparisonCompleteSum = this.comparisonSumsPerCategory.values().stream().reduce(0.0, (a, b) -> a + b);
                this.ctx.setFont(Fonts.opensansSemibold((double)(cellHeight * 0.25)));
                this.ctx.setFill((Paint)this.getNameColor());
                this.ctx.fillText(this.getName(), 0.0, cellHeight * 0.25, cellWidth);
                this.ctx.setFill((Paint)this.getComparisonNameColor());
                this.ctx.fillText(this.getComparisonName(), 0.0, cellHeight * 0.75, cellWidth * 0.95);
                this.ctx.setTextAlign(TextAlignment.RIGHT);
                this.ctx.setFill((Paint)this.getCategorySumColor());
                this.ctx.fillText(Helper.shortenNumber((long)completeSum), this.width, cellHeight * 0.25, sumColumnWidth);
                this.ctx.setFill((Paint)this.getComparisonCategorySumColor());
                this.ctx.fillText(Helper.shortenNumber((long)comparisonCompleteSum), this.width, cellHeight * 0.75, sumColumnWidth * 0.95);
                for (int y = 0; y < noOfSeries; ++y) {
                    ChartItemSeries series = (ChartItemSeries)this.listOfSeries.get(y);
                    String seriesName = series.getName();
                    String sumOfSeries = Helper.shortenNumber((long)series.getSumOfAllItems());
                    double posY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight + cellHeight * 0.1;
                    this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.5)));
                    this.ctx.setTextAlign(TextAlignment.LEFT);
                    this.ctx.setFill((Paint)this.getSeriesNameColor());
                    this.ctx.fillText(seriesName, 0.0, posY + cellHeight * 0.5, nameColumnWidth * 0.95);
                    this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.25)));
                    this.ctx.setTextAlign(TextAlignment.RIGHT);
                    this.ctx.setFill((Paint)this.getSeriesSumColor());
                    this.ctx.fillText(sumOfSeries, this.width, posY + itemHeight * 0.5, sumColumnWidth * 0.95);
                    ChartItemSeries comparisonSeries = (ChartItemSeries)this.comparisonListOfSeries.get(y);
                    String comparisonSumOfSeries = Helper.shortenNumber((long)comparisonSeries.getSumOfAllItems());
                    double comparisonPosY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight + itemHeight + spaceBetweenItems + cellHeight * 0.1;
                    this.ctx.setFill((Paint)this.getComparisonSeriesSumColor());
                    this.ctx.fillText(comparisonSumOfSeries, this.width, comparisonPosY + itemHeight * 0.5, sumColumnWidth * 0.95);
                }
                this.ctx.setTextAlign(TextAlignment.LEFT);
                Locale locale = this.getLocale();
                for (int x = 0; x < noOfCategories; ++x) {
                    String categoryName;
                    this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.25)));
                    double posX = nameColumnWidth + (double)x * (cellWidth + spaceBetweenCategories);
                    Category category = (Category)this.categories.get(x);
                    double sum = this.sumsPerCategory.get(category);
                    double comparisonSum = this.comparisonSumsPerCategory.get(category);
                    if (category instanceof MonthCategory) {
                        MonthCategory monthCategory = (MonthCategory)category;
                        categoryName = monthCategory.getName(TextStyle.SHORT, locale);
                    } else if (category instanceof DayOfWeekCategory) {
                        DayOfWeekCategory dayOfWeekCategory = (DayOfWeekCategory)category;
                        categoryName = dayOfWeekCategory.getName(TextStyle.SHORT, locale);
                    } else {
                        categoryName = category.getName();
                    }
                    this.ctx.setFill((Paint)this.getCategorySumColor());
                    this.ctx.fillText(Helper.shortenNumber((long)sum), posX, cellHeight * 0.25, cellWidth * 0.95);
                    this.ctx.setFill((Paint)this.getComparisonCategorySumColor());
                    this.ctx.fillText(Helper.shortenNumber((long)comparisonSum), posX, cellHeight * 0.75, cellWidth * 0.95);
                    this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.5)));
                    this.ctx.setFill((Paint)this.getCategoryNameColor());
                    this.ctx.fillText(categoryName, posX, this.height - cellHeight * 0.5, cellWidth * 0.95);
                }
                this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.25)));
                this.itemMap.clear();
                this.ctx.setStroke((Paint)this.getGridColor());
                for (int y = 0; y < noOfSeries; ++y) {
                    ChartItemSeries series = (ChartItemSeries)this.listOfSeries.get(y);
                    double posY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight;
                    for (int x = 0; x < noOfCategories; ++x) {
                        double posX = nameColumnWidth + (double)x * (cellWidth + spaceBetweenCategories);
                        this.ctx.strokeLine(posX, cellHeight, posX, (double)noOfSeries * (cellHeight + spaceBetweenSeries) + cellHeight);
                        Category category = (Category)this.categories.get(x);
                        String categoryName = category.getName();
                        Optional<ChartItem> chartItem = series.getItems().stream().filter(item -> item.getCategory().getName().equals(categoryName)).findFirst();
                        if (!chartItem.isPresent()) continue;
                        ChartItem item2 = chartItem.get();
                        double itemWidth = item2.getValue() * scaleFactorX;
                        this.ctx.setFill((Paint)(useCategoryColor ? category.getFill() : item2.getFill()));
                        this.ctx.fillRect(posX, posY + itemOffsetY, itemWidth, itemHeight);
                        this.itemMap.put(new Rectangle(posX, posY + itemOffsetY, itemWidth, itemHeight), item2);
                    }
                    ChartItemSeries comparisonSeries = (ChartItemSeries)this.comparisonListOfSeries.get(y);
                    double comparisonPosY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight + itemHeight + spaceBetweenItems;
                    for (int x = 0; x < noOfCategories; ++x) {
                        double posX = nameColumnWidth + (double)x * (cellWidth + spaceBetweenCategories);
                        this.ctx.strokeLine(posX, cellHeight, posX, (double)noOfSeries * (cellHeight + spaceBetweenSeries) + cellHeight);
                        Category category = (Category)this.categories.get(x);
                        String categoryName = category.getName();
                        Optional<ChartItem> chartItem = comparisonSeries.getItems().stream().filter(item -> item.getCategory().getName().equals(categoryName)).findFirst();
                        if (!chartItem.isPresent()) continue;
                        ChartItem item3 = chartItem.get();
                        double itemWidth = item3.getValue() * scaleFactorX;
                        this.ctx.setFill((Paint)(useCategoryColor ? category.getFill() : item3.getFill()));
                        this.ctx.fillRect(posX, comparisonPosY + itemOffsetY, itemWidth, itemHeight);
                        this.itemMap.put(new Rectangle(posX, comparisonPosY + itemOffsetY, itemWidth, itemHeight), item3);
                    }
                }
            } else {
                int noOfSeries = this.listOfSeries.size();
                int noOfCategories = this.categories.size();
                double nameColumnWidth = this.width * 0.125;
                double sumColumnWidth = this.width * 0.06125;
                double spaceBetweenCategories = this.width * 0.00625;
                double spaceBetweenSeries = this.height * 0.0075;
                double cellWidth = (this.width - (double)(noOfCategories - 1) * spaceBetweenCategories - nameColumnWidth - sumColumnWidth) / (double)noOfCategories;
                double cellHeight = (this.height - (double)(noOfSeries + 1) * spaceBetweenSeries) / (double)(noOfSeries + 2);
                double maxCellValue = this.listOfSeries.parallelStream().max(Comparator.comparingDouble(ChartItemSeries::getMaxValue)).get().getMaxValue();
                double scaleFactorX = cellWidth / maxCellValue;
                double itemHeight = cellHeight * 0.8;
                double itemOffsetY = cellHeight * 0.1;
                boolean useCategoryColor = this.getColorByCategory();
                double completeSum = this.sumsPerCategory.values().stream().reduce(0.0, (a, b) -> a + b);
                this.ctx.setFont(Fonts.opensansSemibold((double)(cellHeight * 0.5)));
                this.ctx.setFill((Paint)this.getNameColor());
                this.ctx.fillText(this.getName(), 0.0, cellHeight * 0.5, cellWidth * 0.95);
                this.ctx.setTextAlign(TextAlignment.RIGHT);
                this.ctx.setFill((Paint)this.getCategoryNameColor());
                this.ctx.fillText(Helper.shortenNumber((long)completeSum), this.width, cellHeight * 0.5, sumColumnWidth * 0.95);
                this.ctx.setFont(Fonts.opensansRegular((double)(cellHeight * 0.5)));
                for (int y = 0; y < noOfSeries; ++y) {
                    ChartItemSeries series = (ChartItemSeries)this.listOfSeries.get(y);
                    String seriesName = series.getName();
                    String sumOfSeries = Helper.shortenNumber((long)series.getSumOfAllItems());
                    double posY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight;
                    this.ctx.setTextAlign(TextAlignment.LEFT);
                    this.ctx.setFill((Paint)this.getSeriesNameColor());
                    this.ctx.fillText(seriesName, 0.0, posY + cellHeight * 0.5, nameColumnWidth * 0.95);
                    this.ctx.setTextAlign(TextAlignment.RIGHT);
                    this.ctx.setFill((Paint)this.getSeriesSumColor());
                    this.ctx.fillText(sumOfSeries, this.width, posY + cellHeight * 0.5, sumColumnWidth * 0.95);
                }
                this.ctx.setTextAlign(TextAlignment.LEFT);
                Locale locale = this.getLocale();
                for (int x = 0; x < noOfCategories; ++x) {
                    String categoryName;
                    double posX = nameColumnWidth + (double)x * (cellWidth + spaceBetweenCategories);
                    Category category = (Category)this.categories.get(x);
                    double sum = this.sumsPerCategory.get(category);
                    if (category instanceof MonthCategory) {
                        MonthCategory monthCategory = (MonthCategory)category;
                        categoryName = monthCategory.getName(TextStyle.SHORT, locale);
                    } else if (category instanceof DayOfWeekCategory) {
                        DayOfWeekCategory dayOfWeekCategory = (DayOfWeekCategory)category;
                        categoryName = dayOfWeekCategory.getName(TextStyle.SHORT, locale);
                    } else {
                        categoryName = category.getName();
                    }
                    this.ctx.setFill((Paint)this.getCategorySumColor());
                    this.ctx.fillText(Helper.shortenNumber((long)sum), posX, cellHeight * 0.5, cellWidth * 0.95);
                    this.ctx.setFill((Paint)this.getCategoryNameColor());
                    this.ctx.fillText(categoryName, posX, this.height - cellHeight * 0.5, cellWidth * 0.95);
                }
                this.itemMap.clear();
                this.ctx.setStroke((Paint)this.getGridColor());
                for (int y = 0; y < noOfSeries; ++y) {
                    ChartItemSeries series = (ChartItemSeries)this.listOfSeries.get(y);
                    double posY = (double)y * (cellHeight + spaceBetweenSeries) + cellHeight;
                    for (int x = 0; x < noOfCategories; ++x) {
                        double posX = nameColumnWidth + (double)x * (cellWidth + spaceBetweenCategories);
                        this.ctx.strokeLine(posX, cellHeight, posX, (double)noOfSeries * (cellHeight + spaceBetweenSeries) + cellHeight);
                        Category category = (Category)this.categories.get(x);
                        String categoryName = category.getName();
                        Optional<ChartItem> chartItem = series.getItems().stream().filter(item -> item.getCategory().getName().equals(categoryName)).findFirst();
                        if (!chartItem.isPresent()) continue;
                        ChartItem item4 = chartItem.get();
                        double itemWidth = item4.getValue() * scaleFactorX;
                        this.ctx.setFill((Paint)(useCategoryColor ? category.getFill() : item4.getFill()));
                        this.ctx.fillRect(posX, posY + itemOffsetY, itemWidth, itemHeight);
                        this.itemMap.put(new Rectangle(posX, posY + itemOffsetY, itemWidth, itemHeight), item4);
                    }
                }
            }
        }
    }
}

