/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.TreeNode;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.event.TreeNodeEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.InfoPopup;
import eu.hansolo.fx.charts.tools.TextOrientation;
import eu.hansolo.fx.charts.tools.VisibleData;
import eu.hansolo.fx.geometry.Circle;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.FontMetrix;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class RadialTidyTree<T extends ChartItem>
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color BRIGHT_TEXT_COLOR = Color.WHITE;
    private static final Color DARK_TEXT_COLOR = Color.BLACK;
    private static final double MAX_ANGLE_RANGE = 180.0;
    private double size;
    private double width;
    private double height;
    private double center;
    private double nodeDotRadius;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private Paint backgroundPaint = Color.TRANSPARENT;
    private Paint borderPaint = Color.TRANSPARENT;
    private double borderWidth = 0.0;
    private VisibleData _visibleData = VisibleData.NAME;
    private ObjectProperty<VisibleData> visibleData;
    private Color _backgroundColor = Color.WHITE;
    private ObjectProperty<Color> backgroundColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private boolean _useColorFromParent = false;
    private BooleanProperty useColorFromParent;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _autoTextColor = true;
    private BooleanProperty autoTextColor;
    private Color _brightTextColor = BRIGHT_TEXT_COLOR;
    private ObjectProperty<Color> brightTextColor;
    private Color _darkTextColor = DARK_TEXT_COLOR;
    private ObjectProperty<Color> darkTextColor;
    private boolean _useChartItemTextColor = false;
    private BooleanProperty useChartItemTextColor;
    private String formatString = "%.0f";
    private TreeNode<T> tree;
    private TreeNode<T> root;
    private int maxLevel;
    private Map<Integer, List<TreeNode<T>>> levelMap;
    private Map<Integer, Double> angleStepMap;
    private InvalidationListener sizeListener;
    private Map<Circle, T> circleMap;
    private InfoPopup popup;
    private final EvtObserver<TreeNodeEvt<T>> treeNodeEvtObserver;

    public RadialTidyTree() {
        this(new TreeNode<ChartItem>(new ChartItem()));
    }

    public RadialTidyTree(TreeNode<T> TREE) {
        this.tree = TREE;
        this.levelMap = new HashMap<Integer, List<TreeNode<T>>>(8);
        this.angleStepMap = new HashMap<Integer, Double>(8);
        this.sizeListener = o -> this.resize();
        this.circleMap = new HashMap<Circle, T>();
        this.popup = new InfoPopup();
        this.treeNodeEvtObserver = evt -> {
            if (evt.getEvtType().equals(TreeNodeEvt.NODE_SELECTED)) {
                this.redraw();
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.prepareData();
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.sizeListener);
        this.heightProperty().addListener(this.sizeListener);
        this.tree.addTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            Optional<Map.Entry> optionalEntry = this.circleMap.entrySet().stream().filter(entry -> ((Circle)entry.getKey()).contains(e.getX(), e.getY())).findFirst();
            if (optionalEntry.isPresent()) {
                ChartItem item = (ChartItem)optionalEntry.get().getValue();
                this.popup.setX(e.getScreenX());
                this.popup.setY(e.getScreenY() - this.popup.getHeight());
                this.popup.update(item);
                this.popup.animatedShow(this.getScene().getWindow());
                item.fireChartEvt(new ChartEvt(item, ChartEvt.ITEM_SELECTED));
            }
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.widthProperty().removeListener(this.sizeListener);
        this.heightProperty().removeListener(this.sizeListener);
        this.tree.getChildren().forEach(child -> child.removeAllTreeNodeEvtObservers());
        this.tree.removeAllTreeNodeEvtObservers();
    }

    public VisibleData getVisibleData() {
        return null == this.visibleData ? this._visibleData : (VisibleData)((Object)this.visibleData.get());
    }

    public void setVisibleData(VisibleData VISIBLE_DATA) {
        if (null == this.visibleData) {
            this._visibleData = VISIBLE_DATA;
            this.redraw();
        } else {
            this.visibleData.set((Object)VISIBLE_DATA);
        }
    }

    public ObjectProperty<VisibleData> visibleDataProperty() {
        if (null == this.visibleData) {
            this.visibleData = new ObjectPropertyBase<VisibleData>(this._visibleData){

                protected void invalidated() {
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "visibleData";
                }
            };
            this._visibleData = null;
        }
        return this.visibleData;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public boolean getUseColorFromParent() {
        return null == this.useColorFromParent ? this._useColorFromParent : this.useColorFromParent.get();
    }

    public void setUseColorFromParent(boolean USE) {
        if (null == this.useColorFromParent) {
            this._useColorFromParent = USE;
            this.redraw();
        } else {
            this.useColorFromParent.set(USE);
        }
    }

    public BooleanProperty useColorFromParentProperty() {
        if (null == this.useColorFromParent) {
            this.useColorFromParent = new BooleanPropertyBase(this._useColorFromParent){

                protected void invalidated() {
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "useColorFromParent";
                }
            };
        }
        return this.useColorFromParent;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 5, DECIMALS);
            this.formatString = "%." + this._decimals + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 5, this.get()));
                    RadialTidyTree.this.formatString = "%." + this.get() + "f";
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean isAutoTextColor() {
        return null == this.autoTextColor ? this._autoTextColor : this.autoTextColor.get();
    }

    public void setAutoTextColor(boolean AUTOMATIC) {
        if (null == this.autoTextColor) {
            this._autoTextColor = AUTOMATIC;
            this.adjustTextColors();
            this.redraw();
        } else {
            this.autoTextColor.set(AUTOMATIC);
        }
    }

    public BooleanProperty autoTextColorProperty() {
        if (null == this.autoTextColor) {
            this.autoTextColor = new BooleanPropertyBase(this._autoTextColor){

                protected void invalidated() {
                    RadialTidyTree.this.adjustTextColors();
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "autoTextColor";
                }
            };
        }
        return this.autoTextColor;
    }

    public Color getBrightTextColor() {
        return null == this.brightTextColor ? this._brightTextColor : (Color)this.brightTextColor.get();
    }

    public void setBrightTextColor(Color COLOR) {
        if (null == this.brightTextColor) {
            this._brightTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.brightTextColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> brightTextColorProperty() {
        if (null == this.brightTextColor) {
            this.brightTextColor = new ObjectPropertyBase<Color>(this._brightTextColor){

                protected void invalidated() {
                    if (RadialTidyTree.this.isAutoTextColor()) {
                        RadialTidyTree.this.adjustTextColors();
                        RadialTidyTree.this.redraw();
                    }
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "brightTextColor";
                }
            };
            this._brightTextColor = null;
        }
        return this.brightTextColor;
    }

    public Color getDarkTextColor() {
        return null == this.darkTextColor ? this._darkTextColor : (Color)this.darkTextColor.get();
    }

    public void setDarkTextColor(Color COLOR) {
        if (null == this.darkTextColor) {
            this._darkTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.darkTextColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> darkTextColorProperty() {
        if (null == this.darkTextColor) {
            this.darkTextColor = new ObjectPropertyBase<Color>(this._darkTextColor){

                protected void invalidated() {
                    if (RadialTidyTree.this.isAutoTextColor()) {
                        RadialTidyTree.this.adjustTextColors();
                        RadialTidyTree.this.redraw();
                    }
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "darkTextColor";
                }
            };
            this._darkTextColor = null;
        }
        return this.darkTextColor;
    }

    public boolean getUseChartItemTextColor() {
        return null == this.useChartItemTextColor ? this._useChartItemTextColor : this.useChartItemTextColor.get();
    }

    public void setUseChartItemTextColor(boolean USE) {
        if (null == this.useChartItemTextColor) {
            this._useChartItemTextColor = USE;
            this.redraw();
        } else {
            this.useChartItemTextColor.set(USE);
        }
    }

    public BooleanProperty useChartItemTextColor() {
        if (null == this.useChartItemTextColor) {
            this.useChartItemTextColor = new BooleanPropertyBase(this._useChartItemTextColor){

                protected void invalidated() {
                    RadialTidyTree.this.redraw();
                }

                public Object getBean() {
                    return RadialTidyTree.this;
                }

                public String getName() {
                    return "useChartItemTextColor";
                }
            };
        }
        return this.useChartItemTextColor;
    }

    public void setTree(TreeNode<T> TREE) {
        if (null != this.tree) {
            this.tree.removeTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
        }
        this.tree = TREE;
        this.tree.addTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
        if (this.isAutoTextColor()) {
            this.adjustTextColors();
        }
        this.drawChart();
    }

    private void adjustTextColors() {
        Color brightColor = this.getBrightTextColor();
        Color darkColor = this.getDarkTextColor();
        this.root.stream().forEach(node -> {
            ChartItem item = (ChartItem)node.getItem();
            boolean darkFillColor = Helper.isDark(item.getFill());
            boolean darkTextColor = Helper.isDark(item.getTextFill());
            if (darkFillColor && darkTextColor) {
                item.setTextFill(brightColor);
            }
            if (!darkFillColor && !darkTextColor) {
                item.setTextFill(darkColor);
            }
        });
    }

    private void prepareData() {
        double maxAngleStep;
        this.root = this.tree.getTreeRoot();
        this.maxLevel = this.root.getMaxLevel();
        this.root.setX(this.center);
        this.root.setY(this.center);
        this.levelMap.clear();
        for (int i = 0; i <= this.maxLevel; ++i) {
            this.levelMap.put(i, new ArrayList());
        }
        this.root.stream().forEach(node -> this.levelMap.get(node.getDepth()).add((TreeNode<T>)node));
        this.angleStepMap.clear();
        this.angleStepMap.put(0, 360.0 / (double)this.levelMap.get(1).size());
        for (int level = 0; level < this.maxLevel; ++level) {
            List<TreeNode<T>> nodesInCurrentLevel = this.levelMap.get(level);
            int noOfNodesInCurrentLevel = nodesInCurrentLevel.size();
            int noOfParentsOfCurrentLevel = nodesInCurrentLevel.stream().map(node -> node.getParent()).collect(Collectors.toList()).size();
            double availableAngleSpace = 0 == level ? 360.0 / (double)noOfNodesInCurrentLevel : 360.0 / (double)noOfParentsOfCurrentLevel;
            double maxAngleStep2 = 360.0 / (double)noOfNodesInCurrentLevel;
            this.angleStepMap.put(level, maxAngleStep2);
            for (int i = 0; i < nodesInCurrentLevel.size(); ++i) {
                double angleStep;
                TreeNode<T> currentNode = nodesInCurrentLevel.get(i);
                TreeNode<T> parentNode = currentNode.getParent();
                double noOfChildNodes = null == parentNode ? 0.0 : (double)parentNode.getNoOfChildren().intValue();
                double d = angleStep = null == parentNode ? 360.0 / (double)this.levelMap.get(1).size() : Math.min(availableAngleSpace / (noOfChildNodes - 1.0), this.angleStepMap.get(level));
                if (level > 0) {
                    angleStep = this.angleStepMap.get(level - 1) / (noOfChildNodes - 1.0);
                }
                if (level == this.maxLevel) {
                    angleStep = maxAngleStep2;
                }
                this.angleStepMap.put(level, angleStep);
            }
        }
        List<TreeNode<T>> maxLevelNodes = this.levelMap.get(this.maxLevel);
        int noOfParentNodes = this.levelMap.get(this.maxLevel - 1).size();
        double availableAngleSpacePerMaxLevelNode = 360.0 / (double)noOfParentNodes;
        double angleStep = maxAngleStep = 360.0 / (double)maxLevelNodes.size();
        for (TreeNode<T> node2 : this.levelMap.get(this.maxLevel - 1)) {
            double d = node2.isLeaf() ? maxAngleStep : availableAngleSpacePerMaxLevelNode / (double)node2.getNoOfChildren().intValue();
            double currentAngleStep = d;
            if (!(currentAngleStep < angleStep)) continue;
            angleStep = currentAngleStep;
        }
        this.angleStepMap.put(this.maxLevel, angleStep);
        double currentAngle = 0.0;
        for (TreeNode<T> node3 : this.levelMap.get(1)) {
            node3.setAngle(currentAngle);
            currentAngle += this.angleStepMap.get(1).doubleValue();
        }
    }

    private void drawChart() {
        this.circleMap.clear();
        double ringRadiusStep = this.size / 2.0 / ((double)this.maxLevel + 0.5);
        double innerCircle = ringRadiusStep * 0.65;
        double levelWidth = ringRadiusStep * 0.98;
        Color bkgColor = this.getBackgroundColor();
        double nodeDotDiameter = this.nodeDotRadius * 2.0;
        Color textColor = this.getTextColor();
        double maxTextWidth = levelWidth * 0.9;
        Font font = Fonts.latoRegular((double)(levelWidth * 0.075));
        FontMetrix metrix = new FontMetrix(font);
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        this.ctx.setFill((Paint)bkgColor);
        this.ctx.fillRect(0.0, 0.0, this.size, this.size);
        this.ctx.setFont(font);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.LEFT);
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setLineWidth(1.0);
        this.ctx.setFill((Paint)((ChartItem)this.root.getItem()).getFill());
        this.ctx.fillOval(this.center - this.nodeDotRadius, this.center - this.nodeDotRadius, nodeDotDiameter, nodeDotDiameter);
        this.root.setX(this.center);
        this.root.setY(this.center);
        for (int level = 1; level <= this.maxLevel; ++level) {
            List<TreeNode<T>> nodesInCurrentLevel = this.levelMap.get(level);
            int nodeInParentCounter = 0;
            TreeNode<T> previousParent = null;
            for (int i = 0; i < nodesInCurrentLevel.size(); ++i) {
                TreeNode<T> currentNode = nodesInCurrentLevel.get(i);
                TreeNode<T> parentNode = currentNode.getParent();
                ChartItem item = (ChartItem)currentNode.getItem();
                Color paint = this.getUseColorFromParent() ? ((ChartItem)parentNode.getItem()).getFill() : item.getFill();
                double angleStep = currentNode.isLeaf() ? this.angleStepMap.get(level) : this.angleStepMap.get(parentNode.getDepth());
                double angleRange = Helper.clamp(0.0, 180.0, angleStep * (double)(parentNode.getNoOfChildren() - 1));
                if (null == previousParent || !previousParent.equals(parentNode)) {
                    previousParent = parentNode;
                    nodeInParentCounter = 0;
                }
                double startAngle = parentNode.getAngle() - angleRange * 0.5;
                double angle = startAngle + (double)nodeInParentCounter * angleStep;
                if (level < this.maxLevel && currentNode.isLeaf()) {
                    angle += angleRange * 0.5;
                }
                currentNode.setAngle(angle);
                double previousLevelRadius = level == 1 ? 0.0 : ringRadiusStep * (double)(level - 1) - innerCircle;
                double levelRadius = ringRadiusStep * (double)level - innerCircle;
                double controlPointDistance = levelRadius - previousLevelRadius;
                double[] xy = Helper.rotatePointAroundRotationCenter(this.center + levelRadius, this.center - levelRadius, this.center, this.center, angle + 90.0);
                currentNode.setX(xy[0]);
                currentNode.setY(xy[1]);
                double[] c1xy = new double[]{parentNode.getX() + controlPointDistance * Math.cos(Math.toRadians(parentNode.getAngle() + 45.0)), parentNode.getY() + controlPointDistance * Math.sin(Math.toRadians(parentNode.getAngle() + 45.0))};
                double[] c2xy = new double[]{currentNode.getX() - controlPointDistance * Math.cos(Math.toRadians(currentNode.getAngle() + 45.0)), currentNode.getY() - controlPointDistance * Math.sin(Math.toRadians(currentNode.getAngle() + 45.0))};
                this.ctx.setStroke((Paint)paint);
                this.ctx.beginPath();
                this.ctx.moveTo(parentNode.getX(), parentNode.getY());
                this.ctx.bezierCurveTo(c1xy[0], c1xy[1], c2xy[0], c2xy[1], currentNode.getX(), currentNode.getY());
                this.ctx.stroke();
                this.ctx.setFill((Paint)paint);
                this.ctx.fillOval(currentNode.getX() - this.nodeDotRadius, currentNode.getY() - this.nodeDotRadius, nodeDotDiameter, nodeDotDiameter);
                this.circleMap.put(new Circle(currentNode.getX(), currentNode.getY(), this.nodeDotRadius), item);
                if (this.getVisibleData() != VisibleData.NONE) {
                    String text = "";
                    switch (this.getVisibleData()) {
                        case VALUE: {
                            text = String.format(Locale.US, this.formatString, item.getValue());
                            break;
                        }
                        case NAME: {
                            text = item.getName();
                            break;
                        }
                        case NAME_VALUE: {
                            text = String.join((CharSequence)"", item.getName(), " (", String.format(Locale.US, this.formatString, item.getValue()), ")");
                        }
                    }
                    this.ctx.setTextAlign(angle + 135.0 < 180.0 ? TextAlignment.LEFT : TextAlignment.RIGHT);
                    double offset = currentNode.isLeaf() ? this.size * 0.00625 : -metrix.computeStringWidth(text) - this.size * 0.00625;
                    double textX = currentNode.getX() + offset * Math.cos(Math.toRadians(angle + 45.0));
                    double textY = currentNode.getY() + offset * Math.sin(Math.toRadians(angle + 45.0));
                    this.ctx.setFill((Paint)(this.getUseChartItemTextColor() ? item.getTextFill() : textColor));
                    this.ctx.save();
                    this.ctx.translate(textX, textY);
                    RadialTidyTree.rotateContextForText(this.ctx, angle + 135.0, 0.0, TextOrientation.TANGENT);
                    this.ctx.fillText(text, 0.0, 0.0, maxTextWidth);
                    this.ctx.restore();
                }
                ++nodeInParentCounter;
            }
        }
    }

    private static void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TextOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case TANGENT: {
                if (START_ANGLE + ANGLE < 180.0) {
                    CTX.rotate((START_ANGLE + ANGLE - 90.0) % 360.0);
                    break;
                }
                CTX.rotate((START_ANGLE + ANGLE + 90.0) % 360.0);
                break;
            }
            case ORTHOGONAL: {
                if (START_ANGLE + ANGLE < 270.0) {
                    CTX.rotate((START_ANGLE + ANGLE + 180.0) % 360.0);
                    break;
                }
                CTX.rotate(START_ANGLE + ANGLE);
                break;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = Math.min(this.width, this.height);
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.center = this.size * 0.5;
            this.nodeDotRadius = this.size * 0.0025;
            this.redraw();
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth / 250.0 * this.size))}));
        this.drawChart();
    }
}

