/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.RadialTidyTree;
import eu.hansolo.fx.charts.data.TreeNode;
import eu.hansolo.fx.charts.tools.VisibleData;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class RadialTidyTreeBuilder<B extends RadialTidyTreeBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected RadialTidyTreeBuilder() {
    }

    public static final RadialTidyTreeBuilder create() {
        return new RadialTidyTreeBuilder();
    }

    public final B tree(TreeNode TREE) {
        this.properties.put("tree", (Property)new SimpleObjectProperty((Object)TREE));
        return (B)this;
    }

    public final B visibleData(VisibleData VISIBLE_DATA) {
        this.properties.put("visibleData", (Property)new SimpleObjectProperty((Object)VISIBLE_DATA));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useColorFromParent(boolean USE) {
        this.properties.put("useColorFromParent", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTOMATIC) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTOMATIC));
        return (B)this;
    }

    public final B brightTextColor(Color COLOR) {
        this.properties.put("brightTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B darkTextColor(Color COLOR) {
        this.properties.put("darkTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B useChartItemTextColor(boolean USE) {
        this.properties.put("useChartItemTextColor", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final RadialTidyTree build() {
        RadialTidyTree radialTidyTree = this.properties.containsKey("tree") ? new RadialTidyTree((TreeNode)((ObjectProperty)this.properties.get("tree")).get()) : new RadialTidyTree();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    radialTidyTree.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    radialTidyTree.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    radialTidyTree.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    radialTidyTree.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    radialTidyTree.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    radialTidyTree.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    radialTidyTree.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    radialTidyTree.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    radialTidyTree.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    radialTidyTree.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    radialTidyTree.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    radialTidyTree.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    radialTidyTree.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    radialTidyTree.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    radialTidyTree.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    radialTidyTree.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "visibleData": {
                    radialTidyTree.setVisibleData((VisibleData)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "backgroundColor": {
                    radialTidyTree.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    radialTidyTree.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "useColorFromParent": {
                    radialTidyTree.setUseColorFromParent(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    radialTidyTree.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoTextColor": {
                    radialTidyTree.setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "brightTextColor": {
                    radialTidyTree.setBrightTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "darkTextColor": {
                    radialTidyTree.setDarkTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "useChartItemTextColor": {
                    radialTidyTree.setUseChartItemTextColor(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return radialTidyTree;
    }
}

