/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.StreamChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class StreamChartBuilder<B extends StreamChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected StreamChartBuilder() {
    }

    public static final StreamChartBuilder create() {
        return new StreamChartBuilder();
    }

    public final B category(StreamChart.Category CATEGORY) {
        this.properties.put("category", (Property)new SimpleObjectProperty((Object)CATEGORY));
        return (B)this;
    }

    public final B type(StreamChart.Type TYPE) {
        this.properties.put("type", (Property)new SimpleObjectProperty((Object)TYPE));
        return (B)this;
    }

    public final B items(ChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<ChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B autoTextColor(boolean AUTO) {
        this.properties.put("autoTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", (Property)new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B itemWidth(int WIDTH) {
        this.properties.put("itemWidth", (Property)new SimpleIntegerProperty(WIDTH));
        return (B)this;
    }

    public final B autoItemWidth(boolean AUTO) {
        this.properties.put("autoItemWidth", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B itemGap(int GAP) {
        this.properties.put("itemGap", (Property)new SimpleIntegerProperty(GAP));
        return (B)this;
    }

    public final B autoItemGap(boolean AUTO) {
        this.properties.put("autoItemGap", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return (B)this;
    }

    public final B itemTextThreshold(double THRESHOLD) {
        this.properties.put("itemTextThreshold", (Property)new SimpleDoubleProperty(THRESHOLD));
        return (B)this;
    }

    public final B itemTextVisible(boolean VISIBLE) {
        this.properties.put("itemTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B categoryTextColor(Color COLOR) {
        this.properties.put("categoryTextColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectionColor(Color COLOR) {
        this.properties.put("selectionColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B order(Order ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B sortByName(boolean BY_NAME) {
        this.properties.put("sortByName", (Property)new SimpleBooleanProperty(BY_NAME));
        return (B)this;
    }

    public final B categorySumVisible(boolean VISIBLE) {
        this.properties.put("categorySumVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final StreamChart build() {
        StreamChart streamChart = new StreamChart();
        if (this.properties.keySet().contains("itemsArray")) {
            streamChart.setItems((ChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        } else if (this.properties.keySet().contains("itemsList")) {
            streamChart.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    streamChart.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    streamChart.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                    streamChart.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    streamChart.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "prefHeight": {
                    streamChart.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minWidth": {
                    streamChart.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "minHeight": {
                    streamChart.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxWidth": {
                    streamChart.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "maxHeight": {
                    streamChart.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleX": {
                    streamChart.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "scaleY": {
                    streamChart.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutX": {
                    streamChart.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "layoutY": {
                    streamChart.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateX": {
                    streamChart.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "translateY": {
                    streamChart.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "padding": {
                    streamChart.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "category": {
                    streamChart.setCategory((StreamChart.Category)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "type": {
                    streamChart.setType((StreamChart.Type)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "textColor": {
                    streamChart.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoTextColor": {
                    streamChart.setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "selectionColor": {
                    streamChart.setSelectionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "decimals": {
                    streamChart.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "itemWidth": {
                    streamChart.setItemWidth(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoItemWidth": {
                    streamChart.setAutoItemWidth(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "itemGap": {
                    streamChart.setItemGap(((IntegerProperty)this.properties.get(key)).get());
                    break;
                }
                case "autoItemGap": {
                    streamChart.setAutoItemGap(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "locale": {
                    streamChart.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "itemTextThreshold": {
                    streamChart.setItemTextThreshold(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "itemTextVisible": {
                    streamChart.setItemTextVisible(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "categoryTextColor": {
                    streamChart.setCategoryTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "order": {
                    streamChart.setOrder((Order)((Object)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "sortByName": {
                    streamChart.setSortByName(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "categorySumVisible": {
                    streamChart.setCategorySumVisible(((BooleanProperty)this.properties.get(key)).get());
                }
            }
        }
        return streamChart;
    }
}

