/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Grid;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.XYPane;
import eu.hansolo.fx.charts.data.XYItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Marker;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Bounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class XYChart<T extends XYItem>
extends Region {
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double width;
    private double height;
    private double size;
    private ObservableList<XYPane<T>> xyPanes;
    private ObservableList<Axis> axis;
    private Canvas markerCanvas;
    private GraphicsContext markerCtx;
    private Axis yAxisL;
    private Axis yAxisC;
    private Axis yAxisR;
    private Axis xAxisT;
    private Axis xAxisC;
    private Axis xAxisB;
    private double topAxisHeight;
    private double rightAxisWidth;
    private double bottomAxisHeight;
    private double leftAxisWidth;
    private Grid grid;
    private boolean hasLeftYAxis;
    private boolean hasCenterYAxis;
    private boolean hasRightYAxis;
    private boolean hasTopXAxis;
    private boolean hasCenterXAxis;
    private boolean hasBottomXAxis;
    private String _title;
    private StringProperty title;
    private String _subTitle;
    private StringProperty subTitle;
    private Color _titleColor;
    private ObjectProperty<Color> titleColor;
    private Color _subTitleColor;
    private ObjectProperty<Color> subTitleColor;
    private AnchorPane pane;
    private BooleanBinding showing;
    private EvtObserver<ChartEvt> axisObserver;
    private EvtObserver<ChartEvt> updateObserver;
    private List<Marker> markers;

    public XYChart(XYPane<T> XY_PANE, Axis ... AXIS) {
        this(List.of(XY_PANE), (Grid)null, AXIS);
    }

    public XYChart(XYPane<T> XY_PANE, Grid GRID, Axis ... AXIS) {
        this(List.of(XY_PANE), GRID, AXIS);
    }

    public XYChart(List<XYPane<T>> XY_PANES, Axis ... AXIS) {
        this(XY_PANES, (Grid)null, AXIS);
    }

    public XYChart(List<XYPane<T>> XY_PANES, Grid GRID, Axis ... AXIS) {
        if (null == XY_PANES) {
            throw new IllegalArgumentException("XYPanes cannot be null");
        }
        long noOfPolarCharts = XY_PANES.stream().filter(xyPane -> xyPane.containsPolarChart()).count();
        if (noOfPolarCharts > 0L) {
            throw new IllegalArgumentException("XYPane contains Polar chart type");
        }
        this.xyPanes = FXCollections.observableList(new LinkedList<XYPane<T>>(XY_PANES));
        this.axis = FXCollections.observableList(Arrays.asList(AXIS));
        this.grid = GRID;
        this.width = 400.0;
        this.height = 250.0;
        this.axisObserver = evt -> this.adjustChartRange();
        this.updateObserver = evt -> this.drawMarkerCanvas();
        this.markers = new ArrayList<Marker>();
        this._title = "";
        this._subTitle = "";
        XY_PANES.forEach(xyPane -> xyPane.addChartEvtObserver(ChartEvt.UPDATE, this.updateObserver));
        this.checkReferenceZero();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 250.0);
            }
        }
        this.checkForAxis();
        if (this.xyPanes.size() > 1) {
            this.xyPanes.forEach(xyPane -> xyPane.setChartBackground((Paint)Color.TRANSPARENT));
        }
        this.adjustChartRange();
        this.adjustAxisAnchors();
        this.pane = new AnchorPane();
        this.xyPanes.forEach(xyPane -> this.pane.getChildren().add(xyPane));
        this.pane.getChildren().addAll(this.axis);
        this.setGrid(this.grid);
        this.markerCanvas = new Canvas(400.0, 250.0);
        this.markerCtx = this.markerCanvas.getGraphicsContext2D();
        this.markerCanvas.setMouseTransparent(true);
        this.pane.getChildren().addAll((Object[])new Node[]{this.markerCanvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.xyPanes.addListener(c -> {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(xyPane -> xyPane.addChartEvtObserver(ChartEvt.UPDATE, this.updateObserver));
            } else if (c.wasRemoved()) {
                c.getRemoved().forEach(xyPane -> xyPane.removeChartEvtObserver(ChartEvt.UPDATE, this.updateObserver));
            }
            if (this.xyPanes.size() > 1) {
                this.xyPanes.forEach(xyPane -> xyPane.setChartBackground((Paint)Color.TRANSPARENT));
            }
            this.checkReferenceZero();
            this.refresh();
        });
        if (null != this.getScene()) {
            this.setupBinding();
        } else {
            this.sceneProperty().addListener((o1, ov1, nv1) -> {
                if (null == nv1) {
                    return;
                }
                if (null != this.getScene().getWindow()) {
                    this.setupBinding();
                } else {
                    ((Scene)this.sceneProperty().get()).windowProperty().addListener((o2, ov2, nv2) -> {
                        if (null == nv2) {
                            return;
                        }
                        this.setupBinding();
                    });
                }
            });
        }
        this.axis.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(axis -> axis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.axisObserver));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getAddedSubList().forEach(axis -> axis.removeChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.axisObserver));
            }
        });
        this.axis.forEach(axis -> axis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.axisObserver));
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.axis.forEach(axis -> axis.removeChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, this.axisObserver));
        this.xyPanes.forEach(xyPane -> xyPane.dispose());
    }

    public String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
            this.refresh();
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new StringPropertyBase(this._title){

                protected void invalidated() {
                    XYChart.this.refresh();
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "title";
                }
            };
            this._title = null;
        }
        return this.title;
    }

    public String getSubTitle() {
        return null == this.subTitle ? this._subTitle : (String)this.subTitle.get();
    }

    public void setSubTitle(String SUB_TITLE) {
        if (null == this.subTitle) {
            this._subTitle = SUB_TITLE;
            this.xyPanes.forEach(xyPane -> xyPane.redraw());
        } else {
            this.subTitle.set((Object)SUB_TITLE);
        }
    }

    public StringProperty subTitleProperty() {
        if (null == this.subTitle) {
            this.subTitle = new StringPropertyBase(this._subTitle){

                protected void invalidated() {
                    XYChart.this.xyPanes.forEach(xyPane -> xyPane.redraw());
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "subTitle";
                }
            };
            this._subTitle = null;
        }
        return this.subTitle;
    }

    public Color getTitleColor() {
        return null == this.titleColor ? this._titleColor : (Color)this.titleColor.get();
    }

    public void setTitleColor(Color TITLE_COLOR) {
        if (null == this.titleColor) {
            this._titleColor = TITLE_COLOR;
            this.refresh();
        } else {
            this.titleColor.set((Object)TITLE_COLOR);
        }
    }

    public ObjectProperty<Color> titleColorProperty() {
        if (null == this.titleColor) {
            this.titleColor = new ObjectPropertyBase<Color>(this._titleColor){

                protected void invalidated() {
                    XYChart.this.refresh();
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "titleColor";
                }
            };
            this._titleColor = null;
        }
        return this.titleColor;
    }

    public Color getSubTitleColor() {
        return null == this.subTitleColor ? this._subTitleColor : (Color)this.subTitleColor.get();
    }

    public void setSubTitleColor(Color SUB_TITLE_COLOR) {
        if (null == this.subTitleColor) {
            this._subTitleColor = SUB_TITLE_COLOR;
            this.refresh();
        } else {
            this.subTitleColor.set((Object)SUB_TITLE_COLOR);
        }
    }

    public ObjectProperty<Color> subTitleColorProperty() {
        if (null == this.subTitleColor) {
            this.subTitleColor = new ObjectPropertyBase<Color>(this._subTitleColor){

                protected void invalidated() {
                    XYChart.this.refresh();
                }

                public Object getBean() {
                    return XYChart.this;
                }

                public String getName() {
                    return "subTitleColor";
                }
            };
            this._subTitleColor = null;
        }
        return this.subTitleColor;
    }

    public boolean isReferenceZero() {
        if (this.xyPanes.size() > 0) {
            return ((XYPane)this.xyPanes.get(0)).isReferenceZero();
        }
        return true;
    }

    public void setReferenceZero(boolean IS_ZERO) {
        this.xyPanes.forEach(xyPane -> xyPane.setReferenceZero(IS_ZERO));
    }

    public void setGrid(Grid GRID) {
        if (null == GRID) {
            return;
        }
        if (null != this.grid) {
            this.pane.getChildren().remove((Object)this.grid);
        }
        this.grid = GRID;
        this.pane.getChildren().add(0, (Object)this.grid);
        this.adjustGridAnchors();
    }

    public XYPane<T> getXYPane() {
        return this.xyPanes.size() > 0 ? (XYPane)this.xyPanes.get(0) : null;
    }

    public List<XYPane<T>> getXYPanes() {
        return this.xyPanes;
    }

    public void addXYPane(XYPane<T> xyPane) {
        this.xyPanes.add(xyPane);
    }

    public void removeXYPane(XYPane<T> xyPane) {
        this.xyPanes.remove(xyPane);
    }

    public List<Marker> getMarkers() {
        return new ArrayList<Marker>(this.markers);
    }

    public void setMarkers(List<Marker> markers) {
        List<Marker> validatedMarkers = this.validateMarkers(markers);
        this.markers.clear();
        validatedMarkers.forEach(marker -> this.markers.add((Marker)marker));
        this.refresh();
    }

    public void addMarker(Marker marker) {
        if (this.markers.contains(marker)) {
            return;
        }
        this.markers.add(marker);
        this.drawMarkerCanvas();
    }

    public void refresh() {
        this.xyPanes.forEach(xyPane -> xyPane.redraw());
        this.drawMarkerCanvas();
    }

    private void drawMarkerCanvas() {
        if (null == this.markerCanvas) {
            return;
        }
        this.markerCtx.clearRect(0.0, 0.0, this.width, this.height);
        this.markerCtx.setTextBaseline(VPos.BASELINE);
        this.markerCtx.setLineCap(StrokeLineCap.BUTT);
        this.markers.forEach(marker -> {
            this.markerCtx.save();
            Axis axis = marker.getAxis();
            Bounds axisBounds = axis.getAxisBounds();
            String formatString = marker.getFormatString();
            double stepSize = axis.getStepSize();
            double value = marker.getValue();
            double fontSize = axis.getTitleFontSize();
            double lineWidth = marker.getLineWidth();
            String markerText = marker.getText() + " (" + String.format(Locale.US, formatString, value) + ")";
            this.markerCtx.setLineWidth(lineWidth);
            this.markerCtx.setStroke((Paint)marker.getStroke());
            switch (marker.getLineStyle()) {
                case SOLID: {
                    this.markerCtx.setLineDashes(new double[0]);
                    break;
                }
                case DASHED: {
                    this.markerCtx.setLineDashes(new double[]{2.0 * lineWidth, lineWidth});
                    break;
                }
                case DOTTED: {
                    this.markerCtx.setLineDashes(new double[]{lineWidth, lineWidth});
                }
            }
            this.markerCtx.setFont(Fonts.latoLight((double)(fontSize * 1.5)));
            this.markerCtx.setFill((Paint)marker.getTextFill());
            switch (axis.getOrientation()) {
                case VERTICAL: {
                    double textOffsetX = 5.0;
                    double textOffsetY = fontSize * 0.8;
                    double y = axisBounds.getMinY() + axis.getMinValue() * stepSize + axisBounds.getHeight() - value * stepSize;
                    this.markerCtx.strokeLine(axisBounds.getWidth(), y, this.width - axisBounds.getWidth(), y);
                    this.markerCtx.fillText(markerText, axisBounds.getWidth() + textOffsetX, y - textOffsetY);
                    break;
                }
                case HORIZONTAL: {
                    double textOffsetX = 5.0;
                    double textOffsetY = fontSize * 0.8;
                    double x = axisBounds.getHeight() - axis.getMinValue() * stepSize + value * stepSize;
                    this.markerCtx.strokeLine(x, axisBounds.getMinY(), x, this.height - axisBounds.getHeight());
                    this.markerCtx.fillText(markerText, x + textOffsetX, this.height - axisBounds.getHeight() - textOffsetY);
                }
            }
            this.markerCtx.restore();
        });
        this.markerCtx.setFill((Paint)this.getTitleColor());
        this.markerCtx.setFont(Font.font((double)(this.size * 0.035)));
        this.markerCtx.setTextAlign(TextAlignment.CENTER);
        this.markerCtx.setTextBaseline(VPos.CENTER);
        this.markerCtx.fillText(this.getTitle(), this.width * 0.5, this.height * 0.1, this.width);
        this.markerCtx.setFill((Paint)this.getSubTitleColor());
        this.markerCtx.setFont(Font.font((double)(this.size * 0.0175)));
        this.markerCtx.fillText(this.getSubTitle(), this.width * 0.5, this.height * 0.1 + this.size * 0.035 * 1.25, this.width);
    }

    private void checkForAxis() {
        this.axis.forEach(axis -> {
            Position position = axis.getPosition();
            block0 : switch (axis.getOrientation()) {
                case HORIZONTAL: {
                    switch (position) {
                        case TOP: {
                            this.hasTopXAxis = true;
                            this.topAxisHeight = axis.getPrefHeight();
                            this.xAxisT = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterXAxis = true;
                            this.xAxisC = axis;
                            break block0;
                        }
                        case BOTTOM: {
                            this.hasBottomXAxis = true;
                            this.bottomAxisHeight = axis.getPrefHeight();
                            this.xAxisB = axis;
                            break block0;
                        }
                    }
                    this.hasTopXAxis = false;
                    this.hasCenterXAxis = false;
                    this.hasBottomXAxis = false;
                    break;
                }
                case VERTICAL: {
                    switch (position) {
                        case LEFT: {
                            this.hasLeftYAxis = true;
                            this.leftAxisWidth = axis.getPrefWidth();
                            this.yAxisL = axis;
                            break block0;
                        }
                        case CENTER: {
                            this.hasCenterYAxis = true;
                            this.yAxisC = axis;
                            break block0;
                        }
                        case RIGHT: {
                            this.hasRightYAxis = true;
                            this.rightAxisWidth = axis.getPrefWidth();
                            this.yAxisR = axis;
                            break block0;
                        }
                    }
                    this.hasLeftYAxis = false;
                    this.hasCenterYAxis = false;
                    this.hasRightYAxis = false;
                }
            }
        });
    }

    private void adjustChartRange() {
        this.xyPanes.forEach(xyPane -> {
            if (this.hasBottomXAxis) {
                xyPane.setLowerBoundX(this.xAxisB.getMinValue());
                xyPane.setUpperBoundX(this.xAxisB.getMaxValue());
            } else if (this.hasTopXAxis) {
                xyPane.setLowerBoundX(this.xAxisT.getMinValue());
                xyPane.setUpperBoundX(this.xAxisT.getMaxValue());
            } else if (this.hasCenterXAxis) {
                xyPane.setLowerBoundX(this.xAxisC.getMinValue());
                xyPane.setUpperBoundX(this.xAxisC.getMaxValue());
            }
            if (this.hasLeftYAxis) {
                xyPane.setLowerBoundY(this.yAxisL.getMinValue());
                xyPane.setUpperBoundY(this.yAxisL.getMaxValue());
            } else if (this.hasRightYAxis) {
                xyPane.setLowerBoundY(this.yAxisR.getMinValue());
                xyPane.setUpperBoundY(this.yAxisR.getMaxValue());
            } else if (this.hasCenterYAxis) {
                xyPane.setLowerBoundY(this.yAxisC.getMinValue());
                xyPane.setUpperBoundY(this.yAxisC.getMaxValue());
            }
        });
    }

    private void adjustAxisAnchors() {
        this.xyPanes.forEach(xyPane -> this.axis.forEach(axis -> {
            if (Orientation.HORIZONTAL == axis.getOrientation()) {
                AnchorPane.setLeftAnchor((Node)axis, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor((Node)axis, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
                AnchorPane.setLeftAnchor((Node)xyPane, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
                AnchorPane.setRightAnchor((Node)xyPane, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
            } else {
                AnchorPane.setTopAnchor((Node)axis, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor((Node)axis, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
                AnchorPane.setTopAnchor((Node)xyPane, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
                AnchorPane.setBottomAnchor((Node)xyPane, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
            }
        }));
    }

    private void adjustCenterAxisAnchors() {
        if (this.hasCenterYAxis) {
            if (this.hasBottomXAxis) {
                if (this.hasLeftYAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)(this.xAxisB.getZeroPosition() + this.yAxisL.getWidth()));
                } else if (this.hasRightYAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisB.getZeroPosition());
                } else if (this.hasCenterXAxis) {
                    AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisC.getZeroPosition());
                }
            } else if (this.hasLeftYAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)(this.xAxisT.getZeroPosition() + this.yAxisL.getWidth()));
            } else if (this.hasRightYAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisT.getZeroPosition());
            } else if (this.hasCenterXAxis) {
                AnchorPane.setLeftAnchor((Node)this.yAxisC, (Double)this.xAxisC.getZeroPosition());
            }
        }
        if (this.hasCenterXAxis) {
            if (this.hasLeftYAxis) {
                if (this.hasTopXAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)(this.yAxisL.getZeroPosition() + this.xAxisT.getHeight()));
                } else if (this.hasBottomXAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisL.getZeroPosition());
                } else if (this.hasCenterYAxis) {
                    AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisC.getZeroPosition());
                }
            } else if (this.hasTopXAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)(this.yAxisR.getZeroPosition() + this.xAxisT.getHeight()));
            } else if (this.hasBottomXAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisR.getZeroPosition());
            } else if (this.hasCenterYAxis) {
                AnchorPane.setTopAnchor((Node)this.xAxisC, (Double)this.yAxisC.getZeroPosition());
            }
        }
    }

    private void adjustGridAnchors() {
        if (null == this.grid) {
            return;
        }
        AnchorPane.setLeftAnchor((Node)this.grid, (Double)(this.hasLeftYAxis ? this.leftAxisWidth : 0.0));
        AnchorPane.setRightAnchor((Node)this.grid, (Double)(this.hasRightYAxis ? this.rightAxisWidth : 0.0));
        AnchorPane.setTopAnchor((Node)this.grid, (Double)(this.hasTopXAxis ? this.topAxisHeight : 0.0));
        AnchorPane.setBottomAnchor((Node)this.grid, (Double)(this.hasBottomXAxis ? this.bottomAxisHeight : 0.0));
    }

    private void setupBinding() {
        this.showing = Bindings.selectBoolean((ObservableValue)this.sceneProperty(), (String[])new String[]{"window", "showing"});
        this.showing.addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.adjustCenterAxisAnchors();
            }
        });
    }

    private void checkReferenceZero() {
        boolean isReferenceZero = true;
        if (this.xyPanes.size() > 0) {
            isReferenceZero = ((XYPane)this.xyPanes.get(0)).isReferenceZero();
        }
        this.setReferenceZero(isReferenceZero);
    }

    private List<Marker> validateMarkers(List<Marker> markersToValidate) {
        ArrayList<Marker> validatedMarkers = new ArrayList<Marker>();
        markersToValidate.forEach(marker -> {
            if (this.axis.contains((Object)marker.getAxis())) {
                validatedMarkers.add((Marker)marker);
            }
        });
        return validatedMarkers;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width > this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.markerCanvas.setWidth(this.width);
            this.markerCanvas.setHeight(this.height);
            this.markerCanvas.relocate(this.getInsets().getLeft(), this.getInsets().getTop());
            this.adjustCenterAxisAnchors();
            this.drawMarkerCanvas();
        }
    }
}

