/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ChartArea;
import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.PolarTickStep;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.XYChartItem;
import eu.hansolo.fx.charts.data.XYItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.event.CursorEvent;
import eu.hansolo.fx.charts.event.CursorEventListener;
import eu.hansolo.fx.charts.event.SeriesEventListener;
import eu.hansolo.fx.charts.series.Series;
import eu.hansolo.fx.charts.series.XYSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.toolbox.Statistics;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class XYPane<T extends XYItem>
extends Region
implements ChartArea {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 0.0;
    private static final double MINIMUM_HEIGHT = 0.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static final double MIN_SYMBOL_SIZE = 2.0;
    private static final double MAX_SYMBOL_SIZE = 6.0;
    private static final int SUB_DIVISIONS = 24;
    private static double aspectRatio;
    private boolean keepAspect;
    private double size;
    private double width;
    private double height;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private ObservableList<XYSeries<T>> listOfSeries;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Canvas cursorCanvas;
    private GraphicsContext cursorCtx;
    private double cursorX;
    private double cursorY;
    private double scaleX;
    private double scaleY;
    private double symbolSize;
    private int noOfBands;
    private double _lowerBoundX;
    private DoubleProperty lowerBoundX;
    private double _upperBoundX;
    private DoubleProperty upperBoundX;
    private double _lowerBoundY;
    private DoubleProperty lowerBoundY;
    private double _upperBoundY;
    private DoubleProperty upperBoundY;
    private boolean referenceZero;
    private double _thresholdY;
    private DoubleProperty thresholdY;
    private boolean _thresholdYVisible;
    private BooleanProperty thresholdYVisible;
    private Color _thresholdYColor;
    private ObjectProperty<Color> thresholdYColor;
    private PolarTickStep _polarTickStep;
    private ObjectProperty<PolarTickStep> polarTickStep;
    private Paint _envelopeFill;
    private ObjectProperty<Paint> envelopeFill;
    private Color _envelopeStroke;
    private ObjectProperty<Color> envelopeStroke;
    private Color _averageStroke;
    private ObjectProperty<Color> averageStroke;
    private Paint _stdDeviationFill;
    private ObjectProperty<Paint> stdDeviationFill;
    private Color _stdDeviationStroke;
    private ObjectProperty<Color> stdDeviationStroke;
    private boolean _envelopeVisible;
    private BooleanProperty envelopeVisible;
    private boolean _stdDeviationVisible;
    private BooleanProperty stdDeviationVisible;
    private double _averageStrokeWidth;
    private DoubleProperty averageStrokeWidth;
    private boolean _crossHairVisible;
    private BooleanProperty crossHairVisible;
    private Color _crossHairColor;
    private ObjectProperty<Color> crossHairColor;
    private TooltipPopup popup;
    private SeriesEventListener seriesListener;
    private EventHandler<MouseEvent> mouseHandler;
    private List<CursorEventListener> cursorEventListeners;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();

    public XYPane(List<XYSeries<T>> SERIES) {
        this((Paint)Color.TRANSPARENT, 1, SERIES.toArray(new XYSeries[0]));
    }

    public XYPane(XYSeries<T> ... SERIES) {
        this((Paint)Color.TRANSPARENT, 1, SERIES);
    }

    public XYPane(int BANDS, XYSeries<T> ... SERIES) {
        this((Paint)Color.TRANSPARENT, BANDS, SERIES);
    }

    public XYPane(Paint BACKGROUND, int BANDS, XYSeries<T> ... SERIES) {
        this.getStylesheets().add((Object)XYPane.class.getResource("chart.css").toExternalForm());
        aspectRatio = 1.0;
        this.cursorEventListeners = new CopyOnWriteArrayList<CursorEventListener>();
        this.keepAspect = false;
        this._chartBackground = BACKGROUND;
        this.listOfSeries = FXCollections.observableArrayList((Object[])SERIES);
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.symbolSize = 2.0;
        this.noOfBands = Helper.clamp(1, 5, BANDS);
        this._lowerBoundX = 0.0;
        this._upperBoundX = 100.0;
        this._lowerBoundY = 0.0;
        this._upperBoundY = 100.0;
        this.referenceZero = true;
        this._thresholdY = 100.0;
        this._thresholdYVisible = false;
        this._thresholdYColor = Color.RED;
        this._polarTickStep = PolarTickStep.FOURTY_FIVE;
        this._envelopeFill = Color.rgb((int)120, (int)120, (int)120, (double)0.2);
        this._envelopeStroke = Color.rgb((int)120, (int)120, (int)120);
        this._averageStroke = Color.BLACK;
        this._stdDeviationFill = Color.rgb((int)200, (int)0, (int)0, (double)0.2);
        this._stdDeviationStroke = Color.rgb((int)200, (int)0, (int)0);
        this._envelopeVisible = false;
        this._stdDeviationVisible = true;
        this._averageStrokeWidth = 1.0;
        this._crossHairVisible = false;
        this._crossHairColor = Color.GRAY;
        this.cursorX = -1.0;
        this.cursorY = -1.0;
        this.popup = new TooltipPopup(2000L);
        this.seriesListener = e -> this.redraw();
        this.mouseHandler = e -> {
            this.cursorX = e.getX();
            this.cursorY = e.getY();
            this.drawCursor();
            block0: for (XYSeries series : this.listOfSeries) {
                double radius = series.getSymbolSize() * 0.5;
                for (XYItem item : series.getItems()) {
                    Point2D pointInScene = this.localToScene(new Point2D((item.getX() - this.getLowerBoundX()) * this.scaleX, this.height - (item.getY() - this.getLowerBoundY()) * this.scaleY));
                    if (!Helper.isInCircle(e.getSceneX(), e.getSceneY(), pointInScene.getX(), pointInScene.getY(), radius) || item.getTooltipText().isEmpty() || this.popup.getText().equals(item.getTooltipText())) continue;
                    this.popup.setX(e.getScreenX());
                    this.popup.setY(e.getScreenY() - this.popup.getHeight());
                    this.popup.setText(item.getTooltipText());
                    this.popup.animatedShow(this.getScene().getWindow());
                    continue block0;
                }
            }
        };
        this.popup.setOnHiding(e -> this.popup.setText(""));
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().setAll((Object[])new String[]{"chart", "xy-chart"});
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.cursorCanvas = new Canvas(250.0, 250.0);
        this.cursorCanvas.setMouseTransparent(true);
        Helper.enableNode((Node)this.cursorCanvas, true);
        this.cursorCtx = this.cursorCanvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas, this.cursorCanvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.listOfSeries.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(series -> series.setOnSeriesEvent(this.seriesListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(series -> series.removeSeriesEventListener(this.seriesListener));
            }
            this.redraw();
        });
        this.listOfSeries.forEach(series -> {
            if (null != series) {
                series.setOnSeriesEvent(seriesEvent -> this.redraw());
            }
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
    }

    protected double computeMinWidth(double HEIGHT) {
        return 0.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 0.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.canvas.removeEventHandler(MouseEvent.MOUSE_MOVED, this.mouseHandler);
        this.removeAllCursorEventListeners();
    }

    @Override
    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    @Override
    public void setChartBackground(Paint PAINT) {
        if (null == this.chartBackground) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public int getNoOfBands() {
        return this.noOfBands;
    }

    public void setNoOfBands(int BANDS) {
        this.noOfBands = Helper.clamp(1, 5, BANDS);
        this.redraw();
    }

    public double getLowerBoundX() {
        return null == this.lowerBoundX ? this._lowerBoundX : this.lowerBoundX.get();
    }

    public void setLowerBoundX(double VALUE) {
        if (null == this.lowerBoundX) {
            this._lowerBoundX = VALUE;
            this.resize();
        } else {
            this.lowerBoundX.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundXProperty() {
        if (null == this.lowerBoundX) {
            this.lowerBoundX = new DoublePropertyBase(this._lowerBoundX){

                protected void invalidated() {
                    XYPane.this.resize();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "lowerBoundX";
                }
            };
        }
        return this.lowerBoundX;
    }

    public double getUpperBoundX() {
        return null == this.upperBoundX ? this._upperBoundX : this.upperBoundX.get();
    }

    public void setUpperBoundX(double VALUE) {
        if (null == this.upperBoundX) {
            this._upperBoundX = VALUE;
            this.resize();
        } else {
            this.upperBoundX.set(VALUE);
        }
    }

    public DoubleProperty upperBoundXProperty() {
        if (null == this.upperBoundX) {
            this.upperBoundX = new DoublePropertyBase(this._upperBoundX){

                protected void invalidated() {
                    XYPane.this.resize();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "upperBoundX";
                }
            };
        }
        return this.upperBoundX;
    }

    public double getLowerBoundY() {
        return null == this.lowerBoundY ? this._lowerBoundY : this.lowerBoundY.get();
    }

    public void setLowerBoundY(double VALUE) {
        if (null == this.lowerBoundY) {
            this._lowerBoundY = VALUE;
            this.resize();
        } else {
            this.lowerBoundY.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundYProperty() {
        if (null == this.lowerBoundY) {
            this.lowerBoundY = new DoublePropertyBase(this._lowerBoundY){

                protected void invalidated() {
                    XYPane.this.resize();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "lowerBoundY";
                }
            };
        }
        return this.lowerBoundY;
    }

    public double getUpperBoundY() {
        return null == this.upperBoundY ? this._upperBoundY : this.upperBoundY.get();
    }

    public void setUpperBoundY(double VALUE) {
        if (null == this.upperBoundY) {
            this._upperBoundY = VALUE;
            this.resize();
        } else {
            this.upperBoundY.set(VALUE);
        }
    }

    public DoubleProperty upperBoundYProperty() {
        if (null == this.upperBoundY) {
            this.upperBoundY = new DoublePropertyBase(this._upperBoundY){

                protected void invalidated() {
                    XYPane.this.resize();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "upperBoundY";
                }
            };
        }
        return this.upperBoundY;
    }

    public boolean isReferenceZero() {
        return this.referenceZero;
    }

    public void setReferenceZero(boolean IS_ZERO) {
        this.referenceZero = IS_ZERO;
        this.redraw();
    }

    public double getRangeX() {
        return this.getUpperBoundX() - this.getLowerBoundX();
    }

    public double getRangeY() {
        return this.getUpperBoundY() - this.getLowerBoundY();
    }

    public double getDataMinX() {
        return this.listOfSeries.stream().mapToDouble(XYSeries::getMinX).min().getAsDouble();
    }

    public double getDataMaxX() {
        return this.listOfSeries.stream().mapToDouble(XYSeries::getMaxX).max().getAsDouble();
    }

    public double getDataMinY() {
        return this.listOfSeries.stream().mapToDouble(XYSeries::getMinY).min().getAsDouble();
    }

    public double getDataMaxY() {
        return this.listOfSeries.stream().mapToDouble(XYSeries::getMaxY).max().getAsDouble();
    }

    public double getDataRangeX() {
        return this.getDataMaxX() - this.getDataMinX();
    }

    public double getDataRangeY() {
        return this.getDataMaxY() - this.getDataMinY();
    }

    public List<XYSeries<T>> getListOfSeries() {
        return this.listOfSeries;
    }

    public double getThresholdY() {
        return null == this.thresholdY ? this._thresholdY : this.thresholdY.get();
    }

    public void setThresholdY(double THRESHOLD) {
        if (null == this.thresholdY) {
            this._thresholdY = THRESHOLD;
            this.redraw();
        } else {
            this.thresholdY.set(THRESHOLD);
        }
    }

    public DoubleProperty thresholdYProperty() {
        if (null == this.thresholdY) {
            this.thresholdY = new DoublePropertyBase(this._thresholdY){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "thresholdY";
                }
            };
        }
        return this.thresholdY;
    }

    public boolean isThresholdYVisible() {
        return null == this.thresholdYVisible ? this._thresholdYVisible : this.thresholdYVisible.get();
    }

    public void setThresholdYVisible(boolean VISIBLE) {
        if (null == this.thresholdYVisible) {
            this._thresholdYVisible = VISIBLE;
            this.redraw();
        } else {
            this.thresholdYVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdYVisibleProperty() {
        if (null == this.thresholdYVisible) {
            this.thresholdYVisible = new BooleanPropertyBase(this._thresholdYVisible){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "thresholdYVisible";
                }
            };
        }
        return this.thresholdYVisible;
    }

    public Color getThresholdYColor() {
        return null == this.thresholdYColor ? this._thresholdYColor : (Color)this.thresholdYColor.get();
    }

    public void setThresholdYColor(Color COLOR) {
        if (null == this.thresholdYColor) {
            this._thresholdYColor = COLOR;
            this.redraw();
        } else {
            this.thresholdYColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdYColorProperty() {
        if (null == this.thresholdYColor) {
            this.thresholdYColor = new ObjectPropertyBase<Color>(this._thresholdYColor){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "thresholdYColor";
                }
            };
            this._thresholdYColor = null;
        }
        return this.thresholdYColor;
    }

    public PolarTickStep getPolarTickStep() {
        return null == this.polarTickStep ? this._polarTickStep : (PolarTickStep)((Object)this.polarTickStep.get());
    }

    public void setPolarTickStep(PolarTickStep STEP) {
        if (null == this.polarTickStep) {
            this._polarTickStep = STEP;
            this.drawChart();
        } else {
            this.polarTickStep.set((Object)STEP);
        }
    }

    public ObjectProperty<PolarTickStep> polarTickStepProperty() {
        if (null == this.polarTickStep) {
            this.polarTickStep = new ObjectPropertyBase<PolarTickStep>(){

                protected void invalidated() {
                    XYPane.this.drawChart();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "polarTickStep";
                }
            };
            this._polarTickStep = null;
        }
        return this.polarTickStep;
    }

    public Paint getEnvelopeFill() {
        return null == this.envelopeFill ? this._envelopeFill : (Paint)this.envelopeFill.get();
    }

    public void setEnvelopeFill(Paint ENVELOPE_FILL) {
        if (null == this.envelopeFill) {
            this._envelopeFill = ENVELOPE_FILL;
            this.redraw();
        } else {
            this.envelopeFill.set((Object)ENVELOPE_FILL);
        }
    }

    public ObjectProperty<Paint> envelopeFillProperty() {
        if (null == this.envelopeFill) {
            this.envelopeFill = new ObjectPropertyBase<Paint>(this._envelopeFill){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "envelopeFill";
                }
            };
            this._envelopeFill = null;
        }
        return this.envelopeFill;
    }

    public Color getEnvelopeStroke() {
        return null == this.envelopeStroke ? this._envelopeStroke : (Color)this.envelopeStroke.get();
    }

    public void setEnvelopeStroke(Color ENVELOPE_STROKE) {
        if (null == this.envelopeStroke) {
            this._envelopeStroke = ENVELOPE_STROKE;
            this.redraw();
        } else {
            this.envelopeStroke.set((Object)ENVELOPE_STROKE);
        }
    }

    public ObjectProperty<Color> envelopeStrokeProperty() {
        if (null == this.envelopeStroke) {
            this.envelopeStroke = new ObjectPropertyBase<Color>(this._envelopeStroke){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "envelopeStroke";
                }
            };
            this._envelopeStroke = null;
        }
        return this.envelopeStroke;
    }

    public Color getAverageStroke() {
        return null == this.averageStroke ? this._averageStroke : (Color)this.averageStroke.get();
    }

    public void setAverageStroke(Color AVERAGE_STROKE) {
        if (null == this.averageStroke) {
            this._averageStroke = AVERAGE_STROKE;
            this.redraw();
        } else {
            this.averageStroke.set((Object)AVERAGE_STROKE);
        }
    }

    public ObjectProperty<Color> averageStrokeProperty() {
        if (null == this.averageStroke) {
            this.averageStroke = new ObjectPropertyBase<Color>(this._averageStroke){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "averageStroke";
                }
            };
            this._averageStroke = null;
        }
        return this.averageStroke;
    }

    public Paint getStdDeviationFill() {
        return null == this.stdDeviationFill ? this._stdDeviationFill : (Paint)this.stdDeviationFill.get();
    }

    public void setStdDeviationFill(Paint STD_DEVIATION_FILL) {
        if (null == this.stdDeviationFill) {
            this._stdDeviationFill = STD_DEVIATION_FILL;
            this.redraw();
        } else {
            this.stdDeviationFill.set((Object)STD_DEVIATION_FILL);
        }
    }

    public ObjectProperty<Paint> stdDeviationFillProperty() {
        if (null == this.stdDeviationFill) {
            this.stdDeviationFill = new ObjectPropertyBase<Paint>(this._stdDeviationFill){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "stdDeviationFill";
                }
            };
            this._stdDeviationFill = null;
        }
        return this.stdDeviationFill;
    }

    public Color getStdDeviationStroke() {
        return null == this.stdDeviationStroke ? this._stdDeviationStroke : (Color)this.stdDeviationStroke.get();
    }

    public void setStdDeviationStroke(Color STD_DEVIATION_STROKE) {
        if (null == this.stdDeviationStroke) {
            this._stdDeviationStroke = STD_DEVIATION_STROKE;
            this.redraw();
        } else {
            this.stdDeviationStroke.set((Object)STD_DEVIATION_STROKE);
        }
    }

    public ObjectProperty<Color> stdDeviationStrokeProperty() {
        if (null == this.stdDeviationStroke) {
            this.stdDeviationStroke = new ObjectPropertyBase<Color>(this._stdDeviationStroke){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "stdDeviationStroke";
                }
            };
            this._stdDeviationStroke = null;
        }
        return this.stdDeviationStroke;
    }

    public boolean isEnvelopeVisible() {
        return null == this.envelopeVisible ? this._envelopeVisible : this.envelopeVisible.get();
    }

    public void setEnvelopeVisible(boolean VISIBLE) {
        if (null == this.envelopeVisible) {
            this._envelopeVisible = VISIBLE;
            this.redraw();
        } else {
            this.envelopeVisible.set(VISIBLE);
        }
    }

    public BooleanProperty envelopeVisibleProperty() {
        if (null == this.envelopeVisible) {
            this.envelopeVisible = new BooleanPropertyBase(){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "envelopeVisible";
                }
            };
        }
        return this.envelopeVisible;
    }

    public boolean isStdDeviationVisible() {
        return null == this.stdDeviationVisible ? this._stdDeviationVisible : this.stdDeviationVisible.get();
    }

    public void setStdDeviationVisbile(boolean VISIBLE) {
        if (null == this.stdDeviationVisible) {
            this._stdDeviationVisible = VISIBLE;
            this.redraw();
        } else {
            this.stdDeviationVisible.set(VISIBLE);
        }
    }

    public BooleanProperty stdDeviationVisibleProperty() {
        if (null == this.stdDeviationVisible) {
            this.stdDeviationVisible = new BooleanPropertyBase(this._stdDeviationVisible){

                protected void invalidated() {
                    XYPane.this.redraw();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "stdDeviationVisible";
                }
            };
        }
        return this.stdDeviationVisible;
    }

    public double getAverageStrokeWidth() {
        return null == this.averageStrokeWidth ? this._averageStrokeWidth : this.averageStrokeWidth.get();
    }

    public void setAverageStrokeWidth(double WIDTH) {
        if (null == this.averageStrokeWidth) {
            this._averageStrokeWidth = Helper.clamp(0.1, 10.0, WIDTH);
            this.redraw();
        } else {
            this.averageStrokeWidth.set(WIDTH);
        }
    }

    public DoubleProperty averageStrokeWidthProperty() {
        if (null == this.averageStrokeWidth) {
            this.averageStrokeWidth = new DoublePropertyBase(this._averageStrokeWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(0.1, 10.0, this.get()));
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "averageStrokeWidth";
                }
            };
        }
        return this.averageStrokeWidth;
    }

    public boolean isCrossHairVisible() {
        return null == this.crossHairVisible ? this._crossHairVisible : this.crossHairVisible.get();
    }

    public void setCrossHairVisible(boolean VISIBLE) {
        if (null == this.crossHairVisible) {
            this._crossHairVisible = VISIBLE;
            Helper.enableNode((Node)this.cursorCanvas, VISIBLE);
            this.drawCursor();
        } else {
            this.crossHairVisible.set(VISIBLE);
        }
    }

    public BooleanProperty crossHairVisibleProperty() {
        if (null == this.crossHairVisible) {
            this.crossHairVisible = new BooleanPropertyBase(this._crossHairVisible){

                protected void invalidated() {
                    Helper.enableNode((Node)XYPane.this.cursorCanvas, this.get());
                    XYPane.this.drawCursor();
                }

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "crossHairVisible";
                }
            };
        }
        return this.crossHairVisible;
    }

    public Color getCrossHairColor() {
        return null == this.crossHairColor ? this._crossHairColor : (Color)this.crossHairColor.get();
    }

    public void setCrossHairColor(Color COLOR) {
        if (null == this.crossHairColor) {
            this._crossHairColor = COLOR;
            this.drawCursor();
        } else {
            this.crossHairColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> crossHairColorProperty() {
        if (null == this.crossHairColor) {
            this.crossHairColor = new ObjectPropertyBase<Color>(this._crossHairColor){

                public Object getBean() {
                    return XYPane.this;
                }

                public String getName() {
                    return "crossHairColor";
                }
            };
            this._crossHairColor = null;
        }
        return this.crossHairColor;
    }

    public boolean containsPolarChart() {
        for (XYSeries series : this.listOfSeries) {
            ChartType type;
            if (null == series || ChartType.POLAR != (type = series.getChartType()) && ChartType.SMOOTH_POLAR != type) continue;
            return true;
        }
        return false;
    }

    protected void redraw() {
        this.drawChart();
        this.drawCursor();
        this.fireChartEvt(new ChartEvt(this, ChartEvt.UPDATE));
    }

    private void drawChart() {
        if (null == this.listOfSeries || this.listOfSeries.isEmpty()) {
            return;
        }
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.listOfSeries.size() == 2) {
            boolean deltaChart = false;
            ChartType[] chartTypes = new ChartType[2];
            int count = 0;
            for (Series series2 : this.listOfSeries) {
                chartTypes[count] = series2.getChartType();
                deltaChart = ChartType.LINE_DELTA == chartTypes[count] || ChartType.SMOOTH_LINE_DELTA == chartTypes[count];
                ++count;
            }
            if (deltaChart && chartTypes[0] == chartTypes[1]) {
                switch (chartTypes[0]) {
                    case LINE_DELTA: {
                        this.drawLineDelta((XYSeries)this.listOfSeries.get(0), (XYSeries)this.listOfSeries.get(1));
                        return;
                    }
                    case SMOOTH_LINE_DELTA: {
                        this.drawSmoothLineDelta((XYSeries)this.listOfSeries.get(0), (XYSeries)this.listOfSeries.get(1));
                        return;
                    }
                }
            }
        }
        List<XYSeries<T>> listOfmultiTimeSeries = this.listOfSeries.stream().filter(series -> ChartType.MULTI_TIME_SERIES == series.getChartType()).collect(Collectors.toList());
        List<XYSeries<T>> listOfSmoothedMultiTimeSeries = this.listOfSeries.stream().filter(series -> ChartType.SMOOTHED_MULTI_TIME_SERIES == series.getChartType()).collect(Collectors.toList());
        if (listOfmultiTimeSeries.isEmpty() && listOfSmoothedMultiTimeSeries.isEmpty()) {
            for (XYSeries series3 : this.listOfSeries) {
                ChartType TYPE = series3.getChartType();
                boolean SHOW_POINTS = series3.getSymbolsVisible();
                switch (TYPE) {
                    case LINE: {
                        this.drawLine(series3, SHOW_POINTS);
                        break;
                    }
                    case SMOOTH_LINE: {
                        this.drawSmoothLine(series3, SHOW_POINTS);
                        break;
                    }
                    case AREA: {
                        this.drawArea(series3, SHOW_POINTS);
                        break;
                    }
                    case SMOOTH_AREA: {
                        this.drawSmoothArea(series3, SHOW_POINTS);
                        break;
                    }
                    case SCATTER: {
                        this.drawScatter(series3);
                        break;
                    }
                    case POINCARE: {
                        this.drawPoincare(series3);
                        break;
                    }
                    case HORIZON: {
                        this.drawHorizon(series3, false);
                        break;
                    }
                    case RIDGE_LINE: {
                        this.drawRidgeLine(series3);
                        break;
                    }
                    case SMOOTHED_HORIZON: {
                        this.drawHorizon(series3, true);
                        break;
                    }
                    case POLAR: 
                    case SMOOTH_POLAR: {
                        this.drawPolar(series3);
                    }
                }
            }
        } else if (listOfmultiTimeSeries.size() == this.listOfSeries.size()) {
            this.drawMultiTimeSeries(listOfmultiTimeSeries);
        } else if (listOfSmoothedMultiTimeSeries.size() == this.listOfSeries.size()) {
            this.drawSmoothedMultiTimeSeries(listOfSmoothedMultiTimeSeries);
        }
    }

    private void drawCursor() {
        this.cursorCtx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.isCrossHairVisible()) {
            this.cursorCtx.setStroke((Paint)this.getCrossHairColor());
            this.cursorCtx.strokeLine(0.0, this.cursorY, this.width, this.cursorY);
            this.cursorCtx.strokeLine(this.cursorX, 0.0, this.cursorX, this.height);
            double x = this.cursorX / this.scaleX + this.getLowerBoundX();
            double y = ((this.cursorY - this.height) / this.scaleY - this.getLowerBoundY()) * -1.0;
            this.fireCursorEvent(new CursorEvent(x, y));
        }
    }

    private void drawLine(XYSeries<T> SERIES, boolean SHOW_POINTS) {
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        ObservableList<T> items = SERIES.getItems();
        double oldX = (((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)items.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        boolean wasEmpty = ((XYItem)items.get(0)).isEmptyItem();
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        this.ctx.setFill((Paint)Color.TRANSPARENT);
        for (XYItem item : SERIES.getItems()) {
            double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            boolean isEmpty = item.isEmptyItem();
            if (!isEmpty && !wasEmpty) {
                this.ctx.strokeLine(oldX, oldY, x, y);
            }
            oldX = x;
            oldY = y;
            wasEmpty = isEmpty;
        }
        if (SHOW_POINTS) {
            this.drawSymbols(SERIES);
        }
    }

    private void drawArea(XYSeries<T> SERIES, boolean SHOW_POINTS) {
        boolean isEmpty;
        double y;
        double x;
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        ObservableList<T> items = SERIES.getItems();
        int noOfItems = items.size();
        double oldX = (((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)items.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        boolean wasEmpty = ((XYItem)items.get(0)).isEmptyItem();
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        this.ctx.setFill(SERIES.getFill());
        this.ctx.beginPath();
        this.ctx.moveTo(oldX, oldY);
        for (int i = 1; i < noOfItems; ++i) {
            XYItem item = (XYItem)items.get(i);
            x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            isEmpty = item.isEmptyItem();
            if (isEmpty) {
                this.ctx.lineTo(oldX, this.height - LOWER_BOUND_Y * this.scaleY);
                this.ctx.lineTo(x, this.height - LOWER_BOUND_Y * this.scaleY);
            } else if (wasEmpty) {
                this.ctx.lineTo(x, this.height - LOWER_BOUND_Y * this.scaleY);
                this.ctx.lineTo(x, y);
            } else {
                this.ctx.lineTo(x, y);
            }
            oldX = x;
            wasEmpty = isEmpty;
        }
        this.ctx.lineTo(oldX, this.height);
        this.ctx.lineTo((((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX, this.height);
        this.ctx.closePath();
        this.ctx.fill();
        oldX = (((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        oldY = this.height - (((XYItem)items.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        for (XYItem item : SERIES.getItems()) {
            x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            isEmpty = item.isEmptyItem();
            if (!isEmpty && !wasEmpty) {
                this.ctx.strokeLine(oldX, oldY, x, y);
            }
            oldX = x;
            oldY = y;
            wasEmpty = isEmpty;
        }
        if (SHOW_POINTS) {
            this.drawSymbols(SERIES);
        }
    }

    private void drawScatter(XYSeries<T> SERIES) {
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        this.ctx.setStroke((Paint)Color.TRANSPARENT);
        this.ctx.setFill((Paint)Color.TRANSPARENT);
        Symbol seriesSymbol = SERIES.getSymbol();
        Color symbolFill = SERIES.getSymbolFill();
        Color symbolStroke = SERIES.getSymbolStroke();
        double size = SERIES.getSymbolSize() > -1.0 ? SERIES.getSymbolSize() : this.symbolSize;
        for (XYItem item : SERIES.getItems()) {
            double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            Symbol itemSymbol = item.getSymbol();
            if (Symbol.NONE == itemSymbol) {
                this.drawSymbol(x, y, (Paint)symbolFill, (Paint)symbolStroke, seriesSymbol, size);
                continue;
            }
            this.drawSymbol(x, y, (Paint)item.getFill(), (Paint)item.getStroke(), itemSymbol, size);
        }
    }

    private void drawPoincare(XYSeries<T> SERIES) {
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        this.ctx.setStroke((Paint)Color.TRANSPARENT);
        this.ctx.setFill((Paint)Color.TRANSPARENT);
        Symbol seriesSymbol = SERIES.getSymbol();
        Color symbolFill = SERIES.getSymbolFill();
        Color symbolStroke = SERIES.getSymbolStroke();
        double size = SERIES.getSymbolSize() > -1.0 ? SERIES.getSymbolSize() : this.symbolSize;
        for (int i = 0; i < SERIES.getItems().size() - 2; ++i) {
            XYItem item = (XYItem)SERIES.getItems().get(i);
            XYItem nextItem = (XYItem)SERIES.getItems().get(i + 1);
            double x = item.getY() * this.scaleX;
            double y = (this.getUpperBoundY() - nextItem.getY() + this.getLowerBoundY()) * this.scaleY;
            Symbol itemSymbol = item.getSymbol();
            if (Symbol.NONE == itemSymbol) {
                this.drawSymbol(x, y, (Paint)symbolFill, (Paint)symbolStroke, seriesSymbol, size);
                continue;
            }
            this.drawSymbol(x, y, (Paint)item.getFill(), (Paint)item.getStroke(), itemSymbol, size);
        }
    }

    private void drawSmoothLine(XYSeries<T> SERIES, boolean SHOW_POINTS) {
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        this.ctx.setFill((Paint)Color.TRANSPARENT);
        ArrayList points = new ArrayList(SERIES.getItems().size());
        SERIES.getItems().forEach(item -> points.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
        Point[] interpolatedPoints = Helper.subdividePoints(points.toArray(new Point[0]), 24);
        this.ctx.beginPath();
        for (Point p : interpolatedPoints) {
            if (p.isEmpty()) {
                this.ctx.moveTo((p.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
                continue;
            }
            this.ctx.lineTo((p.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        this.ctx.stroke();
        if (SHOW_POINTS) {
            this.drawSymbols(SERIES);
        }
    }

    private void drawSmoothArea(XYSeries<T> SERIES, boolean SHOW_POINTS) {
        if (null == SERIES || !SERIES.isVisible() || SERIES.getItems().isEmpty()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        ObservableList<XYItem> items = SERIES.getItems();
        double oldX = (((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)items.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        boolean wasEmpty = ((XYItem)items.get(0)).isEmptyItem();
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        this.ctx.setFill(SERIES.getFill());
        ArrayList points = new ArrayList(items.size());
        items.forEach(item -> points.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
        Point[] interpolatedPoints = Helper.subdividePoints(points.toArray(new Point[0]), 24);
        this.ctx.beginPath();
        this.ctx.moveTo(oldX, oldY);
        for (Point p : interpolatedPoints) {
            double x = (p.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY;
            boolean isEmpty = p.isEmpty();
            if (isEmpty) {
                this.ctx.lineTo(oldX, this.height - LOWER_BOUND_Y * this.scaleY);
                this.ctx.lineTo(x, this.height - LOWER_BOUND_Y * this.scaleY);
            } else if (wasEmpty) {
                this.ctx.lineTo(x, this.height - LOWER_BOUND_Y * this.scaleY);
                this.ctx.lineTo(x, y);
            } else {
                this.ctx.lineTo(x, y);
            }
            oldX = x;
            wasEmpty = isEmpty;
        }
        this.ctx.lineTo(oldX, this.height);
        this.ctx.lineTo((((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX, this.height);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.beginPath();
        for (Point p : interpolatedPoints) {
            if (p.isEmpty()) {
                this.ctx.moveTo((p.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
                continue;
            }
            this.ctx.lineTo((p.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        this.ctx.stroke();
        if (SHOW_POINTS) {
            this.drawSymbols(SERIES);
        }
    }

    private void drawHorizon(XYSeries<T> SERIES, boolean SMOOTHED) {
        Color negativeBaseColor;
        Color positiveBaseColor;
        if (null == SERIES || SERIES.getItems().isEmpty() || !SERIES.isVisible()) {
            return;
        }
        if (SERIES.getFill() instanceof Color) {
            positiveBaseColor = (Color)SERIES.getFill();
            if (positiveBaseColor.equals((Object)Color.BLACK) || positiveBaseColor.equals((Object)Color.WHITE) || positiveBaseColor.equals((Object)Color.TRANSPARENT)) {
                positiveBaseColor = Color.BLUE;
                negativeBaseColor = Color.RED;
            } else {
                negativeBaseColor = Helper.getComplementaryColor(positiveBaseColor);
            }
        } else {
            positiveBaseColor = Color.BLUE;
            negativeBaseColor = Color.RED;
        }
        List<Color> aboveColors = Helper.createColorVariations(positiveBaseColor, this.noOfBands);
        List<Color> belowColors = Helper.createColorVariations(negativeBaseColor, this.noOfBands);
        int noOfItems = SERIES.getItems().size();
        ArrayList<Point> points = new ArrayList<Point>(noOfItems);
        for (int i = 0; i < noOfItems; ++i) {
            points.add(new Point((double)i, ((XYItem)SERIES.getItems().get(i)).getY()));
        }
        double refValue = this.isReferenceZero() ? 0.0 : (points.isEmpty() ? 0.0 : ((Point)points.get(0)).getY());
        double minY = points.stream().mapToDouble(Point::getY).min().getAsDouble();
        double maxY = points.stream().mapToDouble(Point::getY).max().getAsDouble();
        double bandWidth = (maxY - minY) / (double)this.noOfBands;
        this.scaleX = this.width / (double)(noOfItems - 1);
        this.scaleY = this.height / ((maxY - minY) / (double)this.getNoOfBands());
        points.forEach(point -> point.setY(point.getY() - refValue));
        Point[] subdividedPoints = SMOOTHED ? Helper.subdividePoints(points.toArray(new Point[0]), 24) : Helper.subdividePointsLinear(points.toArray(new Point[0]), 24);
        List<Point>[] splittedPoints = this.splitIntoAboveAndBelow(Arrays.asList(subdividedPoints));
        List<Point> aboveRefPoints = splittedPoints[0];
        List<Point> belowRefPoints = splittedPoints[1];
        Map<Integer, List<Point>> aboveRefPointsSplitToBands = this.splitIntoBands(aboveRefPoints, bandWidth);
        Map<Integer, List<Point>> belowRefPointsSplitToBands = this.splitIntoBands(belowRefPoints, bandWidth);
        if (!aboveRefPoints.isEmpty()) {
            this.drawPath(aboveRefPointsSplitToBands, bandWidth, aboveColors);
        }
        if (!belowRefPoints.isEmpty()) {
            this.drawPath(belowRefPointsSplitToBands, bandWidth, belowColors);
        }
    }

    private void drawRidgeLine(XYSeries<T> SERIES) {
        if (null == SERIES || SERIES.getItems().isEmpty() || !SERIES.isVisible()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY() - SERIES.getStrokeWidth();
        ObservableList<XYItem> items = SERIES.getItems();
        double oldX = (((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)items.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        this.ctx.setFill(SERIES.getFill());
        ArrayList points = new ArrayList(items.size());
        items.forEach(item -> points.add(new Point(item.getX(), item.getY())));
        Point[] interpolatedPoints = Helper.subdividePoints(points.toArray(new Point[0]), 24);
        this.ctx.beginPath();
        this.ctx.moveTo(oldX, oldY);
        for (Point p : interpolatedPoints) {
            double x = (p.getX() - LOWER_BOUND_X) * this.scaleX;
            this.ctx.lineTo(x, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
            oldX = x;
        }
        this.ctx.lineTo(oldX, this.height);
        this.ctx.lineTo((((XYItem)items.get(0)).getX() - LOWER_BOUND_X) * this.scaleX, this.height);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.beginPath();
        for (Point p : interpolatedPoints) {
            this.ctx.lineTo((p.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (p.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        this.ctx.stroke();
    }

    private void drawLineDelta(XYSeries<T> SERIES_1, XYSeries<T> SERIES_2) {
        if (null == SERIES_1 || SERIES_1.getItems().isEmpty() || !SERIES_1.isVisible() || null == SERIES_2 || SERIES_2.getItems().isEmpty() || !SERIES_2.isVisible()) {
            return;
        }
        if (SERIES_1.getItems().size() != SERIES_2.getItems().size()) {
            throw new IllegalArgumentException("Both series must have the same number of items!");
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        int noOfItems = SERIES_1.getItems().size();
        LinkedList<XYItem> cachedItems = new LinkedList<XYItem>();
        Point lastPointForClose = new Point();
        XYItem series1Item0 = (XYItem)SERIES_1.getItems().get(0);
        XYItem series2Item0 = (XYItem)SERIES_2.getItems().get(0);
        int currentSeries = series1Item0.getY() > series2Item0.getY() ? 1 : 2;
        Paint series1Stroke = SERIES_1.getStroke();
        Paint series1Fill = SERIES_1.getFill();
        Paint series2Stroke = SERIES_2.getStroke();
        Paint series2Fill = SERIES_2.getFill();
        this.ctx.setLineWidth(this.size * 0.0025);
        this.ctx.beginPath();
        switch (currentSeries) {
            case 1: {
                this.ctx.moveTo((series1Item0.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (series1Item0.getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(series2Item0.getX(), series2Item0.getY());
                break;
            }
            case 2: {
                this.ctx.moveTo((series2Item0.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (series2Item0.getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(series1Item0.getX(), series1Item0.getY());
                break;
            }
            default: {
                this.ctx.moveTo((series1Item0.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (series1Item0.getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(series2Item0.getX(), series2Item0.getY());
            }
        }
        ObservableList<T> items1 = SERIES_1.getItems();
        ObservableList<T> items2 = SERIES_2.getItems();
        for (int i = 1; i < noOfItems; ++i) {
            XYItem lastXyData1 = (XYItem)items1.get(i - 1);
            XYItem lastXyData2 = (XYItem)items2.get(i - 1);
            XYItem xyData1 = (XYItem)items1.get(i);
            XYItem xyData2 = (XYItem)items2.get(i);
            if (lastXyData1.getY() > lastXyData2.getY() && xyData1.getY() < xyData2.getY()) {
                intersectionPoint = Helper.calcIntersectionOfTwoLines(lastXyData1.getX(), lastXyData1.getY(), xyData1.getX(), xyData1.getY(), lastXyData2.getX(), lastXyData2.getY(), xyData2.getX(), xyData2.getY());
                this.ctx.lineTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                Collections.reverse(cachedItems);
                for (XYItem item : cachedItems) {
                    this.ctx.lineTo((item.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY);
                }
                this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.closePath();
                this.ctx.setFill(series1Fill);
                this.ctx.fill();
                cachedItems.clear();
                this.ctx.beginPath();
                this.ctx.moveTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.lineTo((xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
                currentSeries = 2;
                cachedItems.add(xyData1);
                lastPointForClose.set(intersectionPoint.getX(), intersectionPoint.getY());
            } else if (lastXyData1.getY() < lastXyData2.getY() && xyData1.getY() > xyData2.getY()) {
                intersectionPoint = Helper.calcIntersectionOfTwoLines(lastXyData1.getX(), lastXyData1.getY(), xyData1.getX(), xyData1.getY(), lastXyData2.getX(), lastXyData2.getY(), xyData2.getX(), xyData2.getY());
                this.ctx.lineTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                Collections.reverse(cachedItems);
                for (XYItem item : cachedItems) {
                    this.ctx.lineTo((item.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY);
                }
                this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.closePath();
                this.ctx.setFill(series2Fill);
                this.ctx.fill();
                cachedItems.clear();
                this.ctx.beginPath();
                this.ctx.moveTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.lineTo((xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
                currentSeries = 1;
                cachedItems.add(xyData2);
                lastPointForClose.set(intersectionPoint.getX(), intersectionPoint.getY());
            } else {
                switch (currentSeries) {
                    case 1: {
                        this.ctx.lineTo((xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
                        cachedItems.add(xyData2);
                        break;
                    }
                    case 2: {
                        this.ctx.lineTo((xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
                        cachedItems.add(xyData1);
                    }
                }
            }
            this.ctx.setLineWidth(SERIES_1.getStrokeWidth() > -1.0 ? SERIES_1.getStrokeWidth() : this.size * 0.0025);
            this.ctx.setStroke(series1Stroke);
            this.ctx.strokeLine((lastXyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastXyData1.getY() - LOWER_BOUND_Y) * this.scaleY, (xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
            this.ctx.setLineWidth(SERIES_2.getStrokeWidth() > -1.0 ? SERIES_2.getStrokeWidth() : this.size * 0.0025);
            this.ctx.setStroke(series2Stroke);
            this.ctx.strokeLine((lastXyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastXyData2.getY() - LOWER_BOUND_Y) * this.scaleY, (xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        Collections.reverse(cachedItems);
        for (XYItem item : cachedItems) {
            this.ctx.lineTo((item.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
        this.ctx.closePath();
        switch (currentSeries) {
            case 1: {
                this.ctx.setFill(series1Fill);
                break;
            }
            case 2: {
                this.ctx.setFill(series2Fill);
            }
        }
        this.ctx.fill();
        cachedItems.clear();
        if (SERIES_1.getSymbolsVisible()) {
            this.drawSymbols(SERIES_1);
        }
        if (SERIES_2.getSymbolsVisible()) {
            this.drawSymbols(SERIES_2);
        }
    }

    private void drawSmoothLineDelta(XYSeries<T> SERIES_1, XYSeries<T> SERIES_2) {
        if (null == SERIES_1 || SERIES_1.getItems().isEmpty() || !SERIES_1.isVisible() || null == SERIES_2 || SERIES_2.getItems().isEmpty() || !SERIES_2.isVisible()) {
            return;
        }
        if (SERIES_1.getItems().size() != SERIES_2.getItems().size()) {
            throw new IllegalArgumentException("Both series must have the same number of items!");
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        ArrayList points1 = new ArrayList(SERIES_1.getItems().size());
        SERIES_1.getItems().forEach(item -> points1.add(new Point(item.getX(), item.getY())));
        Point[] interpolatedPoints1 = Helper.subdividePoints(points1.toArray(new Point[0]), 24);
        ArrayList points2 = new ArrayList(SERIES_2.getItems().size());
        SERIES_2.getItems().forEach(item -> points2.add(new Point(item.getX(), item.getY())));
        Point[] interpolatedPoints2 = Helper.subdividePoints(points2.toArray(new Point[0]), 24);
        int noOfItems = interpolatedPoints1.length;
        LinkedList<Point> cachedItems = new LinkedList<Point>();
        Point lastPointForClose = new Point();
        XYItem series1Item0 = (XYItem)SERIES_1.getItems().get(0);
        XYItem series2Item0 = (XYItem)SERIES_2.getItems().get(0);
        int currentSeries = series1Item0.getY() > series2Item0.getY() ? 1 : 2;
        Paint series1Stroke = SERIES_1.getStroke();
        Paint series1Fill = SERIES_1.getFill();
        Paint series2Stroke = SERIES_2.getStroke();
        Paint series2Fill = SERIES_2.getFill();
        this.ctx.setLineWidth(this.size * 0.0025);
        this.ctx.beginPath();
        switch (currentSeries) {
            case 1: {
                this.ctx.moveTo((interpolatedPoints1[0].getX() - LOWER_BOUND_X) * this.scaleX, this.height - (interpolatedPoints1[0].getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(interpolatedPoints2[0].getX(), interpolatedPoints2[0].getY());
                break;
            }
            case 2: {
                this.ctx.moveTo((interpolatedPoints2[0].getX() - LOWER_BOUND_X) * this.scaleX, this.height - (interpolatedPoints2[0].getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(interpolatedPoints1[0].getX(), interpolatedPoints1[0].getY());
                break;
            }
            default: {
                this.ctx.moveTo((interpolatedPoints1[0].getX() - LOWER_BOUND_X) * this.scaleX, this.height - (interpolatedPoints1[0].getY() - LOWER_BOUND_Y) * this.scaleY);
                lastPointForClose.set(interpolatedPoints2[0].getX(), interpolatedPoints2[0].getY());
            }
        }
        for (int i = 1; i < noOfItems; ++i) {
            Point lastXyData1 = interpolatedPoints1[i - 1];
            Point lastXyData2 = interpolatedPoints2[i - 1];
            Point xyData1 = interpolatedPoints1[i];
            Point xyData2 = interpolatedPoints2[i];
            if (lastXyData1.getY() > lastXyData2.getY() && xyData1.getY() < xyData2.getY()) {
                intersectionPoint = Helper.calcIntersectionOfTwoLines(lastXyData1.getX(), lastXyData1.getY(), xyData1.getX(), xyData1.getY(), lastXyData2.getX(), lastXyData2.getY(), xyData2.getX(), xyData2.getY());
                this.ctx.lineTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                Collections.reverse(cachedItems);
                for (Point item2 : cachedItems) {
                    this.ctx.lineTo((item2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item2.getY() - LOWER_BOUND_Y) * this.scaleY);
                }
                this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.closePath();
                this.ctx.setFill(series1Fill);
                this.ctx.fill();
                cachedItems.clear();
                this.ctx.beginPath();
                this.ctx.moveTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.lineTo((xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
                currentSeries = 2;
                cachedItems.add(xyData1);
                lastPointForClose.set(intersectionPoint.getX(), intersectionPoint.getY());
            } else if (lastXyData1.getY() < lastXyData2.getY() && xyData1.getY() > xyData2.getY()) {
                intersectionPoint = Helper.calcIntersectionOfTwoLines(lastXyData1.getX(), lastXyData1.getY(), xyData1.getX(), xyData1.getY(), lastXyData2.getX(), lastXyData2.getY(), xyData2.getX(), xyData2.getY());
                this.ctx.lineTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                Collections.reverse(cachedItems);
                for (Point item2 : cachedItems) {
                    this.ctx.lineTo((item2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item2.getY() - LOWER_BOUND_Y) * this.scaleY);
                }
                this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.closePath();
                this.ctx.setFill(series2Fill);
                this.ctx.fill();
                cachedItems.clear();
                this.ctx.beginPath();
                this.ctx.moveTo((intersectionPoint.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (intersectionPoint.getY() - LOWER_BOUND_Y) * this.scaleY);
                this.ctx.lineTo((xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
                currentSeries = 1;
                cachedItems.add(xyData2);
                lastPointForClose.set(intersectionPoint.getX(), intersectionPoint.getY());
            } else {
                switch (currentSeries) {
                    case 1: {
                        this.ctx.lineTo((xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
                        cachedItems.add(xyData2);
                        break;
                    }
                    case 2: {
                        this.ctx.lineTo((xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
                        cachedItems.add(xyData1);
                    }
                }
            }
            this.ctx.setLineWidth(SERIES_1.getStrokeWidth() > -1.0 ? SERIES_1.getStrokeWidth() : this.size * 0.0025);
            this.ctx.setStroke(series1Stroke);
            this.ctx.strokeLine((lastXyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastXyData1.getY() - LOWER_BOUND_Y) * this.scaleY, (xyData1.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData1.getY() - LOWER_BOUND_Y) * this.scaleY);
            this.ctx.setLineWidth(SERIES_2.getStrokeWidth() > -1.0 ? SERIES_2.getStrokeWidth() : this.size * 0.0025);
            this.ctx.setStroke(series2Stroke);
            this.ctx.strokeLine((lastXyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastXyData2.getY() - LOWER_BOUND_Y) * this.scaleY, (xyData2.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (xyData2.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        Collections.reverse(cachedItems);
        for (Point item3 : cachedItems) {
            this.ctx.lineTo((item3.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (item3.getY() - LOWER_BOUND_Y) * this.scaleY);
        }
        this.ctx.lineTo((lastPointForClose.getX() - LOWER_BOUND_X) * this.scaleX, this.height - (lastPointForClose.getY() - LOWER_BOUND_Y) * this.scaleY);
        this.ctx.closePath();
        switch (currentSeries) {
            case 1: {
                this.ctx.setFill(series1Fill);
                break;
            }
            case 2: {
                this.ctx.setFill(series2Fill);
            }
        }
        this.ctx.fill();
        cachedItems.clear();
        if (SERIES_1.getSymbolsVisible()) {
            this.drawSymbols(SERIES_1);
        }
        if (SERIES_2.getSymbolsVisible()) {
            this.drawSymbols(SERIES_2);
        }
    }

    private void drawPolar(XYSeries<T> SERIES) {
        int i;
        double CENTER_X;
        if (null == SERIES || SERIES.getItems().isEmpty() || !SERIES.isVisible()) {
            return;
        }
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double LOWER_BOUND_Y = this.getLowerBoundY() - SERIES.getStrokeWidth();
        double DATA_RANGE = this.getRangeY();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        double OFFSET = 0.14286 * CIRCLE_SIZE;
        int NO_OF_ITEMS = SERIES.getItems().size();
        boolean SHOW_POINTS = SERIES.getSymbolsVisible();
        this.drawPolarOverlay(this.getPolarTickStep().get());
        this.ctx.save();
        if (SERIES.getFill() instanceof RadialGradient) {
            this.ctx.setFill((Paint)new RadialGradient(0.0, 0.0, this.size * 0.5, this.size * 0.5, this.size * 0.45, false, CycleMethod.NO_CYCLE, ((RadialGradient)SERIES.getFill()).getStops()));
        } else {
            this.ctx.setFill(SERIES.getFill());
        }
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        double radAngle = Math.toRadians(180.0);
        Point[] points = new Point[NO_OF_ITEMS + 1];
        XYItem item = (XYItem)SERIES.getItems().get(0);
        double r1 = CENTER_Y - (CENTER_Y - OFFSET - (item.getY() - LOWER_BOUND_Y) / DATA_RANGE * RANGE);
        double phi = Math.toRadians(Helper.clamp(0.0, 360.0, item.getX()));
        double x = CENTER_X + -Math.sin(radAngle + phi) * r1;
        double y = CENTER_Y + Math.cos(radAngle + phi) * r1;
        points[0] = new Point(x, y);
        for (i = 1; i < NO_OF_ITEMS; ++i) {
            item = (XYItem)SERIES.getItems().get(i);
            r1 = CENTER_Y - (CENTER_Y - OFFSET - (item.getY() - LOWER_BOUND_Y) / DATA_RANGE * RANGE);
            phi = Math.toRadians(Helper.clamp(0.0, 360.0, item.getX()));
            x = CENTER_X + -Math.sin(radAngle + phi) * r1;
            y = CENTER_Y + Math.cos(radAngle + phi) * r1;
            points[i] = new Point(x, y);
        }
        points[points.length - 1] = points[0];
        if (ChartType.SMOOTH_POLAR == SERIES.getChartType()) {
            Point[] interpolatedPoints = SERIES.isWithWrapping() ? Helper.subdividePointsRadial(points, 16) : Helper.subdividePoints(points, 16);
            this.ctx.beginPath();
            this.ctx.moveTo(interpolatedPoints[0].getX(), interpolatedPoints[0].getY());
            for (int i2 = 0; i2 < interpolatedPoints.length - 1; ++i2) {
                Point point = interpolatedPoints[i2];
                this.ctx.lineTo(point.getX(), point.getY());
            }
            this.ctx.lineTo(interpolatedPoints[interpolatedPoints.length - 1].getX(), interpolatedPoints[interpolatedPoints.length - 1].getY());
            this.ctx.closePath();
        } else {
            this.ctx.beginPath();
            this.ctx.moveTo(points[0].getX(), points[0].getY());
            for (i = 0; i < points.length - 1; ++i) {
                Point point = points[i];
                this.ctx.lineTo(point.getX(), point.getY());
            }
            this.ctx.lineTo(points[points.length - 1].getX(), points[points.length - 1].getY());
            this.ctx.closePath();
        }
        this.ctx.fill();
        this.ctx.stroke();
        this.ctx.restore();
        if (SHOW_POINTS) {
            Symbol seriesSymbol = SERIES.getSymbol();
            Color symbolFill = SERIES.getSymbolFill();
            Color symbolStroke = SERIES.getSymbolStroke();
            double size = SERIES.getSymbolSize() > -1.0 ? SERIES.getSymbolSize() : this.symbolSize;
            for (Point point : points) {
                Symbol itemSymbol = item.getSymbol();
                if (Symbol.NONE == itemSymbol) {
                    this.drawSymbol(point.getX(), point.getY(), (Paint)symbolFill, (Paint)symbolStroke, seriesSymbol, size);
                    continue;
                }
                this.drawSymbol(point.getX(), point.getY(), (Paint)item.getFill(), (Paint)item.getStroke(), itemSymbol, size);
            }
        }
    }

    private void drawPolarOverlay(double ANGLE_STEP) {
        int i;
        double CENTER_X;
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double DATA_RANGE = this.getRangeY();
        double MIN_VALUE = this.getDataMinY();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        double OFFSET = 0.14286 * CIRCLE_SIZE;
        double NO_OF_SECTORS = 360.0 / ANGLE_STEP;
        this.ctx.setLineWidth(1.0);
        this.ctx.setStroke((Paint)Color.GRAY);
        double ringStepSize = this.size / 20.0;
        double pos = 0.5 * (this.size - CIRCLE_SIZE);
        double ringSize = CIRCLE_SIZE;
        for (i = 0; i < 11; ++i) {
            this.ctx.strokeOval(pos, pos, ringSize, ringSize);
            pos += ringStepSize;
            ringSize -= 2.0 * ringStepSize;
        }
        this.ctx.save();
        i = 0;
        while ((double)i < NO_OF_SECTORS) {
            this.ctx.strokeLine(CENTER_X, 0.05 * this.size, CENTER_X, 0.5 * this.size);
            Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, ANGLE_STEP);
            ++i;
        }
        this.ctx.restore();
        if (this.isThresholdYVisible()) {
            double r = (this.getThresholdY() - MIN_VALUE) / DATA_RANGE;
            this.ctx.setLineWidth(Helper.clamp(1.0, 3.0, this.size * 0.005));
            this.ctx.setStroke((Paint)this.getThresholdYColor());
            this.ctx.strokeOval(0.5 * this.size - OFFSET - r * RANGE, 0.5 * this.size - OFFSET - r * RANGE, 2.0 * (r * RANGE + OFFSET), 2.0 * (r * RANGE + OFFSET));
        }
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFill((Paint)Color.BLACK);
        Font font = Fonts.latoRegular((double)(0.025 * this.size));
        String minValueText = String.format(Locale.US, "%.0f", this.getLowerBoundY());
        String maxValueText = String.format(Locale.US, "%.0f", this.getUpperBoundY());
        this.ctx.save();
        this.ctx.setFont(font);
        Helper.drawTextWithBackground(this.ctx, minValueText, font, Color.WHITE, Color.BLACK, CENTER_X, CENTER_Y - this.size * 0.018);
        Helper.drawTextWithBackground(this.ctx, maxValueText, font, Color.WHITE, Color.BLACK, CENTER_X, CENTER_Y - CIRCLE_SIZE * 0.48);
        this.ctx.restore();
        this.ctx.save();
        this.ctx.setFont(Fonts.latoRegular((double)(0.04 * this.size)));
        int i2 = 0;
        while ((double)i2 < NO_OF_SECTORS) {
            this.ctx.fillText(String.format(Locale.US, "%.0f", (double)i2 * ANGLE_STEP), CENTER_X, this.size * 0.02);
            Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, ANGLE_STEP);
            ++i2;
        }
        this.ctx.restore();
    }

    private void drawPath(Map<Integer, List<Point>> MAP_OF_BANDS, double BAND_WIDTH, List<Color> COLORS) {
        double oldX = 0.0;
        for (int band = 0; band < this.getNoOfBands(); ++band) {
            this.ctx.beginPath();
            for (Point p : MAP_OF_BANDS.get(band)) {
                double x = p.getX() * this.scaleX;
                double y = this.height - p.getY() * this.scaleY;
                this.ctx.lineTo(x, y + (double)band * BAND_WIDTH * this.scaleY);
                oldX = x;
            }
            this.ctx.lineTo(oldX, this.height);
            this.ctx.lineTo(0.0, this.height);
            this.ctx.closePath();
            this.ctx.setFill((Paint)COLORS.get(band));
            this.ctx.fill();
        }
    }

    private void drawMultiTimeSeries(List<XYSeries<T>> LIST_OF_SERIES) {
        if (LIST_OF_SERIES.isEmpty()) {
            return;
        }
        LinkedList<XYChartItem> minItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> maxItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> avgItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> stdDevItems = new LinkedList<XYChartItem>();
        XYSeries<T> series0 = LIST_OF_SERIES.get(0);
        if (null == series0.getItems() || series0.getItems().isEmpty()) {
            return;
        }
        for (int i = 0; i < series0.getItems().size(); ++i) {
            XYItem item = (XYItem)series0.getItems().get(i);
            double x = item.getX();
            double minYForX = Double.MAX_VALUE;
            double maxYForX = Double.MIN_VALUE;
            LinkedList<Double> valuesForX = new LinkedList<Double>();
            for (int j = 0; j < LIST_OF_SERIES.size(); ++j) {
                Optional<XYItem> optionalValue;
                XYSeries<T> series = LIST_OF_SERIES.get(j);
                if (null == series.getItems() || series.getItems().isEmpty() || !(optionalValue = series.getItems().stream().filter(si -> Double.compare(x, si.getX()) == 0).findFirst()).isPresent()) continue;
                minYForX = Math.min(minYForX, optionalValue.get().getY());
                maxYForX = Math.max(maxYForX, optionalValue.get().getY());
                valuesForX.add(optionalValue.get().getY());
            }
            minItems.add(new XYChartItem(x, minYForX));
            maxItems.add(new XYChartItem(x, maxYForX));
            avgItems.add(new XYChartItem(x, Statistics.getAverage(valuesForX)));
            stdDevItems.add(new XYChartItem(x, Statistics.getStdDev(valuesForX)));
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        double startX = (((XYItem)maxItems.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double startY = this.height - (((XYItem)maxItems.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        if (this.isEnvelopeVisible()) {
            double y;
            int i;
            this.ctx.setFill(this.getEnvelopeFill());
            this.ctx.setStroke((Paint)this.getEnvelopeStroke());
            this.ctx.setLineWidth(0.5);
            this.ctx.beginPath();
            this.ctx.moveTo(startX, startY);
            for (i = 1; i < maxItems.size(); ++i) {
                XYItem item = (XYItem)maxItems.get(i);
                double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            for (i = minItems.size() - 1; i >= 0; --i) {
                XYItem item = (XYItem)minItems.get(i);
                double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            this.ctx.lineTo(startX, startY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.stroke();
        }
        for (XYSeries<T> SERIES : LIST_OF_SERIES) {
            if (!SERIES.isVisible() || !SERIES.getSymbolsVisible()) continue;
            this.drawSymbols(SERIES);
        }
        if (this.isStdDeviationVisible()) {
            double y;
            double x;
            XYItem avgItem;
            XYItem stdItem;
            int i;
            this.ctx.setFill(this.getStdDeviationFill());
            this.ctx.setStroke((Paint)this.getStdDeviationStroke());
            this.ctx.setLineWidth(0.5);
            this.ctx.beginPath();
            startX = (((XYItem)stdDevItems.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
            startY = this.height - (((XYItem)avgItems.get(0)).getY() - ((XYItem)stdDevItems.get(0)).getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
            this.ctx.moveTo(startX, startY);
            for (i = 0; i < stdDevItems.size(); ++i) {
                stdItem = (XYItem)stdDevItems.get(i);
                avgItem = (XYItem)avgItems.get(i);
                x = (avgItem.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (avgItem.getY() - stdItem.getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            for (i = stdDevItems.size() - 1; i >= 0; --i) {
                stdItem = (XYItem)stdDevItems.get(i);
                avgItem = (XYItem)avgItems.get(i);
                x = (avgItem.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (avgItem.getY() + stdItem.getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            this.ctx.lineTo(startX, startY);
            this.ctx.fill();
            this.ctx.stroke();
        }
        this.ctx.setLineWidth(this.getAverageStrokeWidth());
        this.ctx.setStroke((Paint)this.getAverageStroke());
        this.ctx.beginPath();
        double oldX = (((XYItem)avgItems.get(0)).getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)avgItems.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        this.ctx.moveTo(oldX, oldY);
        for (int i = 1; i < avgItems.size(); ++i) {
            XYItem item = (XYItem)avgItems.get(i);
            double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            this.ctx.lineTo(x, y);
        }
        this.ctx.stroke();
    }

    private void drawSmoothedMultiTimeSeries(List<XYSeries<T>> LIST_OF_SERIES) {
        if (LIST_OF_SERIES.isEmpty()) {
            return;
        }
        LinkedList<XYChartItem> minItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> maxItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> avgItems = new LinkedList<XYChartItem>();
        LinkedList<XYChartItem> stdDevItems = new LinkedList<XYChartItem>();
        XYSeries<T> series0 = LIST_OF_SERIES.get(0);
        if (null == series0.getItems() || series0.getItems().isEmpty()) {
            return;
        }
        for (int i = 0; i < series0.getItems().size(); ++i) {
            XYItem item2 = (XYItem)series0.getItems().get(i);
            double x = item2.getX();
            double minYForX = Double.MAX_VALUE;
            double maxYForX = Double.MIN_VALUE;
            LinkedList<Double> valuesForX = new LinkedList<Double>();
            for (int j = 0; j < LIST_OF_SERIES.size(); ++j) {
                Optional<XYItem> optionalValue;
                XYSeries<T> series = LIST_OF_SERIES.get(j);
                if (null == series.getItems() || series.getItems().isEmpty() || !(optionalValue = series.getItems().stream().filter(si -> Double.compare(x, si.getX()) == 0).findFirst()).isPresent()) continue;
                minYForX = Math.min(minYForX, optionalValue.get().getY());
                maxYForX = Math.max(maxYForX, optionalValue.get().getY());
                valuesForX.add(optionalValue.get().getY());
            }
            minItems.add(new XYChartItem(x, minYForX));
            maxItems.add(new XYChartItem(x, maxYForX));
            avgItems.add(new XYChartItem(x, Statistics.getAverage(valuesForX)));
            stdDevItems.add(new XYChartItem(x, Statistics.getStdDev(valuesForX)));
        }
        ArrayList avgItemsPoints = new ArrayList(avgItems.size());
        avgItems.forEach(item -> avgItemsPoints.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
        Point[] avgInterpolatedPoints = Helper.subdividePoints(avgItemsPoints.toArray(new Point[0]), 24);
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        if (this.isEnvelopeVisible()) {
            double y;
            double x;
            Point point;
            int i;
            ArrayList minItemsPoints = new ArrayList(minItems.size());
            minItems.forEach(item -> minItemsPoints.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
            Point[] minInterpolatedPoints = Helper.subdividePoints(minItemsPoints.toArray(new Point[0]), 24);
            ArrayList maxItemsPoints = new ArrayList(maxItems.size());
            maxItems.forEach(item -> maxItemsPoints.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
            Point[] maxInterpolatedPoints = Helper.subdividePoints(maxItemsPoints.toArray(new Point[0]), 24);
            double startX = (maxInterpolatedPoints[0].getX() - LOWER_BOUND_X) * this.scaleX;
            double startY = this.height - (maxInterpolatedPoints[0].getY() - LOWER_BOUND_Y) * this.scaleY;
            this.ctx.setFill(this.getEnvelopeFill());
            this.ctx.setStroke((Paint)this.getEnvelopeStroke());
            this.ctx.setLineWidth(0.5);
            this.ctx.beginPath();
            this.ctx.moveTo(startX, startY);
            for (i = 1; i < maxInterpolatedPoints.length; ++i) {
                point = maxInterpolatedPoints[i];
                x = (point.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (point.getY() - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            for (i = minInterpolatedPoints.length - 1; i >= 0; --i) {
                point = minInterpolatedPoints[i];
                x = (point.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (point.getY() - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            this.ctx.lineTo(startX, startY);
            this.ctx.closePath();
            this.ctx.fill();
            this.ctx.stroke();
        }
        for (XYSeries<T> SERIES : LIST_OF_SERIES) {
            if (!SERIES.isVisible() || !SERIES.getSymbolsVisible()) continue;
            this.drawSymbols(SERIES);
        }
        if (this.isStdDeviationVisible()) {
            double y;
            double x;
            Point stdPoint;
            int i;
            ArrayList stdDevItemsPoints = new ArrayList(stdDevItems.size());
            stdDevItems.forEach(item -> stdDevItemsPoints.add(new Point(item.getX(), item.getY(), item.isEmptyItem())));
            Point[] stdDevInterpolatedPoints = Helper.subdividePoints(stdDevItemsPoints.toArray(new Point[0]), 24);
            this.ctx.setFill(this.getStdDeviationFill());
            this.ctx.setStroke((Paint)this.getStdDeviationStroke());
            this.ctx.setLineWidth(0.5);
            this.ctx.beginPath();
            double startX = (stdDevInterpolatedPoints[0].getX() - LOWER_BOUND_X) * this.scaleX;
            double startY = this.height - (avgInterpolatedPoints[0].getY() - stdDevInterpolatedPoints[0].getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
            this.ctx.moveTo(startX, startY);
            for (i = 0; i < stdDevInterpolatedPoints.length; ++i) {
                stdPoint = stdDevInterpolatedPoints[i];
                Point avgPoint = avgInterpolatedPoints[i];
                x = (avgPoint.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (avgPoint.getY() - stdPoint.getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            for (i = stdDevInterpolatedPoints.length - 1; i >= 0; --i) {
                stdPoint = stdDevInterpolatedPoints[i];
                Point avgPoint = avgInterpolatedPoints[i];
                x = (avgPoint.getX() - LOWER_BOUND_X) * this.scaleX;
                y = this.height - (avgPoint.getY() + stdPoint.getY() * 0.5 - LOWER_BOUND_Y) * this.scaleY;
                this.ctx.lineTo(x, y);
            }
            this.ctx.lineTo(startX, startY);
            this.ctx.fill();
            this.ctx.stroke();
        }
        this.ctx.setLineWidth(this.getAverageStrokeWidth());
        this.ctx.setStroke((Paint)this.getAverageStroke());
        this.ctx.beginPath();
        double oldX = (avgInterpolatedPoints[0].getX() - LOWER_BOUND_X) * this.scaleX;
        double oldY = this.height - (((XYItem)avgItems.get(0)).getY() - LOWER_BOUND_Y) * this.scaleY;
        this.ctx.moveTo(oldX, oldY);
        for (int i = 1; i < avgInterpolatedPoints.length; ++i) {
            Point point = avgInterpolatedPoints[i];
            double x = (point.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (point.getY() - LOWER_BOUND_Y) * this.scaleY;
            this.ctx.lineTo(x, y);
        }
        this.ctx.stroke();
    }

    private List<Point>[] splitIntoAboveAndBelow(List<Point> POINTS) {
        ArrayList<Point> aboveReferencePoints = new ArrayList<Point>();
        ArrayList<Point> belowReferencePoints = new ArrayList<Point>();
        Point last = POINTS.get(0);
        boolean isAbove = Double.compare(last.getY(), 0.0) >= 0;
        int noOfPoints = POINTS.size();
        for (int i = 0; i < noOfPoints; ++i) {
            Point next;
            Point current = POINTS.get(i);
            Point point = next = i < noOfPoints - 1 ? POINTS.get(i + 1) : POINTS.get(noOfPoints - 1);
            if (Double.compare(current.getY(), 0.0) >= 0) {
                if (!isAbove) {
                    p = Helper.calcIntersectionPoint(last, current, 0.0);
                    aboveReferencePoints.add(p);
                    belowReferencePoints.add(p);
                }
                aboveReferencePoints.add(current);
                isAbove = true;
            } else {
                if (isAbove) {
                    p = Helper.calcIntersectionPoint(current, next, 0.0);
                    aboveReferencePoints.add(p);
                    belowReferencePoints.add(p);
                }
                belowReferencePoints.add(new Point(current.getX(), -current.getY()));
                isAbove = false;
            }
            last = current;
        }
        return new ArrayList[]{aboveReferencePoints, belowReferencePoints};
    }

    private Map<Integer, List<Point>> splitIntoBands(List<Point> POINTS, double BAND_WIDTH) {
        HashMap<Integer, List<Point>> mapOfBands = new HashMap<Integer, List<Point>>(this.getNoOfBands());
        if (POINTS.isEmpty()) {
            return mapOfBands;
        }
        int noOfPoints = POINTS.size();
        Point firstPoint = new Point(POINTS.get(0).getX(), POINTS.get(0).getY());
        for (int band2 = 0; band2 < this.getNoOfBands(); ++band2) {
            ArrayList<Point> listOfPointsInBand = new ArrayList<Point>(noOfPoints);
            listOfPointsInBand.add(firstPoint);
            mapOfBands.put(band2, listOfPointsInBand);
        }
        for (int i = 1; i < noOfPoints - 1; ++i) {
            Point last = POINTS.get(i - 1);
            double lastY = this.height - last.getY() * this.scaleY;
            Point current = POINTS.get(i);
            double currentY = this.height - current.getY() * this.scaleY;
            Point next = POINTS.get(i + 1);
            double nextY = this.height - next.getY() * this.scaleY;
            for (int band3 = 0; band3 < this.getNoOfBands(); ++band3) {
                double currentBandMinY = (double)band3 * BAND_WIDTH;
                double currentBandMaxY = currentBandMinY + BAND_WIDTH;
                double currentBandMinYScaled = this.height - currentBandMinY * this.scaleY;
                double currentBandMaxYScaled = this.height - currentBandMaxY * this.scaleY;
                if (Double.compare(lastY, currentBandMinYScaled) >= 0) {
                    ((List)mapOfBands.get(band3)).add(Helper.calcIntersectionPoint(last, current, currentBandMinY));
                    continue;
                }
                if (Double.compare(currentY, currentBandMinYScaled) <= 0 && Double.compare(currentY, currentBandMaxYScaled) >= 0) {
                    ((List)mapOfBands.get(band3)).add(new Point(current.getX(), current.getY()));
                    continue;
                }
                if (Double.compare(nextY, currentBandMaxYScaled) > 0) continue;
                ((List)mapOfBands.get(band3)).add(Helper.calcIntersectionPoint(current, next, currentBandMaxY));
            }
        }
        Point lastPoint = new Point(POINTS.get(noOfPoints - 1).getX(), Helper.clamp(0.0, BAND_WIDTH, POINTS.get(noOfPoints - 1).getY()));
        mapOfBands.forEach((band, pointsInBand) -> {
            Point lastPointInBand = (Point)pointsInBand.get(pointsInBand.size() - 1);
            if ((double)noOfPoints - lastPointInBand.getX() > 2.0) {
                pointsInBand.add(new Point((double)(noOfPoints - 1), lastPointInBand.getY()));
            }
            pointsInBand.add(lastPoint);
        });
        return mapOfBands;
    }

    private void drawSymbols(XYSeries<T> SERIES) {
        if (!SERIES.isVisible()) {
            return;
        }
        double LOWER_BOUND_X = this.getLowerBoundX();
        double LOWER_BOUND_Y = this.getLowerBoundY();
        Symbol seriesSymbol = SERIES.getSymbol();
        Color symbolFill = SERIES.getSymbolFill();
        Color symbolStroke = SERIES.getSymbolStroke();
        double size = SERIES.getSymbolSize() > -1.0 ? SERIES.getSymbolSize() : this.symbolSize;
        for (XYItem item : SERIES.getItems()) {
            double x = (item.getX() - LOWER_BOUND_X) * this.scaleX;
            double y = this.height - (item.getY() - LOWER_BOUND_Y) * this.scaleY;
            Symbol itemSymbol = item.getSymbol();
            if (item.isEmptyItem()) continue;
            if (Symbol.NONE == itemSymbol) {
                this.drawSymbol(x, y, (Paint)symbolFill, (Paint)symbolStroke, seriesSymbol, size);
                continue;
            }
            this.drawSymbol(x, y, (Paint)item.getFill(), (Paint)item.getStroke(), itemSymbol, size);
        }
    }

    private void drawSymbol(double X, double Y, Paint FILL, Paint STROKE, Symbol SYMBOL, double SYMBOL_SIZE) {
        double halfSymbolSize = SYMBOL_SIZE * 0.5;
        this.ctx.save();
        switch (SYMBOL) {
            case NONE: {
                break;
            }
            case SQUARE: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.fillRect(X - halfSymbolSize, Y - halfSymbolSize, SYMBOL_SIZE, SYMBOL_SIZE);
                this.ctx.strokeRect(X - halfSymbolSize, Y - halfSymbolSize, SYMBOL_SIZE, SYMBOL_SIZE);
                break;
            }
            case TRIANGLE: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.beginPath();
                this.ctx.moveTo(X, Y - halfSymbolSize);
                this.ctx.lineTo(X + halfSymbolSize, Y + halfSymbolSize);
                this.ctx.lineTo(X - halfSymbolSize, Y + halfSymbolSize);
                this.ctx.lineTo(X, Y - halfSymbolSize);
                this.ctx.closePath();
                this.ctx.fill();
                this.ctx.stroke();
                break;
            }
            case STAR: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(null);
                this.ctx.strokeLine(X - halfSymbolSize, Y, X + halfSymbolSize, Y);
                this.ctx.strokeLine(X, Y - halfSymbolSize, X, Y + halfSymbolSize);
                this.ctx.strokeLine(X - halfSymbolSize, Y - halfSymbolSize, X + halfSymbolSize, Y + halfSymbolSize);
                this.ctx.strokeLine(X + halfSymbolSize, Y - halfSymbolSize, X - halfSymbolSize, Y + halfSymbolSize);
                break;
            }
            case CROSS: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(null);
                this.ctx.strokeLine(X - halfSymbolSize, Y, X + halfSymbolSize, Y);
                this.ctx.strokeLine(X, Y - halfSymbolSize, X, Y + halfSymbolSize);
                break;
            }
            default: {
                this.ctx.setStroke(STROKE);
                this.ctx.setFill(FILL);
                this.ctx.fillOval(X - halfSymbolSize, Y - halfSymbolSize, SYMBOL_SIZE, SYMBOL_SIZE);
                this.ctx.strokeOval(X - halfSymbolSize, Y - halfSymbolSize, SYMBOL_SIZE, SYMBOL_SIZE);
            }
        }
        this.ctx.restore();
    }

    public void addCursorEventListener(CursorEventListener LISTENER) {
        if (this.cursorEventListeners.contains(LISTENER)) {
            return;
        }
        this.cursorEventListeners.add(LISTENER);
    }

    public void removeCursorEventListener(CursorEventListener LISTENER) {
        if (this.cursorEventListeners.contains(LISTENER)) {
            this.cursorEventListeners.remove(LISTENER);
        }
    }

    public void removeAllCursorEventListeners() {
        this.cursorEventListeners.clear();
    }

    public void fireCursorEvent(CursorEvent EVT) {
        this.cursorEventListeners.forEach(listener -> listener.handleCursorEvent(EVT));
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    private void resize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.keepAspect) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.cursorCanvas.setWidth(this.width);
            this.cursorCanvas.setHeight(this.height);
            this.cursorCanvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.symbolSize = Helper.clamp(2.0, 6.0, this.size * 0.016);
            this.scaleX = this.width / this.getRangeX();
            this.scaleY = this.height / this.getRangeY();
            this.redraw();
        }
    }
}

