/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.data.PlotItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class Connection {
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    private PlotItem _incomingItem;
    private ObjectProperty<PlotItem> incomingItem;
    private PlotItem _outgoingItem;
    private ObjectProperty<PlotItem> outgoingItem;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private double _value;
    private DoubleProperty value;
    private String _tooltipText;
    private StringProperty tooltipText;

    public Connection(PlotItem INCOMING_ITEM, PlotItem OUTGOING_ITEM, double VALUE, Color FILL) {
        this(INCOMING_ITEM, OUTGOING_ITEM, VALUE, FILL, "");
    }

    public Connection(PlotItem INCOMING_ITEM, PlotItem OUTGOING_ITEM, double VALUE, Color FILL, String TOOLTIP_TEXT) {
        this._incomingItem = INCOMING_ITEM;
        this._outgoingItem = OUTGOING_ITEM;
        this._value = VALUE;
        this._fill = FILL;
        this._tooltipText = TOOLTIP_TEXT;
    }

    public PlotItem getIncomingItem() {
        return null == this.incomingItem ? this._incomingItem : (PlotItem)this.incomingItem.get();
    }

    public void setIncomingItem(PlotItem ITEM1) {
        if (null == this.incomingItem) {
            this._incomingItem = ITEM1;
        } else {
            this.incomingItem.set((Object)ITEM1);
        }
    }

    public ObjectProperty<PlotItem> incomingItemProperty() {
        if (null == this.incomingItem) {
            this.incomingItem = new ObjectPropertyBase<PlotItem>(this._incomingItem){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "item1";
                }
            };
            this._incomingItem = null;
        }
        return this.incomingItem;
    }

    public PlotItem getOutgoingItem() {
        return null == this.outgoingItem ? this._outgoingItem : (PlotItem)this.outgoingItem.get();
    }

    public void setOutgoingItem(PlotItem ITEM2) {
        if (null == this.outgoingItem) {
            this._outgoingItem = ITEM2;
        } else {
            this.outgoingItem.set((Object)ITEM2);
        }
    }

    public ObjectProperty<PlotItem> outgoingItemProperty() {
        if (null == this.outgoingItem) {
            this.outgoingItem = new ObjectPropertyBase<PlotItem>(this._outgoingItem){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "item2";
                }
            };
            this._outgoingItem = null;
        }
        return this.outgoingItem;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public ReadOnlyDoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    public String getTooltipText() {
        return null == this.tooltipText ? this._tooltipText : (String)this.tooltipText.get();
    }

    public void setTooltipText(String TOOLTIP_TEXT) {
        if (null == this.tooltipText) {
            this._tooltipText = TOOLTIP_TEXT;
        } else {
            this.tooltipText.set((Object)TOOLTIP_TEXT);
        }
    }

    public StringProperty tooltipTextProperty() {
        if (null == this.tooltipText) {
            this.tooltipText = new StringPropertyBase(this._tooltipText){

                public Object getBean() {
                    return Connection.this;
                }

                public String getName() {
                    return "tooltipText";
                }
            };
        }
        return this.tooltipText;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

