/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.ValueItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class ValueChartItem
implements ValueItem,
Comparable<ValueChartItem> {
    private final ChartEvt ITEM_EVENT = new ChartEvt(this, ChartEvt.ITEM_UPDATE);
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;
    private double _value;
    private DoubleProperty value;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;

    public ValueChartItem() {
        this(0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(boolean IS_EMPTY) {
        this(0.0, "", Color.RED, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME) {
        this(VALUE, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(double VALUE, String NAME, boolean IS_EMPTY) {
        this(VALUE, NAME, Color.RED, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL) {
        this(VALUE, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, false);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, boolean IS_EMPTY) {
        this(VALUE, NAME, FILL, Color.TRANSPARENT, Symbol.NONE, IS_EMPTY);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, Color STROKE, Symbol SYMBOL) {
        this(VALUE, NAME, FILL, STROKE, SYMBOL, false);
    }

    public ValueChartItem(double VALUE, String NAME, Color FILL, Color STROKE, Symbol SYMBOL, boolean IS_EMPTY) {
        this._value = VALUE;
        this._name = NAME;
        this._fill = FILL;
        this._stroke = STROKE;
        this._symbol = SYMBOL;
        this._isEmpty = IS_EMPTY;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    }

    @Override
    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    @Override
    public void setValue(double VALUE) {
        if (null == this.value) {
            this._value = VALUE;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.value.set(VALUE);
        }
    }

    @Override
    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public boolean isEmptyItem() {
        return null == this.isEmpty ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (null == this.isEmpty) {
            this._isEmpty = isEmpty;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (null == this.isEmpty) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    ValueChartItem.this.fireChartEvt(ValueChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return ValueChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"value\":" + this.getValue() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }

    @Override
    public int compareTo(ValueChartItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }
}

