/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.forcedirectedgraph.GraphEdge;
import eu.hansolo.fx.charts.forcedirectedgraph.GraphNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;

public class NodeEdgeModel {
    static final Color[] KELLY_COLORS = new Color[]{Color.web((String)"0xFFB300"), Color.web((String)"0x803E75"), Color.web((String)"0xFF6800"), Color.web((String)"0xA6BDD7"), Color.web((String)"0xC10020"), Color.web((String)"0xCEA262"), Color.web((String)"0x817066"), Color.web((String)"0x007D34"), Color.web((String)"0xF6768E"), Color.web((String)"0x00538A"), Color.web((String)"0xFF7A5C"), Color.web((String)"0x53377A"), Color.web((String)"0xFF8E00"), Color.web((String)"0xB32851"), Color.web((String)"0xF4C800"), Color.web((String)"0x7F180D"), Color.web((String)"0x93AA00"), Color.web((String)"0x593315"), Color.web((String)"0xF13A13"), Color.web((String)"0x232C16")};
    private final String kellyColorKey = "Kelly Color";
    private String currentColorThemeKey = "Kelly Color";
    private ArrayList<GraphNode> nodes;
    private ArrayList<GraphEdge> edges;
    private HashMap<String, ArrayList<String>> distinctValuesPerGroupKey;
    private HashMap<String, HashMap<String, Color>> colorSchemes;
    private HashMap<String, ArrayList<Color>> colorThemes;
    private ArrayList<Color> kellyColors;
    private String currentSizeKey;
    private String currentGroupKey;
    private String currentForceKey;
    private String currentEdgeWithKey;
    private SimpleObjectProperty<Color> nodeBorderColor;
    private Color _nodeBorderColor;
    private BooleanProperty alwaysNormalize;
    private boolean _alwaysNormalize;
    private BooleanProperty neverNormalize;
    private boolean _neverNormalize;
    private BooleanProperty normalizeIfNotBetweenZeroAndOne;
    private boolean _normalizeIfNotBetweenZeroAndOne;
    private BooleanProperty isModified;
    private boolean _isModified;
    public static String DEFAULT = "Default";

    public NodeEdgeModel(List<GraphNode> nodes, List<GraphEdge> edges) {
        this.nodes = new ArrayList<GraphNode>(nodes);
        this.edges = new ArrayList<GraphEdge>(edges);
        this.currentSizeKey = DEFAULT;
        this.currentGroupKey = DEFAULT;
        this.currentForceKey = DEFAULT;
        this.currentEdgeWithKey = DEFAULT;
        this.distinctValuesPerGroupKey = new HashMap();
        this.saveDistinctValuesForGroupKey(DEFAULT);
        this.colorSchemes = new HashMap();
        this.getOrCreateGroupColorScheme(DEFAULT);
        this._nodeBorderColor = Color.WHITE;
        this._alwaysNormalize = true;
        this._neverNormalize = false;
        this._isModified = false;
        this._normalizeIfNotBetweenZeroAndOne = false;
        this.colorThemes = new HashMap();
        this.kellyColors = new ArrayList();
        Collections.addAll(this.kellyColors, KELLY_COLORS);
        this.colorThemes.put("Kelly Color", this.kellyColors);
        this.setupConnectedNotes();
    }

    public NodeEdgeModel() {
        this(new ArrayList<GraphNode>(), new ArrayList<GraphEdge>());
    }

    private boolean checkIfNodeKeyValuesBetweenZeroAndOne(String key) {
        for (GraphNode node : this.nodes) {
            if (!(node.getNumericAttribute(key) > 1.0) && !(node.getNumericAttribute(key) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private boolean checkIfEdgeValuesBetweenZeroAndOne(String key) {
        for (GraphEdge edge : this.edges) {
            if (!(edge.getNummericAttribute(key) > 1.0) && !(edge.getNummericAttribute(key) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private void setNodeSizeFromAttributeNormalized(String key) {
        double min = this.nodes.get(0).getNumericAttribute(key);
        double max = this.nodes.get(0).getNumericAttribute(key);
        for (GraphNode node : this.nodes) {
            if (node.getNumericAttribute(key) < min) {
                min = node.getNumericAttribute(key);
                continue;
            }
            if (!(node.getNumericAttribute(key) > max)) continue;
            max = node.getNumericAttribute(key);
        }
        for (GraphNode node : this.nodes) {
            if (min != max) {
                node.setValue(Math.sqrt((node.getNumericAttribute(key) - min) / (Math.PI * (max - min))));
                continue;
            }
            node.setValue(Math.sqrt(0.15915494309189535));
        }
    }

    private void setupNodeBorderColorListener() {
        this.nodeBorderColor.addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                for (GraphNode node : NodeEdgeModel.this.nodes) {
                    node.setStroke(newValue);
                }
                NodeEdgeModel.this.isModified.setValue(Boolean.valueOf(true));
            }
        });
    }

    private void initGroupColorScheme(String groupKey) {
        this.saveDistinctValuesForGroupKey(groupKey);
        HashMap<String, Color> colorScheme = new HashMap<String, Color>();
        int index = 0;
        for (String value : this.distinctValuesPerGroupKey.get(groupKey)) {
            colorScheme.put(value, KELLY_COLORS[index++]);
            if (index < KELLY_COLORS.length) continue;
            index = 0;
        }
        this.colorSchemes.put(groupKey, colorScheme);
    }

    private void saveDistinctValuesForGroupKey(String groupKey) {
        if (this.distinctValuesPerGroupKey.containsKey(groupKey)) {
            return;
        }
        String[] distinct = (String[])this.getNodes().stream().map(n -> n.getStringAttribute(groupKey)).distinct().toArray(String[]::new);
        this.distinctValuesPerGroupKey.put(groupKey, new ArrayList<String>(Arrays.asList(distinct)));
    }

    public void setGroupColors(String group) {
        if (null == this.colorSchemes.get(group) || this.colorSchemes.get(group).isEmpty()) {
            this.getOrCreateGroupColorScheme(group);
        }
        this.currentGroupKey = group;
        this.isModifiedProperty().set(true);
    }

    public void setGroupColors() {
        this.setGroupColors(this.getCurrentGroupKey());
    }

    public void setGroupColorScheme(String groupKey, HashMap<String, Color> colorscheme) {
        this.colorSchemes.put(groupKey, colorscheme);
    }

    public HashMap<String, Color> getOrCreateGroupColorScheme(String group) {
        if (null == this.colorSchemes.get(group) || this.colorSchemes.get(group).isEmpty()) {
            this.initGroupColorScheme(group);
        }
        return this.colorSchemes.get(group);
    }

    public HashMap<String, Color> getOrCreateGroupColorScheme() {
        return this.getOrCreateGroupColorScheme(this.getCurrentGroupKey());
    }

    public HashMap<String, ArrayList<String>> getDistinctValuesPerGroupKey() {
        return this.distinctValuesPerGroupKey;
    }

    public ArrayList<String> getDistinctValuesPerGroupKey(String groupKey) {
        return this.distinctValuesPerGroupKey.get(groupKey);
    }

    public Color getGroupValueColor(String value, String key) {
        return this.colorSchemes.get(key).get(value);
    }

    public void setGroupValueColor(String value, String key, Color color) {
        this.colorSchemes.get(key).replace(value, color);
        for (GraphNode node : this.nodes) {
            if (!node.getStringAttribute(key).equals(value)) continue;
            node.setFill(color);
        }
        this.isModifiedProperty().set(true);
    }

    public void addColorTheme(List<Color> theme, String key) {
        this.colorThemes.put(key, new ArrayList<Color>(theme));
    }

    public void instantiateColorScheme(String colorThemeKey) {
        this.currentColorThemeKey = colorThemeKey;
        this.instantiateColorScheme();
    }

    public void instantiateColorScheme() {
        this.saveDistinctValuesForGroupKey(this.currentGroupKey);
        ArrayList<Color> currentColorTheme = this.colorThemes.get(this.currentColorThemeKey);
        HashMap<String, Color> colorScheme = new HashMap<String, Color>();
        int index = 0;
        if (null == this.currentColorThemeKey || null == currentColorTheme) {
            this.currentColorThemeKey = "Kelly Color";
            currentColorTheme = this.colorThemes.get(this.currentColorThemeKey);
        }
        if (this.distinctValuesPerGroupKey.get(this.currentGroupKey).size() <= currentColorTheme.size()) {
            for (String value : this.distinctValuesPerGroupKey.get(this.currentGroupKey)) {
                colorScheme.put(value, currentColorTheme.get(index++));
            }
        } else {
            System.err.println("Too many distinct values to match them to the predefined set of colors");
        }
        this.colorSchemes.put(this.currentGroupKey, colorScheme);
        this.isModifiedProperty().set(true);
    }

    public void setCurrentColorThemeKey(String currentColorThemeKey) {
        this.currentColorThemeKey = currentColorThemeKey;
    }

    public String getCurrentColorThemeKey() {
        return this.currentColorThemeKey;
    }

    public Set<String> getColorThemeKeys() {
        return this.colorThemes.keySet();
    }

    public boolean isAlwaysNormalize() {
        return null != this.alwaysNormalize ? this.alwaysNormalize.get() : this._alwaysNormalize;
    }

    public BooleanProperty alwaysNormalizeProperty() {
        if (null == this.alwaysNormalize) {
            this.alwaysNormalize = new SimpleBooleanProperty(this._alwaysNormalize);
        }
        return this.alwaysNormalize;
    }

    public void setAlwaysNormalize(boolean alwaysNormalize) {
        if (null != this.alwaysNormalize) {
            this.alwaysNormalize.set(alwaysNormalize);
        } else {
            this._alwaysNormalize = alwaysNormalize;
        }
    }

    public boolean isNeverNormalize() {
        return null != this.neverNormalize ? this.neverNormalize.get() : this._neverNormalize;
    }

    public BooleanProperty neverNormalizeProperty() {
        if (null == this.neverNormalize) {
            this.neverNormalize = new SimpleBooleanProperty(this._neverNormalize);
        }
        return this.neverNormalize;
    }

    public void setNeverNormalize(boolean neverNormalize) {
        if (null != this.neverNormalize) {
            this.neverNormalize.set(neverNormalize);
        } else {
            this._neverNormalize = neverNormalize;
        }
    }

    public boolean isNormalizeIfNotBetweenZeroAndOne() {
        return null != this.normalizeIfNotBetweenZeroAndOne ? this.normalizeIfNotBetweenZeroAndOne.get() : this._normalizeIfNotBetweenZeroAndOne;
    }

    public BooleanProperty normalizeIfNotBetweenZeroAndOneProperty() {
        if (null == this.normalizeIfNotBetweenZeroAndOne) {
            this.normalizeIfNotBetweenZeroAndOne = new SimpleBooleanProperty(this._normalizeIfNotBetweenZeroAndOne);
        }
        return this.normalizeIfNotBetweenZeroAndOne;
    }

    public void setNormalizeIfNotBetweenZeroAndOne(boolean normalizeIfNotBetweenZeroAndOne) {
        if (null != this.normalizeIfNotBetweenZeroAndOne) {
            this.normalizeIfNotBetweenZeroAndOne.set(normalizeIfNotBetweenZeroAndOne);
        } else {
            this._normalizeIfNotBetweenZeroAndOne = normalizeIfNotBetweenZeroAndOne;
        }
    }

    public void setNodeSizeKey(String key) {
        this.currentSizeKey = key;
        if (this.isAlwaysNormalize()) {
            this.setNodeSizeFromAttributeNormalized(key);
        } else if (this.isNormalizeIfNotBetweenZeroAndOne()) {
            if (this.checkIfNodeKeyValuesBetweenZeroAndOne(key)) {
                this.setNodeSizeFromAttributeNotNormalized(key);
            } else {
                this.setNodeSizeFromAttributeNormalized(key);
            }
        } else if (this.isNeverNormalize()) {
            this.setNodeSizeFromAttributeNotNormalized(key);
        } else {
            System.err.println("Normalization behavior not defined, data was normalized as default behavior");
        }
        this.isModifiedProperty().set(true);
    }

    public void setNodeSizeFromAttributeNotNormalized(String key) {
        for (GraphNode node : this.nodes) {
            node.setValue(node.getNumericAttribute(key));
        }
    }

    public void setEdgeForceFromAttributeNormalized(String key) {
        double min = this.edges.get(0).getNummericAttribute(key);
        double max = this.edges.get(0).getNummericAttribute(key);
        for (GraphEdge edge : this.edges) {
            if (edge.getNummericAttribute(key) < min) {
                min = edge.getNummericAttribute(key);
                continue;
            }
            if (!(edge.getNummericAttribute(key) > max)) continue;
            max = edge.getNummericAttribute(key);
        }
        for (GraphEdge edge : this.edges) {
            if (min != max) {
                edge.setForce((edge.getNummericAttribute(key) - min) / (max - min));
                continue;
            }
            edge.setForce(0.5);
        }
        this.isModifiedProperty().set(true);
    }

    public void setEdgeWidthFromAttributeNormalized(String key) {
        double min;
        double max = min = this.edges.get(0).getNummericAttribute(key);
        for (GraphEdge edge : this.edges) {
            if (edge.getNummericAttribute(key) < min) {
                min = edge.getNummericAttribute(key);
                continue;
            }
            if (!(edge.getNummericAttribute(key) > max)) continue;
            max = edge.getNummericAttribute(key);
        }
        for (GraphEdge edge : this.edges) {
            if (min != max) {
                edge.setWidth((edge.getNummericAttribute(key) - min) / (max - min));
                continue;
            }
            edge.setWidth(0.5);
        }
        this.isModifiedProperty().set(true);
    }

    public void setEdgeForceFromAttributeNotNormalized(String key) {
        for (GraphEdge edge : this.edges) {
            edge.setForce(edge.getNummericAttribute(key));
        }
    }

    public void setEdgeWithFromAttributeNotNormalized(String key) {
        for (GraphEdge edge : this.edges) {
            edge.setWidth(edge.getNummericAttribute(key));
        }
    }

    public void printPositionsOnConsole() {
        for (GraphNode node : this.nodes) {
            System.out.println(node.getPosition().getX() + " " + node.getPosition().getY());
        }
    }

    public ArrayList<String> getNumericAttributeKeysOfNodes() {
        return this.nodes.get(0).getNumericAttributeKeys();
    }

    public ArrayList<String> getStringAttributeKeysOfNodes() {
        return this.nodes.get(0).getStringAttributeKeys();
    }

    public ArrayList<String> getNumericAttributeKeysOfEdges() {
        return this.edges.get(0).getNummericAttributeKeys();
    }

    public void setupConnectedNotes() {
        for (GraphEdge edge : this.edges) {
            edge.getU().addConnection(edge.getV());
            edge.getV().addConnection(edge.getU());
        }
    }

    public GraphNode getNodeAt(double X, double Y, double scaleFactor, double minRadius, double nodeSizeFactor) {
        for (GraphNode node : this.nodes) {
            if (!node.containedIn(X, Y, nodeSizeFactor, scaleFactor, minRadius)) continue;
            return node;
        }
        return null;
    }

    public ArrayList<GraphNode> getNodes() {
        return this.nodes;
    }

    public ArrayList<GraphEdge> getEdges() {
        return this.edges;
    }

    public String getCurrentSizeKey() {
        return this.currentSizeKey;
    }

    public String getCurrentGroupKey() {
        return this.currentGroupKey;
    }

    public String getCurrentForceKey() {
        return this.currentForceKey;
    }

    public String getCurrentEdgeWithKey() {
        return this.currentEdgeWithKey;
    }

    public Color getNodeBorderColor() {
        return null == this.nodeBorderColor ? this._nodeBorderColor : (Color)this.nodeBorderColor.get();
    }

    public void setNodeBorderColor(Color COLOR) {
        if (null == this.nodeBorderColor) {
            this._nodeBorderColor = COLOR;
        } else {
            this.nodeBorderColor.set((Object)COLOR);
        }
        this.isModifiedProperty().setValue(Boolean.valueOf(true));
    }

    public ObjectProperty<Color> nodeBorderColorProperty() {
        if (null == this.nodeBorderColor) {
            this.nodeBorderColor = new SimpleObjectProperty((Object)this._nodeBorderColor);
            this.setupNodeBorderColorListener();
        }
        return this.nodeBorderColor;
    }

    public boolean isModified() {
        return null == this.isModified ? this._isModified : this.isModified.get();
    }

    public void setModified(boolean modified) {
        if (null == this.isModified) {
            this._isModified = modified;
        } else {
            this.isModified.set(modified);
        }
    }

    public BooleanProperty isModifiedProperty() {
        if (null == this.isModified) {
            this.isModified = new SimpleBooleanProperty(this._isModified);
        }
        return this.isModified;
    }

    public void setEdgeWithKey(String key) {
        this.currentEdgeWithKey = key;
        if (this.isAlwaysNormalize()) {
            this.setEdgeWidthFromAttributeNormalized(key);
        } else if (this.isNormalizeIfNotBetweenZeroAndOne()) {
            if (this.checkIfEdgeValuesBetweenZeroAndOne(key)) {
                this.setEdgeWithFromAttributeNotNormalized(key);
            } else {
                this.setEdgeWidthFromAttributeNormalized(key);
            }
        } else if (this.isNeverNormalize()) {
            this.setEdgeWithFromAttributeNotNormalized(key);
        } else {
            System.err.println("Normalization behavior not defined, data was normalized as default behavior");
        }
    }

    public void setEdgeForceKey(String key) {
        this.currentForceKey = key;
        if (this.isAlwaysNormalize()) {
            this.setEdgeForceFromAttributeNormalized(key);
        } else if (this.isNormalizeIfNotBetweenZeroAndOne()) {
            if (this.checkIfEdgeValuesBetweenZeroAndOne(key)) {
                this.setEdgeForceFromAttributeNotNormalized(key);
            } else {
                this.setEdgeForceFromAttributeNormalized(key);
            }
        } else if (this.isNeverNormalize()) {
            this.setEdgeForceFromAttributeNotNormalized(key);
        } else {
            System.out.println("Normalization behavior not defined, data was normalized as default behavior");
        }
    }
}

