/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.XYItem;
import eu.hansolo.fx.charts.series.Series;
import java.util.Comparator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class XYSeries<T extends XYItem>
extends Series {
    public XYSeries() {
        this(null, ChartType.SCATTER, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Symbol.CIRCLE, true);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE) {
        this(ITEMS, TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Symbol.CIRCLE, true);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, boolean SHOW_POINTS) {
        this(ITEMS, TYPE, "", (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Symbol.CIRCLE, SHOW_POINTS);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, Paint STROKE) {
        this(ITEMS, TYPE, "", (Paint)Color.TRANSPARENT, STROKE, Symbol.CIRCLE, true);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, Paint FILL, Paint STROKE) {
        this(ITEMS, TYPE, "", FILL, STROKE, Symbol.CIRCLE, true);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, String NAME) {
        this(ITEMS, TYPE, NAME, (Paint)Color.TRANSPARENT, (Paint)Color.BLACK, Symbol.CIRCLE, true);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, boolean SHOW_POINTS) {
        this(ITEMS, TYPE, NAME, FILL, STROKE, Symbol.CIRCLE, SHOW_POINTS);
    }

    public XYSeries(List<T> ITEMS, ChartType TYPE, String NAME, Paint FILL, Paint STROKE, Symbol SYMBOL, boolean SYMBOLS_VISIBLE) {
        super(ITEMS, TYPE, NAME, FILL, STROKE, SYMBOL);
        this.setSymbolsVisible(SYMBOLS_VISIBLE);
    }

    @Override
    public ObservableList<T> getItems() {
        return this.items;
    }

    public double getMinX() {
        return this.getItems().stream().min(Comparator.comparingDouble(XYItem::getX)).get().getX();
    }

    public double getMaxX() {
        return this.getItems().stream().max(Comparator.comparingDouble(XYItem::getX)).get().getX();
    }

    public double getMinY() {
        return this.getItems().stream().min(Comparator.comparingDouble(XYItem::getY)).get().getY();
    }

    public double getMaxY() {
        return this.getItems().stream().max(Comparator.comparingDouble(XYItem::getY)).get().getY();
    }

    public double getRangeX() {
        return this.getMaxX() - this.getMinX();
    }

    public double getRangeY() {
        return this.getMaxY() - this.getMinY();
    }

    public double getSumOfXValues() {
        return this.getItems().stream().mapToDouble(XYItem::getX).sum();
    }

    public double getSumOfYValues() {
        return this.getItems().stream().mapToDouble(XYItem::getY).sum();
    }
}

