/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

public class VPoint {
    private double[] coordinates;

    public VPoint(double ... coords) {
        this.coordinates = new double[coords.length];
        System.arraycopy(coords, 0, this.coordinates, 0, coords.length);
    }

    public double getCoordinates(int i) {
        return this.coordinates[i];
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public int checkDimension(VPoint p) {
        int len = this.coordinates.length;
        if (len != p.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return len;
    }

    public VPoint extend(double ... coords) {
        double[] result = new double[this.coordinates.length + coords.length];
        System.arraycopy(this.coordinates, 0, result, 0, this.coordinates.length);
        System.arraycopy(coords, 0, result, this.coordinates.length, coords.length);
        return new VPoint(result);
    }

    public double dotProduct(VPoint p) {
        int len = this.checkDimension(p);
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            sum += this.coordinates[i] * p.coordinates[i];
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dotProduct(this));
    }

    public VPoint subtract(VPoint p) {
        int len = this.checkDimension(p);
        double[] coords = new double[len];
        for (int i = 0; i < len; ++i) {
            coords[i] = this.coordinates[i] - p.coordinates[i];
        }
        return new VPoint(coords);
    }

    public VPoint add(VPoint p) {
        int len = this.checkDimension(p);
        double[] coords = new double[len];
        for (int i = 0; i < len; ++i) {
            coords[i] = this.coordinates[i] + p.coordinates[i];
        }
        return new VPoint(coords);
    }

    public double angle(VPoint p) {
        return Math.acos(this.dotProduct(p) / (this.magnitude() * p.magnitude()));
    }

    public VPoint bisector(VPoint point) {
        this.checkDimension(point);
        VPoint diff = this.subtract(point);
        VPoint sum = this.add(point);
        double dot = diff.dotProduct(sum);
        return diff.extend(-dot / 2.0);
    }

    public static String toString(VPoint[] matrix) {
        StringBuilder buf = new StringBuilder("{");
        for (VPoint row : matrix) {
            buf.append(" " + row);
        }
        buf.append(" }");
        return buf.toString();
    }

    public static double determinant(VPoint[] matrix) {
        if (matrix.length != matrix[0].getDimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] columns = new boolean[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            columns[i] = true;
        }
        try {
            return VPoint.determinant(matrix, 0, columns);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(VPoint[] matrix, int row, boolean[] cols) {
        if (row == matrix.length) {
            return 1.0;
        }
        double sum = 0.0;
        int sign = 1;
        for (int col = 0; col < cols.length; ++col) {
            if (!cols[col]) continue;
            cols[col] = false;
            sum += (double)sign * matrix[row].coordinates[col] * VPoint.determinant(matrix, row + 1, cols);
            cols[col] = true;
            sign = -sign;
        }
        return sum;
    }

    public static VPoint cross(VPoint[] matrix) {
        int len = matrix.length + 1;
        if (len != matrix[0].getDimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] columns = new boolean[len];
        for (int i = 0; i < len; ++i) {
            columns[i] = true;
        }
        double[] result = new double[len];
        int sign = 1;
        try {
            for (int i = 0; i < len; ++i) {
                columns[i] = false;
                result[i] = (double)sign * VPoint.determinant(matrix, 0, columns);
                columns[i] = true;
                sign = -sign;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new VPoint(result);
    }

    public static double content(VPoint[] simplex) {
        VPoint[] matrix = new VPoint[simplex.length];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = simplex[i].extend(1.0);
        }
        int fact = 1;
        for (int i = 1; i < matrix.length; ++i) {
            fact *= i;
        }
        return VPoint.determinant(matrix) / (double)fact;
    }

    public int[] relation(VPoint[] simplex) {
        int i;
        int dim = simplex.length - 1;
        if (this.getDimension() != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        VPoint[] matrix = new VPoint[dim + 1];
        double[] coords = new double[dim + 2];
        for (int j = 0; j < coords.length; ++j) {
            coords[j] = 1.0;
        }
        matrix[0] = new VPoint(coords);
        for (int i2 = 0; i2 < dim; ++i2) {
            coords[0] = this.coordinates[i2];
            for (int j = 0; j < simplex.length; ++j) {
                coords[j + 1] = simplex[j].coordinates[i2];
            }
            matrix[i2 + 1] = new VPoint(coords);
        }
        VPoint vector = VPoint.cross(matrix);
        double content = vector.coordinates[0];
        int[] result = new int[dim + 1];
        for (i = 0; i < result.length; ++i) {
            double value = vector.coordinates[i + 1];
            result[i] = Math.abs(value) <= 1.0E-6 * Math.abs(content) ? 0 : (value < 0.0 ? -1 : 1);
        }
        if (content < 0.0) {
            for (i = 0; i < result.length; ++i) {
                result[i] = -result[i];
            }
        }
        if (content == 0.0) {
            for (i = 0; i < result.length; ++i) {
                result[i] = Math.abs(result[i]);
            }
        }
        return result;
    }

    public VPoint isOutside(VPoint[] simplex) {
        int[] result = this.relation(simplex);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] <= 0) continue;
            return simplex[i];
        }
        return null;
    }

    public VPoint isOn(VPoint[] simplex) {
        int[] result = this.relation(simplex);
        VPoint witness = null;
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == 0) {
                witness = simplex[i];
                continue;
            }
            if (result[i] <= 0) continue;
            return null;
        }
        return witness;
    }

    public boolean isInside(VPoint[] simplex) {
        int[] result;
        for (int r : result = this.relation(simplex)) {
            if (r < 0) continue;
            return false;
        }
        return true;
    }

    public int vsCircumCircle(VPoint[] simplex) {
        int result;
        VPoint[] matrix = new VPoint[simplex.length + 1];
        for (int i = 0; i < simplex.length; ++i) {
            matrix[i] = simplex[i].extend(1.0, simplex[i].dotProduct(simplex[i]));
        }
        matrix[simplex.length] = this.extend(1.0, this.dotProduct(this));
        double d = VPoint.determinant(matrix);
        int n = d < 0.0 ? -1 : (result = d > 0.0 ? 1 : 0);
        if (VPoint.content(simplex) < 0.0) {
            result = -result;
        }
        return result;
    }

    public static VPoint circumcenter(VPoint[] simplex) {
        int dim = simplex[0].getDimension();
        if (simplex.length - 1 != dim) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        VPoint[] matrix = new VPoint[dim];
        for (int i = 0; i < dim; ++i) {
            matrix[i] = simplex[i].bisector(simplex[i + 1]);
        }
        VPoint hCenter = VPoint.cross(matrix);
        double last = hCenter.coordinates[dim];
        double[] result = new double[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = hCenter.coordinates[i] / last;
        }
        return new VPoint(result);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VPoint)) {
            return false;
        }
        VPoint p = (VPoint)other;
        if (this.coordinates.length != p.coordinates.length) {
            return false;
        }
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (this.coordinates[i] == p.coordinates[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (double c : this.coordinates) {
            long bits = Double.doubleToLongBits(c);
            hash = 31 * hash ^ (int)(bits ^ bits >> 32);
        }
        return hash;
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "Point()";
        }
        String result = "Point(" + this.coordinates[0];
        for (int i = 1; i < this.coordinates.length; ++i) {
            result = result + "," + this.coordinates[i];
        }
        result = result + ")";
        return result;
    }
}

