/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Defect {
    private final int id;
    private final double xRel;
    private final double yRel;
    private final int indexX;
    private final int indexY;
    private final double sizeX;
    private final double sizeY;
    private final double defectArea;
    private final double sizeD;
    private final int classNumber;
    private final int roughBinNumber;
    private final int fineBinNumber;
    private final int test;
    private final int clusterNumber;
    private double xAbsolute;
    private double yAbsolute;
    private int imageCount;
    private List<String> imageList;

    public Defect(int id, double xRel, double yRel, int indexX, int indexY, double sizeX, double sizeY, double defectArea, double sizeD, int classNumber, int roughBinNumber, int fineBinNumber, int test, int clusterNumber, int imageCount, String ... imageList) {
        this.id = id;
        this.xRel = xRel;
        this.yRel = yRel;
        this.indexX = indexX;
        this.indexY = indexY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.defectArea = defectArea;
        this.sizeD = sizeD;
        this.classNumber = classNumber;
        this.roughBinNumber = roughBinNumber;
        this.fineBinNumber = fineBinNumber;
        this.test = test;
        this.clusterNumber = clusterNumber;
        this.xAbsolute = 0.0;
        this.yAbsolute = 0.0;
        this.imageCount = imageCount;
        this.imageList = new ArrayList<String>(imageCount);
        this.imageList.addAll(Arrays.stream(imageList).toList());
    }

    public int getId() {
        return this.id;
    }

    public double getXRel() {
        return this.xRel;
    }

    public double getYRel() {
        return this.yRel;
    }

    public int getIndexX() {
        return this.indexX;
    }

    public int getIndexY() {
        return this.indexY;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public double getDefectArea() {
        return this.defectArea;
    }

    public double getSizeD() {
        return this.sizeD;
    }

    public int getClassNumber() {
        return this.classNumber;
    }

    public int getRoughBinNumber() {
        return this.roughBinNumber;
    }

    public int getFineBinNumber() {
        return this.fineBinNumber;
    }

    public int getTest() {
        return this.test;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public double getXAbsolute() {
        return this.xAbsolute;
    }

    public void setXAbsolute(double xAbsolute) {
        this.xAbsolute = xAbsolute;
    }

    public double getYAbsolute() {
        return this.yAbsolute;
    }

    public void setYAbsolute(double yAbsolute) {
        this.yAbsolute = yAbsolute;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int imageCount) {
        this.imageCount = imageCount;
    }

    public List<String> getImageList() {
        return this.imageList;
    }

    public void setImageList(String ... imageList) {
        this.imageList.clear();
        this.imageList.addAll(Arrays.stream(imageList).toList());
    }

    public String getLabel() {
        return this.indexX + "/" + this.indexY;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Defect defect = (Defect)other;
        return this.id == defect.id && Double.compare(defect.xRel, this.xRel) == 0 && Double.compare(defect.yRel, this.yRel) == 0 && this.indexX == defect.indexX && this.indexY == defect.indexY && Double.compare(defect.sizeX, this.sizeX) == 0 && Double.compare(defect.sizeY, this.sizeY) == 0 && Double.compare(defect.defectArea, this.defectArea) == 0 && Double.compare(defect.sizeD, this.sizeD) == 0 && this.classNumber == defect.classNumber && this.roughBinNumber == defect.roughBinNumber && this.fineBinNumber == defect.fineBinNumber && this.test == defect.test && this.clusterNumber == defect.clusterNumber && this.imageCount == defect.imageCount;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.xRel, this.yRel, this.indexX, this.indexY, this.sizeX, this.sizeY, this.defectArea, this.sizeD, this.classNumber, this.roughBinNumber, this.fineBinNumber, this.test, this.clusterNumber, this.imageCount);
    }

    public String toString() {
        return " " + this.id + " " + String.format(Locale.US, "%.10e", this.xRel) + " " + String.format(Locale.US, "%.10e", this.yRel) + " " + this.indexX + " " + this.indexY + " " + String.format(Locale.US, "%.6f", this.sizeX) + " " + String.format(Locale.US, "%.6f", this.sizeY) + " " + String.format(Locale.US, "%.6f", this.defectArea) + " " + String.format(Locale.US, "%.10e", this.sizeD) + " " + this.classNumber + " " + this.roughBinNumber + " " + this.fineBinNumber + " " + this.test + " " + this.clusterNumber + " " + this.imageCount + " " + this.imageList.stream().collect(Collectors.joining(" "));
    }
}

