/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.LineIterator;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;

public class Line
extends Shape {
    public double x1;
    public double y1;
    public double x2;
    public double y2;

    public Line() {
    }

    public Line(double X1, double Y1, double X2, double Y2) {
        this.setLine(X1, Y1, X2, Y2);
    }

    public Line(Point P1, Point P2) {
        this.setLine(P1, P2);
    }

    public void setLine(double X1, double Y1, double X2, double Y2) {
        this.x1 = X1;
        this.y1 = Y1;
        this.x2 = X2;
        this.y2 = Y2;
    }

    public void setLine(Point P1, Point P2) {
        this.setLine(P1.x, P1.y, P2.x, P2.y);
    }

    public void setLine(Line LINE) {
        this.setLine(LINE.x1, LINE.y1, LINE.x2, LINE.y2);
    }

    @Override
    public RectBounds getBounds() {
        RectBounds b = new RectBounds();
        b.setBoundsAndSort(this.x1, this.y1, this.x2, this.y2);
        return b;
    }

    @Override
    public boolean contains(double X, double Y) {
        return false;
    }

    @Override
    public boolean contains(double X, double Y, double WIDTH, double HEIGHT) {
        return false;
    }

    @Override
    public boolean contains(Point POINT) {
        return false;
    }

    @Override
    public boolean intersects(double X, double Y, double WIDTH, double HEIGHT) {
        int out1;
        int out2 = Line.outcode(X, Y, WIDTH, HEIGHT, this.x2, this.y2);
        if (out2 == 0) {
            return true;
        }
        double px = this.x1;
        double py = this.y1;
        while ((out1 = Line.outcode(X, Y, WIDTH, HEIGHT, px, py)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                px = X;
                if ((out1 & 4) != 0) {
                    px += WIDTH;
                }
                py = this.y1 + (px - this.x1) * (this.y2 - this.y1) / (this.x2 - this.x1);
                continue;
            }
            py = Y;
            if ((out1 & 8) != 0) {
                py += HEIGHT;
            }
            px = this.x1 + (py - this.y1) * (this.x2 - this.x1) / (this.y2 - this.y1);
        }
        return true;
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if ((double)Double.compare(ccw, 0.0) == 0.0 && (ccw = px * x2 + py * y2) > 0.0 && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double PX, double PY) {
        return Line.relativeCCW(this.x1, this.y1, this.x2, this.y2, PX, PY);
    }

    public int relativeCCW(Point POINT) {
        return Line.relativeCCW(this.x1, this.y1, this.x2, this.y2, POINT.x, POINT.y);
    }

    public static boolean linesIntersect(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4) {
        return Line.relativeCCW(X1, Y1, X2, Y2, X3, Y3) * Line.relativeCCW(X1, Y1, X2, Y2, X4, Y4) <= 0 && Line.relativeCCW(X3, Y3, X4, Y4, X1, Y1) * Line.relativeCCW(X3, Y3, X4, Y4, X2, Y2) <= 0;
    }

    public boolean intersectsLine(double X1, double Y1, double X2, double Y2) {
        return Line.linesIntersect(X1, Y1, X2, Y2, this.x1, this.y1, this.x2, this.y2);
    }

    public boolean intersectsLine(Line LINE) {
        return Line.linesIntersect(LINE.x1, LINE.y1, LINE.x2, LINE.y2, this.x1, this.y1, this.x2, this.y2);
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double projlenSq;
        double lenSq;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0.0 ? 0.0 : (Double.compare(dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2, 0.0) <= 0 ? 0.0 : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public static double ptSegDist(double X1, double Y1, double X2, double Y2, double PX, double PY) {
        return Math.sqrt(Line.ptSegDistSq(X1, Y1, X2, Y2, PX, PY));
    }

    public double ptSegDistSq(double PX, double PY) {
        return Line.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, PX, PY);
    }

    public double ptSegDistSq(Point POINT) {
        return Line.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, POINT.x, POINT.y);
    }

    public double ptSegDist(double PX, double PY) {
        return Line.ptSegDist(this.x1, this.y1, this.x2, this.y2, PX, PY);
    }

    public double ptSegDist(Point POINT) {
        return Line.ptSegDist(this.x1, this.y1, this.x2, this.y2, POINT.x, POINT.y);
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double dotprod;
        double projlenSq;
        double lenSq;
        if ((lenSq = (px -= x1) * px + (py -= y1) * py - (projlenSq = (dotprod = px * (x2 -= x1) + py * (y2 -= y1)) * dotprod / (x2 * x2 + y2 * y2))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public static double ptLineDist(double X1, double Y1, double X2, double Y2, double PX, double PY) {
        return Math.sqrt(Line.ptLineDistSq(X1, Y1, X2, Y2, PX, PY));
    }

    public double ptLineDistSq(double PX, double PY) {
        return Line.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, PX, PY);
    }

    public double ptLineDistSq(Point POINT) {
        return Line.ptLineDistSq(this.x1, this.y1, this.x2, this.y2, POINT.x, POINT.y);
    }

    public double ptLineDist(double PX, double PY) {
        return Line.ptLineDist(this.x1, this.y1, this.x2, this.y2, PX, PY);
    }

    public double ptLineDist(Point POINT) {
        return Line.ptLineDist(this.x1, this.y1, this.x2, this.y2, POINT.x, POINT.y);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM) {
        return new LineIterator(this, TRANSFORM);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM, double FLATNESS) {
        return new LineIterator(this, TRANSFORM);
    }

    @Override
    public Line copy() {
        return new Line(this.x1, this.y1, this.x2, this.y2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Line) {
            Line line = (Line)obj;
            return this.x1 == line.x1 && this.y1 == line.y1 && this.x2 == line.x2 && this.y2 == line.y2;
        }
        return false;
    }
}

