/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ComparisonBarChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ComparisonBarChartBuilder<B extends ComparisonBarChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private ChartItemSeries<ChartItem> series1;
    private ChartItemSeries<ChartItem> series2;

    protected ComparisonBarChartBuilder(ChartItemSeries<ChartItem> SERIES_1, ChartItemSeries<ChartItem> SERIES_2) {
        this.series1 = SERIES_1;
        this.series2 = SERIES_2;
    }

    public static final ComparisonBarChartBuilder create(ChartItemSeries<ChartItem> series1, ChartItemSeries<ChartItem> series2) {
        return new ComparisonBarChartBuilder(series1, series2);
    }

    public final B backgroundFill(Paint backgroundFill) {
        this.properties.put("backgroundFill", (Property)new SimpleObjectProperty((Object)backgroundFill));
        return (B)this;
    }

    public final B categoryBackgroundFill(Paint categoryBackgroundFill) {
        this.properties.put("categoryBackgroundFill", (Property)new SimpleObjectProperty((Object)categoryBackgroundFill));
        return (B)this;
    }

    public final B barBackgroundFill(Color barBackgroundFill) {
        this.properties.put("barBackgroundFill", (Property)new SimpleObjectProperty((Object)barBackgroundFill));
        return (B)this;
    }

    public final B textFill(Color textFill) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)textFill));
        return (B)this;
    }

    public final B categoryTextFill(Color categoryTextFill) {
        this.properties.put("categoryTextFill", (Property)new SimpleObjectProperty((Object)categoryTextFill));
        return (B)this;
    }

    public final B betterColor(Color betterColor) {
        this.properties.put("betterColor", (Property)new SimpleObjectProperty((Object)betterColor));
        return (B)this;
    }

    public final B poorerColor(Color poorerColor) {
        this.properties.put("poorerColor", (Property)new SimpleObjectProperty((Object)poorerColor));
        return (B)this;
    }

    public final B betterDarkerColor(Color betterDarkerColor) {
        this.properties.put("betterDarkerColor", (Property)new SimpleObjectProperty((Object)betterDarkerColor));
        return (B)this;
    }

    public final B betterBrighterColor(Color betterBrighterColor) {
        this.properties.put("betterBrighterColor", (Property)new SimpleObjectProperty((Object)betterBrighterColor));
        return (B)this;
    }

    public final B poorerDarkerColor(Color poorerDarkerColor) {
        this.properties.put("poorerDarkerColor", (Property)new SimpleObjectProperty((Object)poorerDarkerColor));
        return (B)this;
    }

    public final B poorerBrighterColor(Color poorerBrighterColor) {
        this.properties.put("poorerBrighterColor", (Property)new SimpleObjectProperty((Object)poorerBrighterColor));
        return (B)this;
    }

    public final B barBackgroundVisible(boolean barBackgroundVisible) {
        this.properties.put("barBackgroundVisible", (Property)new SimpleBooleanProperty(barBackgroundVisible));
        return (B)this;
    }

    public final B shadowsVisible(boolean shadowsVisible) {
        this.properties.put("shadowsVisible", (Property)new SimpleBooleanProperty(shadowsVisible));
        return (B)this;
    }

    public final B categorySumVisible(boolean categorySumVisible) {
        this.properties.put("categorySumVisible", (Property)new SimpleBooleanProperty(categorySumVisible));
        return (B)this;
    }

    public final B numberFormat(NumberFormat numberFormat) {
        this.properties.put("numberFormat", (Property)new SimpleObjectProperty((Object)numberFormat));
        return (B)this;
    }

    public final B doCompare(boolean doCompare) {
        this.properties.put("doCompare", (Property)new SimpleBooleanProperty(doCompare));
        return (B)this;
    }

    public final B useItemTextFill(boolean useItemTextFill) {
        this.properties.put("useItemTextFill", (Property)new SimpleBooleanProperty(useItemTextFill));
        return (B)this;
    }

    public final B useCategoryTextFill(boolean useCategoryTextFill) {
        this.properties.put("useCategoryTextFill", (Property)new SimpleBooleanProperty(useCategoryTextFill));
        return (B)this;
    }

    public final B shortenNumbers(boolean shortenNumbers) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(shortenNumbers));
        return (B)this;
    }

    public final B sorted(boolean sorted) {
        this.properties.put("sorted", (Property)new SimpleBooleanProperty(sorted));
        return (B)this;
    }

    public final B order(Order order) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)order));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final ComparisonBarChart build() {
        ComparisonBarChart control = new ComparisonBarChart(this.series1, this.series2);
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "backgroundFill": {
                    control.setBackgroundFill((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "categoryBackgroundFill": {
                    control.setCategoryBackgroundFill((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "barBackgroundFill": {
                    control.setBarBackgroundFill((Color)((ObjectProperty)property).get());
                    break;
                }
                case "textFill": {
                    control.setTextFill((Color)((ObjectProperty)property).get());
                    break;
                }
                case "categoryTextFill": {
                    control.setCategoryTextFill((Color)((ObjectProperty)property).get());
                    break;
                }
                case "betterColor": {
                    control.setBetterColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "poorer": {
                    control.setPoorerColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "betterDarkerColor": {
                    control.setBetterDarkerColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "betterBrighterColor": {
                    control.setBetterBrighterColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "poorerDarkerColor": {
                    control.setPoorerDarkerColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "poorerBrighterColor": {
                    control.setPoorerBrighterColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "barBackgroundVisible": {
                    control.setBarBackgroundVisible(((BooleanProperty)property).get());
                    break;
                }
                case "shadowsVisible": {
                    control.setShadowsVisible(((BooleanProperty)property).get());
                    break;
                }
                case "categorySumVisible": {
                    control.setCategorySumVisible(((BooleanProperty)property).get());
                    break;
                }
                case "numberFormat": {
                    control.setNumberFormat((NumberFormat)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "doCompare": {
                    control.setDoCompare(((BooleanProperty)property).get());
                    break;
                }
                case "useItemTextFill": {
                    control.setUseItemTextFill(((BooleanProperty)property).get());
                    break;
                }
                case "useCategoryTextFill": {
                    control.setUseCategoryTextFill(((BooleanProperty)property).get());
                    break;
                }
                case "shortenNumbers": {
                    control.setShortenNumbers(((BooleanProperty)property).get());
                    break;
                }
                case "sorted": {
                    control.setSorted(((BooleanProperty)property).get());
                    break;
                }
                case "order": {
                    control.setOrder((Order)((Object)((Object)((ObjectProperty)property).get())));
                }
            }
        });
        return control;
    }
}

