/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.ComparisonRingChart;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.NumberFormat;
import eu.hansolo.fx.charts.tools.Order;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;

public class ComparisonRingChartBuilder<B extends ComparisonRingChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private ChartItemSeries<ChartItem> series1;
    private ChartItemSeries<ChartItem> series2;

    protected ComparisonRingChartBuilder(ChartItemSeries<ChartItem> SERIES_1, ChartItemSeries<ChartItem> SERIES_2) {
        this.series1 = SERIES_1;
        this.series2 = SERIES_2;
    }

    public static final ComparisonRingChartBuilder create(ChartItemSeries<ChartItem> SERIES_1, ChartItemSeries<ChartItem> SERIES_2) {
        return new ComparisonRingChartBuilder(SERIES_1, SERIES_2);
    }

    public final B barBackgroundColor(Color COLOR) {
        this.properties.put("barBackgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B sorted(boolean SORTED) {
        this.properties.put("sorted", (Property)new SimpleBooleanProperty(SORTED));
        return (B)this;
    }

    public final B order(Order ORDER) {
        this.properties.put("order", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B numberFormat(NumberFormat FORMAT) {
        this.properties.put("numberFormat", (Property)new SimpleObjectProperty((Object)FORMAT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final ComparisonRingChart build() {
        ComparisonRingChart control = new ComparisonRingChart(this.series1, this.series2);
        this.properties.forEach((key, property) -> {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setMinSize(dim.getWidth(), dim.getHeight());
            } else if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setMaxSize(dim.getWidth(), dim.getHeight());
            } else if ("prefWidth".equals(key)) {
                control.setPrefWidth(((DoubleProperty)property).get());
            } else if ("prefHeight".equals(key)) {
                control.setPrefHeight(((DoubleProperty)property).get());
            } else if ("minWidth".equals(key)) {
                control.setMinWidth(((DoubleProperty)property).get());
            } else if ("minHeight".equals(key)) {
                control.setMinHeight(((DoubleProperty)property).get());
            } else if ("maxWidth".equals(key)) {
                control.setMaxWidth(((DoubleProperty)property).get());
            } else if ("maxHeight".equals(key)) {
                control.setMaxHeight(((DoubleProperty)property).get());
            } else if ("scaleX".equals(key)) {
                control.setScaleX(((DoubleProperty)property).get());
            } else if ("scaleY".equals(key)) {
                control.setScaleY(((DoubleProperty)property).get());
            } else if ("layoutX".equals(key)) {
                control.setLayoutX(((DoubleProperty)property).get());
            } else if ("layoutY".equals(key)) {
                control.setLayoutY(((DoubleProperty)property).get());
            } else if ("translateX".equals(key)) {
                control.setTranslateX(((DoubleProperty)property).get());
            } else if ("translateY".equals(key)) {
                control.setTranslateY(((DoubleProperty)property).get());
            } else if ("padding".equals(key)) {
                control.setPadding((Insets)((ObjectProperty)property).get());
            } else if ("barBackgroundColor".equals(key)) {
                control.setBarBackgroundFill((Color)((ObjectProperty)property).get());
            } else if ("sorted".equals(key)) {
                control.setSorted(((BooleanProperty)property).get());
            } else if ("order".equals(key)) {
                control.setOrder((Order)((Object)((Object)((ObjectProperty)property).get())));
            } else if ("numberFormat".equals(key)) {
                control.setNumberFormat((NumberFormat)((Object)((Object)((ObjectProperty)property).get())));
            }
        });
        return control;
    }
}

