/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.event.PixelMatrixEventListener;
import eu.hansolo.fx.charts.event.PixelMatrixEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolboxfx.geom.Bounds;
import eu.hansolo.toolboxfx.geom.CornerRadii;
import java.awt.image.BufferedImage;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class PixelMatrix
extends Region {
    public static final double DEFAULT_SPACER_SIZE_FACTOR = 0.05;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int ALPHA_MASK = -16777216;
    private static final double ALPHA_FACTOR = 0.00392156862745098;
    private double preferredWidth;
    private double preferredHeight;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private int pixelOnColor;
    private int pixelOffColor;
    private PixelShape pixelShape;
    private int cols;
    private int rows;
    private int[][] matrix;
    private double pixelSize;
    private double pixelWidth;
    private double pixelHeight;
    private double spacer;
    private boolean useSpacer;
    private boolean squarePixels;
    private double spacerSizeFactor;
    private double pixelSizeMinusDoubleSpacer;
    private double pixelWidthMinusDoubleSpacer;
    private double pixelHeightMinusDoubleSpacer;
    private InvalidationListener sizeListener;
    private EventHandler<MouseEvent> clickHandler;
    private CopyOnWriteArrayList<PixelMatrixEventListener> listeners;

    public PixelMatrix() {
        this(250.0, 250.0, 32, 32, Color.BLUE, Color.TRANSPARENT, PixelShape.SQUARE);
    }

    public PixelMatrix(int COLS, int ROWS) {
        this(250.0, 250.0, COLS, ROWS, Color.BLUE, Color.TRANSPARENT, PixelShape.SQUARE);
    }

    public PixelMatrix(int COLS, int ROWS, Color DOT_ON_COLOR) {
        this(250.0, 250.0, COLS, ROWS, DOT_ON_COLOR, Color.TRANSPARENT, PixelShape.SQUARE);
    }

    public PixelMatrix(double PREFERRED_WIDTH, double PREFERRED_HEIGHT, int COLS, int ROWS, Color DOT_ON_COLOR, Color DOT_OFF_COLOR, PixelShape DOT_SHAPE) {
        this.preferredWidth = PREFERRED_WIDTH;
        this.preferredHeight = PREFERRED_HEIGHT;
        this.pixelOnColor = PixelMatrix.convertToInt(DOT_ON_COLOR);
        this.pixelOffColor = PixelMatrix.convertToInt(DOT_OFF_COLOR);
        this.pixelShape = DOT_SHAPE;
        this.cols = COLS;
        this.rows = ROWS;
        this.matrix = new int[this.cols][this.rows];
        this.useSpacer = true;
        this.squarePixels = true;
        this.spacerSizeFactor = 0.05;
        this.sizeListener = o -> this.resize();
        this.clickHandler = e -> this.checkForClick((MouseEvent)e);
        this.listeners = new CopyOnWriteArrayList();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                this.matrix[x][y] = this.pixelOffColor;
            }
        }
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(this.preferredWidth, this.preferredHeight);
            }
        }
        this.canvas = new Canvas(this.preferredWidth, this.preferredHeight);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.sizeListener);
        this.heightProperty().addListener(this.sizeListener);
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void setColsAndRows(int[] COLS_AND_ROWS) {
        this.setColsAndRows(COLS_AND_ROWS[0], COLS_AND_ROWS[1]);
    }

    public void setColsAndRows(int COLS, int ROWS) {
        this.cols = COLS;
        this.rows = ROWS;
        this.matrix = new int[this.cols][this.rows];
        this.initGraphics();
        this.resize();
    }

    public Color getPixelOnColor() {
        return PixelMatrix.convertToColor(this.pixelOnColor);
    }

    public void setPixelOnColor(Color COLOR) {
        this.pixelOnColor = PixelMatrix.convertToInt(COLOR);
        this.drawMatrix();
    }

    public Color getPixelOffColor() {
        return PixelMatrix.convertToColor(this.pixelOffColor);
    }

    public void setPixelOffColor(Color COLOR) {
        this.pixelOffColor = PixelMatrix.convertToInt(COLOR);
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                this.matrix[x][y] = this.pixelOffColor;
            }
        }
        this.drawMatrix();
    }

    public PixelShape getPixelShape() {
        return this.pixelShape;
    }

    public void setPixelShape(PixelShape SHAPE) {
        this.pixelShape = SHAPE;
        this.drawMatrix();
    }

    public boolean isUsingSpacer() {
        return this.useSpacer;
    }

    public void setUseSpacer(boolean USE) {
        this.useSpacer = USE;
        this.resize();
    }

    public boolean isSquarePixels() {
        return this.squarePixels;
    }

    public void setSquarePixels(boolean SQUARE) {
        this.squarePixels = SQUARE;
        this.resize();
    }

    public double getSpacerSizeFactor() {
        return this.spacerSizeFactor;
    }

    public void setSpacerSizeFactor(double FACTOR) {
        this.spacerSizeFactor = Helper.clamp(0.0, 0.2, FACTOR);
        this.spacer = this.useSpacer ? this.pixelSize * this.spacerSizeFactor : 0.0;
        this.pixelSizeMinusDoubleSpacer = this.pixelSize - this.spacer * 2.0;
        this.drawMatrix();
    }

    public void setPixel(int X, int Y, boolean VALUE) {
        this.setPixel(X, Y, VALUE ? this.pixelOnColor : this.pixelOffColor);
    }

    public void setPixel(int X, int Y, Color COLOR) {
        this.setPixel(X, Y, PixelMatrix.convertToInt(COLOR));
    }

    public void setPixel(int X, int Y, int COLOR_VALUE) {
        if (X >= this.cols || X < 0) {
            return;
        }
        if (Y >= this.rows || Y < 0) {
            return;
        }
        this.matrix[X][Y] = COLOR_VALUE;
    }

    public void setPixelWithRedraw(int X, int Y, boolean ON) {
        this.setPixel(X, Y, ON ? this.pixelOnColor : this.pixelOffColor);
        this.drawMatrix();
    }

    public void setPixelWithRedraw(int X, int Y, int COLOR_VALUE) {
        this.setPixel(X, Y, COLOR_VALUE);
        this.drawMatrix();
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public double getPixelWidth() {
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        return this.pixelHeight;
    }

    public double getMatrixWidth() {
        return this.canvas.getWidth();
    }

    public double getMatrixHeight() {
        return this.canvas.getHeight();
    }

    public javafx.geometry.Bounds getMatrixLayoutBounds() {
        return this.canvas.getLayoutBounds();
    }

    public javafx.geometry.Bounds getMatrixBoundsInParent() {
        return this.canvas.getBoundsInParent();
    }

    public javafx.geometry.Bounds getMatrixBoundsInLocal() {
        return this.canvas.getBoundsInLocal();
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public static Color convertToColor(int COLOR_VALUE) {
        return Color.rgb((int)((COLOR_VALUE & 0xFF0000) >> 16), (int)((COLOR_VALUE & 0xFF00) >> 8), (int)(COLOR_VALUE & 0xFF), (double)(0.00392156862745098 * (double)((COLOR_VALUE & 0xFF000000) >>> 24)));
    }

    public static int convertToInt(Color COLOR) {
        return PixelMatrix.convertToInt((float)COLOR.getRed(), (float)COLOR.getGreen(), (float)COLOR.getBlue(), (float)COLOR.getOpacity());
    }

    public static int convertToInt(float RED, float GREEN, float BLUE, float ALPHA) {
        int red = Math.round(255.0f * RED);
        int green = Math.round(255.0f * GREEN);
        int blue = Math.round(255.0f * BLUE);
        int alpha = Math.round(255.0f * ALPHA);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getBitAt(int X, int Y, int[] BYTE_ARRAY) {
        return BYTE_ARRAY[Y] >> X & 1;
    }

    public static boolean getBitAtBoolean(int X, int Y, int[] BYTE_ARRAY) {
        return (BYTE_ARRAY[Y] >> X & 1) == 1;
    }

    public int getColorValueAt(int X, int Y) {
        return this.matrix[X][Y];
    }

    public Color getColorAt(int X, int Y) {
        return PixelMatrix.convertToColor(this.matrix[X][Y]);
    }

    public void shiftLeft() {
        int y;
        int[] firstColumn = new int[this.rows];
        for (y = 0; y < this.rows; ++y) {
            firstColumn[y] = this.matrix[0][y];
        }
        for (y = 0; y < this.rows; ++y) {
            for (int x = 1; x < this.cols; ++x) {
                this.matrix[x - 1][y] = this.matrix[x][y];
            }
        }
        for (y = 0; y < this.rows; ++y) {
            this.matrix[this.cols - 1][y] = firstColumn[y];
        }
        this.drawMatrix();
    }

    public void shiftRight() {
        int y;
        int[] lastColumn = new int[this.rows];
        for (y = 0; y < this.rows; ++y) {
            lastColumn[y] = this.matrix[this.cols - 1][y];
        }
        for (y = 0; y < this.rows; ++y) {
            for (int x = this.cols - 2; x >= 0; --x) {
                this.matrix[x + 1][y] = this.matrix[x][y];
            }
        }
        for (y = 0; y < this.rows; ++y) {
            this.matrix[0][y] = lastColumn[y];
        }
        this.drawMatrix();
    }

    public void shiftUp() {
        int x;
        int[] firstRow = new int[this.cols];
        for (x = 0; x < this.cols; ++x) {
            firstRow[x] = this.matrix[x][0];
        }
        for (int y = 1; y < this.rows; ++y) {
            for (int x2 = 0; x2 < this.cols; ++x2) {
                this.matrix[x2][y - 1] = this.matrix[x2][y];
            }
        }
        for (x = 0; x < this.cols; ++x) {
            this.matrix[x][this.rows - 1] = firstRow[x];
        }
        this.drawMatrix();
    }

    public void shiftDown() {
        int x;
        int[] lastRow = new int[this.cols];
        for (x = 0; x < this.cols; ++x) {
            lastRow[x] = this.matrix[x][this.rows - 1];
        }
        for (int y = this.rows - 2; y >= 0; --y) {
            for (int x2 = 0; x2 < this.cols; ++x2) {
                this.matrix[x2][y + 1] = this.matrix[x2][y];
            }
        }
        for (x = 0; x < this.cols; ++x) {
            this.matrix[x][0] = lastRow[x];
        }
        this.drawMatrix();
    }

    public void setAllPixelsOn() {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                this.setPixel(x, y, true);
            }
        }
        this.drawMatrix();
    }

    public void setAllPixelsOff() {
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                this.setPixel(x, y, false);
            }
        }
        this.drawMatrix();
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    public void drawMatrix() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        switch (this.pixelShape.ordinal()) {
            case 1: {
                Bounds bounds = new Bounds(this.pixelWidthMinusDoubleSpacer, this.pixelHeightMinusDoubleSpacer);
                CornerRadii cornerRadii = new CornerRadii(this.pixelSize * 0.125);
                for (int y = 0; y < this.rows; ++y) {
                    for (int x = 0; x < this.cols; ++x) {
                        this.ctx.setFill((Paint)PixelMatrix.convertToColor(this.matrix[x][y]));
                        bounds.setX((double)x * this.pixelWidth + this.spacer);
                        bounds.setY((double)y * this.pixelHeight + this.spacer);
                        Helper.drawRoundedRect(this.ctx, bounds, cornerRadii);
                        this.ctx.fill();
                    }
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.rows; ++y) {
                    for (int x = 0; x < this.cols; ++x) {
                        this.ctx.setFill((Paint)PixelMatrix.convertToColor(this.matrix[x][y]));
                        this.ctx.fillOval((double)x * this.pixelWidth + this.spacer, (double)y * this.pixelHeight + this.spacer, this.pixelWidthMinusDoubleSpacer, this.pixelHeightMinusDoubleSpacer);
                    }
                }
                break;
            }
            default: {
                for (int y = 0; y < this.rows; ++y) {
                    for (int x = 0; x < this.cols; ++x) {
                        this.ctx.setFill((Paint)PixelMatrix.convertToColor(this.matrix[x][y]));
                        this.ctx.fillRect((double)x * this.pixelWidth + this.spacer, (double)y * this.pixelHeight + this.spacer, this.pixelWidthMinusDoubleSpacer, this.pixelHeightMinusDoubleSpacer);
                    }
                }
            }
        }
    }

    public void setOnPixelMatrixEvent(PixelMatrixEventListener LISTENER) {
        this.addPixelMatrixEventListener(LISTENER);
    }

    public void addPixelMatrixEventListener(PixelMatrixEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removePixelMatrixEventListener(PixelMatrixEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllPixelMatrixEventListeners() {
        this.listeners.clear();
    }

    public void firePixelMatrixEvent(PixelMatrixEvt EVENT) {
        for (PixelMatrixEventListener listener : this.listeners) {
            listener.onPixelMatrixEvent(EVENT);
        }
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    public void dispose() {
        this.listeners.clear();
        this.widthProperty().removeListener(this.sizeListener);
        this.heightProperty().removeListener(this.sizeListener);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
    }

    private long getRed(long COLOR_VALUE) {
        return (COLOR_VALUE & 0xFF0000L) >> 16;
    }

    private long getGreen(long COLOR_VALUE) {
        return (COLOR_VALUE & 0xFF00L) >> 8;
    }

    private long getBlue(long COLOR_VALUE) {
        return COLOR_VALUE & 0xFFL;
    }

    private long getAlpha(long COLOR_VALUE) {
        return (COLOR_VALUE & 0xFFFFFFFFFF000000L) >>> 24;
    }

    public void checkForClick(MouseEvent EVT) {
        double spacerPlusPixelWidthMinusDoubleSpacer = this.spacer + this.pixelWidthMinusDoubleSpacer;
        double spacerPlusPixelHeightMinusDoubleSpacer = this.spacer + this.pixelHeightMinusDoubleSpacer;
        block0: for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.cols; ++x) {
                if (!Helper.isInRectangle(EVT.getX(), EVT.getY(), (double)x * this.pixelWidth + this.spacer, (double)y * this.pixelHeight + this.spacer, (double)x * this.pixelWidth + spacerPlusPixelWidthMinusDoubleSpacer, (double)y * this.pixelHeight + spacerPlusPixelHeightMinusDoubleSpacer)) continue;
                this.firePixelMatrixEvent(new PixelMatrixEvt(x, y, EVT.getScreenX(), EVT.getScreenY()));
                continue block0;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.pixelSize = this.width / (double)this.cols < this.height / (double)this.rows ? this.width / (double)this.cols : this.height / (double)this.rows;
        this.pixelWidth = this.width / (double)this.cols;
        this.pixelHeight = this.height / (double)this.rows;
        this.spacer = this.useSpacer ? this.pixelSize * this.getSpacerSizeFactor() : 0.0;
        this.pixelSizeMinusDoubleSpacer = this.pixelSize - this.spacer * 2.0;
        this.pixelWidthMinusDoubleSpacer = this.pixelWidth - this.spacer * 2.0;
        this.pixelHeightMinusDoubleSpacer = this.pixelHeight - this.spacer * 2.0;
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.squarePixels) {
                this.pixelWidth = this.pixelSize;
                this.pixelHeight = this.pixelSize;
                this.pixelWidthMinusDoubleSpacer = this.pixelSizeMinusDoubleSpacer;
                this.pixelHeightMinusDoubleSpacer = this.pixelSizeMinusDoubleSpacer;
            }
            this.canvas.setWidth((double)this.cols * this.pixelWidth);
            this.canvas.setHeight((double)this.rows * this.pixelHeight);
            this.canvas.relocate((this.getWidth() - (double)this.cols * this.pixelWidth) * 0.5, (this.getHeight() - (double)this.rows * this.pixelHeight) * 0.5);
            this.drawMatrix();
        }
    }

    public static enum PixelShape {
        SQUARE,
        ROUNDED_RECT,
        ROUND;

    }
}

