/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.XYPaneOverlay;
import eu.hansolo.fx.charts.data.TYChartItem;
import eu.hansolo.fx.charts.series.XYSeries;
import eu.hansolo.fx.charts.tools.Constants;
import eu.hansolo.toolboxfx.geom.Point;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;

public class Prediction<T extends TYChartItem>
implements XYPaneOverlay {
    private LocalDateTime start;
    private ChronoUnit timeStep;
    private XYSeries<T> predictionSeries;
    private XYSeries<T> quantile50Series;
    private XYSeries<T> quantile90Series;

    public Prediction(LocalDateTime start, ChronoUnit timeStep, XYSeries<T> predictionSeries, XYSeries<T> quantile50Series, XYSeries<T> quantile90Series) {
        this.start = start;
        this.timeStep = timeStep;
        this.predictionSeries = predictionSeries;
        this.quantile50Series = quantile50Series;
        this.quantile90Series = quantile90Series;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public ChronoUnit getTimeStep() {
        return this.timeStep;
    }

    public XYSeries<T> getPredictionSeries() {
        return this.predictionSeries;
    }

    public XYSeries<T> getQuantile50Series() {
        return this.quantile50Series;
    }

    public XYSeries<T> getQuantile90Series() {
        return this.quantile90Series;
    }

    public List<Point> getQuantile50Points() {
        Point p;
        double dY;
        TYChartItem item;
        TYChartItem pItem;
        int i;
        LinkedList<Point> quantile50Points = new LinkedList<Point>();
        for (i = 0; i < this.predictionSeries.getItems().size(); ++i) {
            pItem = (TYChartItem)this.predictionSeries.getItems().get(i);
            item = (TYChartItem)this.quantile50Series.getItems().get(i);
            dY = Math.abs(pItem.getY() - item.getY());
            p = new Point(item.getX(), pItem.getY() - dY);
            quantile50Points.add(p);
        }
        for (i = this.predictionSeries.getItems().size() - 1; i >= 0; --i) {
            pItem = (TYChartItem)this.predictionSeries.getItems().get(i);
            item = (TYChartItem)this.quantile50Series.getItems().get(i);
            dY = Math.abs(pItem.getY() - item.getY());
            p = new Point(item.getX(), pItem.getY() + dY);
            quantile50Points.add(p);
        }
        return quantile50Points;
    }

    public List<Point> getQuantile90Points() {
        Point p;
        double dY;
        TYChartItem item;
        TYChartItem pItem;
        int i;
        LinkedList<Point> quantile90Points = new LinkedList<Point>();
        for (i = 0; i < this.predictionSeries.getItems().size(); ++i) {
            pItem = (TYChartItem)this.predictionSeries.getItems().get(i);
            item = (TYChartItem)this.quantile90Series.getItems().get(i);
            dY = Math.abs(pItem.getY() - item.getY());
            p = new Point(item.getX(), pItem.getY() - dY);
            quantile90Points.add(p);
        }
        for (i = this.predictionSeries.getItems().size() - 1; i >= 0; --i) {
            pItem = (TYChartItem)this.predictionSeries.getItems().get(i);
            item = (TYChartItem)this.quantile90Series.getItems().get(i);
            dY = Math.abs(pItem.getY() - item.getY());
            p = new Point(item.getX(), pItem.getY() + dY);
            quantile90Points.add(p);
        }
        return quantile90Points;
    }

    @Override
    public Constants.OverlayType getType() {
        return Constants.OverlayType.PREDICTION;
    }
}

