/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.WaffleChart;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Paint;

public class WaffleChartBuilder<B extends WaffleChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected WaffleChartBuilder() {
    }

    public static final WaffleChartBuilder create() {
        return new WaffleChartBuilder();
    }

    public final B value(double value) {
        this.properties.put("value", (Property)new SimpleDoubleProperty(value));
        return (B)this;
    }

    public final B backgroundFill(Paint backgroundFill) {
        this.properties.put("backgroundFill", (Property)new SimpleObjectProperty((Object)backgroundFill));
        return (B)this;
    }

    public final B cellFill(Paint cellFill) {
        this.properties.put("cellFill", (Property)new SimpleObjectProperty((Object)cellFill));
        return (B)this;
    }

    public final B emptyCellFill(Paint emptyCellFill) {
        this.properties.put("emptyCellFill", (Property)new SimpleObjectProperty((Object)emptyCellFill));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxHeight) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(maxHeight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)insets));
        return (B)this;
    }

    public final WaffleChart build() {
        WaffleChart control = new WaffleChart();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "backgroundFill": {
                    control.setBackgroundFill((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "cellFill": {
                    control.setCellFill((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "emptyCellFill": {
                    control.setEmptyCellFill((Paint)((ObjectProperty)property).get());
                }
            }
        });
        return control;
    }
}

