/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.forcedirectedgraph.GraphNode;
import eu.hansolo.fx.charts.forcedirectedgraph.NodeEdgeModel;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class GraphCalculator {
    private static final String DEGREE_KEY = "DegreeCentrality";
    private static final String CLOSENESS_KEY = "ClosenessCentrality";
    private static final String BETWEENNESS_KEY = "BetweennessCentrality";
    private static final String DEGREE_NORMALIZED_KEY = "DegreeCentralityNormalized";
    private static final String CLOSENESS_NORMALIZED_KEY = "ClosenessCentrualityNormalized";
    double[] betweennessResults;

    private void recursiveBetweennesCalculatioin(ArrayList<GraphNode>[][] paths, ArrayList<GraphNode> graphNodes, double split, GraphNode from, GraphNode to) {
        double nextSplit = split / (double)paths[graphNodes.indexOf(from)][graphNodes.indexOf(to)].size();
        for (GraphNode node : paths[graphNodes.indexOf(from)][graphNodes.indexOf(to)]) {
            if (node.equals(from)) continue;
            int n = graphNodes.indexOf(node);
            this.betweennessResults[n] = this.betweennessResults[n] + split;
            this.recursiveBetweennesCalculatioin(paths, graphNodes, nextSplit, from, node);
        }
    }

    private ArrayList<ArrayList<GraphNode>> createRealPathsRecursive(ArrayList<GraphNode>[][] paths, ArrayList<GraphNode> graphNodes, GraphNode from, GraphNode to) {
        if (paths[graphNodes.indexOf(from)][graphNodes.indexOf(to)].size() == 1 && paths[graphNodes.indexOf(from)][graphNodes.indexOf(to)].get(0).equals(from)) {
            return new ArrayList<ArrayList<GraphNode>>();
        }
        ArrayList<ArrayList<GraphNode>> ListOfLists = new ArrayList<ArrayList<GraphNode>>();
        for (GraphNode node : paths[graphNodes.indexOf(from)][graphNodes.indexOf(to)]) {
            ArrayList<ArrayList<GraphNode>> subpaths = this.createRealPathsRecursive(paths, graphNodes, node, from);
            if (subpaths.isEmpty()) {
                ArrayList<GraphNode> temp = new ArrayList<GraphNode>();
                temp.add(node);
                ListOfLists.add(temp);
                continue;
            }
            for (ArrayList<GraphNode> ap : subpaths) {
                ap.add(node);
                ListOfLists.add(ap);
            }
        }
        return ListOfLists;
    }

    public NodeEdgeModel calculateDegreeCentrality(NodeEdgeModel nodeEdgeModel) {
        for (GraphNode node : nodeEdgeModel.getNodes()) {
            node.setNumericAttribute(DEGREE_KEY, node.getConnectedNodes().size());
        }
        return nodeEdgeModel;
    }

    public NodeEdgeModel calculateDegreeCentralityNormalized(NodeEdgeModel nodeEdgeModel) {
        if (!nodeEdgeModel.getNodes().get(0).containsNumericAttribute(DEGREE_KEY)) {
            this.calculateDegreeCentrality(nodeEdgeModel);
        }
        for (GraphNode node : nodeEdgeModel.getNodes()) {
            node.setNumericAttribute(DEGREE_NORMALIZED_KEY, node.getNumericAttribute(DEGREE_KEY) / (double)(nodeEdgeModel.getNodes().size() - 1));
        }
        return nodeEdgeModel;
    }

    public NodeEdgeModel calculateClosenessCentrality(NodeEdgeModel nodeEdgeModel) {
        PriorityQueue<GraphNode> queue = new PriorityQueue<GraphNode>();
        ArrayList<GraphNode> visited = new ArrayList<GraphNode>();
        ArrayList<GraphNode> GraphNodes = nodeEdgeModel.getNodes();
        for (GraphNode node : GraphNodes) {
            visited.clear();
            queue.clear();
            queue.add(node);
            double result = 0.0;
            int level = 0;
            int counterUntilNextLevel = 1;
            int counterOfNextLevel = 0;
            while (!queue.isEmpty()) {
                GraphNode currentNode = (GraphNode)queue.poll();
                counterOfNextLevel += currentNode.getConnectedNodes().size();
                visited.add(currentNode);
                ArrayList<GraphNode> currentNodeList = new ArrayList<GraphNode>(currentNode.getConnectedNodes());
                for (GraphNode gNode : currentNodeList) {
                    if (visited.contains(gNode) || queue.contains(gNode)) continue;
                    queue.add(gNode);
                }
                if (level > 0) {
                    result += 1.0 / (double)level;
                }
                if (--counterUntilNextLevel != 0) continue;
                ++level;
                counterUntilNextLevel = counterOfNextLevel;
                counterOfNextLevel = 0;
            }
            node.setNumericAttribute(CLOSENESS_KEY, result);
        }
        return nodeEdgeModel;
    }

    public NodeEdgeModel calculateClosenessCentralityNormalized(NodeEdgeModel nodeEdgeModel) {
        if (!nodeEdgeModel.getNodes().get(0).containsNumericAttribute(CLOSENESS_KEY)) {
            this.calculateClosenessCentrality(nodeEdgeModel);
        }
        for (GraphNode node : nodeEdgeModel.getNodes()) {
            node.setNumericAttribute(CLOSENESS_NORMALIZED_KEY, node.getNumericAttribute(CLOSENESS_KEY) / (double)(nodeEdgeModel.getNodes().size() - 1));
        }
        return nodeEdgeModel;
    }

    public void calculateBetweennessCentrality(NodeEdgeModel nodeEdgeModel) {
        int i;
        PriorityQueue<GraphNode> currentLevelQueue = new PriorityQueue<GraphNode>();
        PriorityQueue<GraphNode> nextLevelQueue = new PriorityQueue<GraphNode>();
        ArrayList<GraphNode> visited = new ArrayList<GraphNode>();
        ArrayList<GraphNode> graphNodes = nodeEdgeModel.getNodes();
        this.betweennessResults = new double[graphNodes.size()];
        ArrayList[][] paths = new ArrayList[graphNodes.size()][graphNodes.size()];
        ArrayList[][] realPaths = new ArrayList[graphNodes.size()][graphNodes.size()];
        for (int i2 = 0; i2 < graphNodes.size(); ++i2) {
            for (int j = 0; j < graphNodes.size(); ++j) {
                paths[i2][j] = new ArrayList();
            }
        }
        for (GraphNode node : graphNodes) {
            visited.clear();
            currentLevelQueue.clear();
            currentLevelQueue.add(node);
            while (!currentLevelQueue.isEmpty()) {
                GraphNode currentNode = (GraphNode)currentLevelQueue.poll();
                visited.add(currentNode);
                for (GraphNode gNode : currentNode.getConnectedNodes()) {
                    if (visited.contains(gNode) || currentLevelQueue.contains(gNode)) continue;
                    paths[graphNodes.indexOf(node)][graphNodes.indexOf(gNode)].add(currentNode);
                    if (nextLevelQueue.contains(gNode)) continue;
                    nextLevelQueue.add(gNode);
                }
                if (!currentLevelQueue.isEmpty()) continue;
                while (!nextLevelQueue.isEmpty()) {
                    currentLevelQueue.add((GraphNode)nextLevelQueue.poll());
                }
            }
        }
        for (i = 0; i < this.betweennessResults.length; ++i) {
            this.betweennessResults[i] = 0.0;
        }
        for (i = 0; i < paths.length; ++i) {
            for (int j = 0; j < paths[i].length; ++j) {
                if (i == j) continue;
                realPaths[i][j] = this.createRealPathsRecursive(paths, graphNodes, graphNodes.get(i), graphNodes.get(j));
            }
        }
        for (i = 0; i < paths.length; ++i) {
            for (int j = 0; j < paths[i].length; ++j) {
                if (i == j) continue;
                for (ArrayList al : realPaths[i][j]) {
                    if (al.isEmpty()) continue;
                    for (GraphNode graphNode : al) {
                        int n = graphNodes.indexOf(graphNode);
                        this.betweennessResults[n] = this.betweennessResults[n] + 0.5 / (double)realPaths[i][j].size();
                    }
                }
            }
        }
        for (GraphNode node : graphNodes) {
            node.setNumericAttribute(BETWEENNESS_KEY, this.betweennessResults[graphNodes.indexOf(node)]);
        }
    }
}

