/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.world;

import eu.hansolo.fx.charts.data.MapConnection;
import eu.hansolo.fx.charts.data.WeightedMapPoints;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.MapPoint;
import eu.hansolo.fx.charts.tools.MapPointSize;
import eu.hansolo.fx.charts.world.CountryPath;
import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.tools.CRegion;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.HeatMap;
import eu.hansolo.fx.heatmap.HeatMapBuilder;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Location;
import eu.hansolo.toolboxfx.geom.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="children")
public class World
extends Region {
    private static final StyleablePropertyFactory<World> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
    private static final String HIRES_PROPERTIES = "eu/hansolo/fx/charts/world/hires.properties";
    private static final String LORES_PROPERTIES = "eu/hansolo/fx/charts/world/lores.properties";
    private static final double PREFERRED_WIDTH = 1009.0;
    private static final double PREFERRED_HEIGHT = 665.0;
    private static final double MINIMUM_WIDTH = 100.0;
    private static final double MINIMUM_HEIGHT = 66.0;
    private static final double MAXIMUM_WIDTH = 2018.0;
    private static final double MAXIMUM_HEIGHT = 1330.0;
    private static Logger logger = LoggerFactory.getLogger(World.class);
    private static double MAP_OFFSET_X = -28.756500000000003;
    private static double MAP_OFFSET_Y = 129.675;
    private static final double ASPECT_RATIO = 0.6590683845391476;
    private static final double MAX_DIAM = 50.0;
    private static final CssMetaData<World, Color> BACKGROUND_COLOR = FACTORY.createColorCssMetaData("-background-color", s -> s.backgroundColor, Color.web((String)"#3f3f4f"), false);
    private final StyleableProperty<Color> backgroundColor;
    private static final CssMetaData<World, Color> FILL_COLOR = FACTORY.createColorCssMetaData("-fill-color", s -> s.fillColor, Color.web((String)"#d9d9dc"), false);
    private final StyleableProperty<Color> fillColor;
    private static final CssMetaData<World, Color> STROKE_COLOR = FACTORY.createColorCssMetaData("-stroke-color", s -> s.strokeColor, Color.BLACK, false);
    private final StyleableProperty<Color> strokeColor;
    private static final CssMetaData<World, Color> HOVER_COLOR = FACTORY.createColorCssMetaData("-hover-color", s -> s.hoverColor, Color.web((String)"#456acf"), false);
    private final StyleableProperty<Color> hoverColor;
    private static final CssMetaData<World, Color> PRESSED_COLOR = FACTORY.createColorCssMetaData("-pressed-color", s -> s.pressedColor, Color.web((String)"#789dff"), false);
    private final StyleableProperty<Color> pressedColor;
    private static final CssMetaData<World, Color> SELECTED_COLOR = FACTORY.createColorCssMetaData("-selected-color", s -> s.selectedColor, Color.web((String)"#9dff78"), false);
    private final StyleableProperty<Color> selectedColor;
    private static final CssMetaData<World, Color> LOCATION_COLOR = FACTORY.createColorCssMetaData("-location-color", s -> s.locationColor, Color.web((String)"#ff0000"), false);
    private final StyleableProperty<Color> locationColor;
    private BooleanProperty hoverEnabled;
    private BooleanProperty selectionEnabled;
    private ObjectProperty<Country> selectedCountry;
    private BooleanProperty zoomEnabled;
    private DoubleProperty scaleFactor;
    private Properties resolutionProperties;
    private Country formerSelectedCountry;
    private double zoomSceneX;
    private double zoomSceneY;
    private double width;
    private double height;
    private double size;
    private Pane pane;
    private Group group;
    private HeatMap heatMap;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Canvas overlayCanvas;
    private GraphicsContext overlayCtx;
    private Map<String, List<CountryPath>> countryPaths;
    private ObservableMap<Location, Shape> locations;
    private Mapping colorMapping;
    private double spotRadius;
    private boolean fadeColors;
    private OpacityDistribution opacityDistribution;
    private double heatMapOpacity;
    private BooleanProperty heatMapVisible;
    private ObservableList<MapPoint> mapPoints;
    private ObservableList<MapConnection> mapConnections;
    private List<MapPoint> incomingItems;
    private List<MapPoint> outgoingItems;
    private List<MapPoint> allItems;
    private double connectionWidth;
    private WeightedMapPoints weightedMapPoints;
    private boolean weightedMapConnections;
    private boolean arrowsVisible;
    private Optional<MapConnection> connectionWithMaxValue;
    private MapPointSize mapPointSize;
    private boolean mapPointsVisible;
    private boolean mapPointTextVisible;
    private Color textColor;
    private Image image;
    private double[] imagePos;
    private double[] oldImagePos;
    private DoubleProperty imageAlpha;
    private List<Point> imagePathPoints;
    private boolean drawImagePath;
    private Timeline timeline;
    protected EventHandler<MouseEvent> _mouseEnterHandler;
    protected EventHandler<MouseEvent> _mousePressHandler;
    protected EventHandler<MouseEvent> _mouseReleaseHandler;
    protected EventHandler<MouseEvent> _mouseExitHandler;
    private EventHandler<ScrollEvent> _scrollEventHandler;
    private EventHandler<MouseEvent> mouseEnterHandler;
    private EventHandler<MouseEvent> mousePressHandler;
    private EventHandler<MouseEvent> mouseReleaseHandler;
    private EventHandler<MouseEvent> mouseExitHandler;

    public World() {
        this(Resolution.HI_RES, (Mapping)ColorMapping.INFRARED_3, 5.0, false, OpacityDistribution.EXPONENTIAL, 0.75);
    }

    public World(Resolution RESOLUTION) {
        this(RESOLUTION, (Mapping)ColorMapping.INFRARED_3, 5.0, false, OpacityDistribution.EXPONENTIAL, 0.75);
    }

    public World(Resolution RESOLUTION, Mapping COLOR_MAPPING, double EVENT_RADIUS, boolean FADE_COLORS, OpacityDistribution OPACITY_DISTRIBUTION, double HEAT_MAP_OPACITY) {
        this.resolutionProperties = this.readProperties(Resolution.HI_RES == RESOLUTION ? HIRES_PROPERTIES : LORES_PROPERTIES);
        this.backgroundColor = new StyleableObjectProperty<Color>((Color)BACKGROUND_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.get(), CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "backgroundColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return BACKGROUND_COLOR;
            }
        };
        this.fillColor = new StyleableObjectProperty<Color>((Color)FILL_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setFillAndStroke();
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "fillColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return FILL_COLOR;
            }
        };
        this.strokeColor = new StyleableObjectProperty<Color>((Color)STROKE_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.setFillAndStroke();
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "strokeColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return STROKE_COLOR;
            }
        };
        this.hoverColor = new StyleableObjectProperty<Color>((Color)HOVER_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "hoverColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return HOVER_COLOR;
            }
        };
        this.pressedColor = new StyleableObjectProperty<Color>((Color)PRESSED_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "pressedColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return PRESSED_COLOR;
            }
        };
        this.selectedColor = new StyleableObjectProperty<Color>((Color)SELECTED_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectedColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return SELECTED_COLOR;
            }
        };
        this.locationColor = new StyleableObjectProperty<Color>((Color)LOCATION_COLOR.getInitialValue((Styleable)this)){

            protected void invalidated() {
                World.this.locations.forEach((location, shape) -> shape.setFill((Paint)(null == location.getFill() ? (Paint)this.get() : location.getFill())));
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "locationColor";
            }

            public CssMetaData<? extends Styleable, Color> getCssMetaData() {
                return LOCATION_COLOR;
            }
        };
        this.hoverEnabled = new BooleanPropertyBase(true){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "hoverEnabled";
            }
        };
        this.selectionEnabled = new BooleanPropertyBase(false){

            protected void invalidated() {
                World.this.enableMouseInteraction(this.get());
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectionEnabled";
            }
        };
        this.selectedCountry = new ObjectPropertyBase<Country>(){

            protected void invalidated() {
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "selectedCountry";
            }
        };
        this.zoomEnabled = new BooleanPropertyBase(false){

            protected void invalidated() {
                if (null == World.this.getScene()) {
                    return;
                }
                if (this.get()) {
                    World.this.getScene().addEventFilter(ScrollEvent.ANY, World.this._scrollEventHandler);
                } else {
                    World.this.getScene().removeEventFilter(ScrollEvent.ANY, World.this._scrollEventHandler);
                }
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "zoomEnabled";
            }
        };
        this.scaleFactor = new DoublePropertyBase(1.0){

            protected void invalidated() {
                if (World.this.isZoomEnabled()) {
                    World.this.setScaleX(this.get());
                    World.this.setScaleY(this.get());
                }
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "scaleFactor";
            }
        };
        this.countryPaths = this.createCountryPaths();
        this.locations = FXCollections.observableHashMap();
        this.colorMapping = COLOR_MAPPING;
        this.spotRadius = EVENT_RADIUS;
        this.fadeColors = FADE_COLORS;
        this.opacityDistribution = OPACITY_DISTRIBUTION;
        this.heatMapOpacity = HEAT_MAP_OPACITY;
        this.heatMapVisible = new BooleanPropertyBase(true){

            protected void invalidated() {
                World.this.heatMap.setVisible(this.get());
                World.this.heatMap.setManaged(this.get());
            }

            public Object getBean() {
                return World.this;
            }

            public String getName() {
                return "heatMapVisible";
            }
        };
        this.mapPoints = FXCollections.observableArrayList();
        this.mapConnections = FXCollections.observableArrayList();
        this.connectionWidth = 1.0;
        this.weightedMapPoints = WeightedMapPoints.NONE;
        this.weightedMapConnections = false;
        this.arrowsVisible = false;
        this.connectionWithMaxValue = Optional.empty();
        this.mapPointSize = MapPointSize.NORMAL;
        this.mapPointsVisible = true;
        this.mapPointTextVisible = false;
        this.textColor = Color.BLACK;
        this.image = null;
        this.imagePos = new double[0];
        this.oldImagePos = new double[0];
        this.imageAlpha = new SimpleDoubleProperty(0.0);
        this.imagePathPoints = new LinkedList<Point>();
        this.drawImagePath = false;
        this.timeline = new Timeline();
        this.pane = new Pane();
        this.group = new Group();
        this._mouseEnterHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseEnterHandler);
        this._mousePressHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mousePressHandler);
        this._mouseReleaseHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseReleaseHandler);
        this._mouseExitHandler = evt -> this.handleMouseEvent((MouseEvent)evt, this.mouseExitHandler);
        this._scrollEventHandler = evt -> {
            double scale;
            if (this.group.getTranslateX() != 0.0 || this.group.getTranslateY() != 0.0) {
                this.resetZoom();
            }
            double delta = 1.2;
            double oldScale = scale = this.getScaleFactor();
            scale = evt.getDeltaY() < 0.0 ? scale / delta : scale * delta;
            scale = this.clamp(1.0, 10.0, scale);
            double factor = scale / oldScale - 1.0;
            if (Double.compare(1.0, this.getScaleFactor()) == 0) {
                this.zoomSceneX = evt.getSceneX();
                this.zoomSceneY = evt.getSceneY();
                this.resetZoom();
            }
            double deltaX = this.zoomSceneX - (this.getBoundsInParent().getWidth() / 2.0 + this.getBoundsInParent().getMinX());
            double deltaY = this.zoomSceneY - (this.getBoundsInParent().getHeight() / 2.0 + this.getBoundsInParent().getMinY());
            this.setScaleFactor(scale);
            this.setPivot(deltaX * factor, deltaY * factor);
            evt.consume();
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(1009.0, 665.0);
            }
        }
        this.getStyleClass().add((Object)"world");
        Color fill = this.getFillColor();
        Color stroke = this.getStrokeColor();
        this.countryPaths.forEach((name, pathList) -> {
            Country country = Country.valueOf((String)name);
            pathList.forEach(path -> {
                path.setFill((Paint)(null == country.getFill() ? fill : country.getFill()));
                path.setStroke((Paint)stroke);
                path.setStrokeWidth(0.2);
                path.setOnMouseEntered((EventHandler)new WeakEventHandler(this._mouseEnterHandler));
                path.setOnMousePressed((EventHandler)new WeakEventHandler(this._mousePressHandler));
                path.setOnMouseReleased((EventHandler)new WeakEventHandler(this._mouseReleaseHandler));
                path.setOnMouseExited((EventHandler)new WeakEventHandler(this._mouseExitHandler));
            });
            this.pane.getChildren().addAll((Collection)pathList);
        });
        this.group.getChildren().add((Object)this.pane);
        this.heatMap = HeatMapBuilder.create().prefSize(1009.0, 665.0).colorMapping(this.colorMapping).spotRadius(this.spotRadius).fadeColors(this.fadeColors).opacityDistribution(this.opacityDistribution).heatMapOpacity(this.heatMapOpacity).build();
        this.canvas = new Canvas(1009.0, 665.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.overlayCanvas = new Canvas(1009.0, 665.0);
        this.overlayCtx = this.overlayCanvas.getGraphicsContext2D();
        if (this.isSelectionEnabled()) {
            this.enableMouseInteraction(true);
        }
        this.getChildren().setAll((Object[])new Node[]{this.group, this.heatMap, this.canvas, this.overlayCanvas});
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.sceneProperty().addListener(o -> {
            if (!this.locations.isEmpty()) {
                this.addShapesToScene(this.locations.values());
            }
            if (this.isZoomEnabled()) {
                this.getScene().addEventFilter(ScrollEvent.ANY, (EventHandler)new WeakEventHandler(this._scrollEventHandler));
            }
            this.locations.addListener(CHANGE -> {
                if (CHANGE.wasAdded()) {
                    this.addShapesToScene((Shape)CHANGE.getValueAdded());
                } else if (CHANGE.wasRemoved()) {
                    Platform.runLater(() -> this.pane.getChildren().remove(CHANGE.getValueRemoved()));
                }
            });
        });
        this.mapPoints.addListener(c -> this.redraw());
        this.mapConnections.addListener(c -> {
            this.incomingItems = this.mapConnections.stream().map(connection -> connection.getIncomingItem()).distinct().collect(Collectors.toList());
            this.outgoingItems = this.mapConnections.stream().map(connection -> connection.getOutgoingItem()).distinct().collect(Collectors.toList());
            this.allItems = Stream.concat(this.incomingItems.stream(), this.outgoingItems.stream()).distinct().collect(Collectors.toList());
            this.connectionWithMaxValue = this.mapConnections.stream().max(Comparator.comparing(MapConnection::getValue));
            this.redraw();
        });
    }

    protected double computeMinWidth(double HEIGHT) {
        return 100.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 66.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2018.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1330.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public Map<String, List<CountryPath>> getCountryPaths() {
        return this.countryPaths;
    }

    public void setMouseEnterHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseEnterHandler = HANDLER;
    }

    public void setMousePressHandler(EventHandler<MouseEvent> HANDLER) {
        this.mousePressHandler = HANDLER;
    }

    public void setMouseReleaseHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseReleaseHandler = HANDLER;
    }

    public void setMouseExitHandler(EventHandler<MouseEvent> HANDLER) {
        this.mouseExitHandler = HANDLER;
    }

    public Color getBackgroundColor() {
        return (Color)this.backgroundColor.getValue();
    }

    public void setBackgroundColor(Color COLOR) {
        this.backgroundColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        return (ObjectProperty)this.backgroundColor;
    }

    public Color getFillColor() {
        return (Color)this.fillColor.getValue();
    }

    public void setFillColor(Color COLOR) {
        this.fillColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> fillColorProperty() {
        return (ObjectProperty)this.fillColor;
    }

    public Color getStrokeColor() {
        return (Color)this.strokeColor.getValue();
    }

    public void setStrokeColor(Color COLOR) {
        this.strokeColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> strokeColorProperty() {
        return (ObjectProperty)this.strokeColor;
    }

    public Color getHoverColor() {
        return (Color)this.hoverColor.getValue();
    }

    public void setHoverColor(Color COLOR) {
        this.hoverColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> hoverColorProperty() {
        return (ObjectProperty)this.hoverColor;
    }

    public Color getPressedColor() {
        return (Color)this.pressedColor.getValue();
    }

    public void setPressedColor(Color COLOR) {
        this.pressedColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> pressedColorProperty() {
        return (ObjectProperty)this.pressedColor;
    }

    public Color getSelectedColor() {
        return (Color)this.selectedColor.getValue();
    }

    public void setSelectedColor(Color COLOR) {
        this.selectedColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> selectedColorProperty() {
        return (ObjectProperty)this.selectedColor;
    }

    public Color getLocationColor() {
        return (Color)this.locationColor.getValue();
    }

    public void setLocationColor(Color COLOR) {
        this.locationColor.setValue((Object)COLOR);
    }

    public ObjectProperty<Color> locationColorProperty() {
        return (ObjectProperty)this.locationColor;
    }

    public boolean isHoverEnabled() {
        return this.hoverEnabled.get();
    }

    public void setHoverEnabled(boolean ENABLED) {
        this.hoverEnabled.set(ENABLED);
    }

    public BooleanProperty hoverEnabledProperty() {
        return this.hoverEnabled;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled.get();
    }

    public void setSelectionEnabled(boolean ENABLED) {
        this.selectionEnabled.set(ENABLED);
    }

    public BooleanProperty selectionEnabledProperty() {
        return this.selectionEnabled;
    }

    public Country getSelectedCountry() {
        return (Country)this.selectedCountry.get();
    }

    public void setSelectedCountry(Country COUNTRY) {
        this.selectedCountry.set((Object)COUNTRY);
    }

    public ObjectProperty<Country> selectedCountryProperty() {
        return this.selectedCountry;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled.get();
    }

    public void setZoomEnabled(boolean ENABLED) {
        this.zoomEnabled.set(ENABLED);
    }

    public BooleanProperty zoomEnabledProperty() {
        return this.zoomEnabled;
    }

    public double getScaleFactor() {
        return this.scaleFactor.get();
    }

    public void setScaleFactor(double FACTOR) {
        this.scaleFactor.set(FACTOR);
    }

    public DoubleProperty scaleFactorProperty() {
        return this.scaleFactor;
    }

    public boolean isHeatMapVisible() {
        return this.heatMapVisible.get();
    }

    public void setHeatMapVisible(boolean VISIBLE) {
        this.heatMapVisible.set(VISIBLE);
    }

    public BooleanProperty heatMapVisibleProperty() {
        return this.heatMapVisible;
    }

    public List<MapPoint> getMapPoints() {
        return this.mapPoints;
    }

    public void setMapPoints(MapPoint ... MAP_POINTS) {
        this.setMapPoints(Arrays.asList(MAP_POINTS));
    }

    public void setMapPoints(List<MapPoint> MAP_POINTS) {
        this.mapPoints.setAll(MAP_POINTS);
    }

    public void addMapPoints(MapPoint ... MAP_POINTS) {
        this.addMapPoints(Arrays.asList(MAP_POINTS));
    }

    public void addMapPoints(List<MapPoint> MAP_POINTS) {
        this.mapPoints.addAll(MAP_POINTS);
    }

    public void clearMapPoints() {
        this.mapPoints.clear();
    }

    public List<MapConnection> getMapConnections() {
        return this.mapConnections;
    }

    public void setMapConnections(MapConnection ... MAP_CONNECTIONS) {
        this.setMapConnections(Arrays.asList(MAP_CONNECTIONS));
    }

    public void setMapConnections(List<MapConnection> MAP_CONNECTIONS) {
        this.mapConnections.setAll(MAP_CONNECTIONS);
    }

    public void addMapConnections(MapConnection ... MAP_CONNECTIONS) {
        this.addMapConnections(Arrays.asList(MAP_CONNECTIONS));
    }

    public void addMapConnections(List<MapConnection> MAP_CONNECTIONS) {
        this.mapConnections.addAll(MAP_CONNECTIONS);
    }

    public void clearMapConnections() {
        this.mapConnections.clear();
    }

    public double getConnectionWidth() {
        return this.connectionWidth;
    }

    public void setConnectionWidth(double WIDTH) {
        this.connectionWidth = Helper.clamp(0.5, 10.0, WIDTH);
        this.redraw();
    }

    public WeightedMapPoints getWeightedMapPoints() {
        return this.weightedMapPoints;
    }

    public void setWeightedMapPoints(WeightedMapPoints WEIGHTED) {
        this.weightedMapPoints = WEIGHTED;
        this.redraw();
    }

    public boolean getWeightedMapConnections() {
        return this.weightedMapConnections;
    }

    public void setWeightedMapConnections(boolean WEIGHTED) {
        this.weightedMapConnections = WEIGHTED;
        this.redraw();
    }

    public boolean getArrowsVisible() {
        return this.arrowsVisible;
    }

    public void setArrowsVisible(boolean VISIBLE) {
        this.arrowsVisible = VISIBLE;
        this.redraw();
    }

    public MapPointSize getMapPointSize() {
        return this.mapPointSize;
    }

    public void setMapPointSize(MapPointSize SIZE) {
        this.mapPointSize = SIZE;
        this.redraw();
    }

    public boolean getMapPointsVisible() {
        return this.mapPointsVisible;
    }

    public void setMapPointsVisible(boolean VISIBLE) {
        this.mapPointsVisible = VISIBLE;
        this.redraw();
    }

    public boolean getMapPointTextVisible() {
        return this.mapPointTextVisible;
    }

    public void setMapPointTextVisible(boolean VISIBLE) {
        this.mapPointTextVisible = VISIBLE;
        this.redraw();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color COLOR) {
        this.textColor = COLOR;
        this.redraw();
    }

    public void animateImageAlongConnection(Image IMAGE, MapConnection CONNECTION) {
        double[] cp2;
        double[] cp1;
        if (null == IMAGE) {
            return;
        }
        this.imagePathPoints.clear();
        this.image = IMAGE;
        this.overlayCtx.setStroke((Paint)CONNECTION.getStroke());
        this.overlayCtx.setLineWidth(CONNECTION.getLineWidth());
        SimpleDoubleProperty pos = new SimpleDoubleProperty(0.0);
        MapPoint p1 = CONNECTION.getIncomingItem();
        MapPoint p2 = CONNECTION.getOutgoingItem();
        double[] xy1 = World.latLonToXY(p1.getX(), p1.getY());
        double[] xy2 = World.latLonToXY(p2.getX(), p2.getY());
        double[] midPoint = Helper.getMidPoint(xy1[0], xy1[1], xy2[0], xy2[1]);
        double[] midPoint1 = Helper.getMidPoint(xy1[0], xy1[1], midPoint[0], midPoint[1]);
        double[] midPoint2 = Helper.getMidPoint(xy2[0], xy2[1], midPoint[0], midPoint[1]);
        double[] rotCp1 = Helper.getMidPoint(xy1[0], xy1[1], midPoint2[0], midPoint2[1]);
        double[] rotCp2 = Helper.getMidPoint(midPoint1[0], midPoint1[1], xy2[0], xy2[1]);
        if (xy2[0] > xy1[0]) {
            cp1 = Helper.rotatePointAroundRotationCenter(rotCp1[0], rotCp1[1], xy1[0], xy1[1], -80.0);
            cp2 = Helper.rotatePointAroundRotationCenter(rotCp2[0], rotCp2[1], xy2[0], xy2[1], 80.0);
            this.ctx.beginPath();
            this.ctx.moveTo(xy1[0], xy1[1]);
            this.ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1]);
        } else {
            cp1 = Helper.rotatePointAroundRotationCenter(rotCp1[0], rotCp1[1], xy1[0], xy1[1], 80.0);
            cp2 = Helper.rotatePointAroundRotationCenter(rotCp2[0], rotCp2[1], xy2[0], xy2[1], -80.0);
            this.ctx.beginPath();
            this.ctx.moveTo(xy2[0], xy2[1]);
            this.ctx.bezierCurveTo(cp2[0], cp2[1], cp1[0], cp1[1], xy1[0], xy1[1]);
        }
        this.imagePos = Helper.getCubicBezierXYatT(xy1[0], xy1[1], cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1], 0.0);
        this.oldImagePos = this.imagePos;
        this.imagePathPoints.add(new Point(this.imagePos[0], this.imagePos[1]));
        pos.addListener(arg_0 -> this.lambda$animateImageAlongConnection$23(xy1, cp1, cp2, xy2, (DoubleProperty)pos, arg_0));
        this.timeline.stop();
        KeyValue kvPos0 = new KeyValue((WritableValue)pos, (Object)0, Interpolator.EASE_IN);
        KeyValue kvAlpha0 = new KeyValue((WritableValue)this.imageAlpha, (Object)0, Interpolator.EASE_IN);
        KeyValue kvAlpha1 = new KeyValue((WritableValue)this.imageAlpha, (Object)1, Interpolator.EASE_OUT);
        KeyValue kvAlpha2 = new KeyValue((WritableValue)this.imageAlpha, (Object)1, Interpolator.EASE_IN);
        KeyValue kvAlpha3 = new KeyValue((WritableValue)this.imageAlpha, (Object)0, Interpolator.EASE_OUT);
        KeyValue kvPos1 = new KeyValue((WritableValue)pos, (Object)1, Interpolator.EASE_OUT);
        KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvPos0, kvAlpha0});
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{kvAlpha1});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)14900.0), new KeyValue[]{kvAlpha2});
        KeyFrame kf3 = new KeyFrame(Duration.millis((double)15000.0), new KeyValue[]{kvPos1, kvAlpha3});
        this.timeline.setDelay(Duration.millis((double)1000.0));
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2, kf3});
        this.timeline.play();
    }

    public boolean getDrawImagePath() {
        return this.drawImagePath;
    }

    public void setDrawImagePath(boolean DRAW_IMAGE_PATH) {
        this.drawImagePath = DRAW_IMAGE_PATH;
        this.redrawOverlay();
    }

    public void setHeatMapToTop(boolean TO_TOP) {
        if (TO_TOP) {
            this.heatMap.toFront();
        } else {
            this.heatMap.toBack();
            this.group.toBack();
        }
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void resetZoom() {
        this.setScaleFactor(1.0);
        this.setTranslateX(0.0);
        this.setTranslateY(0.0);
        this.group.setTranslateX(0.0);
        this.group.setTranslateY(0.0);
    }

    public void addLocation(Location LOCATION) {
        String tooltipText;
        double x = (LOCATION.getLongitude() + 180.0) * 2.8027777777777776 + MAP_OFFSET_X;
        double y = 332.5 - 1009.0 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(LOCATION.getLatitude()) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        Circle locationIcon = new Circle(x, y, this.size * 0.01);
        locationIcon.setFill((Paint)(null == LOCATION.getFill() ? this.getLocationColor() : LOCATION.getFill()));
        StringBuilder tooltipBuilder = new StringBuilder();
        if (!LOCATION.getName().isEmpty()) {
            tooltipBuilder.append(LOCATION.getName());
        }
        if (!LOCATION.getInfo().isEmpty()) {
            tooltipBuilder.append("\n").append(LOCATION.getInfo());
        }
        if (!(tooltipText = tooltipBuilder.toString()).isEmpty()) {
            Tooltip tooltip = new Tooltip(tooltipText);
            tooltip.setFont(Fonts.opensansRegular((double)10.0));
            Tooltip.install((Node)locationIcon, (Tooltip)tooltip);
        }
        if (null != LOCATION.getMouseEnterHandler()) {
            locationIcon.setOnMouseEntered((EventHandler)new WeakEventHandler(LOCATION.getMouseEnterHandler()));
        }
        if (null != LOCATION.getMousePressHandler()) {
            locationIcon.setOnMousePressed((EventHandler)new WeakEventHandler(LOCATION.getMousePressHandler()));
        }
        if (null != LOCATION.getMouseReleaseHandler()) {
            locationIcon.setOnMouseReleased((EventHandler)new WeakEventHandler(LOCATION.getMouseReleaseHandler()));
        }
        if (null != LOCATION.getMouseExitHandler()) {
            locationIcon.setOnMouseExited((EventHandler)new WeakEventHandler(LOCATION.getMouseExitHandler()));
        }
        this.locations.put((Object)LOCATION, (Object)locationIcon);
    }

    public void removeLocation(Location LOCATION) {
        this.locations.remove((Object)LOCATION);
    }

    public void addLocations(Location ... LOCATIONS) {
        for (Location location : LOCATIONS) {
            this.addLocation(location);
        }
    }

    public void clearLocations() {
        this.locations.clear();
    }

    public void showLocations(boolean SHOW) {
        for (Shape shape : this.locations.values()) {
            shape.setManaged(SHOW);
            shape.setVisible(SHOW);
        }
    }

    public void zoomToCountry(Country COUNTRY) {
        if (!this.isZoomEnabled()) {
            return;
        }
        if (null != this.getSelectedCountry()) {
            this.setCountryFillAndStroke(this.getSelectedCountry(), this.getFillColor(), this.getStrokeColor());
        }
        this.zoomToArea(this.getBounds(COUNTRY));
    }

    public void zoomToRegion(CRegion REGION) {
        if (!this.isZoomEnabled()) {
            return;
        }
        if (null != this.getSelectedCountry()) {
            this.setCountryFillAndStroke(this.getSelectedCountry(), this.getFillColor(), this.getStrokeColor());
        }
        this.zoomToArea(this.getBounds(REGION.getCountries()));
    }

    public HeatMap getHeatMap() {
        return this.heatMap;
    }

    public void addSpots(Point ... SPOTS) {
        this.heatMap.addSpots(SPOTS);
    }

    public void addSpots(List<Point> SPOTS) {
        this.heatMap.addSpots(SPOTS);
    }

    public void addSpot(double X, double Y, double OFFSET_X, double OFFSET_Y, double RADIUS, OpacityDistribution OPACITY_GRADIENT) {
        this.heatMap.addSpot(X, Y, OFFSET_X, OFFSET_Y, RADIUS, OPACITY_GRADIENT);
    }

    public void addSpot(double X, double Y, Image EVENT_IMAGE, double OFFSET_X, double OFFSET_Y) {
        this.heatMap.addSpot(X, Y, EVENT_IMAGE, OFFSET_X, OFFSET_Y);
    }

    public void addSpot(double X, double Y) {
        this.heatMap.addSpot(X, Y);
    }

    public void clearHeatMap() {
        this.heatMap.clearHeatMap();
    }

    public Mapping getColorMapping() {
        return this.heatMap.getColorMapping();
    }

    public void setColorMapping(Mapping COLOR_MAPPING) {
        this.heatMap.setColorMapping(COLOR_MAPPING);
    }

    public boolean isFadeColors() {
        return this.heatMap.isFadeColors();
    }

    public void setFadeColors(boolean FADE_COLORS) {
        this.heatMap.setFadeColors(FADE_COLORS);
    }

    public double getSpotRadius() {
        return this.heatMap.getSpotRadius();
    }

    public void setSpotRadius(double RADIUS) {
        this.heatMap.setSpotRadius(RADIUS);
    }

    public double getHeatMapOpacity() {
        return this.heatMap.getOpacity();
    }

    public void setHeatMapOpacity(double OPACITY) {
        this.heatMap.setOpacity(this.clamp(0.0, 1.0, OPACITY));
    }

    public OpacityDistribution getOpacityDistribution() {
        return this.heatMap.getOpacityDistribution();
    }

    public void setOpacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.heatMap.setOpacityDistribution(OPACITY_DISTRIBUTION);
        this.heatMap.updateMonochromeMap(OPACITY_DISTRIBUTION);
    }

    public static double[] latLonToXY(double LATITUDE, double LONGITUDE) {
        double x = (LONGITUDE + 180.0) * 2.8027777777777776 + MAP_OFFSET_X;
        double y = 332.5 - 1009.0 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(LATITUDE) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        return new double[]{x, y};
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    private double[] getBounds(Country ... COUNTRIES) {
        return this.getBounds(Arrays.asList(COUNTRIES));
    }

    private double[] getBounds(List<Country> COUNTRIES) {
        double upperLeftX = 1009.0;
        double upperLeftY = 665.0;
        double lowerRightX = 0.0;
        double lowerRightY = 0.0;
        for (Country country : COUNTRIES) {
            List<CountryPath> paths = this.countryPaths.get(country.getName());
            for (int i = 0; i < paths.size(); ++i) {
                CountryPath path = paths.get(i);
                Bounds bounds = path.getLayoutBounds();
                upperLeftX = Math.min(bounds.getMinX(), upperLeftX);
                upperLeftY = Math.min(bounds.getMinY(), upperLeftY);
                lowerRightX = Math.max(bounds.getMaxX(), lowerRightX);
                lowerRightY = Math.max(bounds.getMaxY(), lowerRightY);
            }
        }
        return new double[]{upperLeftX, upperLeftY, lowerRightX, lowerRightY};
    }

    private void zoomToArea(double[] BOUNDS) {
        this.group.setTranslateX(0.0);
        this.group.setTranslateY(0.0);
        double areaWidth = BOUNDS[2] - BOUNDS[0];
        double areaHeight = BOUNDS[3] - BOUNDS[1];
        double areaCenterX = BOUNDS[0] + areaWidth * 0.5;
        double areaCenterY = BOUNDS[1] + areaHeight * 0.5;
        Orientation orientation = areaWidth < areaHeight ? Orientation.VERTICAL : Orientation.HORIZONTAL;
        double sf = 1.0;
        switch (orientation) {
            case VERTICAL: {
                sf = this.clamp(1.0, 10.0, 1.0 / (areaHeight / this.height));
                break;
            }
            case HORIZONTAL: {
                sf = this.clamp(1.0, 10.0, 1.0 / (areaWidth / this.width));
            }
        }
        this.setScaleFactor(sf);
        this.group.setTranslateX(this.width * 0.5 - areaCenterX);
        this.group.setTranslateY(this.height * 0.5 - areaCenterY);
    }

    private void setPivot(double X, double Y) {
        this.setTranslateX(this.getTranslateX() - X);
        this.setTranslateY(this.getTranslateY() - Y);
    }

    private void enableMouseInteraction(boolean ENABLE) {
        this.heatMap.setMouseTransparent(ENABLE);
        this.canvas.setMouseTransparent(ENABLE);
        this.overlayCanvas.setMouseTransparent(ENABLE);
    }

    private void handleMouseEvent(MouseEvent EVENT, EventHandler<MouseEvent> HANDLER) {
        CountryPath COUNTRY_PATH = (CountryPath)((Object)EVENT.getSource());
        String COUNTRY_NAME = COUNTRY_PATH.getName();
        Country COUNTRY = Country.valueOf((String)COUNTRY_NAME);
        List<CountryPath> PATHS = this.countryPaths.get(COUNTRY_NAME);
        EventType TYPE = EVENT.getEventType();
        if (MouseEvent.MOUSE_ENTERED == TYPE) {
            if (this.isHoverEnabled()) {
                Color color = this.isSelectionEnabled() && COUNTRY.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getHoverColor();
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_PRESSED == TYPE) {
            if (this.isSelectionEnabled()) {
                Color color;
                if (null == this.getSelectedCountry()) {
                    this.setSelectedCountry(COUNTRY);
                    color = this.getSelectedColor();
                } else {
                    color = null == this.getSelectedCountry().getFill() ? this.getFillColor() : this.getSelectedCountry().getFill();
                }
                for (SVGPath sVGPath : this.countryPaths.get(this.getSelectedCountry().getName())) {
                    sVGPath.setFill((Paint)color);
                }
            } else if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)this.getPressedColor());
                }
            }
        } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
            Color color;
            if (this.isSelectionEnabled()) {
                if (this.formerSelectedCountry == COUNTRY) {
                    this.setSelectedCountry(null);
                    color = null == COUNTRY.getFill() ? this.getFillColor() : COUNTRY.getFill();
                } else {
                    this.setSelectedCountry(COUNTRY);
                    color = this.getSelectedColor();
                }
                this.formerSelectedCountry = this.getSelectedCountry();
            } else {
                color = this.getHoverColor();
            }
            if (this.isHoverEnabled()) {
                for (SVGPath sVGPath : PATHS) {
                    sVGPath.setFill((Paint)color);
                }
            }
        } else if (MouseEvent.MOUSE_EXITED == TYPE && this.isHoverEnabled()) {
            Color color = this.isSelectionEnabled() && COUNTRY.equals((Object)this.getSelectedCountry()) ? this.getSelectedColor() : this.getFillColor();
            for (SVGPath sVGPath : PATHS) {
                sVGPath.setFill((Paint)(null == COUNTRY.getFill() || COUNTRY == this.getSelectedCountry() ? color : COUNTRY.getFill()));
            }
        }
        if (null != HANDLER) {
            HANDLER.handle((Event)EVENT);
        }
    }

    private void setFillAndStroke() {
        this.countryPaths.keySet().forEach(name -> {
            Country country;
            this.setCountryFillAndStroke(country, null == (country = Country.valueOf((String)name)).getFill() ? this.getFillColor() : country.getFill(), null == country.getStroke() ? this.getStrokeColor() : country.getStroke());
        });
    }

    private void setCountryFillAndStroke(Country COUNTRY, Color FILL, Color STROKE) {
        List<CountryPath> paths = this.countryPaths.get(COUNTRY.getName());
        for (CountryPath path : paths) {
            path.setFill((Paint)FILL);
            path.setStroke((Paint)STROKE);
        }
    }

    private void addShapesToScene(Shape ... SHAPES) {
        this.addShapesToScene(Arrays.asList(SHAPES));
    }

    private void addShapesToScene(Collection<Shape> SHAPES) {
        if (null == this.getScene()) {
            return;
        }
        Platform.runLater(() -> this.pane.getChildren().addAll(SHAPES));
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private Properties readProperties(String FILE_NAME) {
        ClassLoader LOADER = Thread.currentThread().getContextClassLoader();
        Properties PROPERTIES = new Properties();
        try (InputStream resourceStream = LOADER.getResourceAsStream(FILE_NAME);){
            PROPERTIES.load(resourceStream);
        }
        catch (IOException exception) {
            logger.error(exception.getMessage());
        }
        return PROPERTIES;
    }

    private Map<String, List<CountryPath>> createCountryPaths() {
        HashMap<String, List<CountryPath>> countryPaths = new HashMap<String, List<CountryPath>>();
        this.resolutionProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String name = key.toString();
            ArrayList<CountryPath> pathList = new ArrayList<CountryPath>();
            for (String path : value.toString().split(";")) {
                pathList.add(new CountryPath(name, path));
            }
            countryPaths.put(name, pathList);
        }));
        return countryPaths;
    }

    private void redraw() {
        double circleR;
        double dotDia;
        double dotR;
        if (this.mapPoints.isEmpty() && this.mapConnections.isEmpty()) {
            return;
        }
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        this.ctx.clearRect(0.0, 0.0, w, h);
        HashMap weightedPoints = new HashMap();
        double fontSize = this.size * 0.01;
        double circleDia = switch (this.mapPointSize) {
            case MapPointSize.TINY -> {
                fontSize = this.size * 0.0025;
                dotR = 0.5;
                dotDia = 1.0;
                circleR = 1.0;
                yield 2.0;
            }
            case MapPointSize.SMALL -> {
                fontSize = this.size * 0.005;
                dotR = 1.0;
                dotDia = 2.0;
                circleR = 2.0;
                yield 4.0;
            }
            case MapPointSize.NORMAL -> {
                fontSize = this.size * 0.01;
                dotR = 1.5;
                dotDia = 3.0;
                circleR = 3.0;
                yield 6.0;
            }
            default -> {
                fontSize = this.size * 0.01;
                dotR = 1.5;
                dotDia = 3.0;
                circleR = 3.0;
                yield 6.0;
            }
        };
        double maxPointDia = 3.0;
        double maxAmount = 0.0;
        switch (this.weightedMapPoints) {
            case INCOMING: {
                this.mapConnections.forEach(connection -> {
                    MapPoint incomingItem = connection.getIncomingItem();
                    if (weightedPoints.containsKey((Object)incomingItem)) {
                        int count = (Integer)weightedPoints.get((Object)incomingItem);
                        weightedPoints.put(incomingItem, count + 1);
                    } else {
                        weightedPoints.put(incomingItem, 1);
                    }
                });
                Optional<Map.Entry> maxIncomingEntry = weightedPoints.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue));
                maxAmount = maxIncomingEntry.isPresent() ? (double)((Integer)maxIncomingEntry.get().getValue()).intValue() : 0.0;
                break;
            }
            case OUTGOING: {
                this.mapConnections.forEach(connection -> {
                    MapPoint outgoingItem = connection.getOutgoingItem();
                    if (weightedPoints.containsKey((Object)outgoingItem)) {
                        int count = (Integer)weightedPoints.get((Object)outgoingItem);
                        weightedPoints.put(outgoingItem, count + 1);
                    } else {
                        weightedPoints.put(outgoingItem, 1);
                    }
                });
                Optional<Map.Entry> maxOutgoingEntry = weightedPoints.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue));
                maxAmount = maxOutgoingEntry.isPresent() ? (double)((Integer)maxOutgoingEntry.get().getValue()).intValue() : 0.0;
                break;
            }
        }
        this.ctx.setFont(Fonts.opensansRegular((double)fontSize));
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setLineWidth(1.0);
        ArrayList<MapPoint> pointsDrawn = new ArrayList<MapPoint>();
        if (this.getMapPointsVisible()) {
            for (MapPoint point : this.mapPoints) {
                pointsDrawn.add(point);
                double[] xy = World.latLonToXY(point.getX(), point.getY());
                if (MapPointSize.TINY != this.mapPointSize) {
                    this.ctx.setStroke((Paint)point.getFill());
                    this.ctx.strokeOval(xy[0] - circleR, xy[1] - circleR, circleDia, circleDia);
                }
                this.ctx.setFill((Paint)point.getFill());
                this.ctx.fillOval(xy[0] - dotR, xy[1] - dotR, dotDia, dotDia);
                if (!this.mapPointTextVisible) continue;
                this.ctx.save();
                this.ctx.setFill((Paint)this.textColor);
                this.ctx.fillText(point.getName(), xy[0], xy[1] + fontSize);
                this.ctx.restore();
            }
        }
        this.ctx.setLineWidth(this.connectionWidth);
        double factor = 50.0 / maxAmount;
        double cubicCurveDistFactor = 0.01;
        double distFactor = 1.0;
        if (this.connectionWithMaxValue.isPresent() && this.connectionWithMaxValue.get().getValue() > 0.0) {
            cubicCurveDistFactor = 0.04 / this.connectionWithMaxValue.get().getValue();
            double[] p1 = new double[]{this.connectionWithMaxValue.get().getOutgoingItem().getX(), this.connectionWithMaxValue.get().getOutgoingItem().getY()};
            double[] p2 = new double[]{this.connectionWithMaxValue.get().getIncomingItem().getX(), this.connectionWithMaxValue.get().getIncomingItem().getY()};
            p1 = World.latLonToXY(p1[0], p1[1]);
            p2 = World.latLonToXY(p2[0], p2[1]);
            double dist = Helper.distance(p1[0], p1[1], p2[0], p2[1]);
            distFactor = 1.0 / dist;
        }
        for (MapConnection connection2 : this.mapConnections) {
            double[] cp2;
            double[] cp1;
            MapPoint p1 = connection2.getIncomingItem();
            MapPoint p2 = connection2.getOutgoingItem();
            this.ctx.save();
            switch (this.weightedMapPoints) {
                case INCOMING: {
                    this.ctx.setFill((Paint)p1.getFill());
                    maxPointDia = (double)((Integer)weightedPoints.get((Object)p1)).intValue() * factor;
                    double[] wp1 = World.latLonToXY(p1.getX(), p1.getY());
                    this.ctx.fillOval(wp1[0] - maxPointDia / 2.0, wp1[1] - maxPointDia / 2.0, maxPointDia, maxPointDia);
                    this.ctx.save();
                    this.ctx.setFill((Paint)this.textColor);
                    this.ctx.fillText(p1.getName(), wp1[0], wp1[1] + fontSize);
                    this.ctx.restore();
                    break;
                }
                case OUTGOING: {
                    this.ctx.setFill((Paint)p2.getFill());
                    maxPointDia = (double)((Integer)weightedPoints.get((Object)p2)).intValue() * factor;
                    double[] wp2 = World.latLonToXY(p2.getX(), p2.getY());
                    this.ctx.fillOval(wp2[0] - maxPointDia / 2.0, wp2[1] - maxPointDia / 2.0, maxPointDia, maxPointDia);
                    this.ctx.save();
                    this.ctx.setFill((Paint)this.textColor);
                    this.ctx.fillText(p2.getName(), wp2[0], wp2[1] + fontSize);
                    this.ctx.restore();
                    break;
                }
            }
            this.ctx.restore();
            if (null == p1 || null == p2) continue;
            double[] xy1 = World.latLonToXY(p1.getX(), p1.getY());
            double[] xy2 = World.latLonToXY(p2.getX(), p2.getY());
            double[] midPoint = Helper.getMidPoint(xy1[0], xy1[1], xy2[0], xy2[1]);
            double[] midPoint1 = Helper.getMidPoint(xy1[0], xy1[1], midPoint[0], midPoint[1]);
            double[] midPoint2 = Helper.getMidPoint(xy2[0], xy2[1], midPoint[0], midPoint[1]);
            double[] rotCp1 = Helper.getMidPoint(xy1[0], xy1[1], midPoint2[0], midPoint2[1]);
            double[] rotCp2 = Helper.getMidPoint(midPoint1[0], midPoint1[1], xy2[0], xy2[1]);
            if (xy2[0] > xy1[0]) {
                cp1 = Helper.rotatePointAroundRotationCenter(rotCp1[0], rotCp1[1], xy1[0], xy1[1], -80.0);
                cp2 = Helper.rotatePointAroundRotationCenter(rotCp2[0], rotCp2[1], xy2[0], xy2[1], 80.0);
                this.ctx.beginPath();
                this.ctx.moveTo(xy1[0], xy1[1]);
                this.ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1]);
            } else {
                cp1 = Helper.rotatePointAroundRotationCenter(rotCp1[0], rotCp1[1], xy1[0], xy1[1], 80.0);
                cp2 = Helper.rotatePointAroundRotationCenter(rotCp2[0], rotCp2[1], xy2[0], xy2[1], -80.0);
                this.ctx.beginPath();
                this.ctx.moveTo(xy2[0], xy2[1]);
                this.ctx.bezierCurveTo(cp2[0], cp2[1], cp1[0], cp1[1], xy1[0], xy1[1]);
            }
            if (this.weightedMapConnections) {
                double distance = Helper.distance(xy1[0], xy1[1], xy2[0], xy2[1]);
                double d = 1.0 / (distance * distFactor) * (connection2.getValue() * cubicCurveDistFactor);
                double[] arrowCenter = Helper.getCubicBezierXYatT(xy1[0], xy1[1], cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1], d);
                double[] arrowPoint1 = Helper.rotatePointAroundRotationCenter(arrowCenter[0], arrowCenter[1], xy1[0], xy1[1], -45.0);
                double[] arrowPoint2 = Helper.rotatePointAroundRotationCenter(arrowCenter[0], arrowCenter[1], xy1[0], xy1[1], 45.0);
                if (connection2.getGradientFill()) {
                    LinearGradient gradient = new LinearGradient(xy1[0], xy1[1], xy2[0], xy2[1], false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, connection2.getEndColor()), new Stop(0.5, connection2.getStartColor()), new Stop(1.0, connection2.getStartColor())});
                    this.ctx.setFill((Paint)gradient);
                    this.ctx.setStroke((Paint)gradient);
                } else {
                    this.ctx.setFill((Paint)connection2.getStroke());
                    this.ctx.setStroke((Paint)connection2.getStroke());
                }
                this.ctx.beginPath();
                this.ctx.moveTo(xy1[0], xy1[1]);
                this.ctx.lineTo(arrowPoint1[0], arrowPoint1[1]);
                this.ctx.bezierCurveTo(cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1]);
                this.ctx.bezierCurveTo(cp2[0], cp2[1], cp1[0], cp1[1], arrowPoint2[0], arrowPoint2[1]);
                this.ctx.lineTo(xy1[0], xy1[1]);
                this.ctx.closePath();
                this.ctx.fill();
                this.ctx.stroke();
            } else {
                this.ctx.setLineWidth(connection2.getLineWidth());
                if (connection2.getGradientFill()) {
                    LinearGradient gradient = new LinearGradient(xy1[0], xy1[1], xy2[0], xy2[1], false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, connection2.getEndColor()), new Stop(0.5, connection2.getStartColor()), new Stop(1.0, connection2.getStartColor())});
                    this.ctx.setStroke((Paint)gradient);
                } else {
                    this.ctx.setStroke((Paint)connection2.getStroke());
                }
                this.ctx.stroke();
                double[] pointNearStart = Helper.getCubicBezierXYatT(xy1[0], xy1[1], cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1], 0.01);
                double dx = xy1[0] - pointNearStart[0];
                double dy = xy1[1] - pointNearStart[1];
                double angleAtEnd = Math.toDegrees(Math.atan2(dy, dx));
                if (this.arrowsVisible) {
                    double arrowSize = this.connectionWidth * 3.0;
                    this.ctx.beginPath();
                    this.ctx.save();
                    if (connection2.getGradientFill()) {
                        this.ctx.setFill((Paint)connection2.getEndColor());
                    } else {
                        this.ctx.setFill((Paint)connection2.getStroke());
                    }
                    this.ctx.translate(xy1[0], xy1[1]);
                    this.ctx.rotate(angleAtEnd);
                    this.ctx.moveTo(-arrowSize * 3.0, 0.0);
                    this.ctx.lineTo(-arrowSize * 3.0, -arrowSize * 2.0);
                    this.ctx.lineTo(0.0, 0.0);
                    this.ctx.lineTo(-arrowSize * 3.0, arrowSize * 2.0);
                    this.ctx.lineTo(-arrowSize * 3.0, 0.0);
                    this.ctx.closePath();
                    this.ctx.fill();
                    this.ctx.restore();
                }
            }
            if (!this.mapPointTextVisible) continue;
            this.ctx.save();
            this.ctx.setFill((Paint)this.textColor);
            for (MapPoint point : this.allItems) {
                if (pointsDrawn.contains((Object)point)) continue;
                double[] xy = World.latLonToXY(point.getX(), point.getY());
                this.ctx.fillText(point.getName(), xy[0], xy[1] + fontSize);
            }
            this.ctx.restore();
        }
    }

    private void redrawOverlay() {
        if (null == this.image || this.imagePos.length == 0) {
            return;
        }
        double w = this.overlayCanvas.getWidth();
        double h = this.overlayCanvas.getHeight();
        this.overlayCtx.clearRect(0.0, 0.0, w, h);
        if (this.drawImagePath) {
            this.overlayCtx.beginPath();
            this.overlayCtx.moveTo(this.imagePathPoints.get(0).getX(), this.imagePathPoints.get(0).getY());
            this.imagePathPoints.forEach(p -> this.overlayCtx.lineTo(p.getX(), p.getY()));
            this.overlayCtx.stroke();
        }
        double bearing = Helper.bearing(this.oldImagePos[0], this.oldImagePos[1], this.imagePos[0], this.imagePos[1]);
        this.overlayCtx.save();
        this.overlayCtx.setGlobalAlpha(this.imageAlpha.get());
        this.overlayCtx.translate(this.imagePos[0], this.imagePos[1]);
        this.overlayCtx.rotate(bearing);
        this.overlayCtx.drawImage(this.image, -this.image.getWidth() * 0.5, -this.image.getHeight() * 0.5);
        this.overlayCtx.restore();
    }

    public String getUserAgentStylesheet() {
        return World.class.getResource("world.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (0.6590683845391476 * this.width > this.height) {
            this.width = 1.0 / (0.6590683845391476 / this.height);
        } else if (1.0 / (0.6590683845391476 / this.height) > this.width) {
            this.height = 0.6590683845391476 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.isZoomEnabled()) {
                this.resetZoom();
            }
            this.pane.setCache(true);
            this.pane.setCacheHint(CacheHint.SCALE);
            this.pane.setScaleX(this.width / 1009.0);
            this.pane.setScaleY(this.height / 665.0);
            this.group.resize(this.width, this.height);
            this.group.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.heatMap.setScaleX(this.pane.getScaleX());
            this.heatMap.setScaleY(this.pane.getScaleY());
            this.heatMap.setTranslateX(this.group.getBoundsInParent().getMinX() - this.group.getLayoutBounds().getMinX());
            this.heatMap.setTranslateY(this.group.getBoundsInParent().getMinY() - this.group.getLayoutBounds().getMinY());
            this.canvas.setScaleX(this.pane.getScaleX());
            this.canvas.setScaleY(this.pane.getScaleY());
            this.canvas.setTranslateX(this.group.getBoundsInParent().getMinX() - this.group.getLayoutBounds().getMinX());
            this.canvas.setTranslateY(this.group.getBoundsInParent().getMinY() - this.group.getLayoutBounds().getMinY());
            this.overlayCanvas.setScaleX(this.pane.getScaleX());
            this.overlayCanvas.setScaleY(this.pane.getScaleY());
            this.overlayCanvas.setTranslateX(this.group.getBoundsInParent().getMinX() - this.group.getLayoutBounds().getMinX());
            this.overlayCanvas.setTranslateY(this.group.getBoundsInParent().getMinY() - this.group.getLayoutBounds().getMinY());
            this.redraw();
            this.redrawOverlay();
            this.pane.setCache(false);
        }
    }

    private /* synthetic */ void lambda$animateImageAlongConnection$23(double[] xy1, double[] cp1, double[] cp2, double[] xy2, DoubleProperty pos, Observable o) {
        this.imagePos = Helper.getCubicBezierXYatT(xy1[0], xy1[1], cp1[0], cp1[1], cp2[0], cp2[1], xy2[0], xy2[1], pos.get());
        this.imagePathPoints.add(new Point(this.imagePos[0], this.imagePos[1]));
        this.redrawOverlay();
        this.oldImagePos = this.imagePos;
    }

    public static enum Resolution {
        HI_RES,
        LO_RES;

    }
}

