/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.tools.IllegalPathStateException;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;

public abstract class Shape {
    public static final int RECT_INTERSECTS = Integer.MIN_VALUE;
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    public abstract RectBounds getBounds();

    public boolean contains(Point POINT) {
        return this.contains(POINT.x, POINT.y);
    }

    public abstract boolean contains(double var1, double var3);

    public boolean contains(RectBounds BOUNDS) {
        double x = BOUNDS.getMinX();
        double y = BOUNDS.getMinY();
        double w = BOUNDS.getMaxX() - x;
        double h = BOUNDS.getMaxY() - y;
        return this.contains(x, y, w, h);
    }

    public abstract boolean contains(double var1, double var3, double var5, double var7);

    public abstract boolean intersects(double var1, double var3, double var5, double var7);

    public boolean intersects(RectBounds BOUNDS) {
        double x = BOUNDS.getMinX();
        double y = BOUNDS.getMinY();
        double w = BOUNDS.getMaxX() - x;
        double h = BOUNDS.getMaxY() - y;
        return this.intersects(x, y, w, h);
    }

    public abstract PathIterator getPathIterator(BaseTransform var1);

    public abstract PathIterator getPathIterator(BaseTransform var1, double var2);

    public abstract Shape copy();

    public static int pointCrossingsForPath(PathIterator PATH_ITERATOR, double POINT_X, double POINT_Y) {
        if (PATH_ITERATOR.isDone()) {
            return 0;
        }
        double[] coords = new double[6];
        if (PATH_ITERATOR.currentSegment(coords) != 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        PATH_ITERATOR.next();
        double movx = coords[0];
        double movy = coords[1];
        double curx = movx;
        double cury = movy;
        int crossings = 0;
        while (!PATH_ITERATOR.isDone()) {
            switch (PATH_ITERATOR.currentSegment(coords)) {
                case 0: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    double endx = coords[0];
                    double endy = coords[1];
                    crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 2: {
                    double endx = coords[2];
                    double endy = coords[3];
                    crossings += Shape.pointCrossingsForQuad(POINT_X, POINT_Y, curx, cury, coords[0], coords[1], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 3: {
                    double endx = coords[4];
                    double endy = coords[5];
                    crossings += Shape.pointCrossingsForCubic(POINT_X, POINT_Y, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 4: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            PATH_ITERATOR.next();
        }
        if (cury != movy) {
            crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
        }
        return crossings;
    }

    public static int pointCrossingsForLine(double POINT_X, double POINT_Y, double X0, double Y0, double X1, double Y1) {
        if (POINT_Y < Y0 && POINT_Y < Y1) {
            return 0;
        }
        if (POINT_Y >= Y0 && POINT_Y >= Y1) {
            return 0;
        }
        if (POINT_X >= X0 && POINT_X >= X1) {
            return 0;
        }
        if (POINT_X < X0 && POINT_X < X1) {
            return Y0 < Y1 ? 1 : -1;
        }
        double xIntercept = X0 + (POINT_Y - Y0) * (X1 - X0) / (Y1 - Y0);
        if (POINT_X >= xIntercept) {
            return 0;
        }
        return Y0 < Y1 ? 1 : -1;
    }

    public static int pointCrossingsForQuad(double POINT_X, double POINT_Y, double X0, double Y0, double xc, double yc, double X1, double Y1, int LEVEL) {
        if (POINT_Y < Y0 && POINT_Y < yc && POINT_Y < Y1) {
            return 0;
        }
        if (POINT_Y >= Y0 && POINT_Y >= yc && POINT_Y >= Y1) {
            return 0;
        }
        if (POINT_X >= X0 && POINT_X >= xc && POINT_X >= X1) {
            return 0;
        }
        if (POINT_X < X0 && POINT_X < xc && POINT_X < X1) {
            if (POINT_Y >= Y0) {
                if (POINT_Y < Y1) {
                    return 1;
                }
            } else if (POINT_Y >= Y1) {
                return -1;
            }
            return 0;
        }
        if (LEVEL > 52) {
            return Shape.pointCrossingsForLine(POINT_X, POINT_Y, X0, Y0, X1, Y1);
        }
        double x0c = (X0 + xc) / 2.0;
        double y0c = (Y0 + yc) / 2.0;
        double xc1 = (xc + X1) / 2.0;
        double yc1 = (yc + Y1) / 2.0;
        xc = (x0c + xc1) / 2.0;
        yc = (y0c + yc1) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        return Shape.pointCrossingsForQuad(POINT_X, POINT_Y, X0, Y0, x0c, y0c, xc, yc, LEVEL + 1) + Shape.pointCrossingsForQuad(POINT_X, POINT_Y, xc, yc, xc1, yc1, X1, Y1, LEVEL + 1);
    }

    public static int pointCrossingsForCubic(double POINT_X, double POINT_Y, double X0, double Y0, double xc0, double yc0, double xc1, double yc1, double X1, double Y1, int LEVEL) {
        if (POINT_Y < Y0 && POINT_Y < yc0 && POINT_Y < yc1 && POINT_Y < Y1) {
            return 0;
        }
        if (POINT_Y >= Y0 && POINT_Y >= yc0 && POINT_Y >= yc1 && POINT_Y >= Y1) {
            return 0;
        }
        if (POINT_X >= X0 && POINT_X >= xc0 && POINT_X >= xc1 && POINT_X >= X1) {
            return 0;
        }
        if (POINT_X < X0 && POINT_X < xc0 && POINT_X < xc1 && POINT_X < X1) {
            if (POINT_Y >= Y0) {
                if (POINT_Y < Y1) {
                    return 1;
                }
            } else if (POINT_Y >= Y1) {
                return -1;
            }
            return 0;
        }
        if (LEVEL > 52) {
            return Shape.pointCrossingsForLine(POINT_X, POINT_Y, X0, Y0, X1, Y1);
        }
        double xmid = (xc0 + xc1) / 2.0;
        double ymid = (yc0 + yc1) / 2.0;
        xc0 = (X0 + xc0) / 2.0;
        yc0 = (Y0 + yc0) / 2.0;
        xc1 = (xc1 + X1) / 2.0;
        yc1 = (yc1 + Y1) / 2.0;
        double xc0m = (xc0 + xmid) / 2.0;
        double yc0m = (yc0 + ymid) / 2.0;
        double xmc1 = (xmid + xc1) / 2.0;
        double ymc1 = (ymid + yc1) / 2.0;
        xmid = (xc0m + xmc1) / 2.0;
        ymid = (yc0m + ymc1) / 2.0;
        if (Double.isNaN(xmid) || Double.isNaN(ymid)) {
            return 0;
        }
        return Shape.pointCrossingsForCubic(POINT_X, POINT_Y, X0, Y0, xc0, yc0, xc0m, yc0m, xmid, ymid, LEVEL + 1) + Shape.pointCrossingsForCubic(POINT_X, POINT_Y, xmid, ymid, xmc1, ymc1, xc1, yc1, X1, Y1, LEVEL + 1);
    }

    public static int rectCrossingsForPath(PathIterator PATH_ITERATOR, double RECT_X_MIN, double RECT_Y_MIN, double RECT_X_MAX, double RECT_Y_MAX) {
        double movy;
        double movx;
        if (RECT_X_MAX <= RECT_X_MIN || RECT_Y_MAX <= RECT_Y_MIN) {
            return 0;
        }
        if (PATH_ITERATOR.isDone()) {
            return 0;
        }
        double[] coords = new double[6];
        if (PATH_ITERATOR.currentSegment(coords) != 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        PATH_ITERATOR.next();
        double curx = movx = coords[0];
        double cury = movy = coords[1];
        int crossings = 0;
        while (crossings != Integer.MIN_VALUE && !PATH_ITERATOR.isDone()) {
            switch (PATH_ITERATOR.currentSegment(coords)) {
                case 0: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, movx, movy);
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    double endx = coords[0];
                    double endy = coords[1];
                    crossings = Shape.rectCrossingsForLine(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 2: {
                    double endx = coords[2];
                    double endy = coords[3];
                    crossings = Shape.rectCrossingsForQuad(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, coords[0], coords[1], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 3: {
                    double endx = coords[4];
                    double endy = coords[5];
                    crossings = Shape.rectCrossingsForCubic(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 4: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            PATH_ITERATOR.next();
        }
        if (crossings != Integer.MIN_VALUE && (curx != movx || cury != movy)) {
            crossings = Shape.rectCrossingsForLine(crossings, RECT_X_MIN, RECT_Y_MIN, RECT_X_MAX, RECT_Y_MAX, curx, cury, movx, movy);
        }
        return crossings;
    }

    public static int rectCrossingsForLine(int crossings, double RECT_X_MIN, double RECT_Y_MIN, double RECT_X_MAX, double RECT_Y_MAX, double X0, double Y0, double X1, double Y1) {
        if (Y0 >= RECT_Y_MAX && Y1 >= RECT_Y_MAX) {
            return crossings;
        }
        if (Y0 <= RECT_Y_MIN && Y1 <= RECT_Y_MIN) {
            return crossings;
        }
        if (X0 <= RECT_X_MIN && X1 <= RECT_X_MIN) {
            return crossings;
        }
        if (X0 >= RECT_X_MAX && X1 >= RECT_X_MAX) {
            if (Y0 < Y1) {
                if (Y0 <= RECT_Y_MIN) {
                    ++crossings;
                }
                if (Y1 >= RECT_Y_MAX) {
                    ++crossings;
                }
            } else if (Y1 < Y0) {
                if (Y1 <= RECT_Y_MIN) {
                    --crossings;
                }
                if (Y0 >= RECT_Y_MAX) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (X0 > RECT_X_MIN && X0 < RECT_X_MAX && Y0 > RECT_Y_MIN && Y0 < RECT_Y_MAX || X1 > RECT_X_MIN && X1 < RECT_X_MAX && Y1 > RECT_Y_MIN && Y1 < RECT_Y_MAX) {
            return Integer.MIN_VALUE;
        }
        double xi0 = X0;
        if (Y0 < RECT_Y_MIN) {
            xi0 += (RECT_Y_MIN - Y0) * (X1 - X0) / (Y1 - Y0);
        } else if (Y0 > RECT_Y_MAX) {
            xi0 += (RECT_Y_MAX - Y0) * (X1 - X0) / (Y1 - Y0);
        }
        double xi1 = X1;
        if (Y1 < RECT_Y_MIN) {
            xi1 += (RECT_Y_MIN - Y1) * (X0 - X1) / (Y0 - Y1);
        } else if (Y1 > RECT_Y_MAX) {
            xi1 += (RECT_Y_MAX - Y1) * (X0 - X1) / (Y0 - Y1);
        }
        if (xi0 <= RECT_X_MIN && xi1 <= RECT_X_MIN) {
            return crossings;
        }
        if (xi0 >= RECT_X_MAX && xi1 >= RECT_X_MAX) {
            if (Y0 < Y1) {
                if (Y0 <= RECT_Y_MIN) {
                    ++crossings;
                }
                if (Y1 >= RECT_Y_MAX) {
                    ++crossings;
                }
            } else if (Y1 < Y0) {
                if (Y1 <= RECT_Y_MIN) {
                    --crossings;
                }
                if (Y0 >= RECT_Y_MAX) {
                    --crossings;
                }
            }
            return crossings;
        }
        return Integer.MIN_VALUE;
    }

    public static int rectCrossingsForQuad(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
        if (y0 >= rymax && yc >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 < rxmax && x0 > rxmin && y0 < rymax && y0 > rymin || x1 < rxmax && x1 > rxmin && y1 < rymax && y1 > rymin) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        double x0c = (x0 + xc) / 2.0;
        double y0c = (y0 + yc) / 2.0;
        double xc1 = (xc + x1) / 2.0;
        double yc1 = (yc + y1) / 2.0;
        xc = (x0c + xc1) / 2.0;
        yc = (y0c + yc1) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        if ((crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x0c, y0c, xc, yc, level + 1)) != Integer.MIN_VALUE) {
            crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, xc, yc, xc1, yc1, x1, y1, level + 1);
        }
        return crossings;
    }

    public static int rectCrossingsForCubic(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
        if (y0 >= rymax && yc0 >= rymax && yc1 >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc0 <= rymin && yc1 <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc0 <= rxmin && xc1 <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc0 >= rxmax && xc1 >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        double xmid = (xc0 + xc1) / 2.0;
        double ymid = (yc0 + yc1) / 2.0;
        xc0 = (x0 + xc0) / 2.0;
        yc0 = (y0 + yc0) / 2.0;
        xc1 = (xc1 + x1) / 2.0;
        yc1 = (yc1 + y1) / 2.0;
        double xc0m = (xc0 + xmid) / 2.0;
        double yc0m = (yc0 + ymid) / 2.0;
        double xmc1 = (xmid + xc1) / 2.0;
        double ymc1 = (ymid + yc1) / 2.0;
        xmid = (xc0m + xmc1) / 2.0;
        ymid = (yc0m + ymc1) / 2.0;
        if (Double.isNaN(xmid) || Double.isNaN(ymid)) {
            return 0;
        }
        if ((crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, x0, y0, xc0, yc0, xc0m, yc0m, xmid, ymid, level + 1)) != Integer.MIN_VALUE) {
            crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, xmid, ymid, xmc1, ymc1, xc1, yc1, x1, y1, level + 1);
        }
        return crossings;
    }

    static boolean intersectsLine(double rx1, double ry1, double rwidth, double rheight, double x1, double y1, double x2, double y2) {
        int out1;
        int out2 = Shape.outcode(rx1, ry1, rwidth, rheight, x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = Shape.outcode(rx1, ry1, rwidth, rheight, x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                if ((out1 & 4) != 0) {
                    rx1 += rwidth;
                }
                y1 += (rx1 - x1) * (y2 - y1) / (x2 - x1);
                x1 = rx1;
                continue;
            }
            if ((out1 & 8) != 0) {
                ry1 += rheight;
            }
            x1 += (ry1 - y1) * (x2 - x1) / (y2 - y1);
            y1 = ry1;
        }
        return true;
    }

    static int outcode(double RECT_X, double RECT_Y, double RECT_WIDTH, double RECT_HEIGHT, double X, double Y) {
        int out = 0;
        if (RECT_WIDTH <= 0.0) {
            out |= 5;
        } else if (X < RECT_X) {
            out |= 1;
        } else if (X > RECT_X + RECT_WIDTH) {
            out |= 4;
        }
        if (RECT_HEIGHT <= 0.0) {
            out |= 0xA;
        } else if (Y < RECT_Y) {
            out |= 2;
        } else if (Y > RECT_Y + RECT_HEIGHT) {
            out |= 8;
        }
        return out;
    }

    public static void accumulate(double[] bbox, Shape s, BaseTransform tx) {
        PathIterator pi = s.getPathIterator(tx);
        double[] coords = new double[6];
        double mx = 0.0;
        double my = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    mx = coords[0];
                    my = coords[1];
                }
                case 1: {
                    x0 = coords[0];
                    y0 = coords[1];
                    if (bbox[0] > x0) {
                        bbox[0] = x0;
                    }
                    if (bbox[1] > y0) {
                        bbox[1] = y0;
                    }
                    if (bbox[2] < x0) {
                        bbox[2] = x0;
                    }
                    if (!(bbox[3] < y0)) break;
                    bbox[3] = y0;
                    break;
                }
                case 2: {
                    double x1 = coords[2];
                    double y1 = coords[3];
                    if (bbox[0] > x1) {
                        bbox[0] = x1;
                    }
                    if (bbox[1] > y1) {
                        bbox[1] = y1;
                    }
                    if (bbox[2] < x1) {
                        bbox[2] = x1;
                    }
                    if (bbox[3] < y1) {
                        bbox[3] = y1;
                    }
                    if (bbox[0] > coords[0] || bbox[2] < coords[0]) {
                        Shape.accumulateQuad(bbox, 0, x0, coords[0], x1);
                    }
                    if (bbox[1] > coords[1] || bbox[3] < coords[1]) {
                        Shape.accumulateQuad(bbox, 1, y0, coords[1], y1);
                    }
                    x0 = x1;
                    y0 = y1;
                    break;
                }
                case 3: {
                    double x1 = coords[4];
                    double y1 = coords[5];
                    if (bbox[0] > x1) {
                        bbox[0] = x1;
                    }
                    if (bbox[1] > y1) {
                        bbox[1] = y1;
                    }
                    if (bbox[2] < x1) {
                        bbox[2] = x1;
                    }
                    if (bbox[3] < y1) {
                        bbox[3] = y1;
                    }
                    if (bbox[0] > coords[0] || bbox[2] < coords[0] || bbox[0] > coords[2] || bbox[2] < coords[2]) {
                        Shape.accumulateCubic(bbox, 0, x0, coords[0], coords[2], x1);
                    }
                    if (bbox[1] > coords[1] || bbox[3] < coords[1] || bbox[1] > coords[3] || bbox[3] < coords[3]) {
                        Shape.accumulateCubic(bbox, 1, y0, coords[1], coords[3], y1);
                    }
                    x0 = x1;
                    y0 = y1;
                    break;
                }
                case 4: {
                    x0 = mx;
                    y0 = my;
                }
            }
            pi.next();
        }
    }

    public static void accumulateQuad(double[] bbox, int off, double v0, double vc, double v1) {
        double t;
        double num = v0 - vc;
        double den = v1 - vc + num;
        if (den != 0.0 && (t = num / den) > 0.0 && t < 1.0) {
            double u = 1.0 - t;
            double v = v0 * u * u + 2.0 * vc * t * u + v1 * t * t;
            if (bbox[off] > v) {
                bbox[off] = v;
            }
            if (bbox[off + 2] < v) {
                bbox[off + 2] = v;
            }
        }
    }

    public static void accumulateCubic(double[] bbox, int off, double v0, double vc0, double vc1, double v1) {
        double c = vc0 - v0;
        double b = 2.0 * (vc1 - vc0 - c);
        double a = v1 - vc1 - b - c;
        if (Double.compare(a, 0.0) == 0) {
            if (Double.compare(b, 0.0) == 0) {
                return;
            }
            Shape.accumulateCubic(bbox, off, -c / b, v0, vc0, vc1, v1);
        } else {
            double d = b * b - 4.0 * a * c;
            if (d < 0.0) {
                return;
            }
            d = Math.sqrt(d);
            if (b < 0.0) {
                d = -d;
            }
            double q = (b + d) / -2.0;
            Shape.accumulateCubic(bbox, off, q / a, v0, vc0, vc1, v1);
            if (q != 0.0) {
                Shape.accumulateCubic(bbox, off, c / q, v0, vc0, vc1, v1);
            }
        }
    }

    public static void accumulateCubic(double[] bbox, int off, double t, double v0, double vc0, double vc1, double v1) {
        if (t > 0.0 && t < 1.0) {
            double u = 1.0 - t;
            double v = v0 * u * u * u + 3.0 * vc0 * t * u * u + 3.0 * vc1 * t * t * u + v1 * t * t * t;
            if (bbox[off] > v) {
                bbox[off] = v;
            }
            if (bbox[off + 2] < v) {
                bbox[off + 2] = v;
            }
        }
    }
}

