/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.BubbleGridChart;
import eu.hansolo.fx.charts.data.BubbleGridChartItem;
import eu.hansolo.fx.charts.tools.Order;
import eu.hansolo.fx.charts.tools.Topic;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;

public class BubbleGridChartBuilder<B extends BubbleGridChartBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected BubbleGridChartBuilder() {
    }

    public static final BubbleGridChartBuilder create() {
        return new BubbleGridChartBuilder();
    }

    public final B items(BubbleGridChartItem ... ITEMS) {
        this.properties.put("itemsArray", (Property)new SimpleObjectProperty((Object)ITEMS));
        return (B)this;
    }

    public final B items(List<BubbleGridChartItem> ITEMS) {
        this.properties.put("itemsList", (Property)new SimpleObjectProperty(ITEMS));
        return (B)this;
    }

    public final B chartBackground(Color COLOR) {
        this.properties.put("chartBackground", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B gridColor(Color COLOR) {
        this.properties.put("gridColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B autoBubbleTextColor(boolean AUTO) {
        this.properties.put("autoBubbleTextColor", (Property)new SimpleBooleanProperty(AUTO));
        return (B)this;
    }

    public final B showGrid(boolean SHOW) {
        this.properties.put("showGrid", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showValues(boolean SHOW) {
        this.properties.put("showValues", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B showPercentage(boolean SHOW) {
        this.properties.put("showPercentage", (Property)new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B useXCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B useYCategoryFill() {
        this.properties.put("useXCategoryFill", null);
        return (B)this;
    }

    public final B sortCategoryX(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryXTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryXOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B sortCategoryY(Topic TOPIC, Order ORDER) {
        this.properties.put("sortCategoryYTopic", (Property)new SimpleObjectProperty((Object)TOPIC));
        this.properties.put("sortCategoryYOrder", (Property)new SimpleObjectProperty((Object)ORDER));
        return (B)this;
    }

    public final B useGradientFill(boolean USE) {
        this.properties.put("useGradientFill", (Property)new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B shortenNumbers(boolean SHORTEN) {
        this.properties.put("shortenNumbers", (Property)new SimpleBooleanProperty(SHORTEN));
        return (B)this;
    }

    public final B minColor(Color MIN_COLOR) {
        this.properties.put("minColor", (Property)new SimpleObjectProperty((Object)MIN_COLOR));
        return (B)this;
    }

    public final B maxColor(Color MAX_COLOR) {
        this.properties.put("maxColor", (Property)new SimpleObjectProperty((Object)MAX_COLOR));
        return (B)this;
    }

    public final B gradient(LinearGradient GRADIENT) {
        this.properties.put("gradient", (Property)new SimpleObjectProperty((Object)GRADIENT));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final BubbleGridChart build() {
        BubbleGridChart control = new BubbleGridChart();
        if (this.properties.keySet().contains("itemsArray")) {
            control.setItems((BubbleGridChartItem[])((ObjectProperty)this.properties.get("itemsArray")).get());
        }
        if (this.properties.keySet().contains("itemsList")) {
            control.setItems((List)((ObjectProperty)this.properties.get("itemsList")).get());
        }
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "chartBackground": {
                    control.setChartBackground((Paint)((ObjectProperty)property).get());
                    break;
                }
                case "textColor": {
                    control.setTextColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "autoBubbleTextColor": {
                    control.setAutoBubbleTextColor(((BooleanProperty)property).get());
                    break;
                }
                case "gridColor": {
                    control.setGridColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "showGrid": {
                    control.setShowGrid(((BooleanProperty)property).get());
                    break;
                }
                case "showValues": {
                    control.setShowValues(((BooleanProperty)property).get());
                    break;
                }
                case "showPercentage": {
                    control.setShowPercentage(((BooleanProperty)property).get());
                    break;
                }
                case "useXCategoryFill": {
                    control.useXCategoryFill();
                    break;
                }
                case "useYCategoryFill": {
                    control.useYCategoryFill();
                    break;
                }
                case "sortCategoryXTopic": {
                    control.sortCategoryX((Topic)((Object)((Object)((ObjectProperty)this.properties.get("sortCategoryXTopic")).get())), (Order)((Object)((Object)((ObjectProperty)this.properties.get("sortCategoryXOrder")).get())));
                    break;
                }
                case "sortCategoryYTopic": {
                    control.sortCategoryY((Topic)((Object)((Object)((ObjectProperty)this.properties.get("sortCategoryYTopic")).get())), (Order)((Object)((Object)((ObjectProperty)this.properties.get("sortCategoryYOrder")).get())));
                    break;
                }
                case "useGradientFill": {
                    control.setUseGradientFill(((BooleanProperty)property).get());
                    break;
                }
                case "shortenNumbers": {
                    control.setShortenNumbers(((BooleanProperty)property).get());
                    break;
                }
                case "minColor": {
                    control.setMinColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "maxColor": {
                    control.setMaxColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "gradient": {
                    control.setGradient((LinearGradient)((ObjectProperty)property).get());
                }
            }
        });
        return control;
    }
}

