/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.Grid;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.paint.Paint;

public class GridBuilder<B extends GridBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private Axis xAxis;
    private Axis yAxis;

    protected GridBuilder(Axis X_AXIS, Axis Y_AXIS) {
        this.xAxis = X_AXIS;
        this.yAxis = Y_AXIS;
    }

    public static final GridBuilder create(Axis X_AXIS, Axis Y_AXIS) {
        return new GridBuilder(X_AXIS, Y_AXIS);
    }

    public final B majorHGridLinePaint(Paint PAINT) {
        this.properties.put("majorHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B mediumHGridLinePaint(Paint PAINT) {
        this.properties.put("mediumHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B minorHGridLinePaint(Paint PAINT) {
        this.properties.put("minorHGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B majorVGridLinePaint(Paint PAINT) {
        this.properties.put("majorVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B mediumVGridLinePaint(Paint PAINT) {
        this.properties.put("mediumVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B minorVGridLinePaint(Paint PAINT) {
        this.properties.put("minorVGridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B gridLinePaint(Paint PAINT) {
        this.properties.put("gridLinePaint", (Property)new SimpleObjectProperty((Object)PAINT));
        return (B)this;
    }

    public final B majorHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("majorHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("mediumHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorHGridLinesVisible(boolean VISIBLE) {
        this.properties.put("minorHGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B majorVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("majorVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mediumVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("mediumVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minorVGridLinesVisible(boolean VISIBLE) {
        this.properties.put("minorVGridLinesVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B gridOpacity(double OPACITY) {
        this.properties.put("opacity", (Property)new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B gridLineDashes(double ... DASHES) {
        this.properties.put("dashesArray", (Property)new SimpleObjectProperty((Object)DASHES));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final Grid build() {
        Grid control = new Grid(this.xAxis, this.yAxis);
        if (this.properties.keySet().contains("dashesArray")) {
            control.setGridLineDashes((double[])((ObjectProperty)this.properties.get("dashesArray")).get());
        }
        this.properties.forEach((key, property) -> {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setPrefSize(dim.getWidth(), dim.getHeight());
            } else if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setMinSize(dim.getWidth(), dim.getHeight());
            } else if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                control.setMaxSize(dim.getWidth(), dim.getHeight());
            } else if ("prefWidth".equals(key)) {
                control.setPrefWidth(((DoubleProperty)property).get());
            } else if ("prefHeight".equals(key)) {
                control.setPrefHeight(((DoubleProperty)property).get());
            } else if ("minWidth".equals(key)) {
                control.setMinWidth(((DoubleProperty)property).get());
            } else if ("minHeight".equals(key)) {
                control.setMinHeight(((DoubleProperty)property).get());
            } else if ("maxWidth".equals(key)) {
                control.setMaxWidth(((DoubleProperty)property).get());
            } else if ("maxHeight".equals(key)) {
                control.setMaxHeight(((DoubleProperty)property).get());
            } else if ("scaleX".equals(key)) {
                control.setScaleX(((DoubleProperty)property).get());
            } else if ("scaleY".equals(key)) {
                control.setScaleY(((DoubleProperty)property).get());
            } else if ("layoutX".equals(key)) {
                control.setLayoutX(((DoubleProperty)property).get());
            } else if ("layoutY".equals(key)) {
                control.setLayoutY(((DoubleProperty)property).get());
            } else if ("translateX".equals(key)) {
                control.setTranslateX(((DoubleProperty)property).get());
            } else if ("translateY".equals(key)) {
                control.setTranslateY(((DoubleProperty)property).get());
            } else if ("padding".equals(key)) {
                control.setPadding((Insets)((ObjectProperty)property).get());
            } else if ("gridLinePaint".equals(key)) {
                control.setGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("majorHGridLinePaint".equals(key)) {
                control.setMajorHGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("mediumHGridLinePaint".equals(key)) {
                control.setMediumHGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("minorHGridLinePaint".equals(key)) {
                control.setMinorHGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("majorVGridLinePaint".equals(key)) {
                control.setMajorVGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("mediumVGridLinePaint".equals(key)) {
                control.setMediumVGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("minorVGridLinePaint".equals(key)) {
                control.setMinorVGridLinePaint((Paint)((ObjectProperty)property).get());
            } else if ("majorHGridLinesVisible".equals(key)) {
                control.setMajorHGridLinesVisible(((BooleanProperty)property).get());
            } else if ("mediumHGridLinesVisible".equals(key)) {
                control.setMediumHGridLinesVisible(((BooleanProperty)property).get());
            } else if ("minorHGridLinesVisible".equals(key)) {
                control.setMinorHGridLinesVisible(((BooleanProperty)property).get());
            } else if ("majorVGridLinesVisible".equals(key)) {
                control.setMajorVGridLinesVisible(((BooleanProperty)property).get());
            } else if ("mediumVGridLinesVisible".equals(key)) {
                control.setMediumVGridLinesVisible(((BooleanProperty)property).get());
            } else if ("minorVGridLinesVisible".equals(key)) {
                control.setMinorVGridLinesVisible(((BooleanProperty)property).get());
            } else if ("gridOpacity".equals(key)) {
                control.setGridOpacity(((DoubleProperty)property).get());
            }
        });
        return control;
    }
}

