/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.data.TreeNode;
import eu.hansolo.fx.charts.event.TreeNodeEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TextOrientation;
import eu.hansolo.fx.charts.tools.VisibleData;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.font.Fonts;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class SunburstChart<T extends ChartItem>
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color BRIGHT_TEXT_COLOR = Color.WHITE;
    private static final Color DARK_TEXT_COLOR = Color.BLACK;
    private double size;
    private double width;
    private double height;
    private double center;
    private Pane segmentPane;
    private Canvas chartCanvas;
    private GraphicsContext chartCtx;
    private Pane pane;
    private Paint backgroundPaint = Color.TRANSPARENT;
    private Paint borderPaint = Color.TRANSPARENT;
    private double borderWidth = 0.0;
    private List<Path> segments = new ArrayList<Path>(64);
    private VisibleData _visibleData = VisibleData.NAME;
    private ObjectProperty<VisibleData> visibleData;
    private TextOrientation _textOrientation = TextOrientation.TANGENT;
    private ObjectProperty<TextOrientation> textOrientation;
    private Color _backgroundColor = Color.WHITE;
    private ObjectProperty<Color> backgroundColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private boolean _useColorFromParent = false;
    private BooleanProperty useColorFromParent;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _interactive = false;
    private BooleanProperty interactive;
    private boolean _autoTextColor = true;
    private BooleanProperty autoTextColor;
    private Color _brightTextColor = BRIGHT_TEXT_COLOR;
    private ObjectProperty<Color> brightTextColor;
    private Color _darkTextColor = DARK_TEXT_COLOR;
    private ObjectProperty<Color> darkTextColor;
    private boolean _useChartItemTextColor = false;
    private BooleanProperty useChartItemTextColor;
    private String formatString = "%.0f";
    private TreeNode<T> tree;
    private TreeNode<T> root;
    private int maxLevel;
    private Map<Integer, List<TreeNode<T>>> levelMap;
    private InvalidationListener sizeListener;
    private final EvtObserver<TreeNodeEvt<T>> treeNodeEvtObserver;

    public SunburstChart() {
        this(new TreeNode<ChartItem>(new ChartItem()));
    }

    public SunburstChart(TreeNode<T> TREE) {
        this.tree = TREE;
        this.levelMap = new HashMap<Integer, List<TreeNode<T>>>(8);
        this.sizeListener = o -> this.resize();
        this.treeNodeEvtObserver = evt -> {
            if (evt.getEvtType().equals(TreeNodeEvt.NODE_SELECTED)) {
                this.redraw();
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.segmentPane = new Pane();
        this.chartCanvas = new Canvas(250.0, 250.0);
        this.chartCanvas.setMouseTransparent(true);
        this.chartCtx = this.chartCanvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.segmentPane, this.chartCanvas});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.prepareData();
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.sizeListener);
        this.heightProperty().addListener(this.sizeListener);
        this.tree.addTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.widthProperty().removeListener(this.sizeListener);
        this.heightProperty().removeListener(this.sizeListener);
        this.tree.removeTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
    }

    public VisibleData getVisibleData() {
        return null == this.visibleData ? this._visibleData : (VisibleData)((Object)this.visibleData.get());
    }

    public void setVisibleData(VisibleData VISIBLE_DATA) {
        if (null == this.visibleData) {
            this._visibleData = VISIBLE_DATA;
            this.redraw();
        } else {
            this.visibleData.set((Object)VISIBLE_DATA);
        }
    }

    public ObjectProperty<VisibleData> visibleDataProperty() {
        if (null == this.visibleData) {
            this.visibleData = new ObjectPropertyBase<VisibleData>(this._visibleData){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "visibleData";
                }
            };
            this._visibleData = null;
        }
        return this.visibleData;
    }

    public TextOrientation getTextOrientation() {
        return null == this.textOrientation ? this._textOrientation : (TextOrientation)((Object)this.textOrientation.get());
    }

    public void setTextOrientation(TextOrientation ORIENTATION) {
        if (null == this.textOrientation) {
            this._textOrientation = ORIENTATION;
            this.redraw();
        } else {
            this.textOrientation.set((Object)ORIENTATION);
        }
    }

    public ObjectProperty<TextOrientation> textOrientationProperty() {
        if (null == this.textOrientation) {
            this.textOrientation = new ObjectPropertyBase<TextOrientation>(this._textOrientation){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "textOrientation";
                }
            };
            this._textOrientation = null;
        }
        return this.textOrientation;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public boolean getUseColorFromParent() {
        return null == this.useColorFromParent ? this._useColorFromParent : this.useColorFromParent.get();
    }

    public void setUseColorFromParent(boolean USE) {
        if (null == this.useColorFromParent) {
            this._useColorFromParent = USE;
            this.redraw();
        } else {
            this.useColorFromParent.set(USE);
        }
    }

    public BooleanProperty useColorFromParentProperty() {
        if (null == this.useColorFromParent) {
            this.useColorFromParent = new BooleanPropertyBase(this._useColorFromParent){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "useColorFromParent";
                }
            };
        }
        return this.useColorFromParent;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 5, DECIMALS);
            this.formatString = "%." + this._decimals + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 5, this.get()));
                    SunburstChart.this.formatString = "%." + this.get() + "f";
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public void setInteractive(boolean INTERACTIVE) {
        if (null == this.interactive) {
            this._interactive = INTERACTIVE;
            this.redraw();
        } else {
            this.interactive.set(INTERACTIVE);
        }
    }

    public BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(this._interactive){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    public boolean isAutoTextColor() {
        return null == this.autoTextColor ? this._autoTextColor : this.autoTextColor.get();
    }

    public void setAutoTextColor(boolean AUTOMATIC) {
        if (null == this.autoTextColor) {
            this._autoTextColor = AUTOMATIC;
            this.adjustTextColors();
            this.redraw();
        } else {
            this.autoTextColor.set(AUTOMATIC);
        }
    }

    public BooleanProperty autoTextColorProperty() {
        if (null == this.autoTextColor) {
            this.autoTextColor = new BooleanPropertyBase(this._autoTextColor){

                protected void invalidated() {
                    SunburstChart.this.adjustTextColors();
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "autoTextColor";
                }
            };
        }
        return this.autoTextColor;
    }

    public Color getBrightTextColor() {
        return null == this.brightTextColor ? this._brightTextColor : (Color)this.brightTextColor.get();
    }

    public void setBrightTextColor(Color COLOR) {
        if (null == this.brightTextColor) {
            this._brightTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.brightTextColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> brightTextColorProperty() {
        if (null == this.brightTextColor) {
            this.brightTextColor = new ObjectPropertyBase<Color>(this._brightTextColor){

                protected void invalidated() {
                    if (SunburstChart.this.isAutoTextColor()) {
                        SunburstChart.this.adjustTextColors();
                        SunburstChart.this.redraw();
                    }
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "brightTextColor";
                }
            };
            this._brightTextColor = null;
        }
        return this.brightTextColor;
    }

    public Color getDarkTextColor() {
        return null == this.darkTextColor ? this._darkTextColor : (Color)this.darkTextColor.get();
    }

    public void setDarkTextColor(Color COLOR) {
        if (null == this.darkTextColor) {
            this._darkTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.darkTextColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> darkTextColorProperty() {
        if (null == this.darkTextColor) {
            this.darkTextColor = new ObjectPropertyBase<Color>(this._darkTextColor){

                protected void invalidated() {
                    if (SunburstChart.this.isAutoTextColor()) {
                        SunburstChart.this.adjustTextColors();
                        SunburstChart.this.redraw();
                    }
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "darkTextColor";
                }
            };
            this._darkTextColor = null;
        }
        return this.darkTextColor;
    }

    public boolean getUseChartItemTextColor() {
        return null == this.useChartItemTextColor ? this._useChartItemTextColor : this.useChartItemTextColor.get();
    }

    public void setUseChartItemTextColor(boolean USE) {
        if (null == this.useChartItemTextColor) {
            this._useChartItemTextColor = USE;
            this.redraw();
        } else {
            this.useChartItemTextColor.set(USE);
        }
    }

    public BooleanProperty useChartItemTextColor() {
        if (null == this.useChartItemTextColor) {
            this.useChartItemTextColor = new BooleanPropertyBase(this._useChartItemTextColor){

                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                public Object getBean() {
                    return SunburstChart.this;
                }

                public String getName() {
                    return "useChartItemTextColor";
                }
            };
        }
        return this.useChartItemTextColor;
    }

    public void setTree(TreeNode<T> TREE) {
        if (null != this.tree) {
            this.tree.removeTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
        }
        this.tree = TREE;
        this.tree.addTreeNodeEvtObserver(TreeNodeEvt.NODE_SELECTED, this.treeNodeEvtObserver);
        this.prepareData();
        if (this.isAutoTextColor()) {
            this.adjustTextColors();
        }
        this.drawChart();
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    private void adjustTextColors() {
        Color brightColor = this.getBrightTextColor();
        Color darkColor = this.getDarkTextColor();
        this.root.stream().forEach(node -> {
            ChartItem item = (ChartItem)node.getItem();
            boolean darkFillColor = Helper.isDark(item.getFill());
            boolean darkTextColor = Helper.isDark(item.getTextFill());
            if (darkFillColor && darkTextColor) {
                item.setTextFill(brightColor);
            }
            if (!darkFillColor && !darkTextColor) {
                item.setTextFill(darkColor);
            }
        });
    }

    private void prepareData() {
        this.root = this.tree.getTreeRoot();
        this.maxLevel = this.root.getMaxLevel();
        this.levelMap.clear();
        for (int i = 0; i <= this.maxLevel; ++i) {
            this.levelMap.put(i, new ArrayList());
        }
        this.root.stream().forEach(node -> this.levelMap.get(node.getDepth()).add((TreeNode<T>)node));
    }

    private void drawChart() {
        this.levelMap.clear();
        for (int i = 0; i <= this.maxLevel; ++i) {
            this.levelMap.put(i, new ArrayList());
        }
        this.root.stream().forEach(node -> this.levelMap.get(node.getDepth()).add((TreeNode<T>)node));
        boolean isInteractive = this.isInteractive();
        double ringRadiusStep = this.size / 2.0 / ((double)this.maxLevel + 0.5);
        double innerCircle = ringRadiusStep * 0.5;
        double barWidth = isInteractive ? ringRadiusStep : ringRadiusStep * 0.98;
        double segmentStrokeWidth = ringRadiusStep * 0.02;
        Color bkgColor = this.getBackgroundColor();
        Color textColor = this.getTextColor();
        TextOrientation textOrientation = this.getTextOrientation();
        double maxTextWidth = barWidth * 0.9;
        this.chartCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.chartCtx.setFill((Paint)(isInteractive ? Color.TRANSPARENT : bkgColor));
        this.chartCtx.fillRect(0.0, 0.0, this.size, this.size);
        this.chartCtx.setFont(Fonts.latoRegular((double)(barWidth * 0.2)));
        this.chartCtx.setTextBaseline(VPos.CENTER);
        this.chartCtx.setTextAlign(TextAlignment.CENTER);
        this.chartCtx.setLineCap(StrokeLineCap.BUTT);
        this.segments.clear();
        HashMap<TreeNode<T>, Double> startAngles = new HashMap<TreeNode<T>, Double>();
        HashMap<TreeNode<T>, Double> angles = new HashMap<TreeNode<T>, Double>();
        double levelOneSum = Double.NaN;
        if (this.maxLevel >= 1) {
            levelOneSum = this.levelMap.get(1).stream().map(TreeNode::getItem).mapToDouble(ChartItem::getValue).sum();
        }
        double outerRadius = 0.0;
        for (int level = 1; level <= this.maxLevel; ++level) {
            List<TreeNode<T>> nodesAtLevel = this.levelMap.get(level);
            double innerRadius = level == 1 ? innerCircle : outerRadius;
            outerRadius = ringRadiusStep * (double)level + innerCircle;
            double segmentEndAngle = 0.0;
            TreeNode<T> currentParent = null;
            for (TreeNode<T> node2 : nodesAtLevel) {
                double segmentStartAngle;
                double segmentAngle;
                Color segmentColor;
                ChartItem segmentData = (ChartItem)node2.getItem();
                Color color = segmentColor = this.getUseColorFromParent() ? ((ChartItem)node2.getMyRoot().getItem()).getFill() : segmentData.getFill();
                if (level == 1) {
                    segmentPercentage = segmentData.getValue() / levelOneSum;
                    segmentAngle = segmentPercentage * 360.0;
                    segmentStartAngle = segmentEndAngle;
                } else {
                    assert (node2.getParent() != null);
                    if (!node2.getParent().equals(currentParent)) {
                        currentParent = node2.getParent();
                        segmentStartAngle = (Double)startAngles.get(currentParent);
                    } else {
                        segmentStartAngle = segmentEndAngle;
                    }
                    segmentPercentage = segmentData.getValue() / ((ChartItem)currentParent.getItem()).getValue();
                    segmentAngle = (Double)angles.get(currentParent) * segmentPercentage;
                }
                segmentEndAngle = segmentStartAngle + segmentAngle;
                assert (!Double.isNaN(segmentStartAngle));
                startAngles.put(node2, segmentStartAngle);
                angles.put(node2, segmentAngle);
                if (Color.TRANSPARENT.equals((Object)segmentData.getFill())) continue;
                double value = segmentData.getValue();
                if (isInteractive) {
                    this.segments.add(this.createSegment(segmentStartAngle, segmentEndAngle, innerRadius, outerRadius, (Paint)segmentColor, bkgColor, node2));
                } else {
                    double xy = this.center - ringRadiusStep * (double)level;
                    double wh = ringRadiusStep * (double)level * 2.0;
                    this.chartCtx.setLineWidth(barWidth);
                    this.chartCtx.setStroke((Paint)segmentColor);
                    this.chartCtx.strokeArc(xy, xy, wh, wh, -segmentStartAngle + 90.0, -segmentAngle, ArcType.OPEN);
                    double radStart = Math.toRadians(-segmentStartAngle + 90.0);
                    double cosStart = Math.cos(radStart);
                    double sinStart = Math.sin(radStart);
                    double x1 = this.center + innerRadius * cosStart;
                    double y1 = this.center - innerRadius * sinStart;
                    double x2 = this.center + outerRadius * cosStart;
                    double y2 = this.center - outerRadius * sinStart;
                    this.chartCtx.setLineWidth(segmentStrokeWidth);
                    this.chartCtx.setStroke((Paint)bkgColor);
                    this.chartCtx.strokeLine(x1, y1, x2, y2);
                }
                if (this.getVisibleData() == VisibleData.NONE || !(segmentAngle > textOrientation.getMaxAngle())) continue;
                double radText = Math.toRadians(segmentStartAngle + segmentAngle * 0.5);
                double cosText = Math.cos(radText);
                double sinText = Math.sin(radText);
                double textRadius = ringRadiusStep * (double)level;
                double textX = this.center + textRadius * sinText;
                double textY = this.center - textRadius * cosText;
                this.chartCtx.setFill((Paint)(this.getUseChartItemTextColor() ? segmentData.getTextFill() : textColor));
                this.chartCtx.save();
                this.chartCtx.translate(textX, textY);
                SunburstChart.rotateContextForText(this.chartCtx, segmentStartAngle, segmentAngle * 0.5, textOrientation);
                switch (this.getVisibleData()) {
                    case VALUE: {
                        this.chartCtx.fillText(String.format(Locale.US, this.formatString, value), 0.0, 0.0, maxTextWidth);
                        break;
                    }
                    case NAME: {
                        this.chartCtx.fillText(segmentData.getName(), 0.0, 0.0, maxTextWidth);
                        break;
                    }
                    case NAME_VALUE: {
                        this.chartCtx.fillText(String.join((CharSequence)"", segmentData.getName(), " (", String.format(Locale.US, this.formatString, value), ")"), 0.0, 0.0, maxTextWidth);
                    }
                }
                this.chartCtx.restore();
            }
        }
        this.segmentPane.getChildren().setAll(this.segments);
    }

    private Path createSegment(double START_ANGLE, double END_ANGLE, double INNER_RADIUS, double OUTER_RADIUS, Paint FILL, Color STROKE, TreeNode<T> NODE) {
        double startAngleRad = Math.toRadians(START_ANGLE);
        double endAngleRad = Math.toRadians(END_ANGLE);
        boolean largeAngle = Math.abs(END_ANGLE - START_ANGLE) > 180.0;
        double x1 = this.center + INNER_RADIUS * Math.sin(startAngleRad);
        double y1 = this.center - INNER_RADIUS * Math.cos(startAngleRad);
        double x2 = this.center + OUTER_RADIUS * Math.sin(startAngleRad);
        double y2 = this.center - OUTER_RADIUS * Math.cos(startAngleRad);
        double x3 = this.center + OUTER_RADIUS * Math.sin(endAngleRad);
        double y3 = this.center - OUTER_RADIUS * Math.cos(endAngleRad);
        double x4 = this.center + INNER_RADIUS * Math.sin(endAngleRad);
        double y4 = this.center - INNER_RADIUS * Math.cos(endAngleRad);
        if (Math.abs(x2 - x3) <= 0.001 && Math.abs(y3 - y2) <= 0.001 && END_ANGLE > 0.0) {
            x3 -= 1.0;
            x4 -= 1.0;
        }
        MoveTo moveTo1 = new MoveTo(x1, y1);
        LineTo lineTo2 = new LineTo(x2, y2);
        ArcTo arcTo3 = new ArcTo(OUTER_RADIUS, OUTER_RADIUS, 0.0, x3, y3, largeAngle, true);
        LineTo lineTo4 = new LineTo(x4, y4);
        ArcTo arcTo1 = new ArcTo(INNER_RADIUS, INNER_RADIUS, 0.0, x1, y1, largeAngle, false);
        Path path = new Path(new PathElement[]{moveTo1, lineTo2, arcTo3, lineTo4, arcTo1});
        path.setFill(FILL);
        path.setStroke((Paint)STROKE);
        String tooltipText = ((ChartItem)NODE.getItem()).getName() + "\n" + String.format(Locale.US, this.formatString, ((ChartItem)NODE.getItem()).getValue());
        Tooltip.install((Node)path, (Tooltip)new Tooltip(tooltipText));
        path.setOnMousePressed(e -> NODE.getTreeRoot().fireTreeNodeEvt(new TreeNodeEvt(NODE, TreeNodeEvt.NODE_SELECTED, NODE.getItem())));
        return path;
    }

    private static void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TextOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case TANGENT: {
                if (START_ANGLE + ANGLE < 180.0) {
                    CTX.rotate((START_ANGLE + ANGLE - 90.0) % 360.0);
                    break;
                }
                CTX.rotate((START_ANGLE + ANGLE + 90.0) % 360.0);
                break;
            }
            case ORTHOGONAL: {
                if (START_ANGLE + ANGLE < 270.0) {
                    CTX.rotate((START_ANGLE + ANGLE + 180.0) % 360.0);
                    break;
                }
                CTX.rotate(START_ANGLE + ANGLE);
                break;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = Math.min(this.width, this.height);
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.segmentPane.setPrefSize(this.size, this.size);
            this.chartCanvas.setWidth(this.size);
            this.chartCanvas.setHeight(this.size);
            this.center = this.size * 0.5;
            this.redraw();
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth / 250.0 * this.size))}));
        this.segmentPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.segmentPane.setManaged(this.isInteractive());
        this.segmentPane.setVisible(this.isInteractive());
        this.drawChart();
    }
}

