/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Category;
import eu.hansolo.fx.charts.ChartArea;
import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.data.ValueItem;
import eu.hansolo.fx.charts.series.YSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolboxfx.font.Fonts;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class YPane<T extends ValueItem>
extends Region
implements ChartArea {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 0.0;
    private static final double MINIMUM_HEIGHT = 0.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private static double aspectRatio;
    private boolean keepAspect;
    private double size;
    private double width;
    private double height;
    private Paint _chartBackground;
    private ObjectProperty<Paint> chartBackground;
    private List<YSeries<T>> listOfSeries;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double _thresholdY;
    private DoubleProperty thresholdY;
    private boolean _thresholdYVisible;
    private BooleanProperty thresholdYVisible;
    private Color _thresholdYColor;
    private ObjectProperty<Color> thresholdYColor;
    private Color _categoryColor;
    private ObjectProperty<Color> categoryColor;
    private boolean valid;
    private double _lowerBoundY;
    private DoubleProperty lowerBoundY;
    private double _upperBoundY;
    private DoubleProperty upperBoundY;
    private boolean _zeroRadarOffset;
    private BooleanProperty zeroRadarOffset;
    private ObservableList<Category> categories;

    public YPane(YSeries<T> ... SERIES) {
        this((Paint)Color.TRANSPARENT, new ArrayList<Category>(), SERIES);
    }

    public YPane(List<Category> CATEGORIES, YSeries<T> ... SERIES) {
        this((Paint)Color.TRANSPARENT, CATEGORIES, SERIES);
    }

    public YPane(List<Category> CATEGORIES, List<YSeries<T>> SERIES) {
        this((Paint)Color.TRANSPARENT, CATEGORIES, SERIES.toArray(new YSeries[SERIES.size()]));
    }

    public YPane(Paint BACKGROUND, YSeries<T> ... SERIES) {
        this(BACKGROUND, new ArrayList<Category>(), SERIES);
    }

    public YPane(Paint BACKGROUND, List<Category> CATEGORIES, YSeries<T> ... SERIES) {
        this.getStylesheets().add((Object)YPane.class.getResource("chart.css").toExternalForm());
        aspectRatio = 1.0;
        this.keepAspect = false;
        this._chartBackground = BACKGROUND;
        this.listOfSeries = FXCollections.observableArrayList((Object[])SERIES);
        this._thresholdY = 100.0;
        this._thresholdYVisible = false;
        this._thresholdYColor = Color.RED;
        this._categoryColor = Color.BLACK;
        this._lowerBoundY = 0.0;
        this._upperBoundY = 100.0;
        this._zeroRadarOffset = false;
        this.categories = FXCollections.observableArrayList(CATEGORIES);
        this.valid = this.isChartTypeValid();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().setAll((Object[])new String[]{"chart", "xy-chart"});
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.listOfSeries.forEach(series -> series.setOnSeriesEvent(seriesEvent -> this.redraw()));
        this.categories.addListener(c -> this.redraw());
    }

    protected double computeMinWidth(double HEIGHT) {
        return 0.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 0.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    @Override
    public void setChartBackground(Paint PAINT) {
        if (null == this.chartBackground) {
            this._chartBackground = PAINT;
            this.redraw();
        } else {
            this.chartBackground.set((Object)PAINT);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public double getThresholdY() {
        return null == this.thresholdY ? this._thresholdY : this.thresholdY.get();
    }

    public void setThresholdY(double THRESHOLD) {
        if (null == this.thresholdY) {
            this._thresholdY = THRESHOLD;
            this.redraw();
        } else {
            this.thresholdY.set(THRESHOLD);
        }
    }

    public DoubleProperty thresholdYProperty() {
        if (null == this.thresholdY) {
            this.thresholdY = new DoublePropertyBase(this._thresholdY){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "thresholdY";
                }
            };
        }
        return this.thresholdY;
    }

    public boolean isThresholdYVisible() {
        return null == this.thresholdYVisible ? this._thresholdYVisible : this.thresholdYVisible.get();
    }

    public void setThresholdYVisible(boolean VISIBLE) {
        if (null == this.thresholdYVisible) {
            this._thresholdYVisible = VISIBLE;
            this.redraw();
        } else {
            this.thresholdYVisible.set(VISIBLE);
        }
    }

    public BooleanProperty thresholdYVisibleProperty() {
        if (null == this.thresholdYVisible) {
            this.thresholdYVisible = new BooleanPropertyBase(this._thresholdYVisible){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "thresholdYVisible";
                }
            };
        }
        return this.thresholdYVisible;
    }

    public Color getThresholdYColor() {
        return null == this.thresholdYColor ? this._thresholdYColor : (Color)this.thresholdYColor.get();
    }

    public void setThresholdYColor(Color COLOR) {
        if (null == this.thresholdYColor) {
            this._thresholdYColor = COLOR;
            this.redraw();
        } else {
            this.thresholdYColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> thresholdYColorProperty() {
        if (null == this.thresholdYColor) {
            this.thresholdYColor = new ObjectPropertyBase<Color>(this._thresholdYColor){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "thresholdYColor";
                }
            };
            this._thresholdYColor = null;
        }
        return this.thresholdYColor;
    }

    public Color getCategoryColor() {
        return null == this.categoryColor ? this._categoryColor : (Color)this.categoryColor.get();
    }

    public void setCategoryColor(Color COLOR) {
        if (null == this.categoryColor) {
            this._categoryColor = COLOR;
            this.redraw();
        } else {
            this.categoryColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> categoryColorProperty() {
        if (null == this.categoryColor) {
            this.categoryColor = new ObjectPropertyBase<Color>(this._categoryColor){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "categoryColor";
                }
            };
            this._categoryColor = null;
        }
        return this.categoryColor;
    }

    public double getLowerBoundY() {
        return null == this.lowerBoundY ? this._lowerBoundY : this.lowerBoundY.get();
    }

    public void setLowerBoundY(double VALUE) {
        if (null == this.lowerBoundY) {
            this._lowerBoundY = VALUE;
            this.redraw();
        } else {
            this.lowerBoundY.set(VALUE);
        }
    }

    public DoubleProperty lowerBoundYProperty() {
        if (null == this.lowerBoundY) {
            this.lowerBoundY = new DoublePropertyBase(this._lowerBoundY){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "lowerBoundY";
                }
            };
        }
        return this.lowerBoundY;
    }

    public double getUpperBoundY() {
        return null == this.upperBoundY ? this._upperBoundY : this.upperBoundY.get();
    }

    public void setUpperBoundY(double VALUE) {
        if (null == this.upperBoundY) {
            this._upperBoundY = VALUE;
            this.redraw();
        } else {
            this.upperBoundY.set(VALUE);
        }
    }

    public DoubleProperty upperBoundYProperty() {
        if (null == this.upperBoundY) {
            this.upperBoundY = new DoublePropertyBase(this._upperBoundY){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "upperBoundY";
                }
            };
        }
        return this.upperBoundY;
    }

    public ObservableList<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories.setAll(categories);
    }

    public boolean getZeroRadarOffset() {
        return null == this.zeroRadarOffset ? this._zeroRadarOffset : this.zeroRadarOffset.get();
    }

    public void setZeroRadarOffset(boolean zeroRadarOffset) {
        if (null == this.zeroRadarOffset) {
            this._zeroRadarOffset = zeroRadarOffset;
            this.redraw();
        } else {
            this.zeroRadarOffset.set(zeroRadarOffset);
        }
    }

    public BooleanProperty zeroRadarOffsetProperty() {
        if (null == this.zeroRadarOffset) {
            this.zeroRadarOffset = new BooleanPropertyBase(this._zeroRadarOffset){

                protected void invalidated() {
                    YPane.this.redraw();
                }

                public Object getBean() {
                    return YPane.this;
                }

                public String getName() {
                    return "zeroRadarOffset";
                }
            };
        }
        return this.zeroRadarOffset;
    }

    public double getRangeY() {
        return this.getUpperBoundY() - this.getLowerBoundY();
    }

    public double getDataMinY() {
        return this.listOfSeries.stream().mapToDouble(YSeries::getMinY).min().getAsDouble();
    }

    public double getDataMaxY() {
        return this.listOfSeries.stream().mapToDouble(YSeries::getMaxY).max().getAsDouble();
    }

    public double getDataRangeY() {
        return this.getDataMaxY() - this.getDataMinY();
    }

    public List<YSeries<T>> getListOfSeries() {
        return this.listOfSeries;
    }

    public boolean containsRadarChart() {
        for (YSeries<T> series : this.listOfSeries) {
            ChartType type = series.getChartType();
            if (ChartType.RADAR_POLYGON != type && ChartType.RADAR_SECTOR != type && ChartType.SMOOTH_RADAR_POLYGON != type) continue;
            return true;
        }
        return false;
    }

    private void drawChart() {
        if (null == this.listOfSeries || this.listOfSeries.isEmpty()) {
            return;
        }
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.containsRadarChart()) {
            this.drawRadarOverlay(this.listOfSeries.get(0).getItems().size(), this.listOfSeries.get(0).getChartType());
        }
        for (YSeries<T> series : this.listOfSeries) {
            ChartType TYPE = series.getChartType();
            switch (TYPE) {
                case DONUT: {
                    this.drawDonut(series);
                    break;
                }
                case RADAR_POLYGON: 
                case SMOOTH_RADAR_POLYGON: 
                case RADAR_SECTOR: {
                    this.drawRadar(series);
                }
            }
        }
    }

    private void drawDonut(YSeries<T> SERIES) {
        if (null == SERIES) {
            return;
        }
        ObservableList<T> items = SERIES.getItems();
        int noOfItems = items.size();
        double center = this.size * 0.5;
        double innerRadius = this.size * 0.275;
        double outerRadius = this.size * 0.4;
        double barWidth = this.size * 0.1;
        double sum = items.stream().mapToDouble(ValueItem::getValue).sum();
        double stepSize = 360.0 / sum;
        double angle = 0.0;
        double startAngle = 90.0;
        double xy = this.size * 0.1;
        double wh = this.size * 0.8;
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        for (ValueItem item : items) {
            double value = item.getValue();
            angle = value * stepSize;
            this.ctx.setLineWidth(barWidth);
            this.ctx.setStroke((Paint)item.getFill());
            this.ctx.strokeArc(xy, xy, wh, wh, startAngle -= angle, -angle, ArcType.OPEN);
            if (!(angle > 8.0)) continue;
            double x = outerRadius * Math.cos(Math.toRadians(startAngle - angle * 0.5));
            double y = -outerRadius * Math.sin(Math.toRadians(startAngle - angle * 0.5));
            this.ctx.setFill((Paint)Color.WHITE);
            this.ctx.fillText(String.format(Locale.US, "%.0f", value), center + x, center + y, barWidth);
        }
    }

    private void drawRadar(YSeries<T> SERIES) {
        double CENTER_X;
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double LOWER_BOUND_Y = this.getLowerBoundY();
        double DATA_RANGE = this.getRangeY();
        boolean ZERO_RADAR_OFFSET = this.getZeroRadarOffset();
        double RANGE = ZERO_RADAR_OFFSET ? 0.5 * CIRCLE_SIZE : 0.35714 * CIRCLE_SIZE;
        double OFFSET = ZERO_RADAR_OFFSET ? 0.0 : 0.14286 * CIRCLE_SIZE;
        int NO_OF_SECTORS = SERIES.getItems().size();
        double angleStep = 360.0 / (double)NO_OF_SECTORS;
        this.ctx.save();
        if (SERIES.getFill() instanceof RadialGradient) {
            this.ctx.setFill((Paint)new RadialGradient(0.0, 0.0, this.size * 0.5, this.size * 0.5, this.size * 0.45, false, CycleMethod.NO_CYCLE, ((RadialGradient)SERIES.getFill()).getStops()));
        } else {
            this.ctx.setFill(SERIES.getFill());
        }
        this.ctx.setLineWidth(SERIES.getStrokeWidth() > -1.0 ? SERIES.getStrokeWidth() : this.size * 0.0025);
        this.ctx.setStroke(SERIES.getStroke());
        switch (SERIES.getChartType()) {
            case RADAR_POLYGON: {
                this.ctx.save();
                this.ctx.beginPath();
                this.ctx.moveTo(CENTER_X, 0.36239 * this.size);
                SERIES.getItems().forEach(item -> {
                    double r1 = (item.getValue() - LOWER_BOUND_Y) / DATA_RANGE;
                    this.ctx.lineTo(CENTER_X, CENTER_Y - OFFSET - r1 * RANGE);
                    Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, angleStep);
                });
                double r2 = SERIES.isWithWrapping() ? (((ValueItem)SERIES.getItems().get(0)).getValue() - LOWER_BOUND_Y) / DATA_RANGE : (((ValueItem)SERIES.getItems().get(NO_OF_SECTORS - 1)).getValue() - LOWER_BOUND_Y) / DATA_RANGE;
                this.ctx.lineTo(CENTER_X, CENTER_Y - OFFSET - r2 * RANGE);
                this.ctx.closePath();
                this.ctx.fill();
                this.ctx.stroke();
                this.ctx.restore();
                break;
            }
            case SMOOTH_RADAR_POLYGON: {
                double radAngle = Math.toRadians(180.0);
                double radAngleStep = Math.toRadians(angleStep);
                ArrayList<Point> points = new ArrayList<Point>();
                double x = CENTER_X + -Math.sin(radAngle) * (CENTER_Y - 0.36239 * this.size);
                double y = CENTER_Y + Math.cos(radAngle) * (CENTER_Y - 0.36239 * this.size);
                if (!SERIES.isWithWrapping()) {
                    points.add(new Point(x, y));
                }
                for (ValueItem item2 : SERIES.getItems()) {
                    double r1 = CENTER_Y - (CENTER_Y - OFFSET - (item2.getValue() - LOWER_BOUND_Y) / DATA_RANGE * RANGE);
                    x = CENTER_X + -Math.sin(radAngle) * r1;
                    y = CENTER_Y + Math.cos(radAngle) * r1;
                    points.add(new Point(x, y));
                    radAngle += radAngleStep;
                }
                double r3 = SERIES.isWithWrapping() ? CENTER_Y - (CENTER_Y - OFFSET - (((ValueItem)SERIES.getItems().get(0)).getValue() - LOWER_BOUND_Y) / DATA_RANGE * RANGE) : CENTER_Y - (CENTER_Y - OFFSET - (((ValueItem)SERIES.getItems().get(NO_OF_SECTORS - 1)).getValue() - LOWER_BOUND_Y) / DATA_RANGE * RANGE);
                x = CENTER_X + -Math.sin(radAngle) * r3;
                y = CENTER_Y + Math.cos(radAngle) * r3;
                points.add(new Point(x, y));
                Point[] interpolatedPoints = SERIES.isWithWrapping() ? Helper.subdividePointsRadial(points.toArray(new Point[0]), 16) : Helper.subdividePoints(points.toArray(new Point[0]), 16);
                this.ctx.beginPath();
                this.ctx.moveTo(interpolatedPoints[0].getX(), interpolatedPoints[0].getY());
                for (int i = 0; i < interpolatedPoints.length - 1; ++i) {
                    Point point = interpolatedPoints[i];
                    this.ctx.lineTo(point.getX(), point.getY());
                }
                this.ctx.lineTo(interpolatedPoints[interpolatedPoints.length - 1].getX(), interpolatedPoints[interpolatedPoints.length - 1].getY());
                this.ctx.closePath();
                this.ctx.fill();
                this.ctx.stroke();
                break;
            }
            case RADAR_SECTOR: {
                Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, -90.0);
                SERIES.getItems().forEach(item -> {
                    double r1 = (item.getValue() - LOWER_BOUND_Y) / DATA_RANGE;
                    this.ctx.beginPath();
                    this.ctx.moveTo(CENTER_X, CENTER_Y);
                    this.ctx.arc(CENTER_X, CENTER_Y, r1 * RANGE + OFFSET, r1 * RANGE + OFFSET, 0.0, -angleStep);
                    this.ctx.closePath();
                    this.ctx.fill();
                    this.ctx.stroke();
                    Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, angleStep);
                });
            }
        }
        this.ctx.restore();
    }

    private void drawRadarOverlay(int NO_OF_SECTORS, ChartType TYPE) {
        int i;
        double CENTER_X;
        double CENTER_Y = CENTER_X = 0.5 * this.size;
        double CIRCLE_SIZE = 0.9 * this.size;
        double DATA_RANGE = this.getRangeY();
        double MIN_VALUE = this.listOfSeries.stream().mapToDouble(YSeries::getMinY).min().getAsDouble();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        boolean ZERO_RADAR_OFFSET = this.getZeroRadarOffset();
        double OFFSET = ZERO_RADAR_OFFSET ? 0.0 : 0.14286 * CIRCLE_SIZE;
        double angleStep = 360.0 / (double)NO_OF_SECTORS;
        this.ctx.setLineWidth(1.0);
        this.ctx.setStroke((Paint)Color.GRAY);
        double ringStepSize = this.size / 20.0;
        double pos = 0.5 * (this.size - CIRCLE_SIZE);
        double ringSize = CIRCLE_SIZE;
        for (i = 0; i < 11; ++i) {
            this.ctx.strokeOval(pos, pos, ringSize, ringSize);
            pos += ringStepSize;
            ringSize -= 2.0 * ringStepSize;
        }
        this.ctx.save();
        for (i = 0; i < NO_OF_SECTORS; ++i) {
            this.ctx.strokeLine(CENTER_X, 0.05 * this.size, CENTER_X, 0.5 * this.size);
            Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, angleStep);
        }
        this.ctx.restore();
        if (this.isThresholdYVisible()) {
            double r = (this.getThresholdY() - MIN_VALUE) / DATA_RANGE;
            this.ctx.setLineWidth(Helper.clamp(1.0, 3.0, this.size * 0.005));
            this.ctx.setStroke((Paint)this.getThresholdYColor());
            this.ctx.strokeOval(0.5 * this.size - OFFSET - r * RANGE, 0.5 * this.size - OFFSET - r * RANGE, 2.0 * (r * RANGE + OFFSET), 2.0 * (r * RANGE + OFFSET));
        }
        this.ctx.save();
        if (ChartType.RADAR_SECTOR == TYPE) {
            Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, angleStep * 0.5);
        }
        this.ctx.save();
        this.ctx.setFont(Fonts.latoRegular((double)(0.025 * this.size)));
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFill((Paint)this.getCategoryColor());
        int index = this.categories.size();
        if (index > NO_OF_SECTORS) {
            index = NO_OF_SECTORS;
        }
        for (int i2 = 0; i2 < index; ++i2) {
            this.ctx.fillText(((Category)this.categories.get(i2)).getName(), CENTER_X, this.size * 0.03);
            Helper.rotateCtx(this.ctx, CENTER_X, CENTER_Y, angleStep);
        }
        this.ctx.restore();
        this.ctx.restore();
        Font font = Fonts.latoRegular((double)(0.025 * this.size));
        String minValueText = String.format(Locale.US, "%.0f", this.getLowerBoundY());
        String maxValueText = String.format(Locale.US, "%.0f", this.getUpperBoundY());
        this.ctx.save();
        this.ctx.setFont(font);
        Helper.drawTextWithBackground(this.ctx, minValueText, font, Color.WHITE, Color.BLACK, CENTER_X, CENTER_Y - this.size * 0.018);
        Helper.drawTextWithBackground(this.ctx, maxValueText, font, Color.WHITE, Color.BLACK, CENTER_X, CENTER_Y - CIRCLE_SIZE * 0.48);
        this.ctx.restore();
    }

    private boolean isChartTypeValid() {
        boolean containsDonut = false;
        boolean containsRadarSector = false;
        boolean containsRadarPolygon = false;
        boolean containsSmoothRadarPolygon = false;
        for (YSeries<T> series : this.getListOfSeries()) {
            ChartType TYPE = series.getChartType();
            containsDonut = ChartType.DONUT == TYPE && !containsDonut;
            containsRadarSector = ChartType.RADAR_SECTOR == TYPE && !containsRadarSector;
            containsRadarPolygon = ChartType.RADAR_POLYGON == TYPE && !containsRadarPolygon;
            containsSmoothRadarPolygon = ChartType.SMOOTH_RADAR_POLYGON == TYPE && !containsSmoothRadarPolygon;
        }
        boolean valid = false;
        if (containsDonut && !containsRadarSector && !containsRadarPolygon && !containsSmoothRadarPolygon) {
            valid = true;
        } else if (containsRadarSector && !containsDonut && !containsRadarPolygon && !containsSmoothRadarPolygon) {
            valid = true;
        } else if (containsRadarPolygon | containsSmoothRadarPolygon && !containsDonut && !containsRadarSector) {
            valid = true;
        }
        return valid;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.keepAspect) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.width - this.size) * 0.5, (this.height - this.size) * 0.5);
            this.redraw();
        }
    }

    protected void redraw() {
        this.drawChart();
    }
}

