/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.BubbleGridItem;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;

public class BubbleGridChartItem
implements BubbleGridItem {
    private final ChartEvt ITEM_EVENT = new ChartEvt(this, ChartEvt.ITEM_UPDATE);
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;
    private String _name;
    private StringProperty name;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private ChartItem _categoryX;
    private ObjectProperty<ChartItem> categoryX;
    private ChartItem _categoryY;
    private ObjectProperty<ChartItem> categoryY;
    private double _value;
    private DoubleProperty value;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;

    BubbleGridChartItem() {
        this("", Color.BLACK, Color.BLACK, Symbol.NONE, new ChartItem(), new ChartItem(), 0.0, false);
    }

    BubbleGridChartItem(boolean isEmpty) {
        this("", Color.BLACK, Color.BLACK, Symbol.NONE, new ChartItem(), new ChartItem(), 0.0, isEmpty);
    }

    BubbleGridChartItem(String name, Color fill, Color stroke, Symbol symbol, ChartItem categoryX, ChartItem categoryY, double value) {
        this(name, fill, stroke, symbol, categoryX, categoryY, value, false);
    }

    BubbleGridChartItem(String name, Color fill, Color stroke, Symbol symbol, ChartItem categoryX, ChartItem categoryY, double value, boolean isEmpty) {
        this._name = name;
        this._fill = fill;
        this._stroke = stroke;
        this._symbol = symbol;
        this._categoryX = categoryX;
        this._categoryY = categoryY;
        this._value = value;
        this._isEmpty = isEmpty;
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String name) {
        if (null == this.name) {
            this._name = name;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.name.set((Object)name);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color fill) {
        if (null == this.fill) {
            this._fill = fill;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)fill);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color stroke) {
        if (null == this.stroke) {
            this._stroke = stroke;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)stroke);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol symbol) {
        if (null == this.symbol) {
            this._symbol = symbol;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)symbol);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public ChartItem getCategoryX() {
        return null == this.categoryX ? this._categoryX : (ChartItem)this.categoryX.get();
    }

    @Override
    public void setCategoryX(ChartItem categoryX) {
        if (null == this.categoryX) {
            this._categoryX = categoryX;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.categoryX.set((Object)categoryX);
        }
    }

    @Override
    public ObjectProperty<ChartItem> categoryXProperty() {
        if (null == this.categoryX) {
            this.categoryX = new ObjectPropertyBase<ChartItem>(this._categoryX){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "categoryX";
                }
            };
            this._categoryX = null;
        }
        return this.categoryX;
    }

    @Override
    public ChartItem getCategoryY() {
        return null == this.categoryY ? this._categoryY : (ChartItem)this.categoryY.get();
    }

    @Override
    public void setCategoryY(ChartItem categoryY) {
        if (null == this.categoryY) {
            this._categoryY = categoryY;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.categoryY.set((Object)categoryY);
        }
    }

    @Override
    public ObjectProperty<ChartItem> categoryYProperty() {
        if (null == this.categoryY) {
            this.categoryY = new ObjectPropertyBase<ChartItem>(this._categoryY){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "categoryY";
                }
            };
            this._categoryY = null;
        }
        return this.categoryY;
    }

    @Override
    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    @Override
    public void setValue(double value) {
        if (null == this.value) {
            this._value = value;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.value.set(value);
        }
    }

    @Override
    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    @Override
    public boolean isEmptyItem() {
        return null == this.isEmpty ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (null == this.isEmpty) {
            this._isEmpty = isEmpty;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (null == this.isEmpty) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    BubbleGridChartItem.this.fireChartEvt(BubbleGridChartItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return BubbleGridChartItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }

    public String toString() {
        return "{\n" + "  \"name\":\"" + this.getName() + "\",\n" + "  \"categoryX\":" + this.getCategoryX() + ",\n" + "  \"categoryY\":" + this.getCategoryY() + ",\n" + "  \"value\":" + this.getValue() + ",\n" + "  \"symbol\":\"" + this.getSymbol().name() + "\"\n" + "}";
    }
}

