/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.forcedirectedgraph.NodeEdgeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;

public class GraphNode
extends ChartItem {
    private ObjectProperty<Point2D> disp;
    private ObjectProperty<Point2D> position;
    private HashMap<String, Double> numericAttributes;
    private HashMap<String, String> stringAttributes;
    private ArrayList<GraphNode> connectedNodes;
    private String SIZE_KEY;
    private boolean _selected;
    private BooleanProperty selected;

    public GraphNode(String NAME, Color COLOR, Map<String, Double> NUMERIC_ATTRIBUTES, Map<String, String> STRING_ATTRIBUTES) {
        this(Point2D.ZERO, NAME, COLOR, NUMERIC_ATTRIBUTES, STRING_ATTRIBUTES);
    }

    public GraphNode(String NAME, Map<String, Double> NUMERIC_ATTRIBUTES, Map<String, String> STRING_ATTRIBUTES) {
        this(NAME, Color.BLACK, NUMERIC_ATTRIBUTES, STRING_ATTRIBUTES);
    }

    public GraphNode(Point2D POSITION, String NAME, Color COLOR, Map<String, Double> NUMERIC_ATTRIBUTES, Map<String, String> STRING_ATTRIBUTES) {
        super(NAME, 1.0, COLOR);
        this.position = new SimpleObjectProperty((Object)POSITION);
        this.disp = new SimpleObjectProperty((Object)new Point2D(0.0, 0.0));
        this.numericAttributes = new HashMap<String, Double>(NUMERIC_ATTRIBUTES);
        this.stringAttributes = new HashMap<String, String>(STRING_ATTRIBUTES);
        this.connectedNodes = new ArrayList();
        this._selected = false;
        this.setFill(COLOR);
        this.setStroke(Color.WHITE);
        this.addDefault();
    }

    public GraphNode(Map<String, Double> numericAttributes, Map<String, String> stringAttributes) {
        this(Point2D.ZERO, "", Color.BLUE, numericAttributes, stringAttributes);
    }

    public GraphNode(String NAME) {
        this(NAME, new HashMap<String, Double>(), new HashMap<String, String>());
    }

    public boolean containedIn(double x, double y, double nodeScaleFactor, double generalScaleFactor, double minRadius) {
        double x0 = x - ((Point2D)this.position.get()).getX();
        double y0 = y - ((Point2D)this.position.get()).getY();
        return Math.sqrt(Math.pow(x0, 2.0) + Math.pow(y0, 2.0)) < (this.getRadius() * nodeScaleFactor + minRadius) * generalScaleFactor;
    }

    public double getRadius() {
        return this.getValue();
    }

    private void addDefault() {
        this.numericAttributes.putIfAbsent(NodeEdgeModel.DEFAULT, Math.sqrt(0.3183098861837907));
        this.stringAttributes.putIfAbsent(NodeEdgeModel.DEFAULT, "Group1");
    }

    public String getSizeKey() {
        return this.SIZE_KEY;
    }

    public void setSizeKey(String key) {
        this.SIZE_KEY = key;
        this.setValue(Math.sqrt(this.getNumericAttribute(key) / Math.PI));
    }

    public void addConnection(GraphNode node) {
        this.connectedNodes.add(node);
    }

    public double getNumericAttribute(String key) {
        Double value = this.numericAttributes.get(key);
        return value == null ? 0.0 : value;
    }

    public void setNumericAttribute(String key, double value) {
        this.numericAttributes.put(key, value);
    }

    public String getStringAttribute(String key) {
        String val = this.stringAttributes.get(key);
        return val == null ? "" : val;
    }

    public boolean containsNumericAttribute(String key) {
        return this.numericAttributes.containsKey(key);
    }

    public void setDisp(Point2D disp) {
        this.disp.setValue((Object)disp);
    }

    public Point2D getDisp() {
        return (Point2D)this.disp.get();
    }

    public ObjectProperty<Point2D> dispProperty() {
        return this.disp;
    }

    public Point2D getPosition() {
        return (Point2D)this.position.get();
    }

    public void setPosition(Point2D position) {
        this.position.set((Object)position);
    }

    public ObjectProperty<Point2D> positionProperty() {
        return this.position;
    }

    @Override
    public boolean isSelected() {
        return null == this.selected ? this._selected : this.selected.get();
    }

    @Override
    public void setSelected(boolean SELECTED) {
        if (null == this.selected) {
            this._selected = SELECTED;
        } else {
            this.selected.set(SELECTED);
        }
    }

    @Override
    public BooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.selected = new BooleanPropertyBase(this._selected){

                protected void invalidated() {
                }

                public Object getBean() {
                    return GraphNode.this;
                }

                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    public ArrayList<GraphNode> getConnectedNodes() {
        return this.connectedNodes;
    }

    public ArrayList<String> getNumericAttributeKeys() {
        return new ArrayList<String>(this.numericAttributes.keySet());
    }

    public ArrayList<String> getStringAttributeKeys() {
        return new ArrayList<String>(this.stringAttributes.keySet());
    }
}

