/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.forcedirectedgraph;

import eu.hansolo.fx.charts.forcedirectedgraph.GraphCalculator;
import eu.hansolo.fx.charts.forcedirectedgraph.GraphEdge;
import eu.hansolo.fx.charts.forcedirectedgraph.GraphNode;
import eu.hansolo.fx.charts.forcedirectedgraph.InfoPopup;
import eu.hansolo.fx.charts.forcedirectedgraph.NodeEdgeModel;
import eu.hansolo.fx.charts.tools.Helper;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class GraphPanel
extends Region {
    private static final double PREFERRED_WIDTH = 800.0;
    private static final double PREFERRED_HEIGHT = 800.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final long REFRESH_PERIOD = 100000000L;
    private static final int THRESHOLD = 1;
    private static final int BASE_TEMPERATURE = 100;
    private static final double DISTANCE_SCALING_FACTOR = 7.0;
    private static final double MIN_EDGE_WIDTH = 0.5;
    private static final double MIN_FORCE = 0.01;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private EventHandler<MouseEvent> mouseHandler;
    private long lastTimerCall;
    private AnimationTimer timer;
    private double temp;
    private double area;
    private double k;
    private NodeEdgeModel nodeEdgeModel;
    private GraphNode selectedNode;
    private ChangeListener<Point2D> nodeChangeListener;
    private SimpleDoubleProperty distanceScalingFactor;
    private String GROUPING_KEY;
    private double minRadius = 5.0;
    private Point2D pointDragStarted;
    private Point2D pointDragLast;
    private Color _edgeColor;
    private ObjectProperty<Color> edgeColor;
    private double _edgeWidthFactor;
    private DoubleProperty edgeWidthFactor;
    private double _nodeSizeFactor;
    private DoubleProperty nodeSizeFactor;
    private Color _nodeHighlightingColor;
    private ObjectProperty<Color> nodeHighlightingColor;
    private double _nodeBorderWidth;
    private DoubleProperty nodeBorderWidth;
    private Color _selectedNodeFillColor;
    private ObjectProperty<Color> selectedNodeFillColor;
    private Color _selectedNodeBorderColor;
    private ObjectProperty<Color> selectedNodeBorderColor;
    private InfoPopup popup;
    private double maxXPosition;
    private double maxYPosition;
    private double minXPosition;
    private double minYPosition;
    private SimpleBooleanProperty physicsActive;
    private boolean _physicsActive;
    private SimpleBooleanProperty forceInverted;
    private boolean _forceInverted;
    private double maxRadius = 20.0;
    private double scaleOfNodes = 450.0;
    private GraphCalculator graphCalculator;

    public GraphPanel() {
        this(new NodeEdgeModel());
    }

    public GraphPanel(NodeEdgeModel nodeEdgeModel) {
        this.nodeEdgeModel = nodeEdgeModel;
        this.init();
    }

    private void init() {
        this.width = 800.0;
        this.height = 800.0;
        this.mouseHandler = this::handleMouseEvents;
        this.lastTimerCall = System.nanoTime();
        this._physicsActive = true;
        this._forceInverted = false;
        this.setInitialPosition((int)this.width, (int)this.height);
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > GraphPanel.this.lastTimerCall + 100000000L) {
                    GraphPanel.this.fruchtermanReingold();
                    GraphPanel.this.lastTimerCall = now;
                    GraphPanel.this.redraw();
                }
            }
        };
        this.nodeChangeListener = (o, ov, nv) -> this.redraw();
        this.temp = 100.0;
        this.area = this.width * this.height;
        this.k = Math.sqrt(this.area / (double)this.nodeEdgeModel.getNodes().size());
        this.distanceScalingFactor = new SimpleDoubleProperty(7.0);
        this._edgeColor = Color.DARKGRAY;
        this._edgeWidthFactor = 2.0;
        this._nodeHighlightingColor = Color.RED;
        this._nodeBorderWidth = 3.0;
        this._selectedNodeFillColor = Color.BLACK;
        this._selectedNodeBorderColor = Color.LIME;
        this.maxXPosition = 1.0;
        this.maxYPosition = 1.0;
        this.minXPosition = -1.0;
        this.minYPosition = -1.0;
        this.GROUPING_KEY = null != this.nodeEdgeModel.getCurrentGroupKey() ? this.nodeEdgeModel.getCurrentGroupKey() : NodeEdgeModel.DEFAULT;
        this.popup = new InfoPopup();
        this.initGraphics();
        this.registerListeners();
        this.timer.start();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(800.0, 800.0);
            }
        }
        this.canvas = new Canvas(this.width, this.height);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        this.nodeEdgeModel.isModifiedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.redraw();
                this.nodeEdgeModel.isModifiedProperty().setValue(Boolean.valueOf(false));
            }
        });
        this.nodeEdgeModel.nodeBorderColorProperty().addListener((observable, oldValue, newValue) -> this.redraw());
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public void restart() {
        this.lastTimerCall = System.nanoTime();
        this.temp = 100.0;
        this.setInitialPosition((int)this.width, (int)this.height);
        this.timer.start();
    }

    private double cool(double TEMPERATURE) {
        return (TEMPERATURE - 1.0) * 0.93;
    }

    private double repulseForce(double DISTANCE, double K) {
        return (this.calculateScaleFactor() > 0.0 ? this.calculateScaleFactor() : 1.0) * (K * K) / (DISTANCE * DISTANCE);
    }

    private double attractForce(double DISTANCE, double K) {
        return (this.calculateScaleFactor() > 0.0 ? this.calculateScaleFactor() : 1.0) * DISTANCE * DISTANCE / K;
    }

    private double pointToLength(Point2D POINT) {
        return Math.sqrt(Math.abs(POINT.getX() * POINT.getX() + POINT.getY() * POINT.getY()));
    }

    private void handleMouseEvents(MouseEvent EVT) {
        EventType TYPE = EVT.getEventType();
        double X = EVT.getX();
        double Y = EVT.getY();
        if (MouseEvent.MOUSE_PRESSED.equals(TYPE)) {
            if (null != this.selectedNode) {
                this.selectedNode.setSelected(false);
            }
            this.selectedNode = this.nodeEdgeModel.getNodeAt(this.xPositionDrawnToReal(X), this.yPositionDrawnToReal(Y), this.calculateNodeAndEdgeScaleFactor() / this.calculateScaleFactor(), this.minRadius, this.getNodeSizeFactor());
            if (null == this.selectedNode) {
                this.pointDragStarted = new Point2D(0.0, 0.0);
            } else {
                this.pointDragStarted = this.selectedNode.getPosition();
                this.nodeEdgeModel.getNodes().forEach(node -> node.setSelected(false));
                this.selectedNode.setSelected(true);
                this.updatePopup(this.selectedNode, EVT);
            }
            this.redraw();
        } else if (MouseEvent.MOUSE_DRAGGED.equals(TYPE)) {
            if (null == this.selectedNode) {
                return;
            }
            this.popup.setOpacity(0.0);
            this.popup.animatedHide();
            double radius = this.getMinNodeDistance(this.selectedNode.getRadius());
            X = this.xPositionDrawnToReal(X);
            Y = this.yPositionDrawnToReal(Y);
            X = Math.min(this.xPositionDrawnToReal(this.width - radius), Math.max(this.xPositionDrawnToReal(radius), X));
            Y = Math.min(this.yPositionDrawnToReal(this.height - radius), Math.max(this.yPositionDrawnToReal(radius), Y));
            this.selectedNode.setPosition(new Point2D(X, Y));
            if (null == this.pointDragLast) {
                this.pointDragLast = this.pointDragStarted;
            }
            this.temp = this.pointDragLast.distance(X, Y) / this.distanceScalingFactor.doubleValue();
            this.pointDragLast = new Point2D(X, Y);
            this.fruchtermanReingold();
            this.fruchtermanReingold();
            this.redraw();
        } else if (MouseEvent.MOUSE_RELEASED.equals(TYPE)) {
            if (null == this.pointDragStarted) {
                return;
            }
            X = this.xPositionDrawnToReal(X);
            Y = this.yPositionDrawnToReal(Y);
            this.temp = this.pointDragStarted.distance(X, Y) / this.distanceScalingFactor.doubleValue();
            if (null != this.selectedNode) {
                this.timer.start();
            }
            this.pointDragStarted = null;
            this.pointDragLast = null;
        }
    }

    private void updatePopup(GraphNode NODE, MouseEvent EVT) {
        String[] names = new String[2];
        String[] values = new String[2];
        names[0] = "Name";
        names[1] = this.nodeEdgeModel.getCurrentGroupKey();
        values[0] = null == NODE.getName() ? "-" : NODE.getName();
        values[1] = NODE.getStringAttribute(this.nodeEdgeModel.getCurrentGroupKey());
        this.popup.update(names, values);
        this.popup.setX(EVT.getScreenX());
        this.popup.setY(EVT.getScreenY() - this.popup.getHeight());
        this.popup.animatedShow(this.getScene().getWindow());
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            if (this.maxRadius * this.calculateScaleFactor() != 0.0 && this.maxRadius * this.calculateScaleFactor() < Double.MAX_VALUE && this.maxRadius * this.calculateScaleFactor() > Double.MIN_VALUE) {
                this.maxRadius = this.calculateNodeAndEdgeScaleFactor() * 20.0;
            }
            this.redraw();
        }
    }

    private void initalizeCalculatorIfNecessary() {
        if (null == this.graphCalculator) {
            this.graphCalculator = new GraphCalculator();
        }
    }

    private double xPositionDrawnToReal(double x) {
        return (x - this.maxRadius) / this.calculateScaleFactor() + this.minXPosition;
    }

    private double yPositionDrawnToReal(double y) {
        return (y - this.maxRadius) / this.calculateScaleFactor() + this.minYPosition;
    }

    private double xPositionRealToDrawn(double x) {
        return (x - this.minXPosition) * this.calculateScaleFactor() + this.maxRadius;
    }

    private double yPositionRealToDrawn(double y) {
        return (y - this.minYPosition) * this.calculateScaleFactor() + this.maxRadius;
    }

    private double calculateScaleFactor() {
        if ((this.width - 2.0 * this.maxRadius) / (this.maxXPosition - this.minXPosition) <= (this.height - 2.0 * this.maxRadius) / (this.maxYPosition - this.minYPosition)) {
            return (this.width - 2.0 * this.maxRadius) / (this.maxXPosition - this.minXPosition);
        }
        return (this.height - 2.0 * this.maxRadius) / (this.maxYPosition - this.minYPosition);
    }

    private double calculateNodeAndEdgeScaleFactor() {
        if (this.maxXPosition - this.minXPosition <= this.maxYPosition - this.minYPosition) {
            if (this.width / (this.maxXPosition - this.minXPosition) <= this.height / (this.maxYPosition - this.minYPosition)) {
                return this.width / this.scaleOfNodes;
            }
            return this.width / this.scaleOfNodes / (this.width / (this.maxXPosition - this.minXPosition) / (this.height / (this.maxYPosition - this.minYPosition)));
        }
        if (this.width / (this.maxXPosition - this.minXPosition) <= this.height / (this.maxYPosition - this.minYPosition)) {
            return this.height / this.scaleOfNodes / (this.height / (this.maxYPosition - this.minYPosition) / (this.width / (this.maxXPosition - this.minXPosition)));
        }
        return this.height / this.scaleOfNodes;
    }

    public void mapGroup(String group, Consumer<GraphNode> ingroupConsumer, Consumer<GraphNode> outgroupConsumer) {
        for (GraphNode node : this.nodeEdgeModel.getNodes()) {
            if (group.equals(node.getStringAttribute(this.nodeEdgeModel.getCurrentGroupKey()))) {
                ingroupConsumer.accept(node);
                continue;
            }
            outgroupConsumer.accept(node);
        }
    }

    public void highlightGroup(String group) {
        this.mapGroup(group, node -> node.setStroke(this.getNodeHighlightingColor()), node -> node.setStroke(this.nodeEdgeModel.getNodeBorderColor()));
    }

    public void highlightGroup(String groupValue, Color strokeColor, Color fillColor) {
        this.mapGroup(groupValue, node -> {
            node.setStroke(strokeColor);
            node.setFill(fillColor);
        }, node -> {
            node.setStroke(this.nodeEdgeModel.getNodeBorderColor());
            node.setFill(this.nodeEdgeModel.getOrCreateGroupColorScheme().get(node.getStringAttribute(this.GROUPING_KEY)));
        });
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void highlightNode(GraphNode node) {
        this.highlightNode(node, this.getNodeHighlightingColor());
    }

    public void highlightNode(GraphNode node, Color color) {
        node.setStroke(color);
    }

    public double getMinNodeDistance(double radius) {
        return this.minRadius + radius * this.getNodeSizeFactor();
    }

    public Color getSelectedNodeFillColor() {
        return null == this.selectedNodeFillColor ? this._selectedNodeFillColor : (Color)this.selectedNodeFillColor.get();
    }

    public void setSelectedNodeFillColor(Color COLOR) {
        if (null == this.selectedNodeFillColor) {
            this._selectedNodeFillColor = COLOR;
            this.redraw();
        } else {
            this.selectedNodeFillColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectedNodeFillColorProperty() {
        if (null == this.selectedNodeFillColor) {
            this.selectedNodeFillColor = new ObjectPropertyBase<Color>(this._selectedNodeFillColor){

                protected void invalidated() {
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "selectedNodeFillColor";
                }
            };
            this._selectedNodeFillColor = null;
        }
        return this.selectedNodeFillColor;
    }

    public Color getSelectedNodeBorderColor() {
        return null == this.selectedNodeBorderColor ? this._selectedNodeBorderColor : (Color)this.selectedNodeBorderColor.get();
    }

    public void setSelectedNodeBorderColor(Color COLOR) {
        if (null == this.selectedNodeBorderColor) {
            this._selectedNodeBorderColor = COLOR;
            this.redraw();
        } else {
            this.selectedNodeBorderColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> selectedNodeBorderColorProperty() {
        if (null == this.selectedNodeBorderColor) {
            this.selectedNodeBorderColor = new ObjectPropertyBase<Color>(this._selectedNodeBorderColor){

                protected void invalidated() {
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "selectedNodeBorderColor";
                }
            };
            this._selectedNodeBorderColor = null;
        }
        return this.selectedNodeBorderColor;
    }

    public double getNodeSizeFactor() {
        return this.nodeSizeFactor != null ? this.nodeSizeFactor.doubleValue() : this._nodeSizeFactor;
    }

    public DoubleProperty nodeSizeFactorProperty() {
        if (null == this.nodeSizeFactor) {
            this.nodeSizeFactor = new SimpleDoubleProperty(this._nodeSizeFactor);
            this.nodeSizeFactor.addListener(observable -> this.redraw());
        }
        return this.nodeSizeFactor;
    }

    public void setNodeSizeFactor(double nodeSizeFactor) {
        if (null != this.nodeSizeFactor) {
            this.nodeSizeFactor.setValue((Number)nodeSizeFactor);
        } else {
            this._nodeSizeFactor = nodeSizeFactor;
        }
    }

    public void fruchtermanReingold() {
        if (this.temp < 1.0 || !this.isPhysicsActive()) {
            this.timer.stop();
            return;
        }
        for (GraphNode v : this.nodeEdgeModel.getNodes()) {
            v.setDisp(Point2D.ZERO);
            for (GraphNode u : this.nodeEdgeModel.getNodes()) {
                if (u == v) continue;
                Point2D positionU = v.getPosition();
                Point2D positionV = u.getPosition();
                Point2D vectorUV = positionU.subtract(positionV);
                Point2D displacement = vectorUV.normalize().multiply(this.repulseForce(this.pointToLength(vectorUV), this.k));
                v.setDisp(v.getDisp().add(displacement));
            }
        }
        for (GraphEdge e : this.nodeEdgeModel.getEdges()) {
            Point2D positionU = e.getU().getPosition();
            Point2D positionV = e.getV().getPosition();
            Point2D vectorUV = positionV.subtract(positionU);
            double delta = this.pointToLength(vectorUV);
            Point2D addition = !this.isForceInverted() ? vectorUV.normalize().multiply(this.attractForce(Math.abs(delta), this.k) * (e.getForce() + 0.01)) : vectorUV.normalize().multiply(this.attractForce(Math.abs(delta), this.k) / (e.getForce() + 0.01));
            e.getV().setDisp(e.getV().getDisp().subtract(addition));
            e.getU().setDisp(e.getU().getDisp().add(addition));
        }
        this.minXPosition = Double.MAX_VALUE;
        this.minYPosition = Double.MAX_VALUE;
        this.maxXPosition = Double.MIN_VALUE;
        this.maxYPosition = Double.MIN_VALUE;
        for (GraphNode v : this.nodeEdgeModel.getNodes()) {
            Point2D tempPoint = v.getPosition().add(v.getDisp().normalize().multiply(Math.min(this.pointToLength(v.getDisp()), this.temp)));
            if (tempPoint.getX() < this.minXPosition) {
                this.minXPosition = tempPoint.getX();
            }
            if (tempPoint.getX() > this.maxXPosition) {
                this.maxXPosition = tempPoint.getX();
            }
            if (tempPoint.getY() < this.minYPosition) {
                this.minYPosition = tempPoint.getY();
            }
            if (tempPoint.getY() > this.maxYPosition) {
                this.maxYPosition = tempPoint.getY();
            }
            v.setPosition(new Point2D(tempPoint.getX(), tempPoint.getY()));
        }
        this.temp = this.cool(this.temp);
    }

    public void setNodeEdgeModel(NodeEdgeModel nodeEdgeModel) {
        this.nodeEdgeModel = nodeEdgeModel;
        this.restart();
        this.nodeEdgeModel.isModifiedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.redraw();
                this.nodeEdgeModel.isModifiedProperty().setValue(Boolean.valueOf(false));
            }
        });
    }

    public void setInitialPosition(int width, int height) {
        int q = (int)Math.sqrt(this.nodeEdgeModel.getNodes().size());
        if (0 == q) {
            return;
        }
        int xFactor = width / q;
        int yFactor = height / q;
        int i = 1;
        int j = 1;
        for (GraphNode node : this.nodeEdgeModel.getNodes()) {
            node.setPosition(new Point2D((double)(1 + i * xFactor), (double)(1 + j * yFactor)));
            if (++i != q + 1) continue;
            ++j;
            i = 0;
        }
    }

    public NodeEdgeModel calculateDegreeCentrality() {
        this.initalizeCalculatorIfNecessary();
        this.setNodeEdgeModel(this.graphCalculator.calculateDegreeCentrality(this.nodeEdgeModel));
        return this.nodeEdgeModel;
    }

    public NodeEdgeModel calculateDegreeCentralityNormalized() {
        this.initalizeCalculatorIfNecessary();
        this.setNodeEdgeModel(this.graphCalculator.calculateDegreeCentralityNormalized(this.nodeEdgeModel));
        return this.nodeEdgeModel;
    }

    public NodeEdgeModel calculateClosenessCentrality() {
        this.initalizeCalculatorIfNecessary();
        this.setNodeEdgeModel(this.graphCalculator.calculateClosenessCentrality(this.nodeEdgeModel));
        return this.nodeEdgeModel;
    }

    public NodeEdgeModel calculateClosenessCentralityNormalized() {
        this.initalizeCalculatorIfNecessary();
        this.setNodeEdgeModel(this.graphCalculator.calculateClosenessCentralityNormalized(this.nodeEdgeModel));
        return this.nodeEdgeModel;
    }

    public NodeEdgeModel calculateBetweennessCentrality() {
        this.initalizeCalculatorIfNecessary();
        this.graphCalculator.calculateBetweennessCentrality(this.nodeEdgeModel);
        return this.nodeEdgeModel;
    }

    public void dispose() {
        this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        this.canvas.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
    }

    public NodeEdgeModel getNodeEdgeModel() {
        return this.nodeEdgeModel;
    }

    public Color getEdgeColor() {
        return null == this.edgeColor ? this._edgeColor : (Color)this.edgeColor.get();
    }

    public void setEdgeColor(Color COLOR) {
        if (null == this.edgeColor) {
            this._edgeColor = COLOR;
            this.redraw();
        } else {
            this.edgeColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> edgeColorProperty() {
        if (null == this.edgeColor) {
            this.edgeColor = new ObjectPropertyBase<Color>(this._edgeColor){

                protected void invalidated() {
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "edgeColor";
                }
            };
            this._edgeColor = null;
        }
        return this.edgeColor;
    }

    public double getEdgeWidthFactor() {
        return null == this.edgeWidthFactor ? this._edgeWidthFactor : this.edgeWidthFactor.get();
    }

    public void setEdgeWidthFactor(double WIDTH) {
        if (null == this.edgeWidthFactor) {
            this._edgeWidthFactor = Helper.clamp(1.0, 10.0, WIDTH);
            this.redraw();
        } else {
            this.edgeWidthFactor.set(WIDTH);
        }
    }

    public DoubleProperty edgeWidthFactorProperty() {
        if (null == this.edgeWidthFactor) {
            this.edgeWidthFactor = new DoublePropertyBase(this._edgeWidthFactor){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 10.0, this.get()));
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "edgeWidthFactor";
                }
            };
            this.edgeWidthFactor.addListener(observable -> this.redraw());
        }
        return this.edgeWidthFactor;
    }

    public Color getNodeHighlightingColor() {
        return null == this.nodeHighlightingColor ? this._nodeHighlightingColor : (Color)this.nodeHighlightingColor.get();
    }

    public ObjectProperty<Color> nodeHighlightingColorProperty() {
        if (null == this.nodeHighlightingColor) {
            this.nodeHighlightingColor = new ObjectPropertyBase<Color>(this._nodeHighlightingColor){

                protected void invalidated() {
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "nodeHighlightingColor";
                }
            };
            this._nodeHighlightingColor = null;
            this.nodeHighlightingColor.addListener(observable -> this.redraw());
        }
        return this.nodeHighlightingColor;
    }

    public void setNodeHighlightingColor(Color COLOR) {
        if (null == this.nodeHighlightingColor) {
            this._nodeHighlightingColor = COLOR;
            this.redraw();
        } else {
            this.nodeHighlightingColor.set((Object)COLOR);
        }
        this.redraw();
    }

    public double getNodeBorderWidth() {
        return null == this.nodeBorderWidth ? this._nodeBorderWidth : this.nodeBorderWidth.get();
    }

    public void setNodeBorderWidth(double WIDTH) {
        if (null == this.nodeBorderWidth) {
            this._nodeBorderWidth = Helper.clamp(1.0, 10.0, WIDTH);
            this.redraw();
        } else {
            this.nodeBorderWidth.set(WIDTH);
        }
    }

    public DoubleProperty nodeBorderWidthProperty() {
        if (null == this.nodeBorderWidth) {
            this.nodeBorderWidth = new DoublePropertyBase(this._nodeBorderWidth){

                protected void invalidated() {
                    this.set(Helper.clamp(1.0, 10.0, this.get()));
                    GraphPanel.this.redraw();
                }

                public Object getBean() {
                    return GraphPanel.this;
                }

                public String getName() {
                    return "nodeBorderWidth";
                }
            };
            this.nodeBorderWidth.addListener(observable -> this.redraw());
        }
        return this.nodeBorderWidth;
    }

    public boolean isPhysicsActive() {
        return null != this.physicsActive ? this.physicsActive.get() : this._physicsActive;
    }

    public BooleanProperty physicsActiveProperty() {
        if (null == this.physicsActive) {
            this.physicsActive = new SimpleBooleanProperty(this._physicsActive);
        }
        return this.physicsActive;
    }

    public void setPhysicsActive(boolean physicsActive) {
        if (null != this.physicsActive) {
            this.physicsActive.set(physicsActive);
        } else {
            this._physicsActive = physicsActive;
        }
    }

    public boolean isForceInverted() {
        return null != this.forceInverted ? this.forceInverted.get() : this._forceInverted;
    }

    public BooleanProperty forceInvertedProperty() {
        if (null == this.forceInverted) {
            this.forceInverted = new SimpleBooleanProperty(this._forceInverted);
        }
        return this.forceInverted;
    }

    public void setForceInverted(boolean forceInverted) {
        if (null != this.forceInverted) {
            this.forceInverted.set(forceInverted);
        } else {
            this._forceInverted = forceInverted;
        }
    }

    public SimpleDoubleProperty distanceScalingFactorProperty() {
        return this.distanceScalingFactor;
    }

    public void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setStroke((Paint)this.getEdgeColor());
        this.ctx.setLineWidth(this.getEdgeWidthFactor() * this.getEdgeWidthFactor());
        for (GraphEdge edge : this.nodeEdgeModel.getEdges()) {
            this.ctx.setLineWidth(this.getEdgeWidthFactor() * this.calculateNodeAndEdgeScaleFactor() * edge.getWidth() + 0.5);
            this.ctx.strokeLine(this.xPositionRealToDrawn(edge.getU().getPosition().getX()), this.yPositionRealToDrawn(edge.getU().getPosition().getY()), this.xPositionRealToDrawn(edge.getV().getPosition().getX()), this.yPositionRealToDrawn(edge.getV().getPosition().getY()));
        }
        for (GraphNode node : this.nodeEdgeModel.getNodes()) {
            node.setFill(this.nodeEdgeModel.getOrCreateGroupColorScheme().get(node.getStringAttribute(this.nodeEdgeModel.getCurrentGroupKey())));
            this.ctx.setFill((Paint)node.getFill());
            this.ctx.setLineWidth(2.0);
            this.ctx.setStroke((Paint)node.getStroke());
            if (node.isSelected()) {
                this.ctx.save();
                this.ctx.setFill((Paint)this.getSelectedNodeFillColor());
                this.ctx.setStroke((Paint)this.getSelectedNodeBorderColor());
            }
            double val = node.getValue();
            double sizeFactor = this.getNodeSizeFactor();
            this.ctx.fillOval(this.xPositionRealToDrawn(node.getPosition().getX()) - (val * sizeFactor + this.minRadius) * this.calculateNodeAndEdgeScaleFactor(), this.yPositionRealToDrawn(node.getPosition().getY()) - (val * sizeFactor + this.minRadius) * this.calculateNodeAndEdgeScaleFactor(), (val * 2.0 * sizeFactor + this.minRadius * 2.0) * this.calculateNodeAndEdgeScaleFactor(), (val * 2.0 * sizeFactor + this.minRadius * 2.0) * this.calculateNodeAndEdgeScaleFactor());
            this.ctx.strokeOval(this.xPositionRealToDrawn(node.getPosition().getX()) - (val * sizeFactor + this.minRadius) * this.calculateNodeAndEdgeScaleFactor(), this.yPositionRealToDrawn(node.getPosition().getY()) - (val * sizeFactor + this.minRadius) * this.calculateNodeAndEdgeScaleFactor(), (val * 2.0 * sizeFactor + this.minRadius * 2.0) * this.calculateNodeAndEdgeScaleFactor(), (val * 2.0 * sizeFactor + this.minRadius * 2.0) * this.calculateNodeAndEdgeScaleFactor());
            if (!node.isSelected()) continue;
            this.ctx.restore();
        }
    }
}

