/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.pareto;

import eu.hansolo.fx.charts.pareto.ParetoBar;
import java.util.ArrayList;
import java.util.List;

public class ParetoModel {
    private String title;
    private ArrayList<ParetoBar> data;

    public ParetoModel(String title, List<ParetoBar> data) {
        this.title = title;
        this.data = new ArrayList<ParetoBar>(data);
    }

    public ParetoModel(List<ParetoBar> data) {
        this("Pareto Chart", data);
    }

    public ParetoModel() {
        this("Pareto Chart", new ArrayList<ParetoBar>());
    }

    public ParetoModel(ParetoModel model) {
        this.title = model.getTitle();
        this.data = model.getData();
    }

    public ArrayList<ParetoBar> getData() {
        return this.data;
    }

    public void setData(List<ParetoBar> DATA) {
        this.data = new ArrayList<ParetoBar>(DATA);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String TITLE) {
        this.title = TITLE;
    }

    public double getMin() {
        return this.getData().stream().mapToDouble(ParetoBar::getValue).min().orElse(0.0);
    }

    public double getMax() {
        return this.getData().stream().mapToDouble(ParetoBar::getValue).max().orElse(0.0);
    }

    public double getTotal() {
        return this.getData().stream().mapToDouble(ParetoBar::getValue).sum();
    }
}

