/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.world;

import eu.hansolo.fx.charts.data.MapConnection;
import eu.hansolo.fx.charts.data.WeightedMapPoints;
import eu.hansolo.fx.charts.tools.MapPoint;
import eu.hansolo.fx.charts.tools.MapPointSize;
import eu.hansolo.fx.charts.world.World;
import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Location;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class WorldBuilder<B extends WorldBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private World.Resolution resolution = World.Resolution.HI_RES;

    protected WorldBuilder() {
    }

    public static final WorldBuilder create() {
        return new WorldBuilder();
    }

    public final B resolution(World.Resolution RESOLUTION) {
        this.resolution = RESOLUTION;
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B fillColor(Color COLOR) {
        this.properties.put("fillColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B strokeColor(Color COLOR) {
        this.properties.put("strokeColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hoverColor(Color COLOR) {
        this.properties.put("hoverColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B pressedColor(Color COLOR) {
        this.properties.put("pressedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B selectedColor(Color COLOR) {
        this.properties.put("selectedColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B locationColor(Color COLOR) {
        this.properties.put("locationColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B hoverEnabled(boolean ENABLED) {
        this.properties.put("hoverEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B selectionEnabled(boolean ENABLED) {
        this.properties.put("selectionEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B zoomEnabled(boolean ENABLED) {
        this.properties.put("zoomEnabled", (Property)new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B mouseEnterHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseEnterHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mousePressHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mousePressHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mouseReleaseHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseReleaseHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B mouseExitHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("mouseExitHandler", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B locations(Location ... LOCATIONS) {
        this.properties.put("locations", (Property)new SimpleObjectProperty((Object)LOCATIONS));
        return (B)this;
    }

    public final B showLocations(boolean VISIBLE) {
        this.properties.put("showLocations", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B colorMapping(Mapping COLOR_MAPPING) {
        this.properties.put("colorMapping", (Property)new SimpleObjectProperty((Object)COLOR_MAPPING));
        return (B)this;
    }

    public final B eventRadius(double EVENT_RADIUS) {
        this.properties.put("eventRadius", (Property)new SimpleDoubleProperty(EVENT_RADIUS));
        return (B)this;
    }

    public final B fadeColors(boolean FADE_COLORS) {
        this.properties.put("fadeColors", (Property)new SimpleBooleanProperty(FADE_COLORS));
        return (B)this;
    }

    public final B heatMapOpacity(double HEAT_MAP_OPACITY) {
        this.properties.put("heatMapOpacity", (Property)new SimpleDoubleProperty(HEAT_MAP_OPACITY));
        return (B)this;
    }

    public final B opacityDistribution(OpacityDistribution OPACITY_DISTRIBUTION) {
        this.properties.put("opacityDistribution", (Property)new SimpleObjectProperty((Object)OPACITY_DISTRIBUTION));
        return (B)this;
    }

    public final B mapPoints(List<MapPoint> MAP_POINTS) {
        this.properties.put("mapPoints", (Property)new SimpleObjectProperty(MAP_POINTS));
        return (B)this;
    }

    public final B mapConnections(List<MapConnection> MAP_CONNECTIONS) {
        this.properties.put("mapConnections", (Property)new SimpleObjectProperty(MAP_CONNECTIONS));
        return (B)this;
    }

    public final B weightedMapPoints(WeightedMapPoints WEIGHTED) {
        this.properties.put("weightedMapPoints", (Property)new SimpleObjectProperty((Object)WEIGHTED));
        return (B)this;
    }

    public final B weightedMapConnections(boolean WEIGHTED) {
        this.properties.put("weightedMapConnections", (Property)new SimpleBooleanProperty(WEIGHTED));
        return (B)this;
    }

    public final B mapPointSize(MapPointSize SIZE) {
        this.properties.put("mapPointSize", (Property)new SimpleObjectProperty((Object)SIZE));
        return (B)this;
    }

    public final B mapPointsVisible(boolean VISIBLE) {
        this.properties.put("mapPointsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B mapPointTextVisible(boolean VISIBLE) {
        this.properties.put("mapPointTextVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B connectionWidth(double WIDTH) {
        this.properties.put("connectionWidth", (Property)new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B arrowsVisible(boolean VISIBLE) {
        this.properties.put("arrowsVisible", (Property)new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B drawImagePath(boolean DRAW) {
        this.properties.put("drawImagePath", (Property)new SimpleBooleanProperty(DRAW));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", (Property)new SimpleObjectProperty((Object)INSETS));
        return (B)this;
    }

    public final World build() {
        ColorMapping colorMapping = this.properties.containsKey("colorMapping") ? (Mapping)((ObjectProperty)this.properties.get("colorMapping")).get() : ColorMapping.INFRARED_3;
        double eventRadius = this.properties.containsKey("eventRadius") ? ((DoubleProperty)this.properties.get("eventRadius")).get() : 5.0;
        boolean fadeColors = this.properties.containsKey("fadeColors") ? ((BooleanProperty)this.properties.get("fadeColors")).get() : false;
        double heatMapOpacity = this.properties.containsKey("heatMapOpacity") ? ((DoubleProperty)this.properties.get("heatMapOpacity")).get() : 0.5;
        OpacityDistribution opacityDistribution = this.properties.containsKey("opacityDistribution") ? (OpacityDistribution)((ObjectProperty)this.properties.get("opacityDistribution")).get() : OpacityDistribution.EXPONENTIAL;
        World control = new World(this.resolution, (Mapping)colorMapping, eventRadius, fadeColors, opacityDistribution, heatMapOpacity);
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "prefSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setPrefSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "minSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMinSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "maxSize": {
                    Dimension2D dim = (Dimension2D)((ObjectProperty)property).get();
                    control.setMaxSize(dim.getWidth(), dim.getHeight());
                    break;
                }
                case "prefWidth": {
                    control.setPrefWidth(((DoubleProperty)property).get());
                    break;
                }
                case "prefHeight": {
                    control.setPrefHeight(((DoubleProperty)property).get());
                    break;
                }
                case "minWidth": {
                    control.setMinWidth(((DoubleProperty)property).get());
                    break;
                }
                case "minHeight": {
                    control.setMinHeight(((DoubleProperty)property).get());
                    break;
                }
                case "maxWidth": {
                    control.setMaxWidth(((DoubleProperty)property).get());
                    break;
                }
                case "maxHeight": {
                    control.setMaxHeight(((DoubleProperty)property).get());
                    break;
                }
                case "scaleX": {
                    control.setScaleX(((DoubleProperty)property).get());
                    break;
                }
                case "scaleY": {
                    control.setScaleY(((DoubleProperty)property).get());
                    break;
                }
                case "layoutX": {
                    control.setLayoutX(((DoubleProperty)property).get());
                    break;
                }
                case "layoutY": {
                    control.setLayoutY(((DoubleProperty)property).get());
                    break;
                }
                case "translateX": {
                    control.setTranslateX(((DoubleProperty)property).get());
                    break;
                }
                case "translateY": {
                    control.setTranslateY(((DoubleProperty)property).get());
                    break;
                }
                case "padding": {
                    control.setPadding((Insets)((ObjectProperty)property).get());
                    break;
                }
                case "backgroundColor": {
                    control.setBackgroundColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "fillColor": {
                    control.setFillColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "strokeColor": {
                    control.setStrokeColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "hoverColor": {
                    control.setHoverColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "pressedColor": {
                    control.setPressedColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "selectedColor": {
                    control.setSelectedColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "locationColor": {
                    control.setLocationColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "hoverEnabled": {
                    control.setHoverEnabled(((BooleanProperty)property).get());
                    break;
                }
                case "selectionEnabled": {
                    control.setSelectionEnabled(((BooleanProperty)property).get());
                    break;
                }
                case "zoomEnabled": {
                    control.setZoomEnabled(((BooleanProperty)property).get());
                    break;
                }
                case "mouseEnterHandler": {
                    control.setMouseEnterHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "mousePressHandler": {
                    control.setMousePressHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "mouseReleaseHandler": {
                    control.setMouseReleaseHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "mouseExitHandler": {
                    control.setMouseExitHandler((EventHandler<MouseEvent>)((EventHandler)((ObjectProperty)property).get()));
                    break;
                }
                case "locations": {
                    control.addLocations((Location[])((ObjectProperty)property).get());
                    break;
                }
                case "showLocations": {
                    control.showLocations(((BooleanProperty)property).get());
                    break;
                }
                case "mapPoints": {
                    control.setMapPoints((List)((ObjectProperty)property).get());
                    break;
                }
                case "mapConnections": {
                    control.setMapConnections((List)((ObjectProperty)property).get());
                    break;
                }
                case "weightedMapPoints": {
                    control.setWeightedMapPoints((WeightedMapPoints)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "weightedMapConnections": {
                    control.setWeightedMapConnections(((BooleanProperty)property).get());
                    break;
                }
                case "mapPointSize": {
                    control.setMapPointSize((MapPointSize)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "mapPointsVisible": {
                    control.setMapPointsVisible(((BooleanProperty)property).get());
                    break;
                }
                case "mapPointTextVisible": {
                    control.setMapPointTextVisible(((BooleanProperty)property).get());
                    break;
                }
                case "textColor": {
                    control.setTextColor((Color)((ObjectProperty)property).get());
                    break;
                }
                case "connectionWidth": {
                    control.setConnectionWidth(((DoubleProperty)property).get());
                    break;
                }
                case "arrowsVisible": {
                    control.setArrowsVisible(((BooleanProperty)property).get());
                    break;
                }
                case "drawImagePath": {
                    control.setDrawImagePath(((BooleanProperty)property).get());
                }
            }
        });
        return control;
    }
}

