/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.BezierCurveIterator;
import eu.hansolo.fx.geometry.FlatteningPathIterator;
import eu.hansolo.fx.geometry.Line;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.QuadCurve;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.Arrays;
import java.util.Objects;

public class BezierCurve
extends Shape {
    private static final int BELOW = -2;
    private static final int LOW_EDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGH_EDGE = 1;
    private static final int ABOVE = 2;
    public double x1;
    public double y1;
    public double ctrlx1;
    public double ctrly1;
    public double ctrlx2;
    public double ctrly2;
    public double x2;
    public double y2;

    public BezierCurve() {
    }

    public BezierCurve(double X1, double Y1, double CTRL_X1, double CTRL_Y1, double CTRL_X2, double CTRL_Y2, double X2, double Y2) {
        this.setCurve(X1, Y1, CTRL_X1, CTRL_Y1, CTRL_X2, CTRL_Y2, X2, Y2);
    }

    public static int solveCubic(double[] EQN) {
        return BezierCurve.solveCubic(EQN, EQN);
    }

    public static int solveCubic(double[] eqn, double[] RES) {
        double d = eqn[3];
        if (Double.compare(d, 0.0) == 0) {
            return QuadCurve.solveQuadratic(eqn, RES);
        }
        double a = eqn[2] / d;
        double b = eqn[1] / d;
        double c = eqn[0] / d;
        int roots = 0;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (2.0 * a * a * a - 9.0 * a * b + 27.0 * c) / 54.0;
        double R2 = R * R;
        double Q3 = Q * Q * Q;
        a /= 3.0;
        if (R2 < Q3) {
            double theta = Math.acos(R / Math.sqrt(Q3));
            Q = -2.0 * Math.sqrt(Q);
            if (RES == eqn) {
                eqn = new double[4];
                System.arraycopy(RES, 0, eqn, 0, 4);
            }
            RES[roots++] = Q * Math.cos(theta / 3.0) - a;
            RES[roots++] = Q * Math.cos((theta + Math.PI * 2) / 3.0) - a;
            RES[roots++] = Q * Math.cos((theta - Math.PI * 2) / 3.0) - a;
            BezierCurve.fixRoots(RES, eqn);
        } else {
            boolean neg = R < 0.0;
            double S = Math.sqrt(R2 - Q3);
            if (neg) {
                R = -R;
            }
            double A = Math.pow(R + S, 0.3333333333333333);
            if (!neg) {
                A = -A;
            }
            double B = Double.compare(A, 0.0) == 0 ? 0.0 : Q / A;
            RES[roots++] = A + B - a;
        }
        return roots;
    }

    private static void fixRoots(double[] RES, double[] EQN) {
        double EPSILON = 1.0E-5;
        for (int i = 0; i < 3; ++i) {
            double t = RES[i];
            if (Math.abs(t) < 1.0E-5) {
                RES[i] = BezierCurve.findZero(t, 0.0, EQN);
                continue;
            }
            if (!(Math.abs(t - 1.0) < 1.0E-5)) continue;
            RES[i] = BezierCurve.findZero(t, 1.0, EQN);
        }
    }

    private static double solveEqn(double[] EQN, int order, double T) {
        double v = EQN[order];
        while (--order >= 0) {
            v = v * T + EQN[order];
        }
        return v;
    }

    private static double findZero(double t, double TARGET, double[] EQN) {
        double[] slopeqn = new double[]{EQN[1], 2.0 * EQN[2], 3.0 * EQN[3]};
        double origdelta = 0.0;
        double origt = t;
        double slope;
        while (Double.compare(slope = BezierCurve.solveEqn(slopeqn, 2, t), 0.0) != 0) {
            double newt;
            double y = BezierCurve.solveEqn(EQN, 3, t);
            if (Double.compare(y, 0.0) == 0) {
                return t;
            }
            double delta = -(y / slope);
            if (Double.compare(origdelta, 0.0) == 0) {
                origdelta = delta;
            }
            if (t < TARGET) {
                if (delta < 0.0) {
                    return t;
                }
            } else if (t > TARGET) {
                if (delta > 0.0) {
                    return t;
                }
            } else {
                return delta > 0.0 ? TARGET + (double)1.4E-45f : TARGET - (double)1.4E-45f;
            }
            if (t == (newt = t + delta)) {
                return t;
            }
            if (delta * origdelta < 0.0) {
                int tag;
                int n = tag = origt < t ? BezierCurve.getTag(TARGET, origt, t) : BezierCurve.getTag(TARGET, t, origt);
                if (tag != 0) {
                    return (origt + t) / 2.0;
                }
                t = TARGET;
                continue;
            }
            t = newt;
        }
        return t;
    }

    private static void fillEqn(double[] EQN, double VAL, double C1, double CP1, double CP2, double C2) {
        EQN[0] = C1 - VAL;
        EQN[1] = (CP1 - C1) * 3.0;
        EQN[2] = (CP2 - CP1 - CP1 + C1) * 3.0;
        EQN[3] = C2 + (CP1 - CP2) * 3.0 - C1;
    }

    private static int evalCubic(double[] vals, int num, boolean include0, boolean include1, double[] inflect, double c1, double cp1, double cp2, double c2) {
        int j = 0;
        for (int i = 0; i < num; ++i) {
            double t = vals[i];
            if (!(include0 ? t >= 0.0 : t > 0.0) || !(include1 ? t <= 1.0 : t < 1.0) || inflect != null && inflect[1] + (2.0 * inflect[2] + 3.0 * inflect[3] * t) * t == 0.0) continue;
            double u = 1.0 - t;
            vals[j++] = c1 * u * u * u + 3.0 * cp1 * t * u * u + 3.0 * cp2 * t * t * u + c2 * t * t * t;
        }
        return j;
    }

    private static int getTag(double COORD, double LOW, double HIGH) {
        if (COORD <= LOW) {
            return COORD < LOW ? -2 : -1;
        }
        if (COORD >= HIGH) {
            return COORD > HIGH ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }

    @Override
    public RectBounds getBounds() {
        double left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
        double top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
        double right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
        double bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
        return new RectBounds(left, top, right, bottom);
    }

    public Point eval(double T) {
        Point result = new Point();
        this.eval(T, result);
        return result;
    }

    public void eval(double TD, Point RESULT) {
        RESULT.set(this.calcX(TD), this.calcY(TD));
    }

    public Point evalDt(double T) {
        Point result = new Point();
        this.evalDt(T, result);
        return result;
    }

    public void evalDt(double td, Point RESULT) {
        double t = td;
        double u = 1.0 - t;
        double x = 3.0 * ((this.ctrlx1 - this.x1) * u * u + 2.0 * (this.ctrlx2 - this.ctrlx1) * u * t + (this.x2 - this.ctrlx2) * t * t);
        double y = 3.0 * ((this.ctrly1 - this.y1) * u * u + 2.0 * (this.ctrly2 - this.ctrly1) * u * t + (this.y2 - this.ctrly2) * t * t);
        RESULT.set(x, y);
    }

    public void setCurve(double[] COORDS, int OFFSET) {
        this.setCurve(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 2], COORDS[OFFSET + 3], COORDS[OFFSET + 4], COORDS[OFFSET + 5], COORDS[OFFSET + 6], COORDS[OFFSET + 7]);
    }

    public void setCurve(Point P1, Point CP1, Point CP2, Point P2) {
        this.setCurve(P1.x, P1.y, CP1.x, CP1.y, CP2.x, CP2.y, P2.x, P2.y);
    }

    public void setCurve(Point[] POINTS, int OFFSET) {
        this.setCurve(POINTS[OFFSET + 0].x, POINTS[OFFSET + 0].y, POINTS[OFFSET + 1].x, POINTS[OFFSET + 1].y, POINTS[OFFSET + 2].x, POINTS[OFFSET + 2].y, POINTS[OFFSET + 3].x, POINTS[OFFSET + 3].y);
    }

    public void setCurve(BezierCurve BEZIER_CURVE) {
        this.setCurve(BEZIER_CURVE.x1, BEZIER_CURVE.y1, BEZIER_CURVE.ctrlx1, BEZIER_CURVE.ctrly1, BEZIER_CURVE.ctrlx2, BEZIER_CURVE.ctrly2, BEZIER_CURVE.x2, BEZIER_CURVE.y2);
    }

    public void setCurve(double X1, double Y1, double CTRL_X1, double CTRL_Y1, double CTRL_X2, double CTRL_Y2, double X2, double Y2) {
        this.x1 = X1;
        this.y1 = Y1;
        this.ctrlx1 = CTRL_X1;
        this.ctrly1 = CTRL_Y1;
        this.ctrlx2 = CTRL_X2;
        this.ctrly2 = CTRL_Y2;
        this.x2 = X2;
        this.y2 = Y2;
    }

    public static double getFlatnessSq(double[] COORDS, int OFFSET) {
        return BezierCurve.getFlatnessSq(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 2], COORDS[OFFSET + 3], COORDS[OFFSET + 4], COORDS[OFFSET + 5], COORDS[OFFSET + 6], COORDS[OFFSET + 7]);
    }

    public double getFlatnessSq() {
        return BezierCurve.getFlatnessSq(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public static double getFlatnessSq(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.max(Line.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static double getFlatness(double[] COORDS, int OFFSET) {
        return BezierCurve.getFlatness(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 2], COORDS[OFFSET + 3], COORDS[OFFSET + 4], COORDS[OFFSET + 5], COORDS[OFFSET + 6], COORDS[OFFSET + 7]);
    }

    public double getFlatness() {
        return BezierCurve.getFlatness(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public static double getFlatness(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return Math.sqrt(BezierCurve.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public void subdivide(double T, BezierCurve LEFT, BezierCurve RIGHT) {
        if (LEFT == null && RIGHT == null) {
            return;
        }
        double npx = this.calcX(T);
        double npy = this.calcY(T);
        double x1 = this.x1;
        double y1 = this.y1;
        double c1x = this.ctrlx1;
        double c1y = this.ctrly1;
        double c2x = this.ctrlx2;
        double c2y = this.ctrly2;
        double x2 = this.x2;
        double y2 = this.y2;
        double u = 1.0 - T;
        double hx = u * c1x + T * c2x;
        double hy = u * c1y + T * c2y;
        if (LEFT != null) {
            double lx1 = x1;
            double ly1 = y1;
            double lc1x = u * x1 + T * c1x;
            double lc1y = u * y1 + T * c1y;
            double lc2x = u * lc1x + T * hx;
            double lc2y = u * lc1y + T * hy;
            double lx2 = npx;
            double ly2 = npy;
            LEFT.setCurve(lx1, ly1, lc1x, lc1y, lc2x, lc2y, lx2, ly2);
        }
        if (RIGHT != null) {
            double rx1 = npx;
            double ry1 = npy;
            double rc2x = u * c2x + T * x2;
            double rc2y = u * c2y + T * y2;
            double rc1x = u * hx + T * rc2x;
            double rc1y = u * hy + T * rc2y;
            double rx2 = x2;
            double ry2 = y2;
            RIGHT.setCurve(rx1, ry1, rc1x, rc1y, rc2x, rc2y, rx2, ry2);
        }
    }

    public void subdivide(BezierCurve LEFT, BezierCurve RIGHT) {
        BezierCurve.subdivide(this, LEFT, RIGHT);
    }

    public static void subdivide(BezierCurve SOURCE, BezierCurve LEFT, BezierCurve RIGHT) {
        double x1 = SOURCE.x1;
        double y1 = SOURCE.y1;
        double ctrlx1 = SOURCE.ctrlx1;
        double ctrly1 = SOURCE.ctrly1;
        double ctrlx2 = SOURCE.ctrlx2;
        double ctrly2 = SOURCE.ctrly2;
        double x2 = SOURCE.x2;
        double y2 = SOURCE.y2;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + ctrlx1) / 2.0;
        ctrly1 = (y1 + ctrly1) / 2.0;
        ctrlx2 = (x2 + ctrlx2) / 2.0;
        ctrly2 = (y2 + ctrly2) / 2.0;
        double ctrlx12 = (ctrlx1 + centerx) / 2.0;
        double ctrly12 = (ctrly1 + centery) / 2.0;
        double ctrlx21 = (ctrlx2 + centerx) / 2.0;
        double ctrly21 = (ctrly2 + centery) / 2.0;
        centerx = (ctrlx12 + ctrlx21) / 2.0;
        centery = (ctrly12 + ctrly21) / 2.0;
        if (LEFT != null) {
            LEFT.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (RIGHT != null) {
            RIGHT.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        double x1 = src[srcoff + 0];
        double y1 = src[srcoff + 1];
        double ctrlx1 = src[srcoff + 2];
        double ctrly1 = src[srcoff + 3];
        double ctrlx2 = src[srcoff + 4];
        double ctrly2 = src[srcoff + 5];
        double x2 = src[srcoff + 6];
        double y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0;
        y1 = (y1 + ctrly1) / 2.0;
        x2 = (x2 + ctrlx2) / 2.0;
        y2 = (y2 + ctrly2) / 2.0;
        double centerx = (ctrlx1 + ctrlx2) / 2.0;
        double centery = (ctrly1 + ctrly2) / 2.0;
        ctrlx1 = (x1 + centerx) / 2.0;
        ctrly1 = (y1 + centery) / 2.0;
        ctrlx2 = (x2 + centerx) / 2.0;
        ctrly2 = (y2 + centery) / 2.0;
        centerx = (ctrlx1 + ctrlx2) / 2.0;
        centery = (ctrly1 + ctrly2) / 2.0;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    @Override
    public boolean intersects(double X, double Y, double WIDTH, double HEIGHT) {
        int c2tag;
        int c1tag;
        boolean yoverlap;
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        double x1 = this.x1;
        double y1 = this.y1;
        int x1tag = BezierCurve.getTag(x1, X, X + WIDTH);
        int y1tag = BezierCurve.getTag(y1, Y, Y + HEIGHT);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double x2 = this.x2;
        double y2 = this.y2;
        int x2tag = BezierCurve.getTag(x2, X, X + WIDTH);
        int y2tag = BezierCurve.getTag(y2, Y, Y + HEIGHT);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlx1 = this.ctrlx1;
        double ctrly1 = this.ctrly1;
        double ctrlx2 = this.ctrlx2;
        double ctrly2 = this.ctrly2;
        int ctrlx1tag = BezierCurve.getTag(ctrlx1, X, X + WIDTH);
        int ctrly1tag = BezierCurve.getTag(ctrly1, Y, Y + HEIGHT);
        int ctrlx2tag = BezierCurve.getTag(ctrlx2, X, X + WIDTH);
        int ctrly2tag = BezierCurve.getTag(ctrly2, Y, Y + HEIGHT);
        if (x1tag < 0 && x2tag < 0 && ctrlx1tag < 0 && ctrlx2tag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrly1tag < 0 && ctrly2tag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlx1tag > 0 && ctrlx2tag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrly1tag > 0 && ctrly2tag > 0) {
            return false;
        }
        if (BezierCurve.inwards(x1tag, x2tag, ctrlx1tag) && BezierCurve.inwards(y1tag, y2tag, ctrly1tag)) {
            return true;
        }
        if (BezierCurve.inwards(x2tag, x1tag, ctrlx2tag) && BezierCurve.inwards(y2tag, y1tag, ctrly2tag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[4];
        double[] res = new double[4];
        if (!yoverlap) {
            BezierCurve.fillEqn(eqn, y1tag < 0 ? Y : Y + HEIGHT, y1, ctrly1, ctrly2, y2);
            int num = BezierCurve.solveCubic(eqn, res);
            num = BezierCurve.evalCubic(res, num, true, true, null, x1, ctrlx1, ctrlx2, x2);
            return num == 2 && BezierCurve.getTag(res[0], X, X + WIDTH) * BezierCurve.getTag(res[1], X, X + WIDTH) <= 0;
        }
        if (!xoverlap) {
            BezierCurve.fillEqn(eqn, x1tag < 0 ? X : X + WIDTH, x1, ctrlx1, ctrlx2, x2);
            int num = BezierCurve.solveCubic(eqn, res);
            num = BezierCurve.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
            return num == 2 && BezierCurve.getTag(res[0], Y, Y + HEIGHT) * BezierCurve.getTag(res[1], Y, Y + HEIGHT) <= 0;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double k = y2 * x1 - x2 * y1;
        int n = y1tag == 0 ? x1tag : (c1tag = BezierCurve.getTag((k + dx * (y1tag < 0 ? Y : Y + HEIGHT)) / dy, X, X + WIDTH));
        int n2 = y2tag == 0 ? x2tag : (c2tag = BezierCurve.getTag((k + dx * (y2tag < 0 ? Y : Y + HEIGHT)) / dy, X, X + WIDTH));
        if (c1tag * c2tag <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        BezierCurve.fillEqn(eqn, c2tag < 0 ? X : X + WIDTH, x1, ctrlx1, ctrlx2, x2);
        int num = BezierCurve.solveCubic(eqn, res);
        num = BezierCurve.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
        int[] tags = new int[num + 1];
        for (int i = 0; i < num; ++i) {
            tags[i] = BezierCurve.getTag(res[i], Y, Y + HEIGHT);
        }
        tags[num] = c1tag;
        Arrays.sort(tags);
        return num >= 1 && tags[0] * tags[1] <= 0 || num >= 3 && tags[2] * tags[3] <= 0;
    }

    @Override
    public boolean contains(Point POINT) {
        return this.contains(POINT.x, POINT.y);
    }

    @Override
    public boolean contains(double X, double Y) {
        if (Double.compare(X * 0.0 + Y * 0.0, 0.0) != 0) {
            return false;
        }
        int crossings = Shape.pointCrossingsForLine(X, Y, this.x1, this.y1, this.x2, this.y2) + Shape.pointCrossingsForCubic(X, Y, this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2, 0);
        return (crossings & 1) == 1;
    }

    @Override
    public boolean contains(double X, double Y, double WIDTH, double HEIGHT) {
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        if (!(this.contains(X, Y) && this.contains(X + WIDTH, Y) && this.contains(X + WIDTH, Y + HEIGHT) && this.contains(X, Y + HEIGHT))) {
            return false;
        }
        return !Shape.intersectsLine(X, Y, WIDTH, HEIGHT, this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM) {
        return new BezierCurveIterator(this, TRANSFORM);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM, double FLATNESS) {
        return new FlatteningPathIterator(this.getPathIterator(TRANSFORM), FLATNESS);
    }

    private double calcX(double T) {
        double u = 1.0 - T;
        return u * u * u * this.x1 + 3.0 * (T * u * u * this.ctrlx1 + T * T * u * this.ctrlx2) + T * T * T * this.x2;
    }

    private double calcY(double T) {
        double u = 1.0 - T;
        return u * u * u * this.y1 + 3.0 * (T * u * u * this.ctrly1 + T * T * u * this.ctrly2) + T * T * T * this.y2;
    }

    @Override
    public BezierCurve copy() {
        return new BezierCurve(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BezierCurve) {
            BezierCurve curve = (BezierCurve)obj;
            return this.x1 == curve.x1 && this.y1 == curve.y1 && this.x2 == curve.x2 && this.y2 == curve.y2 && this.ctrlx1 == curve.ctrlx1 && this.ctrly1 == curve.ctrly1 && this.ctrlx2 == curve.ctrlx2 && this.ctrly2 == curve.ctrly2;
        }
        return false;
    }
}

