/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.color.MaterialDesignColors;
import eu.hansolo.fx.charts.data.ChartItem;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.series.ChartItemSeries;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.TooltipPopup;
import eu.hansolo.toolbox.Statistics;
import eu.hansolo.toolbox.evt.EvtObserver;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class BoxPlot<T extends ChartItem>
extends Region {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_WHISKER_STROKE_COLOR = Color.BLACK;
    public static final Color DEFAULT_IQR_FILL_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_IQR_STROKE_COLOR = Color.BLACK;
    public static final Color DEFAULT_MEDIAN_STROKE_COLOR = Color.RED;
    public static final Color DEFAULT_OUTLIER_FILL_COLOR = MaterialDesignColors.LIGHT_BLUE_300.get();
    public static final Color DEFAULT_OUTLIER_STROKE_COLOR = Color.TRANSPARENT;
    public static final Color DEFAULT_TEXT_FILL_COLOR = Color.BLACK;
    private static final double PREFERRED_WIDTH = 50.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private String userAgentStyleSheet;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObservableList<T> items = FXCollections.observableArrayList();
    private EvtObserver<ChartEvt> itemObserver = e -> this.redraw();
    private ListChangeListener<T> itemListListener = c -> {
        while (c.next()) {
            if (c.wasAdded()) {
                c.getAddedSubList().forEach(addedItem -> addedItem.addChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
                continue;
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(removedItem -> removedItem.removeChartEvtObserver(ChartEvt.ITEM_UPDATE, this.itemObserver));
        }
        List values = this.items.stream().map(item -> item.getValue()).collect(Collectors.toList());
        this.median = Statistics.getMedian(values);
        this.q1 = Statistics.percentile(values, (double)25.0);
        this.q3 = Statistics.percentile(values, (double)75.0);
        this.iqr = this.q3 - this.q1;
        this.iqrFraction = this.iqr * 1.5;
        this.minValue = this.items.stream().min(Comparator.comparing(ChartItem::getValue)).get().getValue();
        this.maxValue = this.items.stream().max(Comparator.comparing(ChartItem::getValue)).get().getValue();
        this.minimum = values.stream().filter(v -> v > this.q1 - this.iqrFraction).min(Comparator.naturalOrder()).get();
        this.maximum = values.stream().filter(v -> v < this.q3 + this.iqrFraction).max(Comparator.naturalOrder()).get();
        this.sorted = false;
        this.outliers.clear();
        this.outliers.addAll(this.items.stream().filter(item -> item.getValue() < this.minimum).collect(Collectors.toList()));
        this.outliers.addAll(this.items.stream().filter(item -> item.getValue() > this.maximum).collect(Collectors.toList()));
        this.min = Math.min(this.minValue, this.minimum);
        this.max = Math.max(this.maxValue, this.maximum);
        if (null != this.getYAxis()) {
            this.getYAxis().setMinValue(this.min);
            this.getYAxis().setMaxValue(this.max);
        }
    };
    private int _decimals;
    private IntegerProperty decimals;
    private Locale _locale;
    private ObjectProperty<Locale> locale;
    private String formatString;
    private TooltipPopup popup;
    private double median;
    private double q1;
    private double q3;
    private double iqr;
    private double iqrFraction;
    private double minimum;
    private double maximum;
    private double minValue;
    private double maxValue;
    private double min;
    private double max;
    private List<T> outliers;
    private String _name;
    private StringProperty name;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private Color _whiskerStrokeColor;
    private ObjectProperty<Color> whiskerStrokeColor;
    private Color _iqrFillColor;
    private ObjectProperty<Color> iqrFillColor;
    private Color _iqrStrokeColor;
    private ObjectProperty<Color> iqrStrokeColor;
    private Color _medianStrokeColor;
    private ObjectProperty<Color> medianStrokeColor;
    private Color _outlierFillColor;
    private ObjectProperty<Color> outlierFillColor;
    private Color _outlierStrokeColor;
    private ObjectProperty<Color> outlierStrokeColor;
    private boolean _nameVisible;
    private BooleanProperty nameVisible;
    private Color _textFillColor;
    private ObjectProperty<Color> textFillColor;
    private Axis _yAxis;
    private ObjectProperty<Axis> yAxis;
    private boolean sorted;

    public BoxPlot() {
        this("", new ArrayList());
    }

    public BoxPlot(List<T> ITEMS) {
        this("", ITEMS);
    }

    public BoxPlot(ChartItemSeries<T> SERIES) {
        this(SERIES.getName(), (List<T>)SERIES.getItems());
    }

    public BoxPlot(String NAME, List<T> ITEMS) {
        this._name = NAME;
        this._backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this._whiskerStrokeColor = DEFAULT_WHISKER_STROKE_COLOR;
        this._iqrFillColor = DEFAULT_IQR_FILL_COLOR;
        this._iqrStrokeColor = DEFAULT_IQR_STROKE_COLOR;
        this._medianStrokeColor = DEFAULT_MEDIAN_STROKE_COLOR;
        this._outlierFillColor = DEFAULT_OUTLIER_FILL_COLOR;
        this._outlierStrokeColor = DEFAULT_OUTLIER_STROKE_COLOR;
        this._nameVisible = false;
        this._textFillColor = DEFAULT_TEXT_FILL_COLOR;
        this._decimals = 0;
        this._locale = Locale.getDefault();
        this.formatString = "%." + this._decimals + "f";
        this.popup = new TooltipPopup("", 3500L, true);
        this.sorted = false;
        this.median = 0.0;
        this.q1 = 0.0;
        this.q3 = 0.0;
        this.iqr = 0.0;
        this.minimum = 0.0;
        this.maximum = 0.0;
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.outliers = new ArrayList<T>();
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this._yAxis = null;
        this.items.setAll((Collection)(null == ITEMS ? new ArrayList() : ITEMS));
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(50.0, 400.0);
            }
        }
        this.getStyleClass().add((Object)"box-plot");
        this.canvas = new Canvas(50.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.popup.setOnHiding(e -> this.popup.setText(""));
        this.items.addListener(this.itemListListener);
        this.canvas.setOnMousePressed(e -> {
            String tooltipText = "Name    : " + this.getName() + "\n" + "maxValue: " + String.format(this.getLocale(), this.formatString, this.maxValue) + "\n" + "Maximum : " + String.format(this.getLocale(), this.formatString, this.maximum) + "\n" + "Q3      : " + String.format(this.getLocale(), this.formatString, this.q3) + "\n" + "IQR     : " + String.format(this.getLocale(), this.formatString, this.iqr) + "\n" + "Median  : " + String.format(this.getLocale(), this.formatString, this.median) + "\n" + "Q1      : " + String.format(this.getLocale(), this.formatString, this.q1) + "\n" + "Minimum : " + String.format(this.getLocale(), this.formatString, this.minimum) + "\n" + "minValue: " + String.format(this.getLocale(), this.formatString, this.minValue);
            if (!tooltipText.isEmpty()) {
                this.popup.setX(e.getScreenX() - this.popup.getWidth() * 0.5);
                this.popup.setY(e.getScreenY() - 30.0);
                this.popup.setText(tooltipText);
                this.popup.animatedShow(this.getScene().getWindow());
            }
        });
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.items.removeListener(this.itemListListener);
    }

    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String name) {
        if (null == this.name) {
            this._name = name;
            this.redraw();
        } else {
            this.name.set((Object)name);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(ChartItemSeries<T> SERIES) {
        this.setItems((List<T>)SERIES.getItems());
        this.setName(SERIES.getName());
    }

    public void setItems(T ... ITEMS) {
        this.setItems(Arrays.asList(ITEMS));
    }

    public void setItems(List<T> ITEMS) {
        this.items.setAll(ITEMS);
    }

    public void addItem(T ITEM) {
        if (!this.items.contains(ITEM)) {
            this.items.add(ITEM);
        }
    }

    public void removeItem(T ITEM) {
        if (this.items.contains(ITEM)) {
            this.items.remove(ITEM);
        }
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 6, DECIMALS);
            this.formatString = "%." + this.getDecimals() + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                protected void invalidated() {
                    this.set(Helper.clamp(0, 6, this.get()));
                    BoxPlot.this.formatString = "%." + this.get() + "f";
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public Locale getLocale() {
        return null == this.locale ? this._locale : (Locale)this.locale.get();
    }

    public void setLocale(Locale LOCALE) {
        if (null == this.locale) {
            this._locale = LOCALE;
        } else {
            this.locale.set((Object)LOCALE);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        if (null == this.locale) {
            this.locale = new ObjectPropertyBase<Locale>(this._locale){

                protected void invalidated() {
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "locale";
                }
            };
        }
        this._locale = null;
        return this.locale;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (null == this.backgroundColor) {
            this._backgroundColor = backgroundColor;
            this.redraw();
        } else {
            this.backgroundColor.set((Object)backgroundColor);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getIqrFillColor() {
        return null == this.iqrFillColor ? this._iqrFillColor : (Color)this.iqrFillColor.get();
    }

    public void setIqrFillColor(Color iqrFillColor) {
        if (null == this.iqrFillColor) {
            this._iqrFillColor = iqrFillColor;
            this.redraw();
        } else {
            this.iqrFillColor.set((Object)iqrFillColor);
        }
    }

    public ObjectProperty<Color> iqrFillColorProperty() {
        if (null == this.iqrFillColor) {
            this.iqrFillColor = new ObjectPropertyBase<Color>(this._iqrFillColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "iqrFillColor";
                }
            };
            this._iqrFillColor = null;
        }
        return this.iqrFillColor;
    }

    public Color getIqrStrokeColor() {
        return null == this.iqrStrokeColor ? this._iqrStrokeColor : (Color)this.iqrStrokeColor.get();
    }

    public void setIqrStrokeColor(Color iqrStrokeColor) {
        if (null == this.iqrStrokeColor) {
            this._iqrStrokeColor = iqrStrokeColor;
            this.redraw();
        } else {
            this.iqrStrokeColor.set((Object)iqrStrokeColor);
        }
    }

    public ObjectProperty<Color> iqrStrokeColorProperty() {
        if (null == this.iqrStrokeColor) {
            this.iqrStrokeColor = new ObjectPropertyBase<Color>(this._iqrStrokeColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "iqrStrokeColor";
                }
            };
            this._iqrStrokeColor = null;
        }
        return this.iqrStrokeColor;
    }

    public Color getWhiskerStrokeColor() {
        return null == this.whiskerStrokeColor ? this._whiskerStrokeColor : (Color)this.whiskerStrokeColor.get();
    }

    public void setWhiskerStrokeColor(Color whiskerStrokeColor) {
        if (null == this.whiskerStrokeColor) {
            this._whiskerStrokeColor = whiskerStrokeColor;
            this.redraw();
        } else {
            this.whiskerStrokeColor.set((Object)whiskerStrokeColor);
        }
    }

    public ObjectProperty<Color> whiskerStrokeColorProperty() {
        if (null == this.whiskerStrokeColor) {
            this.whiskerStrokeColor = new ObjectPropertyBase<Color>(this._whiskerStrokeColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "whiskerStrokeColor";
                }
            };
            this._whiskerStrokeColor = null;
        }
        return this.whiskerStrokeColor;
    }

    public Color getMedianStrokeColor() {
        return null == this.medianStrokeColor ? this._medianStrokeColor : (Color)this.medianStrokeColor.get();
    }

    public void setMedianStrokeColor(Color medianStrokeColor) {
        if (null == this.medianStrokeColor) {
            this._medianStrokeColor = medianStrokeColor;
            this.redraw();
        } else {
            this.medianStrokeColor.set((Object)medianStrokeColor);
        }
    }

    public ObjectProperty<Color> medianStrokeColorProperty() {
        if (null == this.medianStrokeColor) {
            this.medianStrokeColor = new ObjectPropertyBase<Color>(this._medianStrokeColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "medianStrokeColor";
                }
            };
            this._medianStrokeColor = null;
        }
        return this.medianStrokeColor;
    }

    public Color getOutlierStrokeColor() {
        return null == this.outlierStrokeColor ? this._outlierStrokeColor : (Color)this.outlierStrokeColor.get();
    }

    public void setOutlierStrokeColor(Color outlierStrokeColor) {
        if (null == this.outlierStrokeColor) {
            this._outlierStrokeColor = outlierStrokeColor;
            this.redraw();
        } else {
            this.outlierStrokeColor.set((Object)outlierStrokeColor);
        }
    }

    public ObjectProperty<Color> outlierStrokeColorProperty() {
        if (null == this.outlierStrokeColor) {
            this.outlierStrokeColor = new ObjectPropertyBase<Color>(this._outlierStrokeColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "outlierStrokeColor";
                }
            };
            this._outlierStrokeColor = null;
        }
        return this.outlierStrokeColor;
    }

    public Color getOutlierFillColor() {
        return null == this.outlierFillColor ? this._outlierFillColor : (Color)this.outlierFillColor.get();
    }

    public void setOutlierFillColor(Color outlierFillColor) {
        if (null == this.outlierFillColor) {
            this._outlierFillColor = outlierFillColor;
            this.redraw();
        } else {
            this.outlierFillColor.set((Object)outlierFillColor);
        }
    }

    public ObjectProperty<Color> outlierFillColorProperty() {
        if (null == this.outlierFillColor) {
            this.outlierFillColor = new ObjectPropertyBase<Color>(this._outlierFillColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "outlierFillColor";
                }
            };
            this._outlierFillColor = null;
        }
        return this.outlierFillColor;
    }

    public boolean getNameVisible() {
        return null == this.nameVisible ? this._nameVisible : this.nameVisible.get();
    }

    public void setNameVisible(boolean nameVisible) {
        if (null == this.nameVisible) {
            this._nameVisible = nameVisible;
            this.redraw();
        } else {
            this.nameVisible.set(nameVisible);
        }
    }

    public BooleanProperty nameVisibleProperty() {
        if (null == this.nameVisible) {
            this.nameVisible = new BooleanPropertyBase(this._nameVisible){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "nameVisible";
                }
            };
        }
        return this.nameVisible;
    }

    public Color getTextFillColor() {
        return null == this.textFillColor ? this._textFillColor : (Color)this.textFillColor.get();
    }

    public void setTextFillColor(Color textFillColor) {
        if (null == this.textFillColor) {
            this._textFillColor = textFillColor;
            this.redraw();
        } else {
            this.textFillColor.set((Object)textFillColor);
        }
    }

    public ObjectProperty<Color> textFillColorProperty() {
        if (null == this.textFillColor) {
            this.textFillColor = new ObjectPropertyBase<Color>(this._textFillColor){

                protected void invalidated() {
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "textFillColor";
                }
            };
            this._textFillColor = null;
        }
        return this.textFillColor;
    }

    public void setPopupTimeout(long milliseconds) {
        this.popup.setTimeout(milliseconds);
    }

    public double getMedian() {
        return this.median;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ3() {
        return this.q3;
    }

    public double getIqr() {
        return this.iqr;
    }

    public double getIqrFraction() {
        return this.iqrFraction;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public List<T> getOutliers() {
        return this.outliers;
    }

    public Axis getYAxis() {
        return null == this.yAxis ? this._yAxis : (Axis)((Object)this.yAxis.get());
    }

    public void setYAxis(Axis yAxis) {
        if (null == this.yAxis) {
            this._yAxis = yAxis;
            this._yAxis.setMinValue(this.min);
            this._yAxis.setMaxValue(this.max);
            this._yAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> this.redraw()));
            this.redraw();
        } else {
            this.yAxis.set((Object)yAxis);
        }
    }

    public ObjectProperty<Axis> yAxisProperty() {
        if (null == this.yAxis) {
            this.yAxis = new ObjectPropertyBase<Axis>(this._yAxis){

                protected void invalidated() {
                    BoxPlot.this._yAxis.setMinValue(BoxPlot.this.min);
                    BoxPlot.this._yAxis.setMaxValue(BoxPlot.this.max);
                    BoxPlot.this._yAxis.addChartEvtObserver(ChartEvt.AXIS_RANGE_CHANGED, (EvtObserver<ChartEvt>)((EvtObserver)e -> BoxPlot.this.redraw()));
                    BoxPlot.this.redraw();
                }

                public Object getBean() {
                    return BoxPlot.this;
                }

                public String getName() {
                    return "yAxis";
                }
            };
        }
        return this.yAxis;
    }

    public void resetYAxis() {
        this.getYAxis().removeAllChartEvtObservers();
        this._yAxis = null;
        this.yAxis = null;
        this.min = Math.min(this.minValue, this.minimum);
        this.max = Math.max(this.maxValue, this.maximum);
        this.redraw();
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    public String getUserAgentStylesheet() {
        if (null == this.userAgentStyleSheet) {
            this.userAgentStyleSheet = BoxPlot.class.getResource("chart.css").toExternalForm();
        }
        return this.userAgentStyleSheet;
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.ctx.setTextBaseline(VPos.CENTER);
        }
        this.redraw();
    }

    private void redraw() {
        if (!this.sorted) {
            Collections.sort(this.items, Comparator.comparing(ChartItem::getValue));
            this.sorted = true;
        }
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill((Paint)this.getBackgroundColor());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        if (this.items.isEmpty()) {
            return;
        }
        Axis yAxis = this.getYAxis();
        if (null != yAxis) {
            this.min = yAxis.getMinValue();
            this.max = yAxis.getMaxValue();
        }
        double rangeY = this.max - this.min;
        double insetY = 10.0;
        double scaleFactorY = (this.height - 2.0 * insetY) / rangeY;
        double minimumY = this.height - insetY - (this.minimum - this.min) * scaleFactorY;
        double q3Y = this.height - insetY - (this.q3 - this.min) * scaleFactorY;
        double iqrY = this.iqr * scaleFactorY;
        double maximumY = this.height - insetY - (this.maximum - this.min) * scaleFactorY;
        double medianY = this.height - insetY - (this.median - this.min) * scaleFactorY;
        double outlierDiameter = this.width * 0.1;
        double outlierRadius = outlierDiameter * 0.5;
        double centerX = this.width * 0.5;
        double fontSize = this.width * 0.1;
        this.ctx.setStroke((Paint)this.getWhiskerStrokeColor());
        this.ctx.strokeLine(centerX, minimumY, centerX, maximumY);
        this.ctx.strokeLine(this.width * 0.25, minimumY, this.width * 0.75, minimumY);
        this.ctx.strokeLine(this.width * 0.25, maximumY, this.width * 0.75, maximumY);
        this.ctx.setStroke((Paint)this.getIqrStrokeColor());
        this.ctx.setFill((Paint)(Color.TRANSPARENT == this.getIqrFillColor() ? this.getBackgroundColor() : this.getIqrFillColor()));
        this.ctx.fillRect(0.0, q3Y, this.width, iqrY);
        this.ctx.strokeRect(0.0, q3Y, this.width, iqrY);
        this.ctx.setStroke((Paint)this.getMedianStrokeColor());
        this.ctx.strokeLine(0.0, medianY, this.width, medianY);
        this.ctx.setStroke((Paint)this.getOutlierStrokeColor());
        this.ctx.setFill((Paint)this.getOutlierFillColor());
        this.outliers.forEach(item -> {
            this.ctx.strokeOval(centerX - outlierRadius, this.height - insetY - (item.getValue() - this.min) * scaleFactorY, outlierDiameter, outlierDiameter);
            this.ctx.fillOval(centerX - outlierRadius, this.height - insetY - (item.getValue() - this.min) * scaleFactorY, outlierDiameter, outlierDiameter);
        });
        if (this.getNameVisible()) {
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.setFill((Paint)this.getBackgroundColor());
            this.ctx.fillRect(centerX - 1.0, minimumY - fontSize * 1.5, 2.0, fontSize);
            this.ctx.setFill((Paint)this.getTextFillColor());
            this.ctx.fillText(this.getName(), centerX, minimumY - fontSize, this.width);
        }
    }
}

