/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.data.ChartItem;
import java.time.Instant;
import java.time.ZonedDateTime;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;

public class CandleChartItem
extends ChartItem {
    private double _high;
    private DoubleProperty high;
    private double _low;
    private DoubleProperty low;
    private double _open;
    private DoubleProperty open;
    private double _close;
    private DoubleProperty close;
    private Instant _openTimestamp;
    private ObjectProperty<Instant> openTimestamp;
    private Instant _closeTimestamp;
    private ObjectProperty<Instant> closeTimestamp;

    public CandleChartItem() {
        this("", "", "", 0.0, 0.0, 0.0, 0.0, Instant.now());
    }

    public CandleChartItem(String name, String unit, String description, double low, double open, double close, double high, ZonedDateTime timestamp) {
        this.setName(name);
        this.setUnit(unit);
        this.setDescription(description);
        this.setTimestamp(timestamp);
        this._high = high;
        this._low = low;
        this._open = open;
        this._close = close;
    }

    public CandleChartItem(String name, String unit, String description, double low, double open, double close, double high, Instant timestamp) {
        this(name, unit, description, low, open, close, high, timestamp, timestamp, timestamp);
    }

    public CandleChartItem(String name, String unit, String description, double low, double open, double close, double high, Instant timestamp, Instant openTimestamp, Instant closeTimestamp) {
        this.setName(name);
        this.setUnit(unit);
        this.setDescription(description);
        this.setTimestamp(timestamp);
        this._high = high;
        this._low = low;
        this._open = open;
        this._close = close;
        this._openTimestamp = openTimestamp;
        this._closeTimestamp = closeTimestamp;
    }

    public double getHigh() {
        return null == this.high ? this._high : this.high.get();
    }

    public void setHigh(double high) {
        if (null == this.high) {
            this._high = high;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.high.set(high);
        }
    }

    public DoubleProperty highProperty() {
        if (null == this.high) {
            this.high = new DoublePropertyBase(this._high){

                protected void invalidated() {
                    CandleChartItem.this.fireChartEvt(CandleChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "high";
                }
            };
        }
        return this.high;
    }

    public double getLow() {
        return null == this.low ? this._low : this.low.get();
    }

    public void setLow(double low) {
        if (null == this.low) {
            this._low = low;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.low.set(low);
        }
    }

    public DoubleProperty lowProperty() {
        if (null == this.low) {
            this.low = new DoublePropertyBase(this._low){

                protected void invalidated() {
                    CandleChartItem.this.fireChartEvt(CandleChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "low";
                }
            };
        }
        return this.low;
    }

    public double getOpen() {
        return null == this.open ? this._open : this.open.get();
    }

    public void setOpen(double open) {
        if (null == this.open) {
            this._open = open;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.open.set(open);
        }
    }

    public DoubleProperty openProperty() {
        if (null == this.open) {
            this.open = new DoublePropertyBase(this._open){

                protected void invalidated() {
                    CandleChartItem.this.fireChartEvt(CandleChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "open";
                }
            };
        }
        return this.open;
    }

    public double getClose() {
        return null == this.close ? this._close : this.close.get();
    }

    public void setClose(double close) {
        if (null == this.close) {
            this._close = close;
            this.fireChartEvt(this.UPDATE_EVENT);
        } else {
            this.close.set(close);
        }
    }

    public DoubleProperty closeProperty() {
        if (null == this.close) {
            this.close = new DoublePropertyBase(this._close){

                protected void invalidated() {
                    CandleChartItem.this.fireChartEvt(CandleChartItem.this.UPDATE_EVENT);
                }

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "close";
                }
            };
        }
        return this.close;
    }

    public Instant getOpenTimestamp() {
        return null == this.openTimestamp ? this._openTimestamp : (Instant)this.openTimestamp.get();
    }

    public void setOpenTimestamp(long openTimestampEpochSecond) {
        this.setOpenTimestamp(Instant.ofEpochSecond(openTimestampEpochSecond));
    }

    public void setOpenTimestamp(Instant openTimestamp) {
        if (null == this.openTimestamp) {
            this._openTimestamp = openTimestamp;
        } else {
            this.openTimestamp.set((Object)openTimestamp);
        }
    }

    public ObjectProperty<Instant> openTimestampProperty() {
        if (null == this.openTimestamp) {
            this.openTimestamp = new ObjectPropertyBase<Instant>(this._openTimestamp){

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "openTimestamp";
                }
            };
            this._openTimestamp = null;
        }
        return this.openTimestamp;
    }

    public Instant getCloseTimestamp() {
        return null == this.closeTimestamp ? this._closeTimestamp : (Instant)this.closeTimestamp.get();
    }

    public void setCloseTimestamp(long closeTimestampEpochSecond) {
        this.setCloseTimestamp(Instant.ofEpochSecond(closeTimestampEpochSecond));
    }

    public void setCloseTimestamp(Instant closeTimestamp) {
        if (null == this.closeTimestamp) {
            this._closeTimestamp = closeTimestamp;
        } else {
            this.closeTimestamp.set((Object)closeTimestamp);
        }
    }

    public ObjectProperty<Instant> closeTimestampProperty() {
        if (null == this.closeTimestamp) {
            this.closeTimestamp = new ObjectPropertyBase<Instant>(this._closeTimestamp){

                public Object getBean() {
                    return CandleChartItem.this;
                }

                public String getName() {
                    return "closeTimestamp";
                }
            };
            this._closeTimestamp = null;
        }
        return this.closeTimestamp;
    }

    public void validate() {
        if (Double.compare(this.getHigh(), this.getLow()) != 0 && this.getHigh() < this.getLow()) {
            throw new IllegalArgumentException("High cannot be smaller than low");
        }
    }

    @Override
    public String toString() {
        return "{\n" + "  \"name\":" + this.getName() + ",\n" + "  \"unit\":" + this.getUnit() + ",\n" + "  \"description\":" + this.getDescription() + ",\n" + "  \"high\":" + this.getHigh() + ",\n" + "  \"low\":" + this.getLow() + ",\n" + "  \"open\":" + this.getOpen() + ",\n" + "  \"close\":" + this.getClose() + ",\n" + "  \"open_timestamp\":" + this.getOpenTimestamp().getEpochSecond() + ",\n" + "  \"close_timestamp\":" + this.getCloseTimestamp().getEpochSecond() + ",\n" + "  \"timestamp\":" + this.getTimestamp().getEpochSecond() + "\n" + "}";
    }
}

