/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Cluster;
import eu.hansolo.fx.charts.Position;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.ChartEvt;
import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.font.Fonts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class PlotItem
implements Item,
Comparable<PlotItem> {
    private final ChartEvt ITEM_EVENT = new ChartEvt(this, ChartEvt.ITEM_UPDATE);
    private String _name;
    private StringProperty name;
    private double _value;
    private DoubleProperty value;
    private String _description;
    private StringProperty description;
    private Color _fill;
    private ObjectProperty<Color> fill;
    private Color _stroke;
    private ObjectProperty<Color> stroke;
    private Color _connectionFill;
    private ObjectProperty<Color> connectionFill;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private Font _font;
    private ObjectProperty<Font> font;
    private Symbol _symbol;
    private ObjectProperty<Symbol> symbol;
    private boolean _isEmpty;
    private BooleanProperty isEmpty;
    private Position _verticalTextPosition;
    private ObjectProperty<Position> verticalTextPosition;
    private Map<PlotItem, Double> outgoing;
    private Map<PlotItem, Double> incoming;
    private Map<EvtType, List<EvtObserver<ChartEvt>>> observers;
    private int level;
    private Cluster cluster;

    public PlotItem() {
        this("", 0.0, "", Color.RED, -1, false);
    }

    public PlotItem(boolean IS_EMPTY) {
        this("", 0.0, "", Color.RED, -1, IS_EMPTY);
    }

    public PlotItem(String NAME, double VALUE) {
        this(NAME, VALUE, "", Color.RED, -1, false);
    }

    public PlotItem(String NAME, double VALUE, boolean IS_EMPTY) {
        this(NAME, VALUE, "", Color.RED, -1, IS_EMPTY);
    }

    public PlotItem(String NAME, Color COLOR) {
        this(NAME, 0.0, "", COLOR, -1, false);
    }

    public PlotItem(String NAME, Color COLOR, boolean IS_EMPTY) {
        this(NAME, 0.0, "", COLOR, -1, IS_EMPTY);
    }

    public PlotItem(String NAME, Color COLOR, int LEVEL) {
        this(NAME, 0.0, NAME, COLOR, LEVEL, false);
    }

    public PlotItem(String NAME, Color COLOR, int LEVEL, boolean IS_EMPTY) {
        this(NAME, 0.0, NAME, COLOR, LEVEL, IS_EMPTY);
    }

    public PlotItem(String NAME, double VALUE, Color COLOR) {
        this(NAME, VALUE, "", COLOR, -1, false);
    }

    public PlotItem(String NAME, double VALUE, Color COLOR, boolean IS_EMPTY) {
        this(NAME, VALUE, "", COLOR, -1, IS_EMPTY);
    }

    public PlotItem(String NAME, double VALUE, Color COLOR, int LEVEL) {
        this(NAME, VALUE, "", COLOR, LEVEL, false);
    }

    public PlotItem(String NAME, double VALUE, Color COLOR, int LEVEL, boolean IS_EMPTY) {
        this(NAME, VALUE, "", COLOR, LEVEL, IS_EMPTY);
    }

    public PlotItem(String NAME, double VALUE, String DESCRIPTION, Color FILL) {
        this(NAME, VALUE, DESCRIPTION, FILL, -1, false);
    }

    public PlotItem(String NAME, double VALUE, String DESCRIPTION, Color FILL, boolean IS_EMPTY) {
        this(NAME, VALUE, DESCRIPTION, FILL, -1, IS_EMPTY);
    }

    public PlotItem(String NAME, double VALUE, String DESCRIPTION, Color FILL, int LEVEL) {
        this(NAME, VALUE, DESCRIPTION, FILL, LEVEL, false);
    }

    public PlotItem(String NAME, double VALUE, String DESCRIPTION, Color FILL, int LEVEL, boolean IS_EMPTY) {
        this._name = NAME;
        this._value = VALUE;
        this._description = DESCRIPTION;
        this._fill = FILL;
        this._stroke = Color.TRANSPARENT;
        this._connectionFill = Color.TRANSPARENT;
        this._textColor = Color.TRANSPARENT;
        this._font = Fonts.opensansRegular((double)10.0);
        this._symbol = Symbol.NONE;
        this._isEmpty = IS_EMPTY;
        this._verticalTextPosition = Position.CENTER;
        this.level = LEVEL;
        this.cluster = null;
        this.outgoing = new LinkedHashMap<PlotItem, Double>();
        this.incoming = new LinkedHashMap<PlotItem, Double>();
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<ChartEvt>>>();
    }

    @Override
    public String getName() {
        return null == this.name ? this._name : (String)this.name.get();
    }

    public void setName(String NAME) {
        if (null == this.name) {
            this._name = NAME;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.name.set((Object)NAME);
        }
    }

    public StringProperty nameProperty() {
        if (null == this.name) {
            this.name = new StringPropertyBase(this._name){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "name";
                }
            };
            this._name = null;
        }
        return this.name;
    }

    public double getValue() {
        return null == this.value ? this._value : this.value.get();
    }

    public void setValue(double VALUE) {
        if (null == this.value) {
            this._value = VALUE;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.value.set(VALUE);
        }
    }

    public DoubleProperty valueProperty() {
        if (null == this.value) {
            this.value = new DoublePropertyBase(this._value){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "value";
                }
            };
        }
        return this.value;
    }

    public String getDescription() {
        return null == this.description ? this._description : (String)this.description.get();
    }

    public void setDescription(String DESCRIPTION) {
        if (null == this.description) {
            this._description = DESCRIPTION;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.description.set((Object)DESCRIPTION);
        }
    }

    public StringProperty descriptionProperty() {
        if (null == this.description) {
            this.description = new StringPropertyBase(this._description){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "description";
                }
            };
            this._description = null;
        }
        return this.description;
    }

    @Override
    public Color getFill() {
        return null == this.fill ? this._fill : (Color)this.fill.get();
    }

    public void setFill(Color FILL) {
        if (null == this.fill) {
            this._fill = FILL;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.fill.set((Object)FILL);
        }
    }

    public ObjectProperty<Color> fillProperty() {
        if (null == this.fill) {
            this.fill = new ObjectPropertyBase<Color>(this._fill){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "fill";
                }
            };
            this._fill = null;
        }
        return this.fill;
    }

    @Override
    public Color getStroke() {
        return null == this.stroke ? this._stroke : (Color)this.stroke.get();
    }

    public void setStroke(Color STROKE) {
        if (null == this.stroke) {
            this._stroke = STROKE;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.stroke.set((Object)STROKE);
        }
    }

    public ObjectProperty<Color> strokeProperty() {
        if (null == this.stroke) {
            this.stroke = new ObjectPropertyBase<Color>(this._stroke){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "stroke";
                }
            };
            this._stroke = null;
        }
        return this.stroke;
    }

    public Color getConnectionFill() {
        return null == this.connectionFill ? this._connectionFill : (Color)this.connectionFill.get();
    }

    private void setConnectionFill(Color FILL) {
        if (null == this.connectionFill) {
            this._connectionFill = FILL;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.connectionFill.set((Object)FILL);
        }
    }

    public ReadOnlyObjectProperty<Color> connectionFillProperty() {
        if (null == this.connectionFill) {
            this.connectionFill = new ObjectPropertyBase<Color>(this._connectionFill){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "connectionFill";
                }
            };
            this._connectionFill = null;
        }
        return this.stroke;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color TEXT_COLOR) {
        if (null == this.textColor) {
            this._textColor = TEXT_COLOR;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.textColor.set((Object)TEXT_COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public Font getFont() {
        return null == this.font ? this._font : (Font)this.font.get();
    }

    public void setFont(Font FONT) {
        if (null == this.font) {
            this._font = FONT;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.font.set((Object)FONT);
        }
    }

    public ObjectProperty<Font> fontProperty() {
        if (null == this.font) {
            this.font = new ObjectPropertyBase<Font>(this._font){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "font";
                }
            };
            this._font = null;
        }
        return this.font;
    }

    @Override
    public Symbol getSymbol() {
        return null == this.symbol ? this._symbol : (Symbol)((Object)this.symbol.get());
    }

    @Override
    public void setSymbol(Symbol SYMBOL) {
        if (null == this.symbol) {
            this._symbol = SYMBOL;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.symbol.set((Object)SYMBOL);
        }
    }

    public ObjectProperty<Symbol> symbolProperty() {
        if (null == this.symbol) {
            this.symbol = new ObjectPropertyBase<Symbol>(this._symbol){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "symbol";
                }
            };
            this._symbol = null;
        }
        return this.symbol;
    }

    @Override
    public boolean isEmptyItem() {
        return null == this.isEmpty ? this._isEmpty : this.isEmpty.get();
    }

    public void setIsEmpty(boolean isEmpty) {
        if (null == this.isEmpty) {
            this._isEmpty = isEmpty;
            this.fireChartEvt(this.ITEM_EVENT);
        } else {
            this.isEmpty.set(isEmpty);
        }
    }

    public BooleanProperty isEmptyProperty() {
        if (null == this.isEmpty) {
            this.isEmpty = new BooleanPropertyBase(this._isEmpty){

                protected void invalidated() {
                    PlotItem.this.fireChartEvt(PlotItem.this.ITEM_EVENT);
                }

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "isEmpty";
                }
            };
        }
        return this.isEmpty;
    }

    public Position getVerticalTextPosition() {
        return null == this.verticalTextPosition ? this._verticalTextPosition : (Position)((Object)this.verticalTextPosition.get());
    }

    public void setVerticalTextPosition(Position verticalTextPosition) {
        if (null == this.verticalTextPosition) {
            switch (verticalTextPosition) {
                case TOP: {
                    this._verticalTextPosition = verticalTextPosition;
                    break;
                }
                case BOTTOM: {
                    this._verticalTextPosition = verticalTextPosition;
                    break;
                }
                default: {
                    this._verticalTextPosition = Position.CENTER;
                    break;
                }
            }
        } else {
            switch (verticalTextPosition) {
                case TOP: {
                    this.verticalTextPosition.set((Object)verticalTextPosition);
                    break;
                }
                case BOTTOM: {
                    this.verticalTextPosition.set((Object)verticalTextPosition);
                    break;
                }
                default: {
                    this.verticalTextPosition.set((Object)Position.CENTER);
                }
            }
        }
    }

    public ObjectProperty<Position> verticalTextPositionProperty() {
        if (null == this.verticalTextPosition) {
            this.verticalTextPosition = new ObjectPropertyBase<Position>(this._verticalTextPosition){

                public Object getBean() {
                    return PlotItem.this;
                }

                public String getName() {
                    return "verticalTextPosition";
                }
            };
            this._verticalTextPosition = null;
        }
        return this.verticalTextPosition;
    }

    public double getSumOfIncoming() {
        return this.incoming.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getSumOfOutgoing() {
        return this.outgoing.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getMaxSum() {
        return Math.max(this.getSumOfIncoming(), this.getSumOfOutgoing());
    }

    public Map<PlotItem, Double> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(Map<PlotItem, Double> OUTGOING) {
        this.outgoing.forEach((item, value) -> item.removeFromIncoming(this));
        this.outgoing.clear();
        this.outgoing.putAll(OUTGOING);
        this.establishConnections();
        this.fireChartEvt(this.ITEM_EVENT);
    }

    public void addToOutgoing(PlotItem ITEM, double VALUE) {
        if (!this.outgoing.containsKey(ITEM)) {
            this.outgoing.put(ITEM, Helper.clamp(0.0, Double.MAX_VALUE, VALUE));
            this.establishConnections();
            this.fireChartEvt(this.ITEM_EVENT);
        }
    }

    public void removeFromOutgoing(PlotItem ITEM) {
        if (this.outgoing.containsKey(ITEM)) {
            ITEM.removeFromIncoming(this);
            this.outgoing.remove(ITEM);
            this.fireChartEvt(this.ITEM_EVENT);
        }
    }

    public void clearOutgoing() {
        this.outgoing.forEach((item, value) -> item.removeFromIncoming(this));
        this.outgoing.clear();
        this.fireChartEvt(this.ITEM_EVENT);
    }

    public boolean hasOutgoing() {
        return this.outgoing.size() > 0;
    }

    public Map<PlotItem, Double> getIncoming() {
        return this.incoming;
    }

    protected void setIncoming(Map<PlotItem, Double> INCOMING) {
        this.incoming.clear();
        this.incoming.putAll(INCOMING);
        this.fireChartEvt(this.ITEM_EVENT);
    }

    protected void addToIncoming(PlotItem ITEM, double VALUE) {
        if (!this.incoming.containsKey(ITEM)) {
            this.incoming.put(ITEM, Helper.clamp(0.0, Double.MAX_VALUE, VALUE));
            this.fireChartEvt(this.ITEM_EVENT);
        }
    }

    protected void removeFromIncoming(PlotItem ITEM) {
        if (this.incoming.containsKey(ITEM)) {
            this.incoming.remove(ITEM);
            this.fireChartEvt(this.ITEM_EVENT);
        }
    }

    protected void clearIncoming() {
        this.incoming.clear();
        this.fireChartEvt(this.ITEM_EVENT);
    }

    public boolean hasIncoming() {
        return this.incoming.size() > 0;
    }

    public double getIncomingValueFrom(PlotItem INCOMING_ITEM) {
        if (this.getIncoming().containsKey(INCOMING_ITEM)) {
            return this.getIncoming().get(INCOMING_ITEM);
        }
        return 0.0;
    }

    public double getOutgoingValueTo(PlotItem OUTGOING_ITEM) {
        if (this.getOutgoing().containsKey(OUTGOING_ITEM)) {
            return this.getOutgoing().get(OUTGOING_ITEM);
        }
        return 0.0;
    }

    public boolean isRoot() {
        return this.hasOutgoing() && !this.hasIncoming();
    }

    public boolean isLeaf() {
        return this.hasIncoming() && !this.hasOutgoing();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int LEVEL) {
        if (LEVEL < 0) {
            throw new IllegalArgumentException("Level cannot be smaller than 0");
        }
        this.level = LEVEL;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster CLUSTER) {
        this.cluster = CLUSTER;
    }

    public void sortOutgoingByGivenList(List<PlotItem> LIST_WITH_SORTED_ITEMS) {
        ArrayList<PlotItem> outgoingKeys = new ArrayList<PlotItem>(this.getOutgoing().keySet());
        this.sortAndReverse(outgoingKeys, LIST_WITH_SORTED_ITEMS);
        LinkedHashMap<PlotItem, Double> sortedOutgoingItems = new LinkedHashMap<PlotItem, Double>(outgoingKeys.size());
        for (PlotItem plotItem : outgoingKeys) {
            sortedOutgoingItems.put(plotItem, this.getOutgoing().get(plotItem));
        }
        this.outgoing.clear();
        this.outgoing.putAll(sortedOutgoingItems);
    }

    public void sortIncomingByGivenList(List<PlotItem> LIST_WITH_SORTED_ITEMS) {
        ArrayList<PlotItem> incomingKeys = new ArrayList<PlotItem>(this.getIncoming().keySet());
        Collections.reverse(incomingKeys);
        this.sortAndReverse(incomingKeys, LIST_WITH_SORTED_ITEMS);
        LinkedHashMap<PlotItem, Double> sortedIncomingItems = new LinkedHashMap<PlotItem, Double>(incomingKeys.size());
        for (PlotItem plotItem : incomingKeys) {
            sortedIncomingItems.put(plotItem, this.getIncoming().get(plotItem));
        }
        this.incoming.clear();
        this.incoming.putAll(sortedIncomingItems);
    }

    private void sortAndReverse(List<PlotItem> LIST_TO_SORT, List<PlotItem> SORTED_LIST) {
        Collections.sort(LIST_TO_SORT, Comparator.comparing(item -> SORTED_LIST.indexOf(item)));
        Collections.reverse(LIST_TO_SORT);
    }

    private void establishConnections() {
        this.outgoing.forEach((item, value) -> item.addToIncoming(this, (double)value));
    }

    @Override
    public int compareTo(PlotItem ITEM) {
        return Double.compare(this.getValue(), ITEM.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlotItem item = (PlotItem)o;
        if (Double.compare(item.getValue(), this.getValue()) != 0) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(item.getName()) : item.getName() != null) {
            return false;
        }
        return this.getName() != null ? !this.getName().equals(item.getName()) : item.getName() != null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getValue());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void addChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeChartEvtObserver(EvtType type, EvtObserver<ChartEvt> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllChartEvtObservers() {
        this.observers.clear();
    }

    public void fireChartEvt(ChartEvt evt) {
        EvtType type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(ChartEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(ChartEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

