/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.XYChartItem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class XYChartItemBuilder<B extends XYChartItemBuilder<B>> {
    private HashMap<String, Property> properties = new LinkedHashMap<String, Property>();

    protected XYChartItemBuilder() {
    }

    public static final XYChartItemBuilder create() {
        return new XYChartItemBuilder();
    }

    public final B x(double x) {
        this.properties.put("x", (Property)new SimpleDoubleProperty(x));
        return (B)this;
    }

    public final B y(double y) {
        this.properties.put("y", (Property)new SimpleDoubleProperty(y));
        return (B)this;
    }

    public final B name(String name) {
        this.properties.put("name", (Property)new SimpleStringProperty(name));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B stroke(Color fill) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B symbol(Symbol symbol) {
        this.properties.put("symbol", (Property)new SimpleObjectProperty((Object)symbol));
        return (B)this;
    }

    public final B isEmpty(boolean isEmpty) {
        this.properties.put("isEmpty", (Property)new SimpleBooleanProperty(isEmpty));
        return (B)this;
    }

    public final B tooltipText(String tooltipText) {
        this.properties.put("tooltipText", (Property)new SimpleStringProperty(tooltipText));
        return (B)this;
    }

    public final XYChartItem build() {
        XYChartItem control = new XYChartItem();
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "x": {
                    control.setX(((DoubleProperty)property).get());
                    break;
                }
                case "y": {
                    control.setY(((DoubleProperty)property).get());
                    break;
                }
                case "name": {
                    control.setName((String)((StringProperty)property).get());
                    break;
                }
                case "symbol": {
                    control.setSymbol((Symbol)((Object)((Object)((ObjectProperty)property).get())));
                    break;
                }
                case "fill": {
                    control.setFill((Color)((ObjectProperty)property).get());
                    break;
                }
                case "stroke": {
                    control.setStroke((Color)((ObjectProperty)property).get());
                    break;
                }
                case "isEmpty": {
                    control.setIsEmpty(((BooleanProperty)property).get());
                    break;
                }
                case "tooltipText": {
                    control.setTooltipText((String)((StringProperty)property).get());
                }
            }
        });
        return control;
    }
}

