/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.tools;

import eu.hansolo.fx.charts.Axis;
import eu.hansolo.fx.charts.tools.LineStyle;
import eu.hansolo.fx.charts.tools.Marker;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class MarkerBuilder<B extends MarkerBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();
    private Axis axis;
    private double value;

    protected MarkerBuilder(Axis axis, double value) {
        this.axis = axis;
        this.value = value;
    }

    public static final MarkerBuilder create(Axis axis, double value) {
        return new MarkerBuilder(axis, value);
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", (Property)new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B text(String text) {
        this.properties.put("text", (Property)new SimpleStringProperty(text));
        return (B)this;
    }

    public final B textFill(Color textFill) {
        this.properties.put("textFill", (Property)new SimpleObjectProperty((Object)textFill));
        return (B)this;
    }

    public final B fromatString(String formatString) {
        this.properties.put("formatString", (Property)new SimpleStringProperty(formatString));
        return (B)this;
    }

    public final B lineStyle(LineStyle lineStyle) {
        this.properties.put("lineStyle", (Property)new SimpleObjectProperty((Object)lineStyle));
        return (B)this;
    }

    public final Marker build() {
        Marker control = new Marker(this.axis, this.value);
        this.properties.forEach((key, property) -> {
            switch (key) {
                case "stroke": {
                    control.setStroke((Color)((ObjectProperty)property).get());
                    break;
                }
                case "lineWidth": {
                    control.setLineWidth(((DoubleProperty)property).get());
                    break;
                }
                case "text": {
                    control.setText((String)((StringProperty)property).get());
                    break;
                }
                case "textFill": {
                    control.setTextFill((Color)((ObjectProperty)property).get());
                    break;
                }
                case "formatString": {
                    control.setFormatString((String)((StringProperty)property).get());
                    break;
                }
                case "lineStyle": {
                    control.setLineStyle((LineStyle)((Object)((Object)((ObjectProperty)property).get())));
                }
            }
        });
        return control;
    }
}

