/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.voronoi.ArraySet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Graph<N> {
    private Map<N, Set<N>> neighbours = new HashMap<N, Set<N>>();
    private Set<N> nodes = Collections.unmodifiableSet(this.neighbours.keySet());

    public Set<N> getNeighbours(N node) throws NullPointerException {
        return Collections.unmodifiableSet(this.neighbours.get(node));
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    public void addNode(N node) {
        if (this.neighbours.containsKey(node)) {
            return;
        }
        this.neighbours.put(node, new ArraySet());
    }

    public void removeNode(N node) {
        if (!this.neighbours.containsKey(node)) {
            return;
        }
        for (N neighbor : this.neighbours.get(node)) {
            this.neighbours.get(neighbor).remove(node);
        }
        this.neighbours.get(node).clear();
        this.neighbours.remove(node);
    }

    public void addConnection(N nodeA, N nodeB) throws NullPointerException {
        this.neighbours.get(nodeA).add(nodeB);
        this.neighbours.get(nodeB).add(nodeA);
    }

    public void removeConnection(N nodeA, N nodeB) throws NullPointerException {
        this.neighbours.get(nodeA).remove(nodeB);
        this.neighbours.get(nodeB).remove(nodeA);
    }
}

