/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.voronoi.ArraySet;
import eu.hansolo.fx.charts.voronoi.VPoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

class Triangle
extends ArraySet<VPoint> {
    private int idNumber = idGenerator++;
    private VPoint circumcenter = null;
    private static int idGenerator = 0;
    public static boolean moreInfo = false;

    public Triangle(VPoint ... vertices) {
        this((Collection<? extends VPoint>)Arrays.asList(vertices));
    }

    public Triangle(Collection<? extends VPoint> collection) {
        super(collection);
        if (this.size() != 3) {
            throw new IllegalArgumentException("Triangle must have 3 vertices");
        }
    }

    public VPoint getVertexButNot(VPoint ... badVertices) {
        List<VPoint> bad = Arrays.asList(badVertices);
        for (VPoint v : this) {
            if (bad.contains(v)) continue;
            return v;
        }
        throw new NoSuchElementException("No vertex found");
    }

    public boolean isNeighbor(Triangle triangle) {
        int count = 0;
        for (VPoint vertex : this) {
            if (triangle.contains(vertex)) continue;
            ++count;
        }
        return count == 1;
    }

    public ArraySet<VPoint> facetOpposite(VPoint vertex) {
        ArraySet<VPoint> facet = new ArraySet<VPoint>(this);
        if (!facet.remove(vertex)) {
            throw new IllegalArgumentException("Vertex not in triangle");
        }
        return facet;
    }

    public VPoint getCircumCenter() {
        if (this.circumcenter == null) {
            this.circumcenter = VPoint.circumcenter(this.toArray(new VPoint[0]));
        }
        return this.circumcenter;
    }

    @Override
    public boolean add(VPoint vertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<VPoint> iterator() {
        return new Iterator<VPoint>(){
            private Iterator<VPoint> it;
            {
                this.it = Triangle.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public VPoint next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Triangle vPoints = (Triangle)o;
        return this.idNumber == vPoints.idNumber && Objects.equals(this.circumcenter, vPoints.circumcenter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.idNumber, this.circumcenter);
    }

    @Override
    public String toString() {
        if (!moreInfo) {
            return "Triangle" + this.idNumber;
        }
        return "Triangle" + this.idNumber + super.toString();
    }
}

