/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.voronoi;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.voronoi.Triangle;
import eu.hansolo.fx.charts.voronoi.Triangulation;
import eu.hansolo.fx.charts.voronoi.VPoint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@DefaultProperty(value="children")
public class VoronoiChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Random RND = new Random();
    private static final double POINT_RADIUS = 3.0;
    private static int initialSize = 10000;
    private String userAgentStyleSheet;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Pane pane;
    private ObservableList<VPoint> points;
    private Triangle initialTriangle;
    private Triangulation triangulation;
    private Map<Object, Color> colorTable;
    private boolean _pointsVisible;
    private BooleanProperty pointsVisible;
    private Color _pointColor;
    private ObjectProperty<Color> pointColor;
    private boolean _fillRegions;
    private BooleanProperty fillRegions;
    private Color _borderColor;
    private ObjectProperty<Color> borderColor;
    private Type _type;
    private ObjectProperty<Type> type;
    private boolean _multicolor;
    private BooleanProperty multicolor;
    private Color _voronoiColor;
    private ObjectProperty<Color> voronoiColor;
    private Color _delaunayColor;
    private ObjectProperty<Color> delaunayColor;
    private boolean _interactive;
    private BooleanProperty interactive;
    private EventHandler<MouseEvent> mouseHandler;

    public VoronoiChart() {
        this(new ArrayList<VPoint>());
    }

    public VoronoiChart(List<VPoint> points) {
        this.points = FXCollections.observableArrayList(points);
        this.initialTriangle = new Triangle(new VPoint(-initialSize, -initialSize), new VPoint(initialSize, -initialSize), new VPoint(0.0, initialSize));
        this.triangulation = new Triangulation(this.initialTriangle);
        this.colorTable = new HashMap<Object, Color>();
        this._pointsVisible = true;
        this._pointColor = Color.BLACK;
        this._fillRegions = true;
        this._borderColor = Color.BLACK;
        this._type = Type.VORONOI;
        this._multicolor = true;
        this._voronoiColor = Color.ORANGERED;
        this._delaunayColor = Color.YELLOWGREEN;
        this._interactive = false;
        this.mouseHandler = event -> this.addPoint(new VPoint(event.getX(), event.getY()));
        this.initGraphics();
        this.registerListeners();
        points.forEach(point -> this.addPoint((VPoint)point));
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.getStyleClass().add((Object)"voronoi-chart");
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.canvas});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.points.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(point -> this.addPoint((VPoint)point));
                    continue;
                }
                if (!c.wasRemoved()) continue;
            }
            this.redraw();
        });
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 1024.0;
    }

    protected double computeMaxHeight(double width) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public ObservableList<VPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<VPoint> points) {
        this.points.setAll(points);
    }

    public boolean getPointsVisible() {
        return null == this.pointsVisible ? this._pointsVisible : this.pointsVisible.get();
    }

    public void setPointsVisible(boolean visible) {
        if (null == this.pointsVisible) {
            this._pointsVisible = visible;
            this.redraw();
        } else {
            this.pointsVisible.set(visible);
        }
    }

    public BooleanProperty pointsVisibleProperty() {
        if (null == this.pointsVisible) {
            this.pointsVisible = new BooleanPropertyBase(this._pointsVisible){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "pointsVisible";
                }
            };
        }
        return this.pointsVisible;
    }

    public Color getPointColor() {
        return null == this.pointColor ? this._pointColor : (Color)this.pointColor.get();
    }

    public void setPointColor(Color color) {
        if (null == this.pointColor) {
            this._pointColor = color;
            this.redraw();
        } else {
            this.pointColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> pointColorProperty() {
        if (null == this.pointColor) {
            this.pointColor = new ObjectPropertyBase<Color>(this._pointColor){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "pointColor";
                }
            };
            this._pointColor = null;
        }
        return this.pointColor;
    }

    public boolean getFillRegions() {
        return null == this.fillRegions ? this._fillRegions : this.fillRegions.get();
    }

    public void setFillRegions(boolean fill) {
        if (null == this.fillRegions) {
            this._fillRegions = fill;
            this.redraw();
        } else {
            this.fillRegions.set(fill);
        }
    }

    public BooleanProperty fillRegionsProperty() {
        if (null == this.fillRegions) {
            this.fillRegions = new BooleanPropertyBase(this._fillRegions){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "fillAreas";
                }
            };
        }
        return this.fillRegions;
    }

    public Color getBorderColor() {
        return null == this.borderColor ? this._borderColor : (Color)this.borderColor.get();
    }

    public void setBorderColor(Color color) {
        if (null == this.borderColor) {
            this._borderColor = color;
            this.redraw();
        } else {
            this.borderColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> borderColorProperty() {
        if (null == this.borderColor) {
            this.borderColor = new ObjectPropertyBase<Color>(this._borderColor){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "borderColor";
                }
            };
            this._borderColor = null;
        }
        return this.borderColor;
    }

    public boolean isVoronoi() {
        return true;
    }

    public boolean getMulticolor() {
        return null == this.multicolor ? this._multicolor : this.multicolor.get();
    }

    public void setMulticolor(boolean multicolor) {
        if (null == this.multicolor) {
            this._multicolor = multicolor;
            this.redraw();
        } else {
            this.multicolor.set(multicolor);
        }
    }

    public BooleanProperty multicolorProperty() {
        if (null == this.multicolor) {
            this.multicolor = new BooleanPropertyBase(this._multicolor){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "colorful";
                }
            };
        }
        return this.multicolor;
    }

    public Color getVoronoiColor() {
        return null == this.voronoiColor ? this._voronoiColor : (Color)this.voronoiColor.get();
    }

    public void setVoronoiColor(Color color) {
        if (null == this.voronoiColor) {
            this._voronoiColor = color;
            this.redraw();
        } else {
            this.voronoiColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> voronoiColorProperty() {
        if (null == this.voronoiColor) {
            this.voronoiColor = new ObjectPropertyBase<Color>(this._voronoiColor){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "voronoiColor";
                }
            };
            this._voronoiColor = null;
        }
        return this.voronoiColor;
    }

    public Color getDelaunayColor() {
        return null == this.delaunayColor ? this._delaunayColor : (Color)this.delaunayColor.get();
    }

    public void setDelaunayColor(Color color) {
        if (null == this.delaunayColor) {
            this._delaunayColor = color;
            this.redraw();
        } else {
            this.delaunayColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> delaunyColorProperty() {
        if (null == this.delaunayColor) {
            this.delaunayColor = new ObjectPropertyBase<Color>(this._delaunayColor){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "delaunyColor";
                }
            };
            this._delaunayColor = null;
        }
        return this.delaunayColor;
    }

    public void addPoint(VPoint point) {
        this.triangulation.place(point);
        this.redraw();
    }

    public void clear() {
        this.triangulation = new Triangulation(this.initialTriangle);
        this.redraw();
    }

    public Type getType() {
        return null == this.type ? this._type : (Type)((Object)this.type.get());
    }

    public void setType(Type TYPE) {
        if (null == this.type) {
            this._type = TYPE;
            this.redraw();
        } else {
            this.type.set((Object)TYPE);
        }
    }

    public ObjectProperty<Type> typeProperty() {
        if (null == this.type) {
            this.type = new ObjectPropertyBase<Type>(this._type){

                protected void invalidated() {
                    VoronoiChart.this.redraw();
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "type";
                }
            };
            this._type = null;
        }
        return this.type;
    }

    public boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public void setInteractive(boolean interactive) {
        if (null == this.interactive) {
            if (this._interactive == interactive) {
                return;
            }
            this._interactive = interactive;
            if (interactive) {
                this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
            } else {
                this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
            }
        }
    }

    public BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(this._interactive){

                protected void invalidated() {
                    if (this.get()) {
                        VoronoiChart.this.canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, VoronoiChart.this.mouseHandler);
                    } else {
                        VoronoiChart.this.canvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, VoronoiChart.this.mouseHandler);
                    }
                }

                public void set(boolean INTERACTIVE) {
                    if (this.get() == INTERACTIVE) {
                        return;
                    }
                    super.set(INTERACTIVE);
                }

                public Object getBean() {
                    return VoronoiChart.this;
                }

                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    public String getUserAgentStylesheet() {
        if (null == this.userAgentStyleSheet) {
            this.userAgentStyleSheet = VoronoiChart.class.getResource("../chart.css").toExternalForm();
        }
        return this.userAgentStyleSheet;
    }

    private Color getColor(Object item) {
        if (this.colorTable.containsKey(item)) {
            return this.colorTable.get(item);
        }
        Color color = Helper.hsbToRGB(RND.nextDouble() * 360.0, 1.0, 1.0);
        this.colorTable.put(item, color);
        return color;
    }

    private void drawPoint(VPoint point) {
        double r = 3.0;
        double x = (int)point.getCoordinates(0);
        double y = (int)point.getCoordinates(1);
        this.ctx.setFill((Paint)this.getPointColor());
        this.ctx.fillOval(x - r, y - r, r + r, r + r);
    }

    private void drawPolygon(VPoint[] polygon, Color fillColor) {
        double[] x = new double[polygon.length];
        double[] y = new double[polygon.length];
        for (int i = 0; i < polygon.length; ++i) {
            x[i] = polygon[i].getCoordinates(0);
            y[i] = polygon[i].getCoordinates(1);
        }
        if (fillColor != null) {
            Paint temp = this.ctx.getFill();
            this.ctx.setFill((Paint)fillColor);
            this.ctx.fillPolygon(x, y, polygon.length);
            this.ctx.setFill(temp);
        }
        this.ctx.setStroke((Paint)this.getBorderColor());
        this.ctx.strokePolygon(x, y, polygon.length);
    }

    private void drawDelaunay() {
        boolean filled = this.getFillRegions();
        for (Triangle triangle : this.triangulation) {
            VPoint[] vertices = triangle.toArray(new VPoint[0]);
            this.drawPolygon(vertices, filled ? (this.getMulticolor() ? this.getColor(triangle) : this.getDelaunayColor()) : Color.TRANSPARENT);
        }
    }

    private void drawVoronoi() {
        boolean filled = this.getFillRegions();
        HashSet<VPoint> done = new HashSet<VPoint>(this.initialTriangle);
        for (Triangle triangle : this.triangulation) {
            for (VPoint point : triangle) {
                if (done.contains(point)) continue;
                done.add(point);
                List<Triangle> triangles = this.triangulation.surroundingTriangles(point, triangle);
                VPoint[] vertices = new VPoint[triangles.size()];
                int counter = 0;
                for (Triangle tri : triangles) {
                    vertices[counter++] = tri.getCircumCenter();
                }
                this.drawPolygon(vertices, filled ? (this.getMulticolor() ? this.getColor(point) : this.getVoronoiColor()) : Color.TRANSPARENT);
                if (!this.getPointsVisible()) continue;
                this.drawPoint(point);
            }
        }
    }

    private void drawChart() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        if (!this.isVoronoi()) {
            this.ctx.setFill((Paint)this.getDelaunayColor());
        } else if (this.triangulation.contains(this.initialTriangle)) {
            this.ctx.setFill((Paint)Color.TRANSPARENT);
        } else {
            this.ctx.setFill((Paint)this.getVoronoiColor());
        }
        this.ctx.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (!this.getMulticolor()) {
            this.colorTable.clear();
        }
        switch (this.getType().ordinal()) {
            case 0: {
                this.drawVoronoi();
                break;
            }
            case 1: {
                this.drawDelaunay();
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            this.redraw();
        }
    }

    private void redraw() {
        this.drawChart();
    }

    public static enum Type {
        VORONOI,
        DELAUNY;

    }
}

