/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.wafermap.Defect;
import eu.hansolo.fx.charts.wafermap.DefectRecordField;
import eu.hansolo.toolbox.properties.DoubleProperty;
import eu.hansolo.toolbox.properties.IntegerProperty;
import eu.hansolo.toolbox.properties.ObjectProperty;
import eu.hansolo.toolbox.properties.ReadOnlyProperty;
import java.util.HashMap;

public class DefectBuilder<B extends DefectBuilder<B>> {
    private final HashMap<String, ReadOnlyProperty> properties = new HashMap();
    private final int id;

    protected DefectBuilder(int id) {
        this.id = id;
    }

    public static final DefectBuilder create(int id) {
        return new DefectBuilder(id);
    }

    public final B relX(double relX) {
        this.properties.put(DefectRecordField.X_REL.name, (ReadOnlyProperty)new DoubleProperty(relX));
        return (B)this;
    }

    public final B relY(double relY) {
        this.properties.put(DefectRecordField.Y_REL.name, (ReadOnlyProperty)new DoubleProperty(relY));
        return (B)this;
    }

    public final B relXY(double xRel, double yRel) {
        this.properties.put("xRel", (ReadOnlyProperty)new DoubleProperty(xRel));
        this.properties.put("yRel", (ReadOnlyProperty)new DoubleProperty(yRel));
        return (B)this;
    }

    public final B indexX(int indexX) {
        this.properties.put(DefectRecordField.X_INDEX.name, (ReadOnlyProperty)new IntegerProperty(indexX));
        return (B)this;
    }

    public final B indexY(int indexY) {
        this.properties.put(DefectRecordField.Y_INDEX.name, (ReadOnlyProperty)new IntegerProperty(indexY));
        return (B)this;
    }

    public final B indexXY(int indexX, int indexY) {
        this.properties.put(DefectRecordField.X_INDEX.name, (ReadOnlyProperty)new IntegerProperty(indexX));
        this.properties.put(DefectRecordField.Y_INDEX.name, (ReadOnlyProperty)new IntegerProperty(indexY));
        return (B)this;
    }

    public final B sizeX(double sizeX) {
        this.properties.put(DefectRecordField.X_SIZE.name, (ReadOnlyProperty)new DoubleProperty(sizeX));
        return (B)this;
    }

    public final B sizeY(double sizeY) {
        this.properties.put(DefectRecordField.Y_SIZE.name, (ReadOnlyProperty)new DoubleProperty(sizeY));
        return (B)this;
    }

    public final B sizeXY(double sizeX, double sizeY) {
        this.properties.put(DefectRecordField.X_SIZE.name, (ReadOnlyProperty)new DoubleProperty(sizeX));
        this.properties.put(DefectRecordField.Y_SIZE.name, (ReadOnlyProperty)new DoubleProperty(sizeY));
        return (B)this;
    }

    public final B absoluteX(double absoluteX) {
        this.properties.put("absoluteX", (ReadOnlyProperty)new DoubleProperty(absoluteX));
        return (B)this;
    }

    public final B absoluteY(double absoluteY) {
        this.properties.put("absoluteY", (ReadOnlyProperty)new DoubleProperty(absoluteY));
        return (B)this;
    }

    public final B absoluteXY(double absoluteX, double absoluteY) {
        this.properties.put("absoluteX", (ReadOnlyProperty)new DoubleProperty(absoluteX));
        this.properties.put("absoluteY", (ReadOnlyProperty)new DoubleProperty(absoluteY));
        return (B)this;
    }

    public final B defectArea(double defectArea) {
        this.properties.put(DefectRecordField.DEFECT_AREA.name, (ReadOnlyProperty)new DoubleProperty(defectArea));
        return (B)this;
    }

    public final B sizeD(double sizeD) {
        this.properties.put(DefectRecordField.D_SIZE.name, (ReadOnlyProperty)new DoubleProperty(sizeD));
        return (B)this;
    }

    public final B classNumber(int classNumber) {
        this.properties.put(DefectRecordField.CLASS_NUMBER.name, (ReadOnlyProperty)new IntegerProperty(classNumber));
        return (B)this;
    }

    public final B roughBinNumber(int roughBinNumber) {
        this.properties.put(DefectRecordField.ROUGH_BIN_NUMBER.name, (ReadOnlyProperty)new IntegerProperty(roughBinNumber));
        return (B)this;
    }

    public final B fineBinNumber(int fineBinNumber) {
        this.properties.put(DefectRecordField.FINE_BIN_NUMBER.name, (ReadOnlyProperty)new IntegerProperty(fineBinNumber));
        return (B)this;
    }

    public final B test(int test) {
        this.properties.put(DefectRecordField.TEST.name, (ReadOnlyProperty)new IntegerProperty(test));
        return (B)this;
    }

    public final B clusterNumber(int clusterNumber) {
        this.properties.put(DefectRecordField.CLUSTER_NUMBER.name, (ReadOnlyProperty)new IntegerProperty(clusterNumber));
        return (B)this;
    }

    public final B imageCount(int imageCount) {
        this.properties.put(DefectRecordField.IMAGE_COUNT.name, (ReadOnlyProperty)new IntegerProperty(imageCount));
        return (B)this;
    }

    public final B imageList(String ... imageList) {
        this.properties.put(DefectRecordField.IMAGE_LIST.name, (ReadOnlyProperty)new ObjectProperty((Object)imageList));
        return (B)this;
    }

    public final Defect build() {
        double xRel = this.properties.containsKey(DefectRecordField.X_REL.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.X_REL.name)).get() : -1.0;
        double yRel = this.properties.containsKey(DefectRecordField.Y_REL.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.Y_REL.name)).get() : -1.0;
        int indexX = this.properties.containsKey(DefectRecordField.X_INDEX.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.X_INDEX.name)).get() : -1;
        int indexY = this.properties.containsKey(DefectRecordField.Y_INDEX.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.Y_INDEX.name)).get() : -1;
        double absoluteX = this.properties.containsKey("absoluteX") ? ((DoubleProperty)this.properties.get("absoluteX")).get() : -1.0;
        double absoluteY = this.properties.containsKey("absoluteY") ? ((DoubleProperty)this.properties.get("absoluteY")).get() : -1.0;
        double sizeX = this.properties.containsKey(DefectRecordField.X_SIZE.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.X_SIZE.name)).get() : -1.0;
        double sizeY = this.properties.containsKey(DefectRecordField.Y_SIZE.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.Y_SIZE.name)).get() : -1.0;
        double defectArea = this.properties.containsKey(DefectRecordField.DEFECT_AREA.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.DEFECT_AREA.name)).get() : -1.0;
        double sizeD = this.properties.containsKey(DefectRecordField.D_SIZE.name) ? ((DoubleProperty)this.properties.get(DefectRecordField.D_SIZE.name)).get() : -1.0;
        int classNumber = this.properties.containsKey(DefectRecordField.CLASS_NUMBER.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.CLASS_NUMBER.name)).get() : 0;
        int roughBinNumber = this.properties.containsKey(DefectRecordField.ROUGH_BIN_NUMBER.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.ROUGH_BIN_NUMBER.name)).get() : 0;
        int fineBinNumber = this.properties.containsKey(DefectRecordField.FINE_BIN_NUMBER.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.FINE_BIN_NUMBER.name)).get() : 0;
        int test = this.properties.containsKey(DefectRecordField.TEST.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.TEST.name)).get() : 0;
        int clusterNumber = this.properties.containsKey(DefectRecordField.CLUSTER_NUMBER.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.CLUSTER_NUMBER.name)).get() : 0;
        int imageCount = this.properties.containsKey(DefectRecordField.IMAGE_COUNT.name) ? ((IntegerProperty)this.properties.get(DefectRecordField.IMAGE_COUNT.name)).get() : 0;
        String[] imageFilenames = this.properties.containsKey(DefectRecordField.IMAGE_LIST.name) ? (String[])((ObjectProperty)this.properties.get(DefectRecordField.IMAGE_LIST.name)).get() : new String[]{};
        Defect defect = new Defect(this.id, xRel, yRel, indexX, indexY, sizeX, sizeY, defectArea, sizeD, classNumber, roughBinNumber, fineBinNumber, test, clusterNumber, imageCount, imageFilenames);
        return defect;
    }
}

