/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.data;

import eu.hansolo.fx.charts.data.Item;
import eu.hansolo.fx.charts.event.TreeNodeEvt;
import eu.hansolo.toolbox.evt.Evt;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TreeNode<T extends Item> {
    private T item;
    private TreeNode<T> parent;
    private TreeNode<T> myRoot;
    private TreeNode<T> treeRoot;
    private int depth;
    private double angle;
    private double x;
    private double y;
    private final ObservableList<TreeNode<T>> children;
    private Map<EvtType, List<EvtObserver<TreeNodeEvt<T>>>> observers;

    public TreeNode(T item) {
        this(item, null);
    }

    public TreeNode(T item, TreeNode<T> parent) {
        this.item = item;
        this.parent = parent;
        this.depth = -1;
        this.angle = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.children = FXCollections.observableArrayList();
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<TreeNodeEvt<T>>>>();
        this.init();
    }

    private void init() {
        if (null != this.parent) {
            this.parent.getChildren().add(this);
        }
        this.children.addListener(c -> {
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(TreeNode::removeAllTreeNodeEvtObservers);
            }
            this.getTreeRoot().fireTreeNodeEvt(new TreeNodeEvt<T>(this, TreeNodeEvt.CHILDREN_CHANGED, this.item));
        });
    }

    public boolean isRoot() {
        return null == this.parent;
    }

    public boolean isLeaf() {
        return null == this.children || this.children.isEmpty();
    }

    public boolean hasParent() {
        return null != this.parent;
    }

    public void removeParent() {
        this.parent = null;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvt(new TreeNodeEvt<T>(this, TreeNodeEvt.PARENT_REMOVED, this.item));
    }

    public boolean isParent() {
        return !this.children.isEmpty();
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> PARENT) {
        if (null != PARENT) {
            PARENT.addNode(this);
        }
        this.parent = PARENT;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvt(new TreeNodeEvt<T>(this, TreeNodeEvt.PARENT_SET, this.item));
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T ITEM) {
        this.item = ITEM;
    }

    public List<TreeNode<T>> getChildrenUnmodifiable() {
        return Collections.unmodifiableList(this.children);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> CHILDREN) {
        this.children.setAll(new LinkedHashSet<TreeNode<T>>(CHILDREN));
    }

    public void addNode(T ITEM) {
        TreeNode<T> child = new TreeNode<T>(ITEM);
        child.setParent(this);
        this.children.add(child);
    }

    public void addNode(TreeNode<T> NODE) {
        if (this.children.contains(NODE)) {
            return;
        }
        NODE.setParent(this);
        this.children.add(NODE);
    }

    public void removeNode(TreeNode<T> NODE) {
        this.children.remove(NODE);
    }

    public void addNodes(TreeNode<T> ... NODES) {
        this.addNodes(Arrays.asList(NODES));
    }

    public void addNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(this::addNode);
    }

    public void removeNodes(TreeNode<T> ... NODES) {
        this.removeNodes(Arrays.asList(NODES));
    }

    public void removeNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(this::removeNode);
    }

    public void removeAllNodes() {
        this.children.clear();
    }

    public Stream<TreeNode<T>> stream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return this.getChildren().stream().map(TreeNode::stream).reduce(Stream.of(this), Stream::concat);
    }

    public Stream<TreeNode<T>> lazyStream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(TreeNode::stream));
    }

    public Stream<TreeNode<T>> flattened() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(TreeNode::flattened));
    }

    public List<TreeNode<T>> getAll() {
        return this.flattened().collect(Collectors.toList());
    }

    public List<T> getAllData() {
        return this.flattened().map(TreeNode::getItem).collect(Collectors.toList());
    }

    public int getNoOfNodes() {
        return (int)this.flattened().map(TreeNode::getItem).count();
    }

    public int getNoOfLeafNodes() {
        return (int)this.flattened().filter(TreeNode::isLeaf).map(TreeNode::getItem).count();
    }

    public Integer getNoOfChildren() {
        return this.getChildren().size();
    }

    public boolean contains(TreeNode<T> NODE) {
        return this.flattened().anyMatch(n -> n.equals(NODE));
    }

    public boolean containsData(T ITEM) {
        return this.flattened().anyMatch(n -> n.item.equals(ITEM));
    }

    public TreeNode<T> getMyRoot() {
        if (null == this.myRoot) {
            this.myRoot = null != this.getParent() && this.getParent().isRoot() ? this : this.getMyRoot(this.getParent());
        }
        return this.myRoot;
    }

    private TreeNode<T> getMyRoot(TreeNode<T> NODE) {
        if (NODE.getParent().isRoot()) {
            return NODE;
        }
        return this.getMyRoot(NODE.getParent());
    }

    public TreeNode<T> getTreeRoot() {
        if (null == this.treeRoot) {
            this.treeRoot = this.isRoot() ? this : this.getTreeRoot(this.getParent());
        }
        return this.treeRoot;
    }

    private TreeNode<T> getTreeRoot(TreeNode<T> NODE) {
        if (NODE.isRoot()) {
            return NODE;
        }
        return this.getTreeRoot(NODE.getParent());
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.depth = this.isRoot() ? 0 : this.getDepth(this.getParent(), 0);
        }
        return this.depth;
    }

    private int getDepth(TreeNode<T> NODE, int depth) {
        ++depth;
        if (NODE.isRoot()) {
            return depth;
        }
        return this.getDepth(NODE.getParent(), depth);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getMaxLevel() {
        return this.getTreeRoot().stream().map(TreeNode::getDepth).max(Comparator.naturalOrder()).orElse(0);
    }

    public List<TreeNode<T>> getSiblings() {
        return null == this.getParent() ? new ArrayList() : this.getParent().getChildren();
    }

    public List<TreeNode<T>> nodesAtSameLevel() {
        int LEVEL = this.getDepth();
        return this.getTreeRoot().stream().filter(node -> node.getDepth() == LEVEL).collect(Collectors.toList());
    }

    public void addTreeNodeEvtObserver(EvtType type, EvtObserver<TreeNodeEvt<T>> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeTreeNodeEvtObserver(EvtType type, EvtObserver<TreeNodeEvt<T>> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllTreeNodeEvtObservers() {
        this.observers.clear();
    }

    public void fireTreeNodeEvt(TreeNodeEvt<T> evt) {
        EvtType<TreeNodeEvt> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(TreeNodeEvt.ANY)).forEach(entry -> ((List)entry.getValue()).forEach(observer -> observer.handle((Evt)evt)));
        if (this.observers.containsKey(type) && !type.equals(TreeNodeEvt.ANY)) {
            this.observers.get(type).forEach(observer -> observer.handle((Evt)evt));
        }
    }
}

