/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.series;

import eu.hansolo.fx.charts.ChartType;
import eu.hansolo.fx.charts.Symbol;
import eu.hansolo.fx.charts.data.MatrixItem;
import eu.hansolo.fx.charts.series.Series;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;

public class MatrixItemSeries<T extends MatrixItem>
extends Series {
    public MatrixItemSeries() {
        this(null, ChartType.MATRIX_HEATMAP, "");
    }

    public MatrixItemSeries(List<T> ITEMS, ChartType TYPE) {
        this(ITEMS, TYPE, "");
    }

    public MatrixItemSeries(List<T> ITEMS, ChartType TYPE, String NAME) {
        super(ITEMS, TYPE, NAME, Symbol.NONE);
    }

    @Override
    public ObservableList<T> getItems() {
        return this.items;
    }

    public int getMinX() {
        return this.getItems().stream().min(Comparator.comparingInt(MatrixItem::getX)).get().getX();
    }

    public int getMaxX() {
        return this.getItems().stream().max(Comparator.comparingInt(MatrixItem::getX)).get().getX();
    }

    public int getMinY() {
        return this.getItems().stream().min(Comparator.comparingInt(MatrixItem::getY)).get().getY();
    }

    public int getMaxY() {
        return this.getItems().stream().max(Comparator.comparingInt(MatrixItem::getY)).get().getY();
    }

    public double getMinZ() {
        return this.getItems().stream().min(Comparator.comparingDouble(MatrixItem::getZ)).get().getZ();
    }

    public double getMaxZ() {
        return this.getItems().stream().max(Comparator.comparingDouble(MatrixItem::getZ)).get().getZ();
    }

    public int getRangeX() {
        return this.getMaxX() - this.getMinX();
    }

    public int getRangeY() {
        return this.getMaxY() - this.getMinY();
    }

    public double getRangeZ() {
        return this.getMaxZ() - this.getMinZ();
    }

    public double getAt(int X, int Y) {
        Optional<MatrixItem> selectedItem = this.getItems().stream().filter(item -> item.getX() == X).filter(item -> item.getY() == Y).findFirst();
        return selectedItem.isPresent() ? selectedItem.get().getZ() : 0.0;
    }

    public void setAt(int X, int Y, double Z) {
        Optional<MatrixItem> selectedItem = this.getItems().stream().filter(item -> item.getX() == X).filter(item -> item.getY() == Y).findFirst();
        if (selectedItem.isPresent()) {
            selectedItem.get().setZ(Z);
        }
    }
}

