/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts.wafermap;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.wafermap.ClassConfig;
import eu.hansolo.fx.charts.wafermap.Constants;
import eu.hansolo.fx.charts.wafermap.Defect;
import eu.hansolo.fx.charts.wafermap.Die;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class DieMap
extends Region {
    private static final double PREFERRED_WIDTH = 500.0;
    private static final double PREFERRED_HEIGHT = 500.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private double size;
    private double width;
    private double height;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Die die;
    private double factor;
    private double defectSize;
    private double halfDefectSize;
    private Color _dieFill;
    private ObjectProperty<Color> dieFill;
    private Color _dieStroke;
    private ObjectProperty<Color> dieStroke;
    private Color _defectFill;
    private ObjectProperty<Color> defectFill;
    private Color _defectStroke;
    private ObjectProperty<Color> defectStroke;
    private Color _dieTextFill;
    private ObjectProperty<Color> dieTextFill;
    private boolean _dieTextVisible;
    private BooleanProperty dieTextVisible;
    private boolean _densityColorsVisible;
    private BooleanProperty densityColorsVisible;
    private List<Color> defectDensityColors;
    private ObservableMap<Integer, ClassConfig> classConfigMap;

    public DieMap() {
        this(null);
    }

    public DieMap(Die die) {
        this.die = die;
        this._dieFill = Constants.DEFAULT_DIE_FILL;
        this._dieStroke = Constants.DEFAULT_DIE_STROKE;
        this._defectFill = Constants.DEFAULT_DEFECT_FILL;
        this._defectStroke = Constants.DEFAULT_DEFECT_STROKE;
        this._dieTextFill = Constants.DEFAULT_DIE_LABEL_FILL;
        this._dieTextVisible = false;
        this._densityColorsVisible = false;
        this.defectDensityColors = Constants.DEFAULT_DEFECT_DENSITY_COLORS;
        this.classConfigMap = FXCollections.observableHashMap();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(500.0, 500.0);
            }
        }
        this.canvas = new Canvas(500.0, 500.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    protected double computeMinWidth(double height) {
        return 50.0;
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected double computePrefHeight(double width) {
        return super.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return 2048.0;
    }

    protected double computeMaxHeight(double width) {
        return 2048.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void setDie(Die die) {
        this.die = die;
        this.resize();
        this.redraw();
    }

    public Color getDieFill() {
        return null == this.dieFill ? this._dieFill : (Color)this.dieFill.get();
    }

    public void setDieFill(Color dieFill) {
        if (null == this.dieFill) {
            this._dieFill = dieFill;
            this.redraw();
        } else {
            this.dieFill.set((Object)dieFill);
        }
    }

    public ObjectProperty<Color> dieFillProperty() {
        if (null == this.dieFill) {
            this.dieFill = new ObjectPropertyBase<Color>(this._dieFill){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "dieFill";
                }
            };
            this._dieFill = null;
        }
        return this.dieFill;
    }

    public Color getDieStroke() {
        return null == this.dieStroke ? this._dieStroke : (Color)this.dieStroke.get();
    }

    public void setDieStroke(Color dieStroke) {
        if (null == this.dieStroke) {
            this._dieStroke = dieStroke;
            this.redraw();
        } else {
            this.dieStroke.set((Object)dieStroke);
        }
    }

    public ObjectProperty<Color> dieStrokeProperty() {
        if (null == this.dieStroke) {
            this.dieStroke = new ObjectPropertyBase<Color>(this._dieStroke){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "DieMapStroke";
                }
            };
            this._dieStroke = null;
        }
        return this.dieStroke;
    }

    public Color getDefectFill() {
        return null == this.defectFill ? this._defectFill : (Color)this.defectFill.get();
    }

    public void setDefectFill(Color defectFill) {
        if (null == this.defectFill) {
            this._defectFill = defectFill;
            this.redraw();
        } else {
            this.defectFill.set((Object)defectFill);
        }
    }

    public ObjectProperty<Color> defectFillProperty() {
        if (null == this.defectFill) {
            this.defectFill = new ObjectPropertyBase<Color>(this._defectFill){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "defectFill";
                }
            };
            this._defectFill = null;
        }
        return this.defectFill;
    }

    public Color getDefectStroke() {
        return null == this.defectStroke ? this._defectStroke : (Color)this.defectStroke.get();
    }

    public void setDefectStroke(Color defectStroke) {
        if (null == this.defectStroke) {
            this._defectStroke = defectStroke;
            this.redraw();
        } else {
            this.defectStroke.set((Object)defectStroke);
        }
    }

    public ObjectProperty<Color> defectStrokeProperty() {
        if (null == this.defectStroke) {
            this.defectStroke = new ObjectPropertyBase<Color>(this._defectStroke){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "defectStroke";
                }
            };
            this._defectStroke = null;
        }
        return this.defectStroke;
    }

    public Color getDieTextFill() {
        return null == this.dieTextFill ? this._dieTextFill : (Color)this.dieTextFill.get();
    }

    public void setDieTextFill(Color dieTextFill) {
        if (null == this.dieTextFill) {
            this._dieTextFill = dieTextFill;
            this.redraw();
        } else {
            this.dieTextFill.set((Object)dieTextFill);
        }
    }

    public ObjectProperty<Color> dieTextFillProperty() {
        if (null == this.dieTextFill) {
            this.dieTextFill = new ObjectPropertyBase<Color>(this._dieTextFill){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "dieLabelFill";
                }
            };
            this._dieTextFill = null;
        }
        return this.dieTextFill;
    }

    public boolean getDieTextVisible() {
        return null == this.dieTextVisible ? this._dieTextVisible : this.dieTextVisible.get();
    }

    public void setDieTextVisible(boolean dieTextVisible) {
        if (null == this.dieTextVisible) {
            this._dieTextVisible = dieTextVisible;
            this.redraw();
        } else {
            this.dieTextVisible.set(dieTextVisible);
        }
    }

    public BooleanProperty dieTextVisibleProperty() {
        if (null == this.dieTextVisible) {
            this.dieTextVisible = new BooleanPropertyBase(this._dieTextVisible){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "dieLabelsVisible";
                }
            };
        }
        return this.dieTextVisible;
    }

    public boolean getDensityColorsVisible() {
        return null == this.densityColorsVisible ? this._densityColorsVisible : this.densityColorsVisible.get();
    }

    public void setDensityColorsVisible(boolean densityColorsVisible) {
        if (null == this.densityColorsVisible) {
            this._densityColorsVisible = densityColorsVisible;
            this.redraw();
        } else {
            this.densityColorsVisible.set(densityColorsVisible);
        }
    }

    public BooleanProperty densityColorsVisibleProperty() {
        if (null == this.densityColorsVisible) {
            this.densityColorsVisible = new BooleanPropertyBase(this._densityColorsVisible){

                protected void invalidated() {
                    DieMap.this.redraw();
                }

                public Object getBean() {
                    return DieMap.this;
                }

                public String getName() {
                    return "densityColorsVisible";
                }
            };
        }
        return this.densityColorsVisible;
    }

    public void setClassConfigMap(Map<Integer, ClassConfig> classConfigMap) {
        this.classConfigMap.clear();
        this.classConfigMap.putAll(classConfigMap);
    }

    public void setClassConfig(int classNumber, ClassConfig classConfig) {
        if (classNumber < 0) {
            throw new IllegalArgumentException("ClassNumber cannot be smaller than 0");
        }
        this.classConfigMap.put((Object)classNumber, (Object)classConfig);
    }

    public void removeClassConfig(int classNumber) {
        if (this.classConfigMap.containsKey((Object)classNumber)) {
            this.classConfigMap.remove((Object)classNumber);
        }
    }

    public void clearClassConfig() {
        this.classConfigMap.clear();
        this.redraw();
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.defectSize = Helper.clamp(1.0, 5.0, this.size / 100.0);
            this.halfDefectSize = this.defectSize * 0.5;
            if (null == this.die) {
                this.factor = 1.0;
            } else {
                double maxDieSize = this.die.getSizeX() > this.die.getSizeY() ? this.die.getSizeX() : this.die.getSizeY();
                this.factor = this.size / maxDieSize;
            }
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.redraw();
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.5;
        double dieWidth = null == this.die ? this.size : this.die.getSizeX() * this.factor;
        double dieHeight = null == this.die ? this.size : this.die.getSizeY() * this.factor;
        double offsetX = (this.width - dieWidth) * 0.5;
        double offsetY = (this.height - dieHeight) * 0.5;
        Color dieFill = this.getDieFill();
        Color dieStroke = this.getDieStroke();
        this.ctx.setLineWidth(1.0);
        if (null == this.die) {
            this.ctx.strokeRect(offsetX, offsetY, dieWidth, dieHeight);
            return;
        }
        if (this.getDensityColorsVisible()) {
            int d = this.die.getNoOfDefects();
            if (d > 100) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(6));
            } else if (d > 60) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(5));
            } else if (d > 40) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(4));
            } else if (d > 20) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(3));
            } else if (d > 10) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(2));
            } else if (d > 0) {
                this.ctx.setFill((Paint)this.defectDensityColors.get(1));
            } else {
                this.ctx.setFill((Paint)Color.TRANSPARENT);
            }
        } else {
            this.ctx.setFill((Paint)dieFill);
        }
        this.ctx.fillRect(offsetX, offsetY, dieWidth, dieHeight);
        this.ctx.setStroke((Paint)dieStroke);
        this.ctx.strokeRect(offsetX, offsetY, dieWidth, dieHeight);
        this.ctx.setFont(Font.font((double)this.factor));
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        if (this.getDieTextVisible()) {
            this.ctx.setFill((Paint)this.getDieTextFill());
            this.ctx.fillText(this.die.getName(), centerX, centerY);
        }
        for (Defect defect : this.die.getDefects()) {
            boolean drawDefect;
            if (this.classConfigMap.isEmpty()) {
                this.ctx.setFill((Paint)this.getDefectFill());
                this.ctx.setStroke((Paint)this.getDefectStroke());
                drawDefect = true;
            } else {
                int classNumber = defect.getClassNumber();
                if (this.classConfigMap.containsKey((Object)classNumber)) {
                    drawDefect = ((ClassConfig)this.classConfigMap.get((Object)classNumber)).visible();
                    this.ctx.setFill((Paint)((ClassConfig)this.classConfigMap.get((Object)classNumber)).fill());
                    this.ctx.setStroke((Paint)((ClassConfig)this.classConfigMap.get((Object)classNumber)).stroke());
                } else {
                    drawDefect = false;
                    this.ctx.setFill((Paint)this.getDefectFill());
                    this.ctx.setStroke((Paint)this.getDefectStroke());
                }
            }
            if (!drawDefect) continue;
            double x = offsetX + defect.getXRel() / 1000.0 * this.factor;
            double y = offsetY + defect.getYRel() / 1000.0 * this.factor;
            this.ctx.fillOval(x - this.halfDefectSize, y - this.halfDefectSize, this.defectSize, this.defectSize);
            this.ctx.strokeOval(x - this.halfDefectSize, y - this.halfDefectSize, this.defectSize, this.defectSize);
        }
    }
}

