/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.FlatteningPathIterator;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.tools.IllegalPathStateException;
import eu.hansolo.fx.geometry.transform.Affine;
import eu.hansolo.fx.geometry.transform.BaseTransform;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.Arrays;
import java.util.Objects;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;

public class Path
extends Shape {
    static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    byte[] pointTypes;
    int numTypes;
    int numCoords;
    WindingRule windingRule;
    double[] doubleCoords;
    double moveX;
    double moveY;
    double prevX;
    double prevY;
    double currentX;
    double currentY;
    private Paint fill = Color.BLACK;
    private Paint stroke = Color.BLACK;

    public Path() {
        this(WindingRule.WIND_NON_ZERO, 20);
    }

    public Path(WindingRule RULE) {
        this(RULE, 20);
    }

    public Path(WindingRule RULE, int INITIAL_CAPACITY) {
        this.setWindingRule(RULE);
        this.pointTypes = new byte[INITIAL_CAPACITY];
        this.doubleCoords = new double[INITIAL_CAPACITY * 2];
    }

    public Path(Shape SHAPE) {
        this(SHAPE, null);
    }

    public Path(Shape SHAPE, BaseTransform TRANSFORM) {
        if (SHAPE instanceof Path) {
            Path p2d = (Path)SHAPE;
            this.setWindingRule(p2d.windingRule);
            this.numTypes = p2d.numTypes;
            this.pointTypes = Path.copyOf(p2d.pointTypes, p2d.pointTypes.length);
            this.numCoords = p2d.numCoords;
            if (TRANSFORM == null || TRANSFORM.isIdentity()) {
                this.doubleCoords = Path.copyOf(p2d.doubleCoords, this.numCoords);
                this.moveX = p2d.moveX;
                this.moveY = p2d.moveY;
                this.prevX = p2d.prevX;
                this.prevY = p2d.prevY;
                this.currentX = p2d.currentX;
                this.currentY = p2d.currentY;
            } else {
                this.doubleCoords = new double[this.numCoords + 6];
                TRANSFORM.transform(p2d.doubleCoords, 0, this.doubleCoords, 0, this.numCoords / 2);
                this.doubleCoords[this.numCoords + 0] = this.moveX;
                this.doubleCoords[this.numCoords + 1] = this.moveY;
                this.doubleCoords[this.numCoords + 2] = this.prevX;
                this.doubleCoords[this.numCoords + 3] = this.prevY;
                this.doubleCoords[this.numCoords + 4] = this.currentX;
                this.doubleCoords[this.numCoords + 5] = this.currentY;
                TRANSFORM.transform(this.doubleCoords, this.numCoords, this.doubleCoords, this.numCoords, 3);
                this.moveX = this.doubleCoords[this.numCoords + 0];
                this.moveY = this.doubleCoords[this.numCoords + 1];
                this.prevX = this.doubleCoords[this.numCoords + 2];
                this.prevY = this.doubleCoords[this.numCoords + 3];
                this.currentX = this.doubleCoords[this.numCoords + 4];
                this.currentY = this.doubleCoords[this.numCoords + 5];
            }
        } else {
            PathIterator pi = SHAPE.getPathIterator(TRANSFORM);
            this.setWindingRule(pi.getWindingRule());
            this.pointTypes = new byte[20];
            this.doubleCoords = new double[40];
            this.append(pi, false);
        }
    }

    public Path(WindingRule RULE, byte[] POINT_TYPES, int NUM_TYPES, double[] POINT_COORDS, int NUM_COORDS) {
        this.windingRule = RULE;
        this.pointTypes = POINT_TYPES;
        this.numTypes = NUM_TYPES;
        this.doubleCoords = POINT_COORDS;
        this.numCoords = NUM_COORDS;
    }

    Point getPoint(int INDEX) {
        return new Point(this.doubleCoords[INDEX], this.doubleCoords[INDEX + 1]);
    }

    void needRoom(boolean NEED_MOVE, int NEW_COORDS) {
        int grow;
        if (NEED_MOVE && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int size = this.pointTypes.length;
        if (size == 0) {
            this.pointTypes = new byte[2];
        } else if (this.numTypes >= size) {
            grow = size;
            if (grow > 500) {
                grow = 500;
            }
            this.pointTypes = Path.copyOf(this.pointTypes, size + grow);
        }
        size = this.doubleCoords.length;
        if (this.numCoords + NEW_COORDS > size) {
            grow = size;
            if (grow > 1000) {
                grow = 1000;
            }
            if (grow < NEW_COORDS) {
                grow = NEW_COORDS;
            }
            this.doubleCoords = Path.copyOf(this.doubleCoords, size + grow);
        }
    }

    public final void moveTo(Point P) {
        this.moveTo(P.getX(), P.getY());
    }

    public final void moveTo(double X, double Y) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.prevX = this.currentX = X;
            this.moveX = this.currentX;
            this.doubleCoords[this.numCoords - 2] = this.currentX;
            this.prevY = this.currentY = Y;
            this.moveY = this.currentY;
            this.doubleCoords[this.numCoords - 1] = this.currentY;
        } else {
            this.needRoom(false, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.prevX = this.currentX = X;
            this.moveX = this.currentX;
            this.doubleCoords[this.numCoords++] = this.currentX;
            this.prevY = this.currentY = Y;
            this.moveY = this.currentY;
            this.doubleCoords[this.numCoords++] = this.currentY;
        }
    }

    public final void moveToRel(Point P) {
        this.moveToRel(P.getX(), P.getY());
    }

    public final void moveToRel(double X_REL, double Y_REL) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.prevX = this.currentX += X_REL;
            this.moveX = this.currentX;
            this.doubleCoords[this.numCoords - 2] = this.currentX;
            this.prevY = this.currentY += Y_REL;
            this.moveY = this.currentY;
            this.doubleCoords[this.numCoords - 1] = this.currentY;
        } else {
            this.needRoom(true, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.prevX = this.currentX += X_REL;
            this.moveX = this.currentX;
            this.doubleCoords[this.numCoords++] = this.currentX;
            this.prevY = this.currentY += Y_REL;
            this.moveY = this.currentY;
            this.doubleCoords[this.numCoords++] = this.currentY;
        }
    }

    public final void lineTo(Point P) {
        this.lineTo(P.getX(), P.getY());
    }

    public final void lineTo(double X, double Y) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currentX = X;
        this.doubleCoords[this.numCoords++] = this.currentX;
        this.prevY = this.currentY = Y;
        this.doubleCoords[this.numCoords++] = this.currentY;
    }

    public final void lineToRel(Point P) {
        this.lineToRel(P.getX(), P.getY());
    }

    public final void lineToRel(double X_REL, double Y_REL) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.prevX = this.currentX += X_REL;
        this.doubleCoords[this.numCoords++] = this.currentX;
        this.prevY = this.currentY += Y_REL;
        this.doubleCoords[this.numCoords++] = this.currentY;
    }

    public final void quadraticCurveTo(Point P1, Point P2) {
        this.quadraticCurveTo(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public final void quadraticCurveTo(double X1, double Y1, double X2, double Y2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.doubleCoords[this.numCoords++] = this.prevX = X1;
        this.doubleCoords[this.numCoords++] = this.prevY = Y1;
        this.doubleCoords[this.numCoords++] = this.currentX = X2;
        this.doubleCoords[this.numCoords++] = this.currentY = Y2;
    }

    public final void quadraticCurveToRel(Point P1, Point P2) {
        this.quadraticCurveToRel(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public final void quadraticCurveToRel(double X1_REL, double Y1_REL, double X2_REL, double Y2_REL) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.doubleCoords[this.numCoords++] = this.prevX = this.currentX + X1_REL;
        this.doubleCoords[this.numCoords++] = this.prevY = this.currentY + Y1_REL;
        this.doubleCoords[this.numCoords++] = this.currentX += X2_REL;
        this.doubleCoords[this.numCoords++] = this.currentY += Y2_REL;
    }

    public final void quadraticCurveToSmooth(Point P) {
        this.quadraticCurveToSmooth(P.getX(), P.getY());
    }

    public final void quadraticCurveToSmooth(double X2, double Y2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.doubleCoords[this.numCoords++] = this.prevX = this.currentX * 2.0 - this.prevX;
        this.doubleCoords[this.numCoords++] = this.prevY = this.currentY * 2.0 - this.prevY;
        this.doubleCoords[this.numCoords++] = this.currentX = X2;
        this.doubleCoords[this.numCoords++] = this.currentY = Y2;
    }

    public final void quadraticCurveToSmoothRel(Point P2) {
        this.quadraticCurveToSmoothRel(P2.getX(), P2.getY());
    }

    public final void quadraticCurveToSmoothRel(double X2_REL, double Y2_REL) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.doubleCoords[this.numCoords++] = this.prevX = this.currentX * 2.0 - this.prevX;
        this.doubleCoords[this.numCoords++] = this.prevY = this.currentY * 2.0 - this.prevY;
        this.doubleCoords[this.numCoords++] = this.currentX += X2_REL;
        this.doubleCoords[this.numCoords++] = this.currentY += Y2_REL;
    }

    public final void bezierCurveTo(Point P1, Point P2, Point P_END) {
        this.bezierCurveTo(P1.getX(), P1.getY(), P2.getX(), P2.getY(), P_END.getX(), P_END.getY());
    }

    public final void bezierCurveTo(double X1, double Y1, double X2, double Y2, double X_END, double Y_END) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.doubleCoords[this.numCoords++] = X1;
        this.doubleCoords[this.numCoords++] = Y1;
        this.doubleCoords[this.numCoords++] = this.prevX = X2;
        this.doubleCoords[this.numCoords++] = this.prevY = Y2;
        this.doubleCoords[this.numCoords++] = this.currentX = X_END;
        this.doubleCoords[this.numCoords++] = this.currentY = Y_END;
    }

    public final void bezierCurveToRel(Point P1, Point P2, Point P_END) {
        this.bezierCurveToRel(P1.getX(), P1.getY(), P2.getX(), P2.getY(), P_END.getX(), P_END.getY());
    }

    public final void bezierCurveToRel(double X1_REL, double Y1_REL, double X2_REL, double Y2_REL, double X_END_REL, double Y_END_REL) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.doubleCoords[this.numCoords++] = this.currentX + X1_REL;
        this.doubleCoords[this.numCoords++] = this.currentY + Y1_REL;
        this.doubleCoords[this.numCoords++] = this.prevX = this.currentX + X2_REL;
        this.doubleCoords[this.numCoords++] = this.prevY = this.currentY + Y2_REL;
        this.doubleCoords[this.numCoords++] = this.currentX += X_END_REL;
        this.doubleCoords[this.numCoords++] = this.currentY += Y_END_REL;
    }

    public final void bezierCurveToSmooth(Point P2, Point P_END) {
        this.bezierCurveToSmooth(P2.getX(), P2.getY(), P_END.getX(), P_END.getY());
    }

    public final void bezierCurveToSmooth(double X2, double Y2, double X_END, double Y_END) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.doubleCoords[this.numCoords++] = this.currentX * 2.0 - this.prevX;
        this.doubleCoords[this.numCoords++] = this.currentY * 2.0 - this.prevY;
        this.doubleCoords[this.numCoords++] = this.prevX = X2;
        this.doubleCoords[this.numCoords++] = this.prevY = Y2;
        this.doubleCoords[this.numCoords++] = this.currentX = X_END;
        this.doubleCoords[this.numCoords++] = this.currentY = Y_END;
    }

    public final void bezierCurveToSmoothRel(Point P2, Point P_END) {
        this.bezierCurveToSmoothRel(P2.getX(), P2.getY(), P_END.getX(), P_END.getY());
    }

    public final void bezierCurveToSmoothRel(double X2_REL, double Y2_REL, double X_END_REL, double Y_END_REL) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.doubleCoords[this.numCoords++] = this.currentX * 2.0 - this.prevX;
        this.doubleCoords[this.numCoords++] = this.currentY * 2.0 - this.prevY;
        this.doubleCoords[this.numCoords++] = this.prevX = this.currentX + X2_REL;
        this.doubleCoords[this.numCoords++] = this.prevY = this.currentY + Y2_REL;
        this.doubleCoords[this.numCoords++] = this.currentX += X_END_REL;
        this.doubleCoords[this.numCoords++] = this.currentY += Y_END_REL;
    }

    public final void ovalQuadrantTo(double CX, double CY, double EX, double EY, double T_FROM, double T_TO) {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        this.appendOvalQuadrant(this.currentX, this.currentY, CX, CY, EX, EY, T_FROM, T_TO, CornerPrefix.CORNER_ONLY);
    }

    public void arcTo(double radiusx, double radiusy, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        double sinPhi;
        double cosPhi;
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        double rx = Math.abs(radiusx);
        double ry = Math.abs(radiusy);
        if (rx == 0.0 || ry == 0.0) {
            this.lineTo(x, y);
            return;
        }
        double x1 = this.currentX;
        double y1 = this.currentY;
        double x2 = x;
        double y2 = y;
        if (x1 == x2 && y1 == y2) {
            return;
        }
        if (xAxisRotation == 0.0) {
            cosPhi = 1.0;
            sinPhi = 0.0;
        } else {
            cosPhi = Math.cos(xAxisRotation);
            sinPhi = Math.sin(xAxisRotation);
        }
        double mx = (x1 + x2) / 2.0;
        double my = (y1 + y2) / 2.0;
        double relx1 = x1 - mx;
        double rely1 = y1 - my;
        double x1p = (cosPhi * relx1 + sinPhi * rely1) / rx;
        double y1p = (cosPhi * rely1 - sinPhi * relx1) / ry;
        double lenpsq = x1p * x1p + y1p * y1p;
        if (lenpsq >= 1.0) {
            double xqpr = y1p * rx;
            double yqpr = x1p * ry;
            if (sweepFlag) {
                xqpr = -xqpr;
            } else {
                yqpr = -yqpr;
            }
            double relxq = cosPhi * xqpr - sinPhi * yqpr;
            double relyq = cosPhi * yqpr + sinPhi * xqpr;
            double xq = mx + relxq;
            double yq = my + relyq;
            double xc = x1 + relxq;
            double yc = y1 + relyq;
            this.appendOvalQuadrant(x1, y1, xc, yc, xq, yq, 0.0, 1.0, CornerPrefix.CORNER_ONLY);
            xc = x2 + relxq;
            yc = y2 + relyq;
            this.appendOvalQuadrant(xq, yq, xc, yc, x2, y2, 0.0, 1.0, CornerPrefix.CORNER_ONLY);
            return;
        }
        double scalef = Math.sqrt((1.0 - lenpsq) / lenpsq);
        double cxp = scalef * y1p;
        double cyp = scalef * x1p;
        if (largeArcFlag == sweepFlag) {
            cxp = -cxp;
        } else {
            cyp = -cyp;
        }
        double ux = x1p - cxp;
        double uy = y1p - cyp;
        double vx = -(x1p + cxp);
        double vy = -(y1p + cyp);
        boolean done = false;
        double quadlen = 1.0;
        boolean wasclose = false;
        mx += cosPhi * cxp * rx - sinPhi * cyp * ry;
        my += cosPhi * cyp * ry + sinPhi * cxp * rx;
        do {
            double xqp = uy;
            double yqp = ux;
            if (sweepFlag) {
                xqp = -xqp;
            } else {
                yqp = -yqp;
            }
            if (xqp * vx + yqp * vy > 0.0) {
                double dot = ux * vx + uy * vy;
                if (dot >= 0.0) {
                    quadlen = Math.acos(dot) / 1.5707963267948966;
                    done = true;
                }
                wasclose = true;
            } else if (wasclose) break;
            double relxq = cosPhi * xqp * rx - sinPhi * yqp * ry;
            double relyq = cosPhi * yqp * ry + sinPhi * xqp * rx;
            double xq = mx + relxq;
            double yq = my + relyq;
            double xc = x1 + relxq;
            double yc = y1 + relyq;
            this.appendOvalQuadrant(x1, y1, xc, yc, xq, yq, 0.0, quadlen, CornerPrefix.CORNER_ONLY);
            x1 = xq;
            y1 = yq;
            ux = xqp;
            uy = yqp;
        } while (!done);
    }

    public void arcToRel(double radiusx, double radiusy, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double relx, double rely) {
        this.arcTo(radiusx, radiusy, xAxisRotation, largeArcFlag, sweepFlag, this.currentX + relx, this.currentY + rely);
    }

    int piontCrossings(Point P) {
        return this.pointCrossings(P.getX(), P.getY());
    }

    int pointCrossings(double POINT_X, double POINT_Y) {
        double movy;
        double movx;
        double[] coords = this.doubleCoords;
        double curx = movx = coords[0];
        double cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings += Shape.pointCrossingsForQuad(POINT_X, POINT_Y, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings += Shape.pointCrossingsForCubic(POINT_X, POINT_Y, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (cury != movy) {
            crossings += Shape.pointCrossingsForLine(POINT_X, POINT_Y, curx, cury, movx, movy);
        }
        return crossings;
    }

    int rectCrossings(double RX_MIN, double RY_MIN, double RX_MAX, double RY_MAX) {
        double movy;
        double movx;
        double[] coords = this.doubleCoords;
        double curx = movx = coords[0];
        double cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; crossings != Integer.MIN_VALUE && i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings = Shape.rectCrossingsForLine(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings = Shape.rectCrossingsForQuad(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    double endx = coords[ci++];
                    double endy = coords[ci++];
                    crossings = Shape.rectCrossingsForCubic(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (crossings != Integer.MIN_VALUE && (curx != movx || cury != movy)) {
            crossings = Shape.rectCrossingsForLine(crossings, RX_MIN, RY_MIN, RX_MAX, RY_MAX, curx, cury, movx, movy);
        }
        return crossings;
    }

    public final void transform(BaseTransform TRANSFORM) {
        if (this.numCoords == 0) {
            return;
        }
        this.needRoom(false, 6);
        this.doubleCoords[this.numCoords + 0] = this.moveX;
        this.doubleCoords[this.numCoords + 1] = this.moveY;
        this.doubleCoords[this.numCoords + 2] = this.prevX;
        this.doubleCoords[this.numCoords + 3] = this.prevY;
        this.doubleCoords[this.numCoords + 4] = this.currentX;
        this.doubleCoords[this.numCoords + 5] = this.currentY;
        TRANSFORM.transform(this.doubleCoords, 0, this.doubleCoords, 0, this.numCoords / 2 + 3);
        this.moveX = this.doubleCoords[this.numCoords + 0];
        this.moveY = this.doubleCoords[this.numCoords + 1];
        this.prevX = this.doubleCoords[this.numCoords + 2];
        this.prevY = this.doubleCoords[this.numCoords + 3];
        this.currentX = this.doubleCoords[this.numCoords + 4];
        this.currentY = this.doubleCoords[this.numCoords + 5];
    }

    @Override
    public final RectBounds getBounds() {
        double x1;
        double x2;
        double y1;
        double y2;
        int i = this.numCoords;
        if (i > 0) {
            y1 = y2 = this.doubleCoords[--i];
            x1 = x2 = this.doubleCoords[--i];
            while (i > 0) {
                double x;
                double y = this.doubleCoords[--i];
                if ((x = this.doubleCoords[--i]) < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        }
        return new RectBounds(x1, y1, x2, y2);
    }

    public final int getNumCommands() {
        return this.numTypes;
    }

    public final byte[] getCommandsNoClone() {
        return this.pointTypes;
    }

    public final double[] getDoubleCoordsNoClone() {
        return this.doubleCoords;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM) {
        return null == TRANSFORM ? new CopyIterator(this) : new TxIterator(this, TRANSFORM);
    }

    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
            this.prevX = this.currentX = this.moveX;
            this.prevY = this.currentY = this.moveY;
        }
    }

    public void pathDone() {
    }

    public final void append(PathIterator PATH_ITERATOR, boolean connect) {
        double[] coords = new double[6];
        while (!PATH_ITERATOR.isDone()) {
            switch (PATH_ITERATOR.currentSegment(coords)) {
                case 0: {
                    if (!connect || this.numTypes < 1 || this.numCoords < 1) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.doubleCoords[this.numCoords - 2] == coords[0] && this.doubleCoords[this.numCoords - 1] == coords[1]) break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadraticCurveTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.bezierCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            PATH_ITERATOR.next();
            connect = false;
        }
    }

    public final void append(Shape SHAPE, boolean CONNECT) {
        this.append(SHAPE.getPathIterator(null), CONNECT);
    }

    public final void appendOvalQuadrant(double sx, double sy, double cx, double cy, double ex, double ey, double tfrom, double tto, CornerPrefix prefix) {
        if (Double.compare(tfrom, 0.0) < 0 || Double.compare(tfrom, tto) > 0 || !((double)Double.compare(tto, 1.0) <= 0.0)) {
            throw new IllegalArgumentException("0 <= tfrom <= tto <= 1 required");
        }
        double cx0 = sx + (cx - sx) * 0.5522847498307933;
        double cy0 = sy + (cy - sy) * 0.5522847498307933;
        double cx1 = ex + (cx - ex) * 0.5522847498307933;
        double cy1 = ey + (cy - ey) * 0.5522847498307933;
        if (tto < 1.0) {
            double t = 1.0 - tto;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
            cx1 += (cx0 - cx1) * t;
            cy1 += (cy0 - cy1) * t;
            cx0 += (sx - cx0) * t;
            cy0 += (sy - cy0) * t;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
            cx1 += (cx0 - cx1) * t;
            cy1 += (cy0 - cy1) * t;
            ex += (cx1 - ex) * t;
            ey += (cy1 - ey) * t;
        }
        if (tfrom > 0.0) {
            if (tto < 1.0) {
                tfrom /= tto;
            }
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
            cx0 += (cx1 - cx0) * tfrom;
            cy0 += (cy1 - cy0) * tfrom;
            cx1 += (ex - cx1) * tfrom;
            cy1 += (ey - cy1) * tfrom;
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
            cx0 += (cx1 - cx0) * tfrom;
            cy0 += (cy1 - cy0) * tfrom;
            sx += (cx0 - sx) * tfrom;
            sy += (cy0 - sy) * tfrom;
        }
        if (prefix == CornerPrefix.MOVE_THEN_CORNER) {
            this.moveTo(sx, sy);
        } else if (prefix == CornerPrefix.LINE_THEN_CORNER && (this.numTypes == 1 || sx != this.currentX || sy != this.currentY)) {
            this.lineTo(sx, sy);
        }
        if (tfrom == tto || sx == cx0 && cx0 == cx1 && cx1 == ex && sy == cy0 && cy0 == cy1 && cy1 == ey) {
            if (prefix != CornerPrefix.LINE_THEN_CORNER) {
                this.lineTo(ex, ey);
            }
        } else {
            this.bezierCurveTo(cx0, cy0, cx1, cy1, ex, ey);
        }
    }

    public final void appendSVGPath(String SVG_PATH) {
        SVGParser p = new SVGParser(SVG_PATH);
        p.allowComma = false;
        while (!p.isDone()) {
            p.allowComma = false;
            char cmd = p.getChar();
            switch (cmd) {
                case 'M': {
                    this.moveTo(p.f(), p.f());
                    while (p.nextIsNumber()) {
                        this.lineTo(p.f(), p.f());
                    }
                    break;
                }
                case 'm': {
                    if (this.numTypes > 0) {
                        this.moveToRel(p.f(), p.f());
                    } else {
                        this.moveTo(p.f(), p.f());
                    }
                    while (p.nextIsNumber()) {
                        this.lineToRel(p.f(), p.f());
                    }
                    break;
                }
                case 'L': {
                    do {
                        this.lineTo(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'l': {
                    do {
                        this.lineToRel(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'H': {
                    do {
                        this.lineTo(p.f(), this.currentY);
                    } while (p.nextIsNumber());
                    break;
                }
                case 'h': {
                    do {
                        this.lineToRel(p.f(), 0.0);
                    } while (p.nextIsNumber());
                    break;
                }
                case 'V': {
                    do {
                        this.lineTo(this.currentX, p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'v': {
                    do {
                        this.lineToRel(0.0, p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'Q': {
                    do {
                        this.quadraticCurveTo(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'q': {
                    do {
                        this.quadraticCurveToRel(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'T': {
                    do {
                        this.quadraticCurveToSmooth(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 't': {
                    do {
                        this.quadraticCurveToSmoothRel(p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'C': {
                    do {
                        this.bezierCurveTo(p.f(), p.f(), p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'c': {
                    do {
                        this.bezierCurveToRel(p.f(), p.f(), p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'S': {
                    do {
                        this.bezierCurveToSmooth(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 's': {
                    do {
                        this.bezierCurveToSmoothRel(p.f(), p.f(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'A': {
                    do {
                        this.arcTo(p.f(), p.f(), p.a(), p.b(), p.b(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'a': {
                    do {
                        this.arcToRel(p.f(), p.f(), p.a(), p.b(), p.b(), p.f(), p.f());
                    } while (p.nextIsNumber());
                    break;
                }
                case 'Z': 
                case 'z': {
                    this.closePath();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid command (" + cmd + ") in SVG path at pos=" + p.pos);
                }
            }
            p.allowComma = false;
        }
    }

    public final WindingRule getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(WindingRule RULE) {
        if (RULE != WindingRule.WIND_EVEN_ODD && RULE != WindingRule.WIND_NON_ZERO) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = RULE;
    }

    public final double getCurrentX() {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currentX;
    }

    public final double getCurrentY() {
        if (this.numTypes < 1) {
            throw new IllegalPathStateException("no current point in empty path");
        }
        return this.currentY;
    }

    public final Point getCurrentPoint() {
        if (this.numTypes < 1) {
            return null;
        }
        return new Point(this.currentX, this.currentY);
    }

    public final void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
        this.currentY = 0.0;
        this.currentX = 0.0;
        this.prevY = 0.0;
        this.prevX = 0.0;
        this.moveY = 0.0;
        this.moveX = 0.0;
    }

    public final Shape createTransformedShape(BaseTransform TRANSFORM) {
        return new Path(this, TRANSFORM);
    }

    @Override
    public Path copy() {
        return new Path(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.pointTypes), this.numTypes, this.numCoords, this.windingRule, Arrays.hashCode(this.doubleCoords), this.moveX, this.moveY, this.prevX, this.prevY, this.currentX, this.currentY, this.fill, this.stroke});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path p = (Path)obj;
            if (p.numTypes == this.numTypes && p.numCoords == this.numCoords && p.windingRule == this.windingRule) {
                int i;
                for (i = 0; i < this.numTypes; ++i) {
                    if (p.pointTypes[i] == this.pointTypes[i]) continue;
                    return false;
                }
                for (i = 0; i < this.numCoords; ++i) {
                    if (p.doubleCoords[i] == this.doubleCoords[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean contains(PathIterator PATH_ITERATOR, double X, double Y) {
        if (X * 0.0 + Y * 0.0 == 0.0) {
            int mask = PATH_ITERATOR.getWindingRule() == WindingRule.WIND_NON_ZERO ? -1 : 1;
            int cross = Shape.pointCrossingsForPath(PATH_ITERATOR, X, Y);
            return (cross & mask) != 0;
        }
        return false;
    }

    public static boolean contains(PathIterator PATH_ITERATOR, Point POINT) {
        return Path.contains(PATH_ITERATOR, POINT.x, POINT.y);
    }

    @Override
    public final boolean contains(double X, double Y) {
        if (X * 0.0 + Y * 0.0 == 0.0) {
            if (this.numTypes < 2) {
                return false;
            }
            int mask = this.windingRule == WindingRule.WIND_NON_ZERO ? -1 : 1;
            return (this.pointCrossings(X, Y) & mask) != 0;
        }
        return false;
    }

    @Override
    public final boolean contains(Point POINT) {
        return this.contains(POINT.x, POINT.y);
    }

    public static boolean contains(PathIterator PATH_ITERATOR, double X, double Y, double WIDTH, double HEIGHT) {
        if (Double.isNaN(X + WIDTH) || Double.isNaN(Y + HEIGHT)) {
            return false;
        }
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        int mask = PATH_ITERATOR.getWindingRule() == WindingRule.WIND_NON_ZERO ? -1 : 2;
        int crossings = Shape.rectCrossingsForPath(PATH_ITERATOR, X, Y, X + WIDTH, Y + HEIGHT);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    @Override
    public final boolean contains(double X, double Y, double WIDTH, double HEIGHT) {
        if (Double.isNaN(X + WIDTH) || Double.isNaN(Y + HEIGHT)) {
            return false;
        }
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        int mask = this.windingRule == WindingRule.WIND_NON_ZERO ? -1 : 2;
        int crossings = this.rectCrossings(X, Y, X + WIDTH, Y + HEIGHT);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    public static boolean intersects(PathIterator PATH_ITERATOR, double X, double Y, double WIDTH, double HEIGHT) {
        if (Double.isNaN(X + WIDTH) || Double.isNaN(Y + HEIGHT)) {
            return false;
        }
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        int mask = PATH_ITERATOR.getWindingRule() == WindingRule.WIND_NON_ZERO ? -1 : 2;
        int crossings = Shape.rectCrossingsForPath(PATH_ITERATOR, X, Y, X + WIDTH, Y + HEIGHT);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    @Override
    public final boolean intersects(double X, double Y, double WIDTH, double HEIGHT) {
        if (Double.isNaN(X + WIDTH) || Double.isNaN(Y + HEIGHT)) {
            return false;
        }
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        int mask = this.windingRule == WindingRule.WIND_NON_ZERO ? -1 : 2;
        int crossings = this.rectCrossings(X, Y, X + WIDTH, Y + HEIGHT);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM, double FLATNESS) {
        return new FlatteningPathIterator(this.getPathIterator(TRANSFORM), FLATNESS);
    }

    static byte[] copyOf(byte[] ORIGINAL, int NEW_LENGTH) {
        byte[] copy = new byte[NEW_LENGTH];
        System.arraycopy(ORIGINAL, 0, copy, 0, Math.min(ORIGINAL.length, NEW_LENGTH));
        return copy;
    }

    static double[] copyOf(double[] ORIGINAL, int NEW_LENGTH) {
        double[] copy = new double[NEW_LENGTH];
        System.arraycopy(ORIGINAL, 0, copy, 0, Math.min(ORIGINAL.length, NEW_LENGTH));
        return copy;
    }

    public void setTo(Path OTHER_PATH) {
        this.numTypes = OTHER_PATH.numTypes;
        this.numCoords = OTHER_PATH.numCoords;
        if (this.numTypes > this.pointTypes.length) {
            this.pointTypes = new byte[this.numTypes];
        }
        System.arraycopy(OTHER_PATH.pointTypes, 0, this.pointTypes, 0, this.numTypes);
        if (this.numCoords > this.doubleCoords.length) {
            this.doubleCoords = new double[this.numCoords];
        }
        System.arraycopy(OTHER_PATH.doubleCoords, 0, this.doubleCoords, 0, this.numCoords);
        this.windingRule = OTHER_PATH.windingRule;
        this.moveX = OTHER_PATH.moveX;
        this.moveY = OTHER_PATH.moveY;
        this.prevX = OTHER_PATH.prevX;
        this.prevY = OTHER_PATH.prevY;
        this.currentX = OTHER_PATH.currentX;
        this.currentY = OTHER_PATH.currentY;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint FILL) {
        this.fill = FILL;
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public void setStroke(Paint STROKE) {
        this.stroke = STROKE;
    }

    public void draw(GraphicsContext CTX) {
        this.draw(CTX, false, false);
    }

    public void draw(GraphicsContext CTX, boolean FILL, boolean STROKE) {
        this.draw(CTX, FILL, this.fill, STROKE, this.stroke);
    }

    public void draw(GraphicsContext CTX, boolean FILL, Paint FILL_PAINT, boolean STROKE, Paint STROKE_PAINT) {
        PathIterator pi = this.getPathIterator(new Affine());
        CTX.setFillRule(WindingRule.WIND_EVEN_ODD == pi.getWindingRule() ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        CTX.beginPath();
        double[] seg = new double[6];
        while (!pi.isDone()) {
            int segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    CTX.moveTo(seg[0], seg[1]);
                    break;
                }
                case 1: {
                    CTX.lineTo(seg[0], seg[1]);
                    break;
                }
                case 2: {
                    CTX.quadraticCurveTo(seg[0], seg[1], seg[2], seg[3]);
                    break;
                }
                case 3: {
                    CTX.bezierCurveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                    break;
                }
                case 4: {
                    CTX.closePath();
                    break;
                }
            }
            pi.next();
        }
        if (FILL) {
            CTX.setFill(FILL_PAINT);
            CTX.fill();
        }
        if (STROKE) {
            CTX.setStroke(STROKE_PAINT);
            CTX.stroke();
        }
    }

    public static enum WindingRule {
        WIND_EVEN_ODD,
        WIND_NON_ZERO;

    }

    public static enum CornerPrefix {
        CORNER_ONLY,
        MOVE_THEN_CORNER,
        LINE_THEN_CORNER;

    }

    static class CopyIterator
    extends Iterator {
        double[] doubleCoords;

        CopyIterator(Path PATH) {
            super(PATH);
            this.doubleCoords = PATH.doubleCoords;
        }

        @Override
        public int currentSegment(double[] COORDINATES) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                System.arraycopy(this.doubleCoords, this.pointIdx, COORDINATES, 0, numCoords);
            }
            return type;
        }
    }

    static class TxIterator
    extends Iterator {
        double[] doubleCoords;
        BaseTransform transform;

        TxIterator(Path PATH, BaseTransform TRANSFORM) {
            super(PATH);
            this.doubleCoords = PATH.doubleCoords;
            this.transform = TRANSFORM;
        }

        @Override
        public int currentSegment(double[] COORDINATES) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                this.transform.transform(this.doubleCoords, this.pointIdx, COORDINATES, 0, numCoords / 2);
            }
            return type;
        }
    }

    static class SVGParser {
        final String svgpath;
        final int length;
        int pos;
        boolean allowComma;

        public SVGParser(String SVG_PATH) {
            this.svgpath = SVG_PATH;
            this.length = SVG_PATH.length();
        }

        public boolean isDone() {
            return this.toNextNonWsp() >= this.length;
        }

        public char getChar() {
            return this.svgpath.charAt(this.pos++);
        }

        public boolean nextIsNumber() {
            if (this.toNextNonWsp() < this.length) {
                switch (this.svgpath.charAt(this.pos)) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return true;
                    }
                }
            }
            return false;
        }

        public double f() {
            return this.getDouble();
        }

        public double a() {
            return Math.toRadians(this.getDouble());
        }

        public double getDouble() {
            int start = this.toNextNonWsp();
            int end = this.toNumberEnd();
            this.allowComma = true;
            if (start < end) {
                String flstr = this.svgpath.substring(start, end);
                try {
                    return Double.parseDouble(flstr);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("invalid double (" + flstr + ") in path at pos=" + start);
                }
            }
            throw new IllegalArgumentException("end of path looking for double");
        }

        public boolean b() {
            this.toNextNonWsp();
            this.allowComma = true;
            if (this.pos < this.length) {
                char flag = this.svgpath.charAt(this.pos);
                switch (flag) {
                    case '0': {
                        ++this.pos;
                        return false;
                    }
                    case '1': {
                        ++this.pos;
                        return true;
                    }
                }
                throw new IllegalArgumentException("invalid boolean flag (" + flag + ") in path at pos=" + this.pos);
            }
            throw new IllegalArgumentException("end of path looking for boolean");
        }

        private int toNextNonWsp() {
            boolean canBeComma = this.allowComma;
            while (this.pos < this.length) {
                switch (this.svgpath.charAt(this.pos)) {
                    case ',': {
                        if (!canBeComma) {
                            return this.pos;
                        }
                        canBeComma = false;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        return this.pos;
                    }
                }
                ++this.pos;
            }
            return this.pos;
        }

        private int toNumberEnd() {
            boolean allowSign = true;
            boolean hasExp = false;
            boolean hasDecimal = false;
            while (this.pos < this.length) {
                switch (this.svgpath.charAt(this.pos)) {
                    case '+': 
                    case '-': {
                        if (!allowSign) {
                            return this.pos;
                        }
                        allowSign = false;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        allowSign = false;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (hasExp) {
                            return this.pos;
                        }
                        allowSign = true;
                        hasExp = true;
                        break;
                    }
                    case '.': {
                        if (hasExp || hasDecimal) {
                            return this.pos;
                        }
                        hasDecimal = true;
                        allowSign = false;
                        break;
                    }
                    default: {
                        return this.pos;
                    }
                }
                ++this.pos;
            }
            return this.pos;
        }
    }

    static abstract class Iterator
    implements PathIterator {
        int typeIdx;
        int pointIdx;
        Path path;

        Iterator(Path PATH) {
            this.path = PATH;
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        @Override
        public void next() {
            byte type = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[type];
        }

        @Override
        public WindingRule getWindingRule() {
            return this.path.getWindingRule();
        }
    }
}

