/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.charts;

import eu.hansolo.fx.charts.tools.Helper;
import eu.hansolo.fx.charts.tools.P2d;
import eu.hansolo.fx.charts.tools.P3d;
import eu.hansolo.fx.charts.tools.PMatrix;
import eu.hansolo.toolboxfx.FontMetrix;
import eu.hansolo.toolboxfx.font.Fonts;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class CubeChart
extends Region {
    public static final Color DEFAULT_CHART_BACKGROUND = Color.TRANSPARENT;
    public static final Color DEFAULT_CUBE_COLOR = Color.WHITE;
    public static final Color DEFAULT_CUBE_FRAME_COLOR = Color.rgb((int)228, (int)228, (int)228);
    public static final LinearGradient RED_ORANGE_LEFT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)210, (int)84, (int)66)), new Stop(1.0, Color.rgb((int)224, (int)130, (int)66))});
    public static final LinearGradient RED_ORANGE_RIGHT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)224, (int)130, (int)66)), new Stop(1.0, Color.rgb((int)237, (int)181, (int)75))});
    public static final LinearGradient ORANGE_GREEN_LEFT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)213, (int)184, (int)79)), new Stop(1.0, Color.rgb((int)177, (int)189, (int)87))});
    public static final LinearGradient ORANGE_GREEN_RIGHT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)167, (int)191, (int)89)), new Stop(1.0, Color.rgb((int)125, (int)184, (int)123))});
    public static final LinearGradient GREEN_BLUE_LEFT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)100, (int)179, (int)153)), new Stop(1.0, Color.rgb((int)79, (int)166, (int)182))});
    public static final LinearGradient GREEN_BLUE_RIGHT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)79, (int)154, (int)179)), new Stop(1.0, Color.rgb((int)103, (int)124, (int)166))});
    public static final LinearGradient BLUE_PURPLE_LEFT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)130, (int)100, (int)158)), new Stop(1.0, Color.rgb((int)101, (int)63, (int)129))});
    public static final LinearGradient BLUE_PURPLE_RIGHT_FILL = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)87, (int)47, (int)118)), new Stop(1.0, Color.rgb((int)45, (int)5, (int)83))});
    public static final Color DEFAULT_TEXT_COLOR = Color.WHITE;
    public static final Color DEFAULT_EMPTY_TEXT_COLOR = Color.rgb((int)128, (int)128, (int)128);
    private static final double PREFERRED_WIDTH = 400.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 4096.0;
    private static final double MAXIMUM_HEIGHT = 4096.0;
    private double width;
    private double height;
    private double size;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Paint _chartBackground = DEFAULT_CHART_BACKGROUND;
    private ObjectProperty<Paint> chartBackground;
    private Color _cubeColor = DEFAULT_CUBE_COLOR;
    private ObjectProperty<Color> cubeColor;
    private Color _cubeFrameColor = DEFAULT_CUBE_FRAME_COLOR;
    private ObjectProperty<Color> cubeFrameColor;
    private Paint _leftFill = RED_ORANGE_LEFT_FILL;
    private ObjectProperty<Paint> leftFill;
    private Paint _rightFill = RED_ORANGE_RIGHT_FILL;
    private ObjectProperty<Paint> rightFill;
    private Color _leftTextColor = DEFAULT_TEXT_COLOR;
    private ObjectProperty<Color> leftTextColor;
    private Color _leftEmptyTextColor = DEFAULT_EMPTY_TEXT_COLOR;
    private ObjectProperty<Color> leftEmptyTextColor;
    private Color _rightTextColor = DEFAULT_TEXT_COLOR;
    private ObjectProperty<Color> rightTextColor;
    private Color _rightEmptyTextColor = DEFAULT_EMPTY_TEXT_COLOR;
    private ObjectProperty<Color> rightEmptyTextColor;
    private DoubleProperty leftValue = new DoublePropertyBase(0.0){

        protected void invalidated() {
            this.set(Helper.clamp(0.0, 1.0, this.get()));
            CubeChart.this.redraw();
        }

        public Object getBean() {
            return CubeChart.this;
        }

        public String getName() {
            return "leftValue";
        }
    };
    private DoubleProperty rightValue = new DoublePropertyBase(0.0){

        protected void invalidated() {
            this.set(Helper.clamp(0.0, 1.0, this.get()));
            CubeChart.this.redraw();
        }

        public Object getBean() {
            return CubeChart.this;
        }

        public String getName() {
            return "leftValue";
        }
    };
    private StringProperty leftText = new StringPropertyBase(""){

        protected void invalidated() {
            CubeChart.this.redraw();
        }

        public Object getBean() {
            return CubeChart.this;
        }

        public String getName() {
            return "leftText";
        }
    };
    private StringProperty rightText = new StringPropertyBase(""){

        protected void invalidated() {
            CubeChart.this.redraw();
        }

        public Object getBean() {
            return CubeChart.this;
        }

        public String getName() {
            return "rightText";
        }
    };
    private double lineWidth = 10.0;
    private double cubeSize = 100.0;
    private double dataAreaSize = this.cubeSize * 0.4;
    private Font valueFont = Fonts.mazzardsoftlBoldName((double)44.0);
    private Font textFont = Fonts.mazzardsoftlBoldName((double)12.0);
    private PMatrix pMatrix;
    private List<P3d> cubePoints = new ArrayList<P3d>();
    private List<P3d> leftPoints;
    private List<P3d> rightPoints;

    public CubeChart() {
        this.cubePoints.add(new P3d(-this.cubeSize, -this.cubeSize, -this.cubeSize));
        this.cubePoints.add(new P3d(this.cubeSize, -this.cubeSize, -this.cubeSize));
        this.cubePoints.add(new P3d(this.cubeSize, this.cubeSize, -this.cubeSize));
        this.cubePoints.add(new P3d(-this.cubeSize, this.cubeSize, -this.cubeSize));
        this.cubePoints.add(new P3d(-this.cubeSize, -this.cubeSize, this.cubeSize));
        this.cubePoints.add(new P3d(this.cubeSize, -this.cubeSize, this.cubeSize));
        this.cubePoints.add(new P3d(this.cubeSize, this.cubeSize, this.cubeSize));
        this.cubePoints.add(new P3d(-this.cubeSize, this.cubeSize, this.cubeSize));
        this.leftPoints = new ArrayList<P3d>();
        this.leftPoints.add(new P3d(-this.dataAreaSize, -this.dataAreaSize, -this.dataAreaSize));
        this.leftPoints.add(new P3d(this.dataAreaSize, -this.dataAreaSize, -this.dataAreaSize));
        this.leftPoints.add(new P3d(this.dataAreaSize, this.dataAreaSize, -this.dataAreaSize));
        this.leftPoints.add(new P3d(-this.dataAreaSize, this.dataAreaSize, -this.dataAreaSize));
        this.leftPoints.add(new P3d(-this.dataAreaSize, -this.dataAreaSize, this.dataAreaSize));
        this.leftPoints.add(new P3d(this.dataAreaSize, -this.dataAreaSize, this.dataAreaSize));
        this.leftPoints.add(new P3d(this.dataAreaSize, this.dataAreaSize, this.dataAreaSize));
        this.leftPoints.add(new P3d(-this.dataAreaSize, this.dataAreaSize, this.dataAreaSize));
        this.rightPoints = new ArrayList<P3d>();
        this.rightPoints.add(new P3d(-this.dataAreaSize, -this.dataAreaSize, -this.dataAreaSize));
        this.rightPoints.add(new P3d(this.dataAreaSize, -this.dataAreaSize, -this.dataAreaSize));
        this.rightPoints.add(new P3d(this.dataAreaSize, this.dataAreaSize, -this.dataAreaSize));
        this.rightPoints.add(new P3d(-this.dataAreaSize, this.dataAreaSize, -this.dataAreaSize));
        this.rightPoints.add(new P3d(-this.dataAreaSize, -this.dataAreaSize, this.dataAreaSize));
        this.rightPoints.add(new P3d(this.dataAreaSize, -this.dataAreaSize, this.dataAreaSize));
        this.rightPoints.add(new P3d(this.dataAreaSize, this.dataAreaSize, this.dataAreaSize));
        this.rightPoints.add(new P3d(-this.dataAreaSize, this.dataAreaSize, this.dataAreaSize));
        this.pMatrix = new PMatrix(new P2d(0.0, 0.0), new P2d(0.0, 0.0), new P2d(0.0, 0.0), new P3d(0.0, 0.0, 0.0), new P2d(200.0, 200.0));
        this.pMatrix.setProjection(Helper.ISOMETRIC);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(400.0, 400.0);
            }
        }
        this.canvas = new Canvas(400.0, 400.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.ctx.setLineCap(StrokeLineCap.BUTT);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 4096.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 4096.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
    }

    public Paint getChartBackground() {
        return null == this.chartBackground ? this._chartBackground : (Paint)this.chartBackground.get();
    }

    public void setChartBackground(Paint paint) {
        if (null == this.chartBackground) {
            this._chartBackground = paint;
            this.redraw();
        } else {
            this.chartBackground.set((Object)paint);
        }
    }

    public ObjectProperty<Paint> chartBackgroundProperty() {
        if (null == this.chartBackground) {
            this.chartBackground = new ObjectPropertyBase<Paint>(this._chartBackground){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "chartBackground";
                }
            };
            this._chartBackground = null;
        }
        return this.chartBackground;
    }

    public Color getCubeColor() {
        return null == this.cubeColor ? this._cubeColor : (Color)this.cubeColor.get();
    }

    public void setCubeColor(Color cubeColor) {
        if (null == this.cubeColor) {
            this._cubeColor = cubeColor;
            this.redraw();
        } else {
            this.cubeColor.set((Object)cubeColor);
        }
    }

    public ObjectProperty<Color> cubeColorProperty() {
        if (null == this.cubeColor) {
            this.cubeColor = new ObjectPropertyBase<Color>(this._cubeColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "cubeColor";
                }
            };
            this._cubeColor = null;
        }
        return this.cubeColor;
    }

    public Color getCubeFrameColor() {
        return null == this.cubeFrameColor ? this._cubeFrameColor : (Color)this.cubeFrameColor.get();
    }

    public void setCubeFrameColor(Color cubeFrameColor) {
        if (null == this.cubeFrameColor) {
            this._cubeFrameColor = cubeFrameColor;
            this.redraw();
        } else {
            this.cubeFrameColor.set((Object)cubeFrameColor);
        }
    }

    public ObjectProperty<Color> cubeFrameColorProperty() {
        if (null == this.cubeFrameColor) {
            this.cubeFrameColor = new ObjectPropertyBase<Color>(this._cubeFrameColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "cubeFrameColor";
                }
            };
            this._cubeFrameColor = null;
        }
        return this.cubeFrameColor;
    }

    public Paint getLeftFill() {
        return null == this.leftFill ? this._leftFill : (Paint)this.leftFill.get();
    }

    public void setLeftFill(Paint leftFill) {
        if (null == this.leftFill) {
            this._leftFill = leftFill;
            this.redraw();
        } else {
            this.leftFill.set((Object)leftFill);
        }
    }

    public ObjectProperty<Paint> leftFillProperty() {
        if (null == this.leftFill) {
            this.leftFill = new ObjectPropertyBase<Paint>(this._leftFill){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "leftFill";
                }
            };
            this._leftFill = null;
        }
        return this.leftFill;
    }

    public Paint getRightFill() {
        return null == this.rightFill ? this._rightFill : (Paint)this.rightFill.get();
    }

    public void setRightFill(Paint rightFill) {
        if (null == this.rightFill) {
            this._rightFill = rightFill;
            this.redraw();
        } else {
            this.rightFill.set((Object)rightFill);
        }
    }

    public ObjectProperty<Paint> rightFillProperty() {
        if (null == this.rightFill) {
            this.rightFill = new ObjectPropertyBase<Paint>(this._rightFill){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "rightFill";
                }
            };
            this._rightFill = null;
        }
        return this.rightFill;
    }

    public Color getLeftTextColor() {
        return null == this.leftTextColor ? this._leftTextColor : (Color)this.leftTextColor.get();
    }

    public void setLeftTextColor(Color color) {
        if (null == this.leftTextColor) {
            this._leftTextColor = color;
            this.redraw();
        } else {
            this.leftTextColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> leftTextColorProperty() {
        if (null == this.leftTextColor) {
            this.leftTextColor = new ObjectPropertyBase<Color>(this._leftTextColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "leftTextColor";
                }
            };
            this._leftTextColor = null;
        }
        return this.leftTextColor;
    }

    public Color getLeftEmptyTextColor() {
        return null == this.leftEmptyTextColor ? this._leftEmptyTextColor : (Color)this.leftEmptyTextColor.get();
    }

    public void setLeftEmptyTextColor(Color color) {
        if (null == this.leftEmptyTextColor) {
            this._leftEmptyTextColor = color;
            this.redraw();
        } else {
            this.leftEmptyTextColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> leftEmptyTextColorProperty() {
        if (null == this.leftEmptyTextColor) {
            this.leftEmptyTextColor = new ObjectPropertyBase<Color>(this._leftEmptyTextColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "leftEmptyTextColor";
                }
            };
            this._leftEmptyTextColor = null;
        }
        return this.leftEmptyTextColor;
    }

    public Color getRightEmptyTextColor() {
        return null == this.rightEmptyTextColor ? this._rightEmptyTextColor : (Color)this.rightEmptyTextColor.get();
    }

    public void setRightEmptyTextColor(Color color) {
        if (null == this.rightEmptyTextColor) {
            this._rightEmptyTextColor = color;
            this.redraw();
        } else {
            this.rightEmptyTextColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> rightEmptyTextColorProperty() {
        if (null == this.rightEmptyTextColor) {
            this.rightEmptyTextColor = new ObjectPropertyBase<Color>(this._rightEmptyTextColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "rightEmptyTextColor";
                }
            };
            this._rightEmptyTextColor = null;
        }
        return this.rightEmptyTextColor;
    }

    public Color getRightTextColor() {
        return null == this.rightTextColor ? this._rightTextColor : (Color)this.rightTextColor.get();
    }

    public void setRightTextColor(Color color) {
        if (null == this.rightTextColor) {
            this._rightTextColor = color;
            this.redraw();
        } else {
            this.rightTextColor.set((Object)color);
        }
    }

    public ObjectProperty<Color> rightTextColorProperty() {
        if (null == this.rightTextColor) {
            this.rightTextColor = new ObjectPropertyBase<Color>(this._rightTextColor){

                protected void invalidated() {
                    CubeChart.this.redraw();
                }

                public Object getBean() {
                    return CubeChart.this;
                }

                public String getName() {
                    return "rightTextColor";
                }
            };
            this._rightTextColor = null;
        }
        return this.rightTextColor;
    }

    public double getLeftValue() {
        return this.leftValue.get();
    }

    public void setLeftValue(double leftValue) {
        this.leftValue.set(Helper.clamp(0.0, 1.0, leftValue));
    }

    public DoubleProperty leftValueProperty() {
        return this.leftValue;
    }

    public double getRightValue() {
        return this.rightValue.get();
    }

    public void setRightValue(double rightValue) {
        this.rightValue.set(Helper.clamp(0.0, 1.0, rightValue));
    }

    public DoubleProperty rightValueProperty() {
        return this.rightValue;
    }

    public String getLeftText() {
        return (String)this.leftText.get();
    }

    public void setLeftText(String leftText) {
        this.leftText.set((Object)leftText);
    }

    public StringProperty leftTextProperty() {
        return this.leftText;
    }

    public String getRightText() {
        return (String)this.rightText.get();
    }

    public void setRightText(String rightText) {
        this.rightText.set((Object)rightText);
    }

    public StringProperty rightTextProperty() {
        return this.rightText;
    }

    public boolean renderToImage(String filename, int width, int height) {
        return Helper.renderToImage((Node)this, width, height, filename);
    }

    public BufferedImage renderToImage(int width, int height) {
        return Helper.renderToImage((Node)this, width, height);
    }

    private void wrapText(GraphicsContext ctx, String text, double x, double y, double maxWidth, double lineHeight, int maxNoOfLines) {
        double tx = x;
        double ty = y;
        double noOfLines = 1.0;
        String[] words = text.split(" ");
        Object line = "";
        FontMetrix metrix = new FontMetrix(this.textFont);
        for (int n = 0; n < words.length; ++n) {
            String testLine = (String)line + words[n] + " ";
            double testWidth = metrix.computeStringWidth(testLine);
            if (testWidth > maxWidth && n > 0) {
                ctx.fillText((String)line, tx, ty);
                line = words[n] + " ";
                if (noOfLines == (double)maxNoOfLines) break;
                ty += lineHeight;
                noOfLines += 1.0;
                continue;
            }
            line = testLine;
        }
        ctx.fillText((String)line, tx, ty);
    }

    protected void drawChart() {
        P3d point2;
        int i;
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        this.ctx.setFill(this.getChartBackground());
        this.ctx.fillRect(0.0, 0.0, this.width, this.height);
        double leftValue = this.getLeftValue();
        double rightValue = this.getRightValue();
        block30: for (i = 0; i < this.cubePoints.size(); ++i) {
            point2 = this.cubePoints.get(i);
            switch (i) {
                case 0: {
                    point2.x = -this.cubeSize;
                    point2.y = -this.cubeSize;
                    point2.z = -this.cubeSize;
                    continue block30;
                }
                case 1: {
                    point2.x = this.cubeSize;
                    point2.y = -this.cubeSize;
                    point2.z = -this.cubeSize;
                    continue block30;
                }
                case 2: {
                    point2.x = this.cubeSize;
                    point2.y = this.cubeSize;
                    point2.z = -this.cubeSize;
                    continue block30;
                }
                case 3: {
                    point2.x = -this.cubeSize;
                    point2.y = this.cubeSize;
                    point2.z = -this.cubeSize;
                    continue block30;
                }
                case 4: {
                    point2.x = -this.cubeSize;
                    point2.y = -this.cubeSize;
                    point2.z = this.cubeSize;
                    continue block30;
                }
                case 5: {
                    point2.x = this.cubeSize;
                    point2.y = -this.cubeSize;
                    point2.z = this.cubeSize;
                    continue block30;
                }
                case 6: {
                    point2.x = this.cubeSize;
                    point2.y = this.cubeSize;
                    point2.z = this.cubeSize;
                    continue block30;
                }
                case 7: {
                    point2.x = -this.cubeSize;
                    point2.y = this.cubeSize;
                    point2.z = this.cubeSize;
                }
            }
        }
        block31: for (i = 0; i < this.leftPoints.size(); ++i) {
            point2 = this.leftPoints.get(i);
            switch (i) {
                case 0: {
                    point2.x = -this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block31;
                }
                case 1: {
                    point2.x = this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block31;
                }
                case 2: {
                    point2.x = this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block31;
                }
                case 3: {
                    point2.x = -this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block31;
                }
                case 4: {
                    point2.x = -this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = this.dataAreaSize;
                    continue block31;
                }
                case 5: {
                    point2.x = this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = this.dataAreaSize;
                    continue block31;
                }
                case 6: {
                    point2.x = this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = this.dataAreaSize - 2.0 * this.dataAreaSize * (1.0 - leftValue);
                    continue block31;
                }
                case 7: {
                    point2.x = -this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = this.dataAreaSize - 2.0 * this.dataAreaSize * (1.0 - leftValue);
                }
            }
        }
        block32: for (i = 0; i < this.rightPoints.size(); ++i) {
            point2 = this.rightPoints.get(i);
            switch (i) {
                case 0: {
                    point2.x = -this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block32;
                }
                case 1: {
                    point2.x = this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block32;
                }
                case 2: {
                    point2.x = this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block32;
                }
                case 3: {
                    point2.x = -this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = -this.dataAreaSize;
                    continue block32;
                }
                case 4: {
                    point2.x = -this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = this.dataAreaSize;
                    continue block32;
                }
                case 5: {
                    point2.x = this.dataAreaSize;
                    point2.y = -this.dataAreaSize;
                    point2.z = this.dataAreaSize - 2.0 * this.dataAreaSize * (1.0 - rightValue);
                    continue block32;
                }
                case 6: {
                    point2.x = this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = this.dataAreaSize - 2.0 * this.dataAreaSize * (1.0 - rightValue);
                    continue block32;
                }
                case 7: {
                    point2.x = -this.dataAreaSize;
                    point2.y = this.dataAreaSize;
                    point2.z = this.dataAreaSize;
                }
            }
        }
        this.pMatrix.getOrigin().x = this.width * 0.5;
        this.pMatrix.getOrigin().y = this.height * 0.5;
        List projectedPoints = this.cubePoints.stream().map(point -> this.pMatrix.project((P3d)point)).collect(Collectors.toList());
        this.pMatrix.getOrigin().x = this.width * 0.46;
        this.pMatrix.getOrigin().y = this.height * 0.52;
        List projectedLeftDataPoints = this.leftPoints.stream().map(point -> this.pMatrix.project((P3d)point)).collect(Collectors.toList());
        this.pMatrix.getOrigin().x = this.width * 0.54;
        this.pMatrix.getOrigin().y = this.height * 0.52;
        List projectedRightDataPoints = this.rightPoints.stream().map(point -> this.pMatrix.project((P3d)point)).collect(Collectors.toList());
        this.ctx.setLineWidth(this.lineWidth);
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.setLineJoin(StrokeLineJoin.ROUND);
        this.ctx.setStroke((Paint)this.getCubeFrameColor());
        this.ctx.setFill((Paint)this.getCubeColor());
        this.ctx.beginPath();
        this.ctx.moveTo(((P3d)projectedPoints.get((int)4)).x, ((P3d)projectedPoints.get((int)4)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.beginPath();
        this.ctx.moveTo(((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)3)).x, ((P3d)projectedPoints.get((int)3)).y);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.beginPath();
        this.ctx.moveTo(((P3d)projectedPoints.get((int)1)).x, ((P3d)projectedPoints.get((int)1)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.lineTo(((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)4)).x, ((P3d)projectedPoints.get((int)4)).y, ((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y, ((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y, ((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y, ((P3d)projectedPoints.get((int)4)).x, ((P3d)projectedPoints.get((int)4)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y, ((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y, ((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)7)).x, ((P3d)projectedPoints.get((int)7)).y, ((P3d)projectedPoints.get((int)3)).x, ((P3d)projectedPoints.get((int)3)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)3)).x, ((P3d)projectedPoints.get((int)3)).y, ((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)1)).x, ((P3d)projectedPoints.get((int)1)).y, ((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)5)).x, ((P3d)projectedPoints.get((int)5)).y, ((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)6)).x, ((P3d)projectedPoints.get((int)6)).y, ((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y);
        this.ctx.strokeLine(((P3d)projectedPoints.get((int)2)).x, ((P3d)projectedPoints.get((int)2)).y, ((P3d)projectedPoints.get((int)1)).x, ((P3d)projectedPoints.get((int)1)).y);
        this.ctx.setFill(this.getLeftFill());
        this.ctx.beginPath();
        this.ctx.moveTo(((P3d)projectedLeftDataPoints.get((int)2)).x, ((P3d)projectedLeftDataPoints.get((int)2)).y);
        this.ctx.lineTo(((P3d)projectedLeftDataPoints.get((int)6)).x, ((P3d)projectedLeftDataPoints.get((int)6)).y);
        this.ctx.lineTo(((P3d)projectedLeftDataPoints.get((int)7)).x, ((P3d)projectedLeftDataPoints.get((int)7)).y);
        this.ctx.lineTo(((P3d)projectedLeftDataPoints.get((int)3)).x, ((P3d)projectedLeftDataPoints.get((int)3)).y);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.setFill(this.getRightFill());
        this.ctx.beginPath();
        this.ctx.moveTo(((P3d)projectedRightDataPoints.get((int)1)).x, ((P3d)projectedRightDataPoints.get((int)1)).y);
        this.ctx.lineTo(((P3d)projectedRightDataPoints.get((int)5)).x, ((P3d)projectedRightDataPoints.get((int)5)).y);
        this.ctx.lineTo(((P3d)projectedRightDataPoints.get((int)6)).x, ((P3d)projectedRightDataPoints.get((int)6)).y);
        this.ctx.lineTo(((P3d)projectedRightDataPoints.get((int)2)).x, ((P3d)projectedRightDataPoints.get((int)2)).y);
        this.ctx.closePath();
        this.ctx.fill();
        this.ctx.setTextBaseline(VPos.TOP);
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.save();
        this.ctx.setFont(this.valueFont);
        this.ctx.setFill((Paint)(leftValue < 0.2 ? this.getLeftEmptyTextColor() : this.getLeftTextColor()));
        this.ctx.setTransform(1.0, 0.6, 0.025, 1.0, 0.0, 0.0);
        double ty = leftValue < 0.29 || this.getLeftText().isEmpty() ? this.size * 0.525 : this.size * 0.63 - this.dataAreaSize * 2.0 * leftValue;
        this.ctx.fillText(String.format(Locale.US, "%.0f%%", leftValue * 100.0), this.size * 0.3, ty);
        if (leftValue > 0.69) {
            this.ctx.setFont(this.textFont);
            this.wrapText(this.ctx, this.getLeftText(), this.size * 0.29, ty + this.valueFont.getSize(), this.dataAreaSize * 1.7, this.textFont.getSize() * 1.25, 3);
        }
        this.ctx.restore();
        this.ctx.save();
        this.ctx.setFont(this.valueFont);
        this.ctx.setFill((Paint)(rightValue < 0.2 ? this.getRightEmptyTextColor() : this.getRightTextColor()));
        this.ctx.setTransform(1.0, -0.6, 0.025, 1.0, 0.0, 0.0);
        ty = rightValue < 0.29 || this.getRightText().isEmpty() ? this.size * 1.1 : this.size * 1.205 - this.dataAreaSize * 2.0 * rightValue;
        this.ctx.fillText(String.format(Locale.US, "%.0f%%", rightValue * 100.0), this.size * 0.67, ty);
        if (rightValue > 0.69) {
            this.ctx.setFont(this.textFont);
            this.wrapText(this.ctx, this.getRightText(), this.size * 0.67, ty + this.valueFont.getSize(), this.dataAreaSize * 1.7, this.textFont.getSize() * 1.25, 3);
        }
        this.ctx.restore();
    }

    private void resize() {
        double h;
        double w = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.width = this.size = w < (h = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom()) ? w : h;
        this.height = this.size;
        if (this.width > 0.0 && this.height > 0.0) {
            this.lineWidth = this.size * 0.03;
            this.cubeSize = this.size * 0.225;
            this.dataAreaSize = this.cubeSize * 0.8;
            this.valueFont = Fonts.mazzardsoftlBoldName((double)(this.size * 0.12));
            this.textFont = Fonts.mazzardsoftlSemiBoldName((double)(this.size * 0.035));
            this.pMatrix.getOrigin().x = this.width * 0.5;
            this.pMatrix.getOrigin().y = this.height * 0.5;
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
            this.redraw();
        }
    }

    public void redraw() {
        this.drawChart();
    }
}

